/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.tabbedpane;

import com.nokia.laf.NetTheme;
import com.nokia.laf.tabbedpane.OverflowPopupBorder;
import com.nokia.laf.tabbedpane.TabbedPaneOverflowRenderer;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListDataListener;

public class TabbedPaneOverflowPopup
extends JPopupMenu {
    protected static final int SCROLL_DOWN = 1;
    protected static final int SCROLL_UP = 0;
    private static final ListModel EMPTY_LIST_MODEL = new ListModel(){

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        public Object getElementAt(int index) {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    };
    private static Object theHidePopupPropertyValue = null;
    protected Timer myAutoscrollTimer;
    protected boolean myHasEntered = false;
    protected boolean myIsAutoScrolling = false;
    protected JList myList;
    protected MouseListener myListMouseListener;
    protected MouseMotionListener myListMouseMotionListener;
    protected int myMaxRowCount = 5;
    protected MouseListener myMouseListener;
    protected MouseMotionListener myMouseMotionListener;
    protected PropertyChangeListener myPropertyChangeListener;
    protected int myScrollDirection = 0;
    protected JScrollPane myScroller;
    protected JTabbedPane myTabbedPane;

    public TabbedPaneOverflowPopup(JTabbedPane tabbedPane, ListModel listModel) {
        this.myTabbedPane = tabbedPane;
        this.setLightWeightPopupEnabled(false);
        this.myList = this.createList();
        this.configureList();
        this.myList.setModel(listModel);
        this.myScroller = this.createScroller();
        this.configurePopup();
        if (theHidePopupPropertyValue == null) {
            JComboBox comboBox = new JComboBox();
            theHidePopupPropertyValue = comboBox.getClientProperty("doNotCancelPopup");
        }
    }

    public Integer getElementAt(int index) {
        return (Integer)this.myList.getModel().getElementAt(index);
    }

    public int getListSize() {
        return this.myList.getModel().getSize();
    }

    public int getMaxRowCount() {
        return this.myMaxRowCount;
    }

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.myList.getSelectedValue();
    }

    @Override
    public void setVisible(boolean visible) {
        this.myTabbedPane.putClientProperty("doNotCancelPopup", visible ? theHidePopupPropertyValue : null);
        super.setVisible(visible);
    }

    @Override
    public void hide() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] selection = manager.getSelectedPath();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] == this) {
                manager.clearSelectedPath();
                break;
            }
            ++i;
        }
        if (selection.length > 0) {
            this.myTabbedPane.repaint();
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.myMaxRowCount = maxRowCount;
    }

    public void setPopupSize() {
        Insets insets = this.getInsets();
        Dimension popupSize = this.myList.getPreferredSize();
        popupSize.width += insets.left + insets.right;
        popupSize.height += insets.top + insets.bottom;
        int maxRowCount = ClientPropertyUtil.intValue(this.myTabbedPane, "OrangeTouch.popupMaximumRowCount");
        int listSize = this.myList.getModel().getSize();
        if (listSize > maxRowCount) {
            popupSize.width += UIManager.getInt("ScrollBar.width") - 1;
        }
        popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(maxRowCount));
        Rectangle popupBounds = this.computePopupBounds(0, this.myTabbedPane.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        scrollSize.height += 2;
        this.myScroller.setMaximumSize(scrollSize);
        this.myScroller.setPreferredSize(scrollSize);
        this.myScroller.setMinimumSize(scrollSize);
        this.myList.revalidate();
    }

    public void setSelectedItem(int listIndex) {
        this.myList.setSelectedIndex(listIndex);
        this.myList.ensureIndexIsVisible(listIndex);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this.setPopupSize();
        super.show(invoker, x, y);
    }

    public void togglePopup() {
        this.setVisible(!this.isVisible());
    }

    protected void autoScrollUp() {
        int index = this.myList.getSelectedIndex();
        if (index > 0) {
            this.myList.setSelectedIndex(index - 1);
            this.myList.ensureIndexIsVisible(index - 1);
        }
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.myTabbedPane.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.myTabbedPane);
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
            rect.y = -rect.height;
        }
        return rect;
    }

    protected void configureList() {
        this.myList.setFont(this.myTabbedPane.getFont());
        this.myList.setForeground(this.myTabbedPane.getForeground());
        this.myList.setBackground(UIManager.getColor("ComboBox.background"));
        this.myList.setBorder(BorderFactory.createEmptyBorder());
        this.myList.setCellRenderer(new TabbedPaneOverflowRenderer(this.myTabbedPane));
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(0);
        this.installListListeners();
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(), new OverflowPopupBorder()));
        this.setOpaque(false);
        this.add(this.myScroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    protected MouseEvent convertMouseEvent(MouseEvent evt) {
        Point convertedPoint = SwingUtilities.convertPoint((Component)evt.getSource(), evt.getPoint(), this.myList);
        return new MouseEvent((Component)evt.getSource(), evt.getID(), evt.getWhen(), evt.getModifiers(), convertedPoint.x, convertedPoint.y, evt.getClickCount(), evt.isPopupTrigger());
    }

    protected JList createList() {
        return new JList(EMPTY_LIST_MODEL){

            @Override
            public void processMouseEvent(MouseEvent e) {
                MouseEvent tempE = e;
                if (tempE.isControlDown()) {
                    tempE = new MouseEvent((Component)tempE.getSource(), tempE.getID(), tempE.getWhen(), tempE.getModifiers() ^ 2, tempE.getX(), tempE.getY(), tempE.getClickCount(), tempE.isPopupTrigger());
                }
                super.processMouseEvent(tempE);
            }
        };
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected JScrollPane createScroller() {
        JScrollPane scroll = new JScrollPane(this.myList, 20, 31);
        scroll.setFocusable(false);
        scroll.setOpaque(false);
        scroll.putClientProperty("OrangeTouch.isInOverflowPopup", true);
        scroll.putClientProperty("OrangeTouch.curvedSheet", false);
        return scroll;
    }

    protected int getPopupHeightForRowCount(int maxRowCount) {
        int size = this.myList.getModel().getSize();
        int minRowCount = maxRowCount > 0 ? Math.min(maxRowCount, size) : size;
        int height = 0;
        ListCellRenderer<Object> renderer = this.myList.getCellRenderer();
        Object value = null;
        int i = 0;
        while (i < minRowCount) {
            value = this.myList.getModel().getElementAt(i);
            Component c = renderer.getListCellRendererComponent(this.myList, value, i, false, false);
            height += c.getPreferredSize().height;
            ++i;
        }
        Insets insets = this.myScroller.getViewportBorder().getBorderInsets(this.myScroller);
        return (height += insets.top + insets.bottom) == 0 ? 100 : height;
    }

    protected void installListListeners() {
        this.myListMouseListener = this.createListMouseListener();
        if (this.myListMouseListener != null) {
            this.myList.addMouseListener(this.myListMouseListener);
        }
    }

    protected void installTabbedPaneListeners() {
        this.myPropertyChangeListener = this.createPropertyChangeListener();
        if (this.myPropertyChangeListener != null) {
            this.myTabbedPane.addPropertyChangeListener(this.myPropertyChangeListener);
        }
        if ((this.myMouseListener = this.createMouseListener()) != null) {
            this.myTabbedPane.addMouseListener(this.myMouseListener);
        }
        if ((this.myMouseMotionListener = this.createMouseMotionListener()) != null) {
            this.myTabbedPane.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        g.setColor(NetTheme.getComponentOutlineColor());
        g.drawLine(0, 0, 0, 0);
    }

    protected void startAutoScrolling(int direction) {
        if (this.myIsAutoScrolling) {
            this.myAutoscrollTimer.stop();
        }
        this.myIsAutoScrolling = true;
        if (direction == 0) {
            this.myScrollDirection = 0;
            Point convertedPoint = SwingUtilities.convertPoint(this.myScroller, 1, 1, this.myList);
            int top = this.myList.locationToIndex(convertedPoint);
            this.myList.setSelectedIndex(top);
            ActionListener timerAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedPaneOverflowPopup.this.autoScrollUp();
                }
            };
            this.myAutoscrollTimer = new Timer(100, timerAction);
        } else if (direction == 1) {
            this.myScrollDirection = 1;
            Dimension size = this.myScroller.getSize();
            Point convertedPoint = SwingUtilities.convertPoint(this.myScroller, new Point(1, size.height - 1 - 2), this.myList);
            int bottom = this.myList.locationToIndex(convertedPoint);
            this.myList.setSelectedIndex(bottom);
            ActionListener timerAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedPaneOverflowPopup.this.autoScrollDown();
                }
            };
            this.myAutoscrollTimer = new Timer(100, timerAction);
        }
        this.myAutoscrollTimer.start();
    }

    protected void stopAutoScrolling() {
        this.myIsAutoScrolling = false;
        if (this.myAutoscrollTimer != null) {
            this.myAutoscrollTimer.stop();
            this.myAutoscrollTimer = null;
        }
    }

    protected void uninstallListListeners() {
        this.myList.removeMouseListener(this.myListMouseListener);
        this.myList.removeMouseMotionListener(this.myListMouseMotionListener);
    }

    protected void uninstallTabbedPaneListeners() {
        this.myTabbedPane.removePropertyChangeListener(this.myPropertyChangeListener);
        this.myTabbedPane.removeMouseListener(this.myMouseListener);
        this.myTabbedPane.removeMouseMotionListener(this.myMouseMotionListener);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent evt) {
        if (this.myList == null) {
            return;
        }
        Point location = evt.getPoint();
        int index = this.myList.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.myList.getModel().getSize() - 1;
        }
        if (this.myList.getSelectedIndex() != index) {
            this.myList.setSelectedIndex(index);
        }
    }

    private void autoScrollDown() {
        int lastItem;
        int index = this.myList.getSelectedIndex();
        if (index < (lastItem = this.myList.getModel().getSize() - 1)) {
            this.myList.setSelectedIndex(index + 1);
            this.myList.ensureIndexIsVisible(index + 1);
        }
    }

    public void setOverflowButtonBounds(int x, int y, int width, int height) {
        this.myScroller.putClientProperty("OrangeTouch.overflowBounds", new Rectangle(x, y, width, height));
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TabbedPaneOverflowPopup.this.isVisible()) {
                Rectangle r = new Rectangle();
                MouseEvent newEvent = TabbedPaneOverflowPopup.this.convertMouseEvent(e);
                Point location = newEvent.getPoint();
                TabbedPaneOverflowPopup.this.myList.computeVisibleRect(r);
                if (r.contains(location)) {
                    Integer selectedItem = (Integer)TabbedPaneOverflowPopup.this.myList.getSelectedValue();
                    if (selectedItem == null) {
                        return;
                    }
                    int selectedTab = selectedItem;
                    if (TabbedPaneOverflowPopup.this.myTabbedPane.isEnabledAt(selectedTab)) {
                        TabbedPaneOverflowPopup.this.myTabbedPane.setSelectedIndex(selectedTab);
                    }
                    TabbedPaneOverflowPopup.this.hide();
                } else if (TabbedPaneOverflowPopup.this.myHasEntered) {
                    TabbedPaneOverflowPopup.this.hide();
                }
            }
            TabbedPaneOverflowPopup.this.myHasEntered = false;
            TabbedPaneOverflowPopup.this.stopAutoScrolling();
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        protected InvocationMouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (TabbedPaneOverflowPopup.this.isVisible()) {
                MouseEvent listEvent = TabbedPaneOverflowPopup.this.convertMouseEvent(evt);
                Rectangle listVisibleRect = new Rectangle();
                TabbedPaneOverflowPopup.this.myList.computeVisibleRect(listVisibleRect);
                if (listEvent.getPoint().y >= listVisibleRect.y && listEvent.getPoint().y <= listVisibleRect.y + listVisibleRect.height - 1) {
                    Point location;
                    TabbedPaneOverflowPopup.this.myHasEntered = true;
                    if (TabbedPaneOverflowPopup.this.myIsAutoScrolling) {
                        TabbedPaneOverflowPopup.this.stopAutoScrolling();
                    }
                    if (listVisibleRect.contains(location = listEvent.getPoint())) {
                        TabbedPaneOverflowPopup.this.updateListBoxSelectionForEvent(listEvent);
                    }
                } else if (TabbedPaneOverflowPopup.this.myHasEntered) {
                    int directionToScroll;
                    int n = directionToScroll = listEvent.getPoint().y < listVisibleRect.y ? 0 : 1;
                    if (TabbedPaneOverflowPopup.this.myIsAutoScrolling && TabbedPaneOverflowPopup.this.myScrollDirection != directionToScroll) {
                        TabbedPaneOverflowPopup.this.stopAutoScrolling();
                        TabbedPaneOverflowPopup.this.startAutoScrolling(directionToScroll);
                    } else if (!TabbedPaneOverflowPopup.this.myIsAutoScrolling) {
                        TabbedPaneOverflowPopup.this.startAutoScrolling(directionToScroll);
                    }
                } else if (evt.getPoint().y < 0) {
                    TabbedPaneOverflowPopup.this.myHasEntered = true;
                    TabbedPaneOverflowPopup.this.startAutoScrolling(0);
                }
            }
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            Integer element = (Integer)TabbedPaneOverflowPopup.this.myList.getSelectedValue();
            int selectedIndex = element;
            if (TabbedPaneOverflowPopup.this.myTabbedPane.isEnabledAt(selectedIndex)) {
                TabbedPaneOverflowPopup.this.myTabbedPane.setSelectedIndex(selectedIndex);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ((ListMouseHandler)ListMouseHandler.this).TabbedPaneOverflowPopup.this.myTabbedPane.repaint();
                    }
                };
                SwingUtilities.invokeLater(run);
            }
            TabbedPaneOverflowPopup.this.hide();
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Point location = event.getPoint();
            Rectangle r = new Rectangle();
            TabbedPaneOverflowPopup.this.myList.computeVisibleRect(r);
            if (r.contains(location)) {
                TabbedPaneOverflowPopup.this.updateListBoxSelectionForEvent(event);
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("componentOrientation".equals(propertyName)) {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                if (TabbedPaneOverflowPopup.this.myList != null && TabbedPaneOverflowPopup.this.myList.getComponentOrientation() != o) {
                    TabbedPaneOverflowPopup.this.myList.setComponentOrientation(o);
                }
                if (TabbedPaneOverflowPopup.this.myScroller != null && TabbedPaneOverflowPopup.this.myScroller.getComponentOrientation() != o) {
                    TabbedPaneOverflowPopup.this.myScroller.setComponentOrientation(o);
                }
                if (o != TabbedPaneOverflowPopup.this.getComponentOrientation()) {
                    TabbedPaneOverflowPopup.this.setComponentOrientation(o);
                }
            }
        }
    }
}

