/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.tabbedpane;

import com.nokia.laf.NetListCellRenderer;
import com.nokia.laf.NetTheme;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class TabbedPaneOverflowRenderer
extends NetListCellRenderer {
    private static Border RENDERER_BORDER = BorderFactory.createEmptyBorder(2, 10, 2, 15);
    private JTabbedPane myTabbedPane;
    private Font myUnselectedFont;

    public TabbedPaneOverflowRenderer(JTabbedPane tabbedPane) {
        this.myTabbedPane = tabbedPane;
        this.myUnselectedFont = this.getFont();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setBorder(RENDERER_BORDER);
        Integer tabIndex = (Integer)value;
        int modelIndex = tabIndex;
        boolean enabledTab = this.myTabbedPane.isEnabledAt(modelIndex);
        if (this.myTabbedPane.getSelectedIndex() == modelIndex) {
            this.setBackground(NetTheme.getSelectionColor());
            this.setForeground(list.getSelectionForeground());
        }
        this.setEnabled(enabledTab);
        this.setFont(this.myUnselectedFont);
        this.setText(this.myTabbedPane.getTitleAt(modelIndex));
        this.setIcon(this.myTabbedPane.getIconAt(modelIndex));
        this.setDisabledIcon(this.myTabbedPane.getDisabledIconAt(modelIndex));
        this.setDisplayedMnemonic(this.myTabbedPane.getMnemonicAt(modelIndex));
        this.setToolTipText(this.myTabbedPane.getToolTipTextAt(modelIndex));
        this.setDisplayedMnemonicIndex(this.myTabbedPane.getDisplayedMnemonicIndexAt(modelIndex));
        if (!enabledTab) {
            this.setBackground(list.getBackground());
        }
        return this;
    }
}

