/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.tabbedpane;

import com.nokia.laf.NetTabbedPaneUI;
import com.nokia.laf.tabbedpane.TabbedPaneOverflowPopup;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class TabbedPaneOverflowSupport
extends MouseInputAdapter
implements ChangeListener,
PropertyChangeListener {
    public static final int OVERFLOW_BUTTON_WIDTH = 35;
    public boolean myOverflowTabSelected = true;
    private int myCachedSize;
    private int myCachedWidth;
    private int myFirstTrailingOverflowTab;
    private int myLastLeadingOverflowTab;
    private DefaultListModel myListModel = new DefaultListModel();
    private TabbedPaneOverflowPopup myOverflowPopup;
    private Rectangle myOverflowRectangle = new Rectangle();
    private boolean myOverflowRollovered;
    private JTabbedPane myTabbedPane;
    private boolean myTabLayoutChanged;

    public TabbedPaneOverflowSupport(JTabbedPane tabPane) {
        this.myTabbedPane = tabPane;
        this.myOverflowPopup = new TabbedPaneOverflowPopup(tabPane, this.myListModel);
    }

    public void installKeyboardActions() {
        this.myTabbedPane.getActionMap().put("hideOverflowPopup", new HidePopupAction());
        this.myTabbedPane.getActionMap().put("selectTabFromOverflow", new EnterAction());
    }

    public void installListeners() {
        this.myTabbedPane.addMouseListener(this);
        this.myTabbedPane.addChangeListener(this);
        this.myTabbedPane.addMouseMotionListener(this);
        this.myTabbedPane.addPropertyChangeListener(this);
        AccessibleContext ctx = this.myTabbedPane.getAccessibleContext();
        if (ctx != null) {
            ctx.addPropertyChangeListener(this);
        }
        this.myOverflowPopup.installTabbedPaneListeners();
    }

    public void uninstallKeyboardActions() {
        this.myTabbedPane.getActionMap().remove("hideOverflowPopup");
        this.myTabbedPane.getActionMap().remove("selectTabFromOverflow");
    }

    public void uninstallListeners() {
        this.myTabbedPane.removeMouseListener(this);
        this.myTabbedPane.removeChangeListener(this);
        this.myTabbedPane.removeMouseMotionListener(this);
        this.myTabbedPane.removePropertyChangeListener(this);
        AccessibleContext ctx = this.myTabbedPane.getAccessibleContext();
        if (ctx != null) {
            ctx.removePropertyChangeListener(this);
        }
        this.myOverflowPopup.uninstallTabbedPaneListeners();
    }

    public boolean isOverflowVisible() {
        return this.myOverflowPopup.isVisible();
    }

    public void calculateOverflowIndices(int tabAreaX, int tabAreaWidth, Rectangle[] rects) {
        FontMetrics metrics = this.myTabbedPane.getFontMetrics(this.myTabbedPane.getFont());
        int tabCount = this.myTabbedPane.getTabCount();
        int tabPlacement = this.myTabbedPane.getTabPlacement();
        boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
        this.myFirstTrailingOverflowTab = -1;
        this.myLastLeadingOverflowTab = -1;
        boolean recalculateLeadingOverflow = false;
        Rectangle selectedTabRect = new Rectangle();
        int i = 0;
        while (i < tabCount) {
            Rectangle rect = rects[i];
            if (!verticalTabRuns) {
                int offset;
                rect.x = i > 0 ? rects[i - 1].x + rects[i - 1].width : tabAreaX;
                rect.width = ((NetTabbedPaneUI)this.myTabbedPane.getUI()).calculateTabWidth(tabPlacement, i, metrics);
                int tabX = rect.x + rect.width;
                int n = offset = i == tabCount - 1 ? 1 : 35;
                if (tabX > tabAreaWidth - offset && this.myFirstTrailingOverflowTab < 0) {
                    if (i > this.myTabbedPane.getSelectedIndex()) {
                        this.myFirstTrailingOverflowTab = i;
                    } else {
                        recalculateLeadingOverflow = true;
                    }
                }
                if (i == this.myTabbedPane.getSelectedIndex()) {
                    selectedTabRect.setBounds(rect);
                }
            }
            ++i;
        }
        if (selectedTabRect.x + selectedTabRect.width <= tabAreaWidth - 35) {
            return;
        }
        if (recalculateLeadingOverflow) {
            if (selectedTabRect.width + 35 > tabAreaWidth) {
                this.myLastLeadingOverflowTab = this.myTabbedPane.getSelectedIndex();
            } else {
                int selectedTabOverflow = selectedTabRect.x + selectedTabRect.width - tabAreaWidth;
                int leadingWidth = -35;
                int idx = 0;
                while (idx < this.myTabbedPane.getSelectedIndex()) {
                    if ((leadingWidth += rects[idx].width) > selectedTabOverflow && this.myLastLeadingOverflowTab <= 0) {
                        this.myLastLeadingOverflowTab = idx;
                        break;
                    }
                    if (idx == this.myTabbedPane.getSelectedIndex() - 1 && this.myLastLeadingOverflowTab <= 0) {
                        this.myLastLeadingOverflowTab = idx;
                    }
                    ++idx;
                }
            }
        }
    }

    public int getLastVisibleTab() {
        if (this.myFirstTrailingOverflowTab > 0) {
            return this.myFirstTrailingOverflowTab - 1;
        }
        return this.myTabbedPane.getTabCount() - 1;
    }

    public Rectangle getOverflowRectangle() {
        return this.myOverflowRectangle;
    }

    public boolean hasLeadingOverflow() {
        return this.myLastLeadingOverflowTab >= 0;
    }

    public boolean hasOverflow() {
        return this.hasLeadingOverflow() || this.hasTrailingOverflow();
    }

    public boolean hasTrailingOverflow() {
        return this.myFirstTrailingOverflowTab > 0;
    }

    public boolean isInLeadingOverflow(int index) {
        if (this.hasLeadingOverflow()) {
            return index <= this.myLastLeadingOverflowTab;
        }
        return false;
    }

    public boolean isInOverflow(int index) {
        return this.isInLeadingOverflow(index) || this.isInTrailingOverflow(index);
    }

    public boolean isInTrailingOverflow(int index) {
        if (this.hasTrailingOverflow()) {
            return index >= this.myFirstTrailingOverflowTab;
        }
        return false;
    }

    public boolean isOverflowRollovered() {
        return this.myOverflowRollovered;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.myOverflowRollovered = false;
        if (this.hasOverflow()) {
            this.myTabbedPane.repaint(this.myOverflowRectangle);
            int selectedIndex = this.myTabbedPane.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.myTabbedPane.getTabCount()) {
                this.myTabbedPane.repaint(this.myTabbedPane.getUI().getTabBounds(this.myTabbedPane, selectedIndex));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.myOverflowRollovered = false;
        if (this.hasOverflow()) {
            this.myOverflowRollovered = this.myOverflowRectangle.contains(e.getPoint());
            this.myTabbedPane.repaint(this.myOverflowRectangle);
            int selectedIndex = this.myTabbedPane.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.myTabbedPane.repaint(this.myTabbedPane.getUI().getTabBounds(this.myTabbedPane, selectedIndex));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.myOverflowRectangle.contains(e.getPoint()) && !this.myOverflowPopup.isVisible() && this.myTabbedPane.isEnabled()) {
            this.showOverflowPopup();
        } else {
            this.myOverflowPopup.setVisible(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.myOverflowRectangle.contains(e.getPoint())) {
            this.myTabbedPane.repaint(this.myOverflowRectangle);
        }
    }

    public void navigateSelectedTab(int direction) {
        if (direction == 1 || direction == 5) {
            if (!this.myOverflowPopup.isVisible()) {
                this.showOverflowPopup();
                this.myOverflowPopup.setSelectedItem(0);
            } else {
                if (direction == 5) {
                    this.myOverflowPopup.setSelectedItem(this.getNextEnabledTab(this.myOverflowPopup.getSelectedIndex()));
                } else {
                    this.myOverflowPopup.setSelectedItem(this.getPreviousEnabledTab(this.myOverflowPopup.getSelectedIndex()));
                }
                this.myTabbedPane.repaint();
            }
            return;
        }
        this.myOverflowPopup.setVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("indexForTitle".equals(propName)) {
            this.myTabLayoutChanged = true;
        } else if ("AccessibleVisibleData".equals(propName) && evt.getNewValue() instanceof Icon) {
            this.myTabLayoutChanged = true;
        }
    }

    public void setOverflowButtonBounds(int x, int y, int width, int height) {
        this.myOverflowRectangle.setBounds(x, y, width, height);
        this.myOverflowPopup.setOverflowButtonBounds(x, y, width, height);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.myOverflowTabSelected = this.isInOverflow(this.myTabbedPane.getSelectedIndex());
        if (this.myOverflowPopup.isVisible()) {
            this.myOverflowPopup.setVisible(false);
        }
    }

    public void updateCachedValues(int tabAreaWidth, int tabAreaX, Rectangle[] rects) {
        if (this.myOverflowTabSelected || this.myTabbedPane.getWidth() != this.myCachedWidth || this.myCachedSize != this.myTabbedPane.getTabCount() || this.myTabLayoutChanged) {
            this.myCachedWidth = this.myTabbedPane.getWidth();
            this.myCachedSize = this.myTabbedPane.getTabCount();
            this.myTabLayoutChanged = false;
            this.calculateOverflowIndices(tabAreaX, tabAreaWidth, rects);
        }
    }

    private Point calculatePopupPosition() {
        Point result = new Point();
        result.x = this.myOverflowRectangle.x - 4;
        switch (this.myTabbedPane.getTabPlacement()) {
            case 1: {
                result.y = this.myOverflowRectangle.y + this.myOverflowRectangle.height;
                break;
            }
            case 3: {
                this.myOverflowPopup.setPopupSize();
                result.y = this.myOverflowRectangle.y - this.myOverflowPopup.getPreferredSize().height;
                break;
            }
        }
        return result;
    }

    private int getNextEnabledTab(int startIndex) {
        int idx = startIndex + 1;
        while (idx < this.myOverflowPopup.getListSize()) {
            Integer tab = this.myOverflowPopup.getElementAt(idx);
            if (this.myTabbedPane.isEnabledAt(tab)) {
                return idx;
            }
            ++idx;
        }
        return startIndex;
    }

    private int getPreviousEnabledTab(int startIndex) {
        int idx = startIndex - 1;
        while (idx >= 0) {
            Integer tab = this.myOverflowPopup.getElementAt(idx);
            if (this.myTabbedPane.isEnabledAt(tab)) {
                return idx;
            }
            --idx;
        }
        return startIndex;
    }

    private void initialiseOverflowPopupList() {
        this.myListModel.removeAllElements();
        if (this.hasLeadingOverflow() || this.hasTrailingOverflow()) {
            int idx = 0;
            while (idx < this.myTabbedPane.getTabCount()) {
                this.myListModel.addElement(idx);
                ++idx;
            }
        }
    }

    private void showOverflowPopup() {
        if (!this.hasOverflow()) {
            return;
        }
        this.initialiseOverflowPopupList();
        Point popupPosition = this.calculatePopupPosition();
        this.myOverflowPopup.show(this.myTabbedPane, popupPosition.x, popupPosition.y);
        this.myOverflowPopup.repaint();
    }

    private class EnterAction
    extends AbstractAction {
        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (!tabbedPane.isEnabled()) {
                return;
            }
            if (TabbedPaneOverflowSupport.this.myOverflowPopup.isVisible()) {
                Integer selectedTab = (Integer)TabbedPaneOverflowSupport.this.myOverflowPopup.getSelectedValue();
                if (selectedTab != null) {
                    tabbedPane.setSelectedIndex(selectedTab);
                }
            } else {
                JRootPane root = SwingUtilities.getRootPane(tabbedPane);
                if (root != null) {
                    Action action;
                    Object obj;
                    InputMap im = root.getInputMap(2);
                    ActionMap am = root.getActionMap();
                    if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = am.get(obj)) != null) {
                        action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                    }
                }
            }
        }
    }

    private class HidePopupAction
    extends AbstractAction {
        private HidePopupAction() {
        }

        @Override
        public boolean isEnabled() {
            return TabbedPaneOverflowSupport.this.myOverflowPopup != null && TabbedPaneOverflowSupport.this.myOverflowPopup.isVisible();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (tabbedPane.isEnabled()) {
                TabbedPaneOverflowSupport.this.myOverflowPopup.setVisible(false);
            }
        }
    }
}

