/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.tabbedpane;

import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class TabbedPaneUtils {
    public static Shape getTabShape(int placemenet, int x, int y, int width, int height) {
        GeneralPath path = new GeneralPath();
        int round = NetTheme.getNormalRounding() + 2;
        switch (placemenet) {
            case 1: {
                path.moveTo(0.0f, height - 1);
                path.lineTo(0.0f, round / 2 + 1);
                path.quadTo(0.0f, 0.0f, round / 2 + 1, 0.0f);
                path.lineTo(width - round / 2 - 2, 0.0f);
                path.quadTo(width - 1, 0.0f, width - 1, round / 2 + 1);
                path.lineTo(width - 1, height - 1);
                break;
            }
            case 3: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(0.0f, height - round / 2 - 1);
                path.quadTo(0.0f, height - 1, round / 2 + 1, height - 1);
                path.lineTo(width - round / 2 - 2, height - 1);
                path.quadTo(width - 1, height - 1, width - 1, height - round / 2 - 1);
                path.lineTo(width - 1, 0.0f);
                break;
            }
            case 2: {
                path.moveTo(width - 1, 0.0f);
                path.lineTo(round / 2, 0.0f);
                path.quadTo(0.0f, 0.0f, 0.0f, round / 2);
                path.lineTo(0.0f, height - round / 2);
                path.quadTo(0.0f, height - 1, round / 2, height - 1);
                path.lineTo(width - 1, height - 1);
                break;
            }
            case 4: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(width - round / 2, 0.0f);
                path.quadTo(width - 1, 0.0f, width - 1, round / 2);
                path.lineTo(width - 1, height - round / 2);
                path.quadTo(width - 1, height - 1, width - 1 - round / 2, height - 1);
                path.lineTo(0.0f, height - 1);
                break;
            }
        }
        path.transform(AffineTransform.getTranslateInstance(x, y));
        return path;
    }

    public static void paintEmphasis(JComponent tabbedPane, int tabPlacement, Graphics2D g2, int x, int y, int width, int height, boolean paintAsHovered, Color hoveroutline) {
        Color color = UIManager.getColor("TabbedPane.selectedTabEmphasis1");
        Shape clippy = g2.getClip();
        g2.clipRect(x, y, width, 8);
        Shape emphasis = TabbedPaneUtils.getTabShape(tabPlacement, x, y, width, 9);
        GradientUtils.drawVerticalGradientOutline(tabbedPane, (Graphics)g2, new Color[]{color, paintAsHovered ? hoveroutline : UIManager.getColor("TabbedPane.darkShadow")}, emphasis);
        g2.setClip(clippy);
        g2.setColor(UIManager.getColor("TabbedPane.selectedTabEmphasis2"));
        g2.drawLine(x + 4, y + 1, x + width - 5, y + 1);
        g2.setColor(NetUtils.getColor("TabbedPane.selectedTabEmphasis2", 110));
        g2.drawLine(x + 3, y + 2, x + 3, y + 2);
        g2.drawLine(x + width - 4, y + 2, x + width - 4, y + 2);
        g2.setColor(NetUtils.getColor("TabbedPane.selectedTabEmphasis2", 200));
        g2.drawLine(x + 4, y + 1, x + 4, y + 1);
        g2.drawLine(x + width - 5, y + 1, x + width - 5, y + 1);
        g2.setColor(paintAsHovered ? hoveroutline : UIManager.getColor("TabbedPane.darkShadow"));
        g2.drawLine(x, y + 8, x, y + height - 1);
        g2.drawLine(x + width - 1, y + 8, x + width - 1, y + height - 1);
    }
}

