/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.table;

import com.nokia.laf.util.PopupCloseEventHandler;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public class DefaultHeaderPopupMenu
extends JPopupMenu
implements UIResource,
PopupMenuListener {
    private JRadioButtonMenuItem myHiddenPrimary = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem myPrimaryAscending;
    private JRadioButtonMenuItem myPrimaryDescending;
    private JRadioButtonMenuItem myHiddenSecondary = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem mySecondaryAscending;
    private JRadioButtonMenuItem mySecondaryDescending;
    private JRadioButtonMenuItem myHiddenTertiary = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem myTertiaryAscending;
    private JRadioButtonMenuItem myTertiaryDescending;
    private JMenu myPrimarySortMenu;
    private JMenu mySecondarySortMenu;
    private JMenu myTertiarySortMenu;
    private int myMouseOverColumn = -1;
    private static final int PRIMARY = 1;
    private static final int SECONDARY = 2;
    private static final int TERTIARY = 3;
    private MouseListener myMouseHandler;
    private PopupCloseEventHandler myPopupCloseEventHandler;

    public DefaultHeaderPopupMenu(JTableHeader header) {
        this.addPopupMenuListener(this);
        this.setInvoker(header);
        this.myMouseHandler = new MouseHandler();
        header.addMouseListener(this.myMouseHandler);
        this.myPopupCloseEventHandler = new PopupCloseEventHandler(this);
        this.myPrimarySortMenu = new JMenu(WidgetResources.getString("Table.sortAsPrimary"));
        this.myPrimaryAscending = new JRadioButtonMenuItem(new PopupSortAction(1, 1));
        this.myPrimaryDescending = new JRadioButtonMenuItem(new PopupSortAction(2, 1));
        new MenuHelper(this.myPrimaryAscending, this.myPrimaryDescending, this.myHiddenPrimary);
        this.myPrimarySortMenu.add(this.myPrimaryAscending);
        this.myPrimarySortMenu.add(this.myPrimaryDescending);
        this.mySecondarySortMenu = new JMenu(WidgetResources.getString("Table.sortAsSecondary"));
        this.mySecondaryAscending = new JRadioButtonMenuItem(new PopupSortAction(1, 2));
        this.mySecondaryDescending = new JRadioButtonMenuItem(new PopupSortAction(2, 2));
        new MenuHelper(this.mySecondaryAscending, this.mySecondaryDescending, this.myHiddenSecondary);
        this.mySecondarySortMenu.add(this.mySecondaryAscending);
        this.mySecondarySortMenu.add(this.mySecondaryDescending);
        this.myTertiarySortMenu = new JMenu(WidgetResources.getString("Table.sortAsTertiary"));
        this.myTertiaryAscending = new JRadioButtonMenuItem(new PopupSortAction(1, 3));
        this.myTertiaryDescending = new JRadioButtonMenuItem(new PopupSortAction(2, 3));
        new MenuHelper(this.myTertiaryAscending, this.myTertiaryDescending, this.myHiddenTertiary);
        this.myTertiarySortMenu.add(this.myTertiaryAscending);
        this.myTertiarySortMenu.add(this.myTertiaryDescending);
        this.add(this.myPrimarySortMenu);
        this.add(this.mySecondarySortMenu);
        this.add(this.myTertiarySortMenu);
    }

    public void uninstallUI() {
        this.getInvoker().removeMouseListener(this.myMouseHandler);
    }

    private PSortableTableModel getSortableModel() {
        JTableHeader header = (JTableHeader)this.getInvoker();
        if (header == null || header.getTable() == null || !(header.getTable().getModel() instanceof PSortableTableModel)) {
            return null;
        }
        return (PSortableTableModel)header.getTable().getModel();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myPopupCloseEventHandler);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myPopupCloseEventHandler);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.armPopup();
        this.updateMenuSelections();
        this.updateMenuEnabledState();
    }

    private void armPopup() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myPopupCloseEventHandler, 80L);
    }

    private void updateMenuEnabledState() {
        PSortableTableModel sortModel = this.getSortableModel();
        this.myPrimarySortMenu.setEnabled(true);
        if (sortModel != null) {
            int modelColumn;
            JTable table;
            JTableHeader header = (JTableHeader)this.getInvoker();
            if (header != null && sortModel != null && this.myMouseOverColumn >= 0 && (table = header.getTable()) != null && (modelColumn = table.convertColumnIndexToModel(this.myMouseOverColumn)) >= 0 && !sortModel.isColumnSortable(modelColumn)) {
                this.myPrimarySortMenu.setSelected(false);
                this.myPrimarySortMenu.setEnabled(false);
                this.mySecondarySortMenu.setEnabled(false);
                this.myTertiarySortMenu.setEnabled(false);
                return;
            }
            int primarySort = sortModel.getSortedColumnIndex();
            int secondarySort = sortModel.getSecondarySortedColumnIndex();
            this.mySecondarySortMenu.setEnabled(primarySort >= 0 && this.myMouseOverColumn != primarySort);
            this.myTertiarySortMenu.setEnabled(primarySort >= 0 && secondarySort >= 0 && this.myMouseOverColumn != primarySort && this.myMouseOverColumn != secondarySort);
        }
    }

    private void updateMenuSelections() {
        PSortableTableModel sortModel = this.getSortableModel();
        if (sortModel != null) {
            this.updateMenuSelection(sortModel, sortModel.getSortedColumnIndex(), this.myPrimaryAscending, this.myPrimaryDescending, this.myHiddenPrimary);
            this.updateMenuSelection(sortModel, sortModel.getSecondarySortedColumnIndex(), this.mySecondaryAscending, this.mySecondaryDescending, this.myHiddenSecondary);
            this.updateMenuSelection(sortModel, sortModel.getTertiarySortedColumnIndex(), this.myTertiaryAscending, this.myTertiaryDescending, this.myHiddenTertiary);
        }
    }

    private void updateMenuSelection(PSortableTableModel sortModel, int sortColumn, JMenuItem ascending, JMenuItem descending, JMenuItem hidden) {
        JTableHeader header = (JTableHeader)this.getInvoker();
        JTable table = header.getTable();
        int modelColumn = table.convertColumnIndexToModel(this.myMouseOverColumn);
        if (sortColumn >= 0 && modelColumn == sortColumn) {
            int direction = sortModel.getSortDirection(sortColumn);
            if (direction == 1) {
                ascending.setSelected(true);
            } else if (direction == 2) {
                descending.setSelected(true);
            }
        } else {
            hidden.setSelected(true);
        }
    }

    private static class MenuHelper
    extends ButtonGroup {
        public MenuHelper(JMenuItem ... menuItems) {
            JMenuItem[] jMenuItemArray = menuItems;
            int n = menuItems.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem abstractButton = jMenuItemArray[n2];
                this.add(abstractButton);
                ++n2;
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTableHeader header = (JTableHeader)DefaultHeaderPopupMenu.this.getInvoker();
            DefaultHeaderPopupMenu.this.myMouseOverColumn = header.columnAtPoint(e.getPoint());
        }
    }

    private class PopupSortAction
    extends AbstractAction {
        private int myDirection;
        private int myLevel;

        public PopupSortAction(int direction, int level) {
            this.myDirection = direction;
            this.myLevel = level;
            this.putValue("Name", direction == 1 ? WidgetResources.getString("Table.ascending") : WidgetResources.getString("Table.descending"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PSortableTableModel sortModel = DefaultHeaderPopupMenu.this.getSortableModel();
            if (DefaultHeaderPopupMenu.this.myMouseOverColumn < 0 || sortModel == null) {
                return;
            }
            JTableHeader header = (JTableHeader)DefaultHeaderPopupMenu.this.getInvoker();
            JTable table = header.getTable();
            int modelColumn = table.convertColumnIndexToModel(DefaultHeaderPopupMenu.this.myMouseOverColumn);
            if (this.myLevel == 1) {
                if (modelColumn != sortModel.getSortedColumnIndex()) {
                    sortModel.resetSortColumns();
                }
                sortModel.sort(this.myDirection, modelColumn);
            } else if (this.myLevel == 2) {
                sortModel.secondarySort(this.myDirection, modelColumn);
            } else if (this.myLevel == 3) {
                sortModel.tertiarySort(this.myDirection, modelColumn);
            }
            DefaultHeaderPopupMenu.this.getInvoker().repaint();
        }
    }
}

