/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.table;

import com.nokia.laf.NetComboBoxUI;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.table.InlineFilterListCellRenderer;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.TableRowFilter;
import com.nokia.widgets.table.TextColumnFilter;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.SwingWorker;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class FilterCombo
extends PComboBox
implements DocumentListener,
PopupMenuListener,
TableModelListener {
    public static final Object SHOW_ALL_ITEM = new ShowAllItem();
    private final JTable myTable;
    private TextColumnFilter myTextFilter = null;
    private int myColumnIndex = -1;
    private Timer myInputDelayTimer;
    private boolean myModelReady = false;
    private boolean myUpdatingPopup = false;
    private boolean myValueSelectedFromPopup = false;
    private SwingWorker<List<Object>> myWorker;
    private static final Border PROGRESS_LABEL_BORDER = BorderFactory.createEmptyBorder(2, 3, 2, 4);

    public FilterCombo(JTable table, int columnIndex) {
        this.myTable = table;
        this.setSizeVariant("small");
        this.setUI(new FilterComboBoxUI());
        this.myTextFilter = new TextColumnFilter(null, columnIndex);
        this.myColumnIndex = columnIndex;
        this.setEditable(true);
        this.myInputDelayTimer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filterText = ((JTextComponent)FilterCombo.this.getEditorComponent()).getText();
                if (filterText != null && "".equals(filterText)) {
                    FilterCombo.this.myTextFilter.setFilterText(null);
                } else {
                    FilterCombo.this.myTextFilter.setFilterText(filterText);
                }
                FilterCombo.this.filterTable();
            }
        });
        this.myInputDelayTimer.setRepeats(false);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        FilterComboBoxModel model = new FilterComboBoxModel();
        model.addElement(SHOW_ALL_ITEM);
        this.setModel(model);
        this.setSelectedItem(SHOW_ALL_ITEM);
        this.setMaximumRowCount(16);
        this.addPopupMenuListener(this);
        this.myTable.getModel().addTableModelListener(this);
        this.myTable.addPropertyChangeListener("model", this);
        this.setPackPopupWidth(true);
        this.setRenderer(new InlineFilterListCellRenderer(this, table, this.myColumnIndex));
        this.initEditor();
        this.setHorizontalAlignment();
        this.putClientProperty("OrangeTouch.bottomHighlight", NetTheme.getMidGrayOutline());
    }

    @Override
    public void updateUI() {
        this.setUI(new FilterComboBoxUI());
    }

    public void clear() {
        PTextField textEditor = (PTextField)this.getEditorComponent();
        this.setSelectedItem(SHOW_ALL_ITEM);
        textEditor.setText("");
    }

    @Override
    public void setEditor(ComboBoxEditor editor) {
        PTextField oldEditor = (PTextField)this.getEditorComponent();
        if (oldEditor != null) {
            oldEditor.removeDocumentListener(this);
        }
        super.setEditor(new FilterComboBoxEditor());
        if (editor != null) {
            this.initEditor();
        }
    }

    private void initEditor() {
        PTextField editorComponent = (PTextField)this.getEditorComponent();
        editorComponent.setClearable(true);
        editorComponent.setPrompt(WidgetResources.getString("Table.filter"));
        editorComponent.putClientProperty("OrangeTouch.normalTextPrompt", true);
        editorComponent.addDocumentListener(this);
        editorComponent.setSizeVariant("small");
    }

    public boolean hasFiltering() {
        return this.myTextFilter.isActive();
    }

    public TableRowFilter getFilter() {
        return new TableRowFilter(){

            @Override
            public boolean isIncluded(int row, PSortableTableModel model) {
                return FilterCombo.this.myTextFilter.isIncluded(row, model);
            }

            @Override
            public boolean isActive() {
                return FilterCombo.this.myTextFilter.isActive();
            }
        };
    }

    public void setComboBoxButtonVisible(boolean visible) {
        this.putClientProperty("OrangeTouch.comboBoxButtonHidden", !visible);
    }

    public void setHorizontalAlignment() {
        Class<?> columnClass = this.myTable.getModel().getColumnClass(this.myColumnIndex);
        if (columnClass != null) {
            if (Number.class.isAssignableFrom(columnClass)) {
                this.setHorizontalAlignment(4);
            } else if (Boolean.class.isAssignableFrom(columnClass)) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(10);
            }
        }
    }

    public int getColumnIndex() {
        return this.myColumnIndex;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.myUpdatingPopup) {
            return;
        }
        if (!this.myValueSelectedFromPopup) {
            this.myModelReady = false;
            this.myInputDelayTimer.restart();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        if (this.myWorker != null) {
            this.myWorker.cancel(true);
            ((PSortableTableModel)this.myTable.getModel()).filter();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.myWorker != null && !this.myUpdatingPopup) {
            this.myWorker.cancel(true);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.myModelReady) {
            return;
        }
        this.myWorker = this.createWorker();
        ((NetComboBoxUI)this.getUI()).getComboPopup().setComponent(this.createProgressLabel());
        this.myWorker.start();
    }

    private JLabel createProgressLabel() {
        PLabel progress = PLabel.createValueText(WidgetResources.getString("Table.Loading"));
        progress.setBorder(PROGRESS_LABEL_BORDER);
        progress.setBackground(Color.WHITE);
        progress.setOpaque(true);
        return progress;
    }

    private SwingWorker<List<Object>> createWorker() {
        return new SwingWorker<List<Object>>(){

            @Override
            protected List<Object> construct() throws Exception {
                PSortableTableModel sortModel = (PSortableTableModel)FilterCombo.this.myTable.getModel();
                return sortModel.getUniqueValues(FilterCombo.this.myColumnIndex);
            }

            @Override
            protected void finished() {
                try {
                    FilterCombo.this.myUpdatingPopup = true;
                    List elements = (List)this.get();
                    DefaultComboBoxModel model = (DefaultComboBoxModel)FilterCombo.this.getModel();
                    String text = ((PTextField)FilterCombo.this.getEditorComponent()).getText();
                    if (text != null && text.length() > 0 && !SHOW_ALL_ITEM.equals(FilterCombo.this.getSelectedItem())) {
                        model.setSelectedItem(text);
                    }
                    model.removeAllElements();
                    model.addElement(SHOW_ALL_ITEM);
                    for (Object element : elements) {
                        model.addElement(element);
                    }
                    PTextField textComp = (PTextField)FilterCombo.this.getEditorComponent();
                    if (textComp.getText() == null || "".equals(textComp.getText())) {
                        textComp.setPrompt(SHOW_ALL_ITEM.equals(FilterCombo.this.getSelectedItem()) ? WidgetResources.getString("Table.filter") : WidgetResources.getString("Table.blanks"));
                    }
                    ((NetComboBoxUI)FilterCombo.this.getUI()).getComboPopup().restoreList();
                    FilterCombo.this.myUpdatingPopup = false;
                    FilterCombo.this.myModelReady = true;
                }
                catch (Exception e) {
                    FilterCombo.this.myUpdatingPopup = false;
                    FilterCombo.this.myModelReady = false;
                    ((PSortableTableModel)FilterCombo.this.myTable.getModel()).filter();
                    ((NetComboBoxUI)FilterCombo.this.getUI()).getComboPopup().hide();
                }
            }
        };
    }

    private void filterTable() {
        ((PSortableTableModel)this.myTable.getModel()).filter();
        JTableHeader header = this.myTable.getTableHeader();
        header.repaint(header.getHeaderRect(this.myTable.convertColumnIndexToView(this.myColumnIndex)));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.myModelReady = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("model".equals(evt.getPropertyName()) && evt.getSource() == this.myTable) {
            TableModel oldModel = (TableModel)evt.getOldValue();
            oldModel.removeTableModelListener(this);
            TableModel newModel = (TableModel)evt.getNewValue();
            newModel.addTableModelListener(this);
            this.myModelReady = false;
        }
    }

    public class FilterComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource {
        private boolean myHandlingPermanentFocusLostEvent = false;

        @Override
        public void setItem(Object item) {
            if (this.myHandlingPermanentFocusLostEvent) {
                return;
            }
            PTextField editorComponent = (PTextField)this.getEditorComponent();
            if (FilterCombo.this.myUpdatingPopup) {
                return;
            }
            if (FilterCombo.this.myInputDelayTimer != null) {
                FilterCombo.this.myInputDelayTimer.stop();
            }
            FilterCombo.this.myValueSelectedFromPopup = true;
            super.setItem(item);
            FilterCombo.this.myValueSelectedFromPopup = false;
            editorComponent.putClientProperty("OrangeTouch.normalTextPrompt", Boolean.FALSE);
            if (FilterCombo.this.getSelectedItem() == SHOW_ALL_ITEM) {
                FilterCombo.this.myTextFilter.setFilterText(null);
            } else {
                String text = this.editor.getText();
                FilterCombo.this.myTextFilter.setFilterText(text);
                if ("".equals(text)) {
                    editorComponent.putClientProperty("OrangeTouch.normalTextPrompt", Boolean.TRUE);
                    editorComponent.setPrompt(WidgetResources.getString("Table.blanks"));
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilterCombo.this.filterTable();
                }
            });
        }

        public FilterComboBoxEditor() {
            this.editor = new PTextField("", 9){

                @Override
                public void setText(String newvalue) {
                    String text = newvalue;
                    if (this.getText().equals(text)) {
                        return;
                    }
                    if (text != null && text.length() > 0) {
                        text = "\"" + text + "\"";
                    }
                    super.setText(text);
                }

                @Override
                protected void processKeyEvent(KeyEvent e) {
                    if (FilterCombo.this.myWorker != null && e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                        FilterCombo.this.myWorker.cancel(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((NetComboBoxUI)FilterCombo.this.getUI()).getComboPopup().hide();
                            }
                        });
                    }
                    super.processKeyEvent(e);
                }

                @Override
                protected void processFocusEvent(FocusEvent e) {
                    FilterComboBoxEditor.this.myHandlingPermanentFocusLostEvent = !e.isTemporary();
                    super.processFocusEvent(e);
                    FilterComboBoxEditor.this.myHandlingPermanentFocusLostEvent = false;
                }
            };
            this.editor.setMargin(new Insets(0, 0, 1, 1));
            this.editor.putClientProperty("OrangeTouch.openRightEdge", true);
            this.editor.setBorder(UIManager.getBorder("ComboBox.Editor.border"));
        }

        @Override
        public Component getEditorComponent() {
            Integer alignment = ClientPropertyUtil.integerValue(FilterCombo.this, "Combobox.horizontalAlignment");
            if (!ClientProperties.UNKNOWN_VALUE.equals(alignment)) {
                this.editor.setHorizontalAlignment(alignment);
            }
            return super.getEditorComponent();
        }
    }

    private class FilterComboBoxModel
    extends DefaultComboBoxModel {
        private FilterComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object item) {
            PSortableTableModel sortModel;
            int firstRow;
            if (SHOW_ALL_ITEM.equals(item) || item == null || item instanceof String || "".equals(item)) {
                super.setSelectedItem(item);
                return;
            }
            int viewColumn = FilterCombo.this.myTable.convertColumnIndexToView(FilterCombo.this.myColumnIndex);
            Class<?> columnClass = FilterCombo.this.myTable.getColumnClass(viewColumn);
            Object castedItem = item;
            if (columnClass != null && !columnClass.isInstance(item)) {
                if (columnClass == Double.class && item instanceof Number) {
                    castedItem = ((Number)item).doubleValue();
                } else {
                    return;
                }
            }
            if ((firstRow = (sortModel = (PSortableTableModel)FilterCombo.this.myTable.getModel()).getFirstRowOfValue(castedItem, FilterCombo.this.myColumnIndex)) < 0) {
                super.setSelectedItem("");
            } else {
                String stringValue = sortModel.getStringValueAt(sortModel.getOriginalIndex(firstRow), FilterCombo.this.myColumnIndex);
                super.setSelectedItem(stringValue);
            }
        }
    }

    private class FilterComboBoxUI
    extends NetComboBoxUI {
        private FilterComboBoxUI() {
        }

        @Override
        public void update(Graphics g, JComponent comp) {
            g.setColor(UIManager.getColor("Table.filterAreaBackground"));
            g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
            g.setColor(FilterCombo.this.myTable.getGridColor());
            g.drawLine(0, comp.getHeight() - 1, comp.getWidth(), comp.getHeight() - 1);
            this.paint(g, comp);
        }
    }

    private static class ShowAllItem {
        private ShowAllItem() {
        }

        public String toString() {
            return "";
        }

        public Object valueOf(String text) {
            return this;
        }
    }
}

