/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.table;

import com.nokia.laf.NetTableHeaderUI;
import com.nokia.laf.borders.NetTableHeaderCellBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.table.PTableHeaderRenderer;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public class NetTrailingCornerComponent
extends PTableHeaderRenderer
implements UIResource {
    private JButton myClearFilterButton;
    private CloseIcon myCloseIcon;
    private JComponent myAuxiliaryComponent;

    public NetTrailingCornerComponent() {
        this.setEnabled(false);
        this.setLayout(null);
        this.setOpaque(false);
        this.putClientProperty("Table.isRightEnd", true);
        this.setBorder(BorderFactory.createCompoundBorder(new NetTableHeaderCellBorder(false), BorderFactory.createEmptyBorder()));
        this.myCloseIcon = new CloseIcon();
        this.myCloseIcon.setSize(13);
        this.myCloseIcon.setPaintRoundBackground(true);
        this.myCloseIcon.setBackgroundColor(NetUtils.decodeColor("#AAAAAA"));
        this.myCloseIcon.setColor(NetUtils.decodeColor("#F5F5F5"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        if (parent instanceof JComponent) {
            this.putClientProperty("OrangeTouch.rootPane", SwingUtilities.getRootPane(parent));
        }
    }

    public void setAuxiliaryComponent(JComponent comp) {
        if (comp == null) {
            if (this.myAuxiliaryComponent != null) {
                this.remove(this.myAuxiliaryComponent);
                this.revalidate();
                this.repaint();
            }
            return;
        }
        if (comp != this.myAuxiliaryComponent) {
            this.myAuxiliaryComponent = comp;
            this.add(this.myAuxiliaryComponent);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.myClearFilterButton != null) {
            JScrollPane scroll = (JScrollPane)this.getParent();
            if (scroll != null && scroll.getVerticalScrollBarPolicy() == 22) {
                Dimension prefSize = this.myClearFilterButton.getPreferredSize();
                this.myClearFilterButton.setBounds((int)((double)this.getWidth() - prefSize.getWidth()) - 2, this.getHeight() - prefSize.height - 7, prefSize.width, prefSize.height);
            } else {
                this.myClearFilterButton.setBounds(-1, -1, 0, 0);
            }
        }
        if (this.myAuxiliaryComponent != null) {
            Dimension prefSize = this.myAuxiliaryComponent.getPreferredSize();
            this.myAuxiliaryComponent.setBounds((int)((double)this.getWidth() - prefSize.getWidth()) / 2, 3, prefSize.width, prefSize.height);
        }
    }

    public void setClearAllButtonActive(boolean active) {
        this.myCloseIcon.setBackgroundColor(active ? NetUtils.decodeColor("#333333") : NetUtils.decodeColor("#AAAAAA"));
    }

    public void setClearFilterButtonShown(boolean clearFilterButtonShown) {
        if (clearFilterButtonShown) {
            this.myClearFilterButton = new JButton(this.myCloseIcon);
            this.myClearFilterButton.setRolloverIcon(this.myCloseIcon);
            this.myClearFilterButton.setFocusable(false);
            NetUtils.setCursor(this.myClearFilterButton);
            this.myClearFilterButton.setToolTipText(WidgetResources.getString("Table.clearAllFilters"));
            this.myClearFilterButton.setBorder(BorderFactory.createEmptyBorder());
            this.myClearFilterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTableHeader header;
                    if (!(NetTrailingCornerComponent.this.getParent() instanceof JScrollPane)) {
                        return;
                    }
                    JScrollPane scroll = (JScrollPane)NetTrailingCornerComponent.this.getParent();
                    if (scroll.getViewport().getView() instanceof JTable && scroll.getColumnHeader().getView() instanceof JTableHeader && (header = (JTableHeader)scroll.getColumnHeader().getView()).getUI() instanceof NetTableHeaderUI) {
                        NetTableHeaderUI netTableHeaderUI = (NetTableHeaderUI)header.getUI();
                        netTableHeaderUI.clearInlineFilters();
                        NetTrailingCornerComponent.this.repaint();
                    }
                }
            });
            this.add(this.myClearFilterButton);
            this.revalidate();
            this.repaint();
        } else if (this.myClearFilterButton != null) {
            this.remove(this.myClearFilterButton);
            this.myClearFilterButton = null;
            this.revalidate();
            this.repaint();
        }
    }
}

