/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.table;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public class TableUtils {
    private static JTableHeader getTableHeader(JComponent headerRenderer) {
        Container parent = headerRenderer.getParent();
        if (parent == null || !(parent.getParent() instanceof JTableHeader)) {
            return null;
        }
        return (JTableHeader)parent.getParent();
    }

    public static void paintTableHeaderBackground(Graphics g, JComponent comp) {
        Color topColor;
        boolean paintAsDisabled;
        JTableHeader tableHeader = TableUtils.getTableHeader(comp);
        if (tableHeader == null) {
            return;
        }
        boolean bl = paintAsDisabled = tableHeader != null && !tableHeader.isEnabled() || tableHeader != null && tableHeader.getTable() != null && !tableHeader.getTable().isEnabled();
        if (comp.isOpaque()) {
            GradientUtils.drawVerticalBackgroundGradient(tableHeader, g);
        }
        Object oldAa = NetUtils.antiAliasingOn(g);
        boolean straightLeft = tableHeader != null && tableHeader.getTable() != null && Boolean.TRUE.equals(tableHeader.getTable().getClientProperty("OrangeTouch.isStraightLeftEdge"));
        comp.putClientProperty("OrangeTouch.isStraightLeftEdge", straightLeft);
        Shape fill = TableUtils.getFillShape(comp, straightLeft);
        Color color = topColor = tableHeader.getBackground() instanceof UIResource ? NetLookAndFeel.getWhite() : tableHeader.getBackground();
        if (paintAsDisabled) {
            g.setColor(NetUtils.isInDialog(tableHeader) ? UIManager.getColor("Table.disabledDialogBackground") : NetTheme.getMidGrayOutline());
            ((Graphics2D)g).fill(fill);
        } else {
            GradientUtils.drawVerticalGradient(comp, g, new Color[]{topColor, topColor}, fill);
            Color bottomColor = tableHeader.getBackground() instanceof UIResource ? UIManager.getColor("TableHeader.bottomColor") : tableHeader.getBackground();
            GradientUtils.drawVerticalGradient(comp, g, new Color[]{topColor, bottomColor}, (Shape)new Rectangle2D.Double(1.0, comp.getHeight() / 3 + 3, comp.getWidth() - 2, 2 * comp.getHeight() / 3 - 3));
        }
        NetUtils.setAntialiasing(g, oldAa);
    }

    private static Shape getFillShape(JComponent c, boolean straightLeft) {
        boolean isLeftmostCell = Boolean.TRUE.equals(c.getClientProperty("Table.isLeftEnd")) && !straightLeft;
        boolean isRightmostCell = Boolean.TRUE.equals(c.getClientProperty("Table.isRightEnd"));
        int rounding = NetTheme.getNormalRounding();
        if (isLeftmostCell) {
            if (isRightmostCell) {
                return NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 1, c.getHeight() - 1, rounding, 5);
            }
            return NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 1, c.getHeight() - 1, rounding, 3, 5);
        }
        if (isRightmostCell) {
            return NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 1, c.getHeight() - 1, rounding, 7, 5);
        }
        return new Rectangle2D.Double(1.0, 1.0, c.getWidth(), c.getHeight());
    }
}

