/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class NetBasicCaret
extends DefaultCaret {
    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if ((SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) && this.getComponent().getComponentPopupMenu() != null && !this.getComponent().hasFocus()) {
            this.positionCaret(e);
            this.adjustFocus();
        }
    }

    @Override
    public void paint(Graphics g) {
        Shape oldClip = g.getClip();
        Rectangle clip = g.getClipBounds();
        if (clip.getHeight() > 4.0) {
            ++clip.y;
            clip.height -= 2;
        }
        g.clipRect(clip.x, clip.y, clip.width, clip.height);
        super.paint(g);
        g.setClip(oldClip);
    }

    private void adjustFocus() {
        JTextComponent comp = this.getComponent();
        if (comp != null && comp.isEnabled() && comp.isRequestFocusEnabled()) {
            comp.requestFocus();
        }
    }

    public static class UIResource
    extends NetBasicCaret {
    }
}

