/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.text;

import com.nokia.laf.text.NetBasicCaret;
import com.nokia.widgets.labels.PStaticLabel;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class NetCaret
extends NetBasicCaret {
    private boolean myIsKeyboardFocusEvent = true;

    @Override
    public void paint(Graphics g) {
        boolean adjustCaretLocation;
        boolean bl = adjustCaretLocation = this.getMark() >= 0 && this.getDot() == this.getComponent().getText().length() && this.getMark() != this.getDot();
        if (adjustCaretLocation) {
            g.translate(3, 0);
        }
        super.paint(g);
        if (adjustCaretLocation) {
            g.translate(-3, 0);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        final JTextComponent textComponent = this.getComponent();
        Object prompt = textComponent.getClientProperty("OrangeTouch.prompt");
        Object label = textComponent.getClientProperty("OrangeTouch.label");
        if (prompt != null || label != null) {
            textComponent.repaint();
        }
        Container parent = textComponent.getParent();
        if (textComponent.isEnabled() && textComponent.isEditable() && this.myIsKeyboardFocusEvent && parent != null && parent.getParent() != null && !(parent instanceof PStaticLabel) && !(parent instanceof JTable) && !(parent.getParent() instanceof JTable) && !(parent.getParent().getParent() instanceof JTable)) {
            if (textComponent instanceof JFormattedTextField) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComponent.selectAll();
                    }
                });
            } else {
                textComponent.selectAll();
            }
        }
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary()) {
            this.myIsKeyboardFocusEvent = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            this.myIsKeyboardFocusEvent = false;
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isPopupTrigger()) {
            this.myIsKeyboardFocusEvent = false;
            JTextComponent component = this.getComponent();
            if (component != null && component.isEnabled() && component.isEditable() && component.isRequestFocusEnabled()) {
                component.requestFocus();
            }
        }
    }

    public static class UIResource
    extends NetCaret {
    }
}

