/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.text;

import com.nokia.laf.util.NetUtils;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.Element;
import javax.swing.text.FieldView;

public class NetFieldView
extends FieldView {
    private int myTextOffset = 3;
    private int myViewHeightIncrement = 2;

    public NetFieldView(Element elem, int viewHeightIncrement, int textOffset) {
        super(elem);
        this.myViewHeightIncrement = viewHeightIncrement;
        this.myTextOffset = textOffset;
    }

    public NetFieldView(Element elem, int viewHeightIncrement) {
        super(elem);
        this.myViewHeightIncrement = viewHeightIncrement;
    }

    public NetFieldView(Element elem) {
        super(elem);
    }

    @Override
    protected Rectangle lineToRect(Shape shape, int line) {
        JTextField field;
        Rectangle rect = super.lineToRect(shape, line);
        rect.x += this.myTextOffset;
        Container container = this.getContainer();
        if (container instanceof JTextField && NetUtils.isTableEditorTextField(field = (JTextField)container)) {
            boolean rightAligned = field.getHorizontalAlignment() == 4 || field.getHorizontalAlignment() == 11;
            ++rect.y;
            boolean comboEditor = field.getParent() instanceof JComboBox;
            int rightAligOffset = comboEditor ? 1 : 3;
            int leftAlignedOffset = -1;
            rect.x = rect.x + (rightAligned ? rightAligOffset : leftAlignedOffset);
        }
        return rect;
    }

    @Override
    public float getPreferredSpan(int axis) {
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)Math.max(2 * this.myTextOffset, 2);
        } else if (axis == 1) {
            span += (float)this.myViewHeightIncrement;
        }
        return span;
    }
}

