/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.text;

import com.nokia.laf.NetTheme;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;

public class NetHTMLEditorKit
extends HTMLEditorKit
implements HyperlinkListener {
    private JEditorPane myEditorPane;
    private Element myHoveredLink;

    @Override
    public Document createDefaultDocument() {
        HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
        Color hyperLinkColor = SystemUtils.isOrangeTouch() ? UIManager.getColor("Hyperlink.foreground") : Color.BLACK;
        String cssLinkColor = "rgb(" + hyperLinkColor.getRed() + "," + hyperLinkColor.getGreen() + "," + hyperLinkColor.getBlue() + ")";
        doc.getStyleSheet().addRule("a { color: " + cssLinkColor + "}");
        return doc;
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        this.myEditorPane = c;
        this.myEditorPane.addHyperlinkListener(this);
    }

    @Override
    public void deinstall(JEditorPane c) {
        super.deinstall(c);
        this.myEditorPane.removeHyperlinkListener(this);
    }

    @Override
    public ViewFactory getViewFactory() {
        return new NetHTMLFactory();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Element oldHoveredElement = this.myHoveredLink;
        this.myHoveredLink = e.getEventType() == HyperlinkEvent.EventType.ENTERED ? e.getSourceElement() : null;
        if (oldHoveredElement != this.myHoveredLink) {
            this.myEditorPane.repaint();
        }
    }

    private class NetHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private NetHTMLFactory() {
        }

        @Override
        public View create(Element elem) {
            AttributeSet attrs = elem.getAttributes();
            AttributeSet anchor = (AttributeSet)attrs.getAttribute(HTML.Tag.A);
            if (anchor != null && anchor.getAttribute(HTML.Attribute.HREF) != null) {
                return new NetLinkView(elem);
            }
            return super.create(elem);
        }
    }

    private class NetLinkView
    extends InlineView {
        public NetLinkView(Element elem) {
            super(elem);
        }

        @Override
        public boolean isUnderline() {
            return false;
        }

        @Override
        public void paint(Graphics g, Shape a) {
            Color oldColor = g.getColor();
            g.setColor(NetHTMLEditorKit.this.myEditorPane.isEnabled() ? NetTheme.getHoverColor() : NetTheme.getDisabledComponentOutlineColor());
            Rectangle bounds = a.getBounds();
            g.drawLine(bounds.x, bounds.y + bounds.height - 2, bounds.x + bounds.width, bounds.y + bounds.height - 2);
            g.setColor(oldColor);
            super.paint(g, a);
        }
    }
}

