/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.text;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class NetTextComponentHandler
implements FocusListener,
DocumentListener,
PropertyChangeListener {
    private String myPropertyPrefix;
    private JTextComponent myComponent;

    public NetTextComponentHandler(String propertyPrefix, JTextComponent component) {
        this.myPropertyPrefix = propertyPrefix;
        this.myComponent = component;
        this.installTo(component);
    }

    public void installTo(JTextComponent comp) {
        if (comp != null) {
            this.setSizeVariant(comp);
            if (!ClientPropertyUtil.booleanValue(comp, "OrangeTouch.displayErrorIcon", true)) {
                LookAndFeel.installColors(comp, String.valueOf(this.myPropertyPrefix) + ".background", String.valueOf(this.myPropertyPrefix) + ".invalidForeground");
            }
            comp.addFocusListener(this);
            comp.addPropertyChangeListener(this);
            if (comp.getDocument() != null) {
                DocumentListener handler = (DocumentListener)comp.getClientProperty("OrangeTouch.handler");
                if (handler != null) {
                    comp.getDocument().removeDocumentListener(handler);
                }
                comp.getDocument().addDocumentListener(this);
                if (handler != null) {
                    comp.getDocument().addDocumentListener(handler);
                }
            }
        }
    }

    public void uninstallFrom(JTextComponent comp) {
        if (comp != null) {
            comp.removeFocusListener(this);
            comp.removePropertyChangeListener(this);
            if (comp.getDocument() != null) {
                comp.getDocument().removeDocumentListener(this);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        JTextComponent src = (JTextComponent)e.getSource();
        if (src != null) {
            src.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        JTextComponent src = (JTextComponent)evt.getSource();
        if (src != null) {
            src.repaint();
        }
        if (evt.isTemporary() || src == null || !src.isEnabled() || !src.isEditable()) {
            return;
        }
        if (evt.getOppositeComponent() instanceof AbstractButton) {
            List buttons = (List)src.getClientProperty("TextField.associatedButtons");
            AbstractButton btn = (AbstractButton)evt.getOppositeComponent();
            if (btn.getModel().isPressed() && buttons != null && buttons.contains(btn)) {
                return;
            }
        }
        if (!Boolean.TRUE.equals(src.getClientProperty("TextField.validateOnFocusLost"))) {
            return;
        }
        if (Boolean.TRUE.equals(src.getClientProperty("invalidEntry")) && Boolean.FALSE.equals(src.getClientProperty("requiredButMissing"))) {
            src.putClientProperty("OrangeTouch.displayInvalidEntry", true);
            if (!ClientPropertyUtil.booleanValue(src, "OrangeTouch.displayErrorIcon", true)) {
                LookAndFeel.installColors(src, String.valueOf(this.myPropertyPrefix) + ".background", String.valueOf(this.myPropertyPrefix) + ".invalidForeground");
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (!this.myComponent.hasFocus()) {
            return;
        }
        if (Boolean.TRUE.equals(this.myComponent.getClientProperty("invalidEntry")) && Boolean.TRUE.equals(this.myComponent.getClientProperty("TextField.validateOnFocusLost"))) {
            this.myComponent.putClientProperty("OrangeTouch.displayInvalidEntry", false);
            if (!ClientPropertyUtil.booleanValue(this.myComponent, "OrangeTouch.displayErrorIcon", true)) {
                LookAndFeel.installColors(this.myComponent, String.valueOf(this.myPropertyPrefix) + ".background", String.valueOf(this.myPropertyPrefix) + ".foreground");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent field = (JComponent)evt.getSource();
        String propertyName = evt.getPropertyName();
        boolean requiredButMissing = Boolean.TRUE.equals(field.getClientProperty("requiredButMissing"));
        boolean validateOnFocusLost = Boolean.TRUE.equals(field.getClientProperty("TextField.validateOnFocusLost"));
        boolean allowEmptyValuesAsInvalid = UIManager.getBoolean("OrangeTouch.TextComponent.allowEmptyValuesAsInvalid");
        if ("mandatoryEntry".equals(propertyName) || "requiredButMissing".equals(propertyName)) {
            if (requiredButMissing && !allowEmptyValuesAsInvalid) {
                field.putClientProperty("OrangeTouch.displayInvalidEntry", false);
                if (!ClientPropertyUtil.booleanValue(this.myComponent, "OrangeTouch.displayErrorIcon", true)) {
                    LookAndFeel.installColors(field, String.valueOf(this.myPropertyPrefix) + ".background", String.valueOf(this.myPropertyPrefix) + ".foreground");
                }
            } else if (!(!Boolean.TRUE.equals(field.getClientProperty("invalidEntry")) || validateOnFocusLost && field.hasFocus())) {
                field.putClientProperty("OrangeTouch.displayInvalidEntry", true);
                if (!ClientPropertyUtil.booleanValue(this.myComponent, "OrangeTouch.displayErrorIcon", true)) {
                    LookAndFeel.installColors(field, String.valueOf(this.myPropertyPrefix) + ".invalidBackground", String.valueOf(this.myPropertyPrefix) + ".foreground");
                }
            }
            field.repaint();
        } else if ("invalidEntry".equals(propertyName)) {
            String foreground;
            String background;
            boolean notFocusedOrMissing;
            if (validateOnFocusLost && !field.hasFocus() && field.getParent() instanceof JComboBox) {
                return;
            }
            field.putClientProperty("OrangeTouch.displayInvalidEntry", true);
            boolean bl = notFocusedOrMissing = !field.hasFocus() && !requiredButMissing;
            if (Boolean.TRUE.equals(evt.getNewValue()) && (notFocusedOrMissing || !validateOnFocusLost && !requiredButMissing)) {
                background = ".invalidBackground";
                foreground = ".invalidForeground";
            } else {
                background = ".background";
                foreground = ".foreground";
            }
            if (!ClientPropertyUtil.booleanValue(this.myComponent, "OrangeTouch.displayErrorIcon", true)) {
                LookAndFeel.installColors(field, String.valueOf(this.myPropertyPrefix) + background, String.valueOf(this.myPropertyPrefix) + foreground);
            }
        } else if ("document".equals(propertyName)) {
            Document oldDocument = (Document)evt.getOldValue();
            Document newDocument = (Document)evt.getNewValue();
            if (oldDocument != null) {
                oldDocument.removeDocumentListener(this);
            }
            if (newDocument != null) {
                newDocument.addDocumentListener(this);
            }
        } else if ("enabled".equals(evt.getPropertyName()) || "editable".equals(evt.getPropertyName())) {
            if (Boolean.TRUE.equals(evt.getNewValue()) && ComponentUtils.isInvalid(field) && !requiredButMissing) {
                field.putClientProperty("OrangeTouch.displayInvalidEntry", true);
                if (!ClientPropertyUtil.booleanValue(this.myComponent, "OrangeTouch.displayErrorIcon", true)) {
                    LookAndFeel.installColors(field, String.valueOf(this.myPropertyPrefix) + ".background", String.valueOf(this.myPropertyPrefix) + ".invalidForeground");
                }
            }
        } else if ("JComponent.sizeVariant".equals(propertyName) && field instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)field;
            this.setSizeVariant(textComponent);
        }
    }

    private void setSizeVariant(JTextComponent comp) {
        if (NetUtils.lookAndFeelCanReplace(comp.getMargin())) {
            if (ComponentUtils.isSmall(comp)) {
                comp.setMargin(UIManager.getInsets(String.valueOf(this.myPropertyPrefix) + ".smallmargin"));
            } else {
                comp.setMargin(UIManager.getInsets(String.valueOf(this.myPropertyPrefix) + ".margin"));
            }
        }
    }
}

