/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.text;

import com.nokia.laf.util.PopupCloseEventHandler;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class TextComponentPopupMenu
extends JPopupMenu
implements UIResource,
PopupMenuListener {
    private JTextComponent myTextComponent;
    private PopupCloseEventHandler myPopupCloseEventHandler;

    public TextComponentPopupMenu(JTextComponent component) {
        this.myTextComponent = component;
        this.myPopupCloseEventHandler = new PopupCloseEventHandler(this);
        this.addPopupMenuListener(this);
        this.add(new CutAction());
        this.add(new CopyAction());
        this.add(new PasteAction());
        this.add(new DeleteAction());
        this.add(new JPopupMenu.Separator());
        this.add(new SelectAllAction());
    }

    private boolean hasSelection() {
        return this.myTextComponent.getCaret() != null && this.myTextComponent.getSelectionEnd() != this.myTextComponent.getSelectionStart();
    }

    public boolean isTextModifiable() {
        return !ComponentUtils.isReadOnly(this.myTextComponent) && this.myTextComponent.isEnabled() && this.myTextComponent.isEditable();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myPopupCloseEventHandler);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myPopupCloseEventHandler);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.armPopup();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractButton button;
            Component comp = componentArray[n2];
            if (comp instanceof AbstractButton && (button = (AbstractButton)comp).getAction() != null) {
                button.setEnabled(button.getAction().isEnabled());
            }
            ++n2;
        }
    }

    private void armPopup() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myPopupCloseEventHandler, 80L);
    }

    private class CopyAction
    extends TextActionWrapper {
        public CopyAction() {
            super(new DefaultEditorKit.CopyAction(), "CopyAction_Text", "CopyPopupAction_Mnemonic");
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && TextComponentPopupMenu.this.hasSelection();
        }
    }

    private class CutAction
    extends TextActionWrapper {
        public CutAction() {
            super(new DefaultEditorKit.CutAction(), "CutAction_Text", "CutAction_Mnemonic");
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && TextComponentPopupMenu.this.hasSelection() && TextComponentPopupMenu.this.isTextModifiable();
        }
    }

    private class DeleteAction
    extends TextAction {
        public DeleteAction() {
            super(WidgetResources.getString("DeleteAction_Text"));
            this.putValue("MnemonicKey", WidgetResources.getMnemonic("DeleteAction_Mnemonic"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TextComponentPopupMenu.this.myTextComponent != null && TextComponentPopupMenu.this.myTextComponent.getCaret() != null) {
                Document doc = TextComponentPopupMenu.this.myTextComponent.getDocument();
                int start = TextComponentPopupMenu.this.myTextComponent.getSelectionStart();
                int end = TextComponentPopupMenu.this.myTextComponent.getSelectionEnd();
                try {
                    doc.remove(start, end - start);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && TextComponentPopupMenu.this.hasSelection() && TextComponentPopupMenu.this.isTextModifiable();
        }
    }

    private class PasteAction
    extends TextActionWrapper {
        public PasteAction() {
            super(new DefaultEditorKit.PasteAction(), "PasteAction_Text", "PasteAction_Mnemonic");
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && TextComponentPopupMenu.this.isTextModifiable();
        }
    }

    private class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(WidgetResources.getString("SelectAllAction_Text"));
            this.putValue("MnemonicKey", WidgetResources.getMnemonic("SelectAllAction_Mnemonic"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TextComponentPopupMenu.this.myTextComponent != null) {
                Document doc = TextComponentPopupMenu.this.myTextComponent.getDocument();
                TextComponentPopupMenu.this.myTextComponent.setCaretPosition(0);
                TextComponentPopupMenu.this.myTextComponent.moveCaretPosition(doc.getLength());
            }
        }

        @Override
        public boolean isEnabled() {
            if (TextComponentPopupMenu.this.myTextComponent.getCaret() == null) {
                return true;
            }
            if (!TextComponentPopupMenu.this.myTextComponent.isEnabled()) {
                return false;
            }
            int end = TextComponentPopupMenu.this.myTextComponent.getSelectionEnd();
            int start = TextComponentPopupMenu.this.myTextComponent.getSelectionStart();
            if (TextComponentPopupMenu.this.myTextComponent.getText() == null) {
                return false;
            }
            if (!TextComponentPopupMenu.this.myTextComponent.isFocusable()) {
                return false;
            }
            return end - start < TextComponentPopupMenu.this.myTextComponent.getText().length();
        }
    }

    private class TextActionWrapper
    extends AbstractAction {
        protected Action myDelegate;

        public TextActionWrapper(Action action, String nameKey, String mnemonicKey) {
            this.myDelegate = action;
            this.putValue("Name", WidgetResources.getString(nameKey));
            this.putValue("MnemonicKey", WidgetResources.getMnemonic(mnemonicKey));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDelegate.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return this.myDelegate.isEnabled();
        }
    }
}

