/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.toolbar;

import com.nokia.laf.NetBorderFactory;
import com.nokia.laf.NetButtonUI;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.painters.GradientAlphaFilter;
import com.nokia.laf.toolbar.WindowGrabber;
import com.nokia.laf.toolbar.WrappingLayout;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.buttons.PToggleToolButton;
import com.nokia.widgets.icons.OverflowIcon;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class OverflowButton
extends PToggleToolButton
implements ComponentListener {
    private static final Border CHANGE_LAYOUT_BUTTON_BORDER = new CompoundBorder(new MatteBorder(1, 0, 0, 0, NetTheme.getComponentOutlineColor()), BorderFactory.createEmptyBorder(3, 6, 4, 6));
    private static final Border CHANGE_LAYOUT_BUTTON_BORDER_WRAPPING = BorderFactory.createEmptyBorder(3, 6, 4, 6);
    private static final String ALLOW_SEVERAL_ROWS_ACTION_PROPERTY = "allowSeveralRows";
    private AbstractButton myChangeLayoutButton;
    private WindowGrabber myGrabber;
    private JPanel myPopupPanel = new JPanel();
    private Window myPopupWindow;
    private JComponent myToolBar;
    private LayoutManager mySavedOriginalLayout;
    private OverflowIcon myOverflowIcon = new OverflowIcon();
    private Image mySeparatorImage = null;
    private static Color SEPARATOR_COLOR = NetUtils.decodeColor("#A2A2A2");
    private static Color OVERFLOW_ICON_COLOR = NetUtils.decodeColor("#5F5F5F");

    public OverflowButton(JComponent toolBar) {
        this.myChangeLayoutButton = this.createChangeLayoutButton();
        this.myToolBar = toolBar;
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setMargin(ComponentUtils.isSmall(toolBar) ? new Insets(4, 4, 1, 12) : new Insets(14, 7, 7, 12));
        this.myPopupPanel.setLayout(WrappingLayout.createComponentWrappingLayout());
        this.setAction(new ShowOverflowPopupAction());
    }

    public Component addToPopup(Component comp) {
        return this.addToPopup(comp, -1);
    }

    public Component addToPopup(Component comp, int index) {
        this.myPopupPanel.add(comp, index);
        if (comp instanceof JButton || comp instanceof JToggleButton) {
            ((JComponent)comp).putClientProperty("toolButton", this.myToolBar instanceof JToolBar);
            ((JComponent)comp).updateUI();
        }
        return comp;
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
        this.getModel().setSelected(false);
        Component[] comps = this.getOverflowComponents();
        int idx = 0;
        while (idx < comps.length) {
            this.myToolBar.add(comps[idx]);
            ++idx;
        }
        if (this.myPopupWindow != null) {
            this.myPopupWindow.removeComponentListener(this);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public Component[] getOverflowComponents() {
        return this.myPopupPanel.getComponents();
    }

    public void hidePopup() {
        if (this.myPopupWindow != null && this.myPopupWindow.isVisible()) {
            this.myGrabber.hidePopupWindow();
        }
    }

    public int getOverflowComponentCount() {
        return this.myPopupPanel.getComponents().length;
    }

    protected AbstractButton createChangeLayoutButton() {
        ChangeLayoutAction changeLayoutAction = new ChangeLayoutAction();
        changeLayoutAction.putValue(ALLOW_SEVERAL_ROWS_ACTION_PROPERTY, Boolean.TRUE);
        JButton button = new JButton(changeLayoutAction);
        button.setUI((ButtonUI)ChangeLayoutButtonUI.createUI(button));
        button.setBackground(Color.WHITE);
        button.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        button.setBorder(CHANGE_LAYOUT_BUTTON_BORDER);
        button.setFocusable(false);
        return button;
    }

    protected Window createOverflowPopupWindow(Window owner, JPanel popupPanel, AbstractButton changeLayoutButton) {
        JWindow popup = new JWindow(owner);
        NetUtils.setTransparent(popup);
        popup.setFocusableWindowState(true);
        popup.setFocusable(true);
        JPanel midPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Insets insets = this.getInsets();
                g.setColor(this.getBackground());
                Object oldAa = NetUtils.antiAliasingOn(g);
                ((Graphics2D)g).fillRoundRect(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom), 10, 10);
                NetUtils.setAntialiasing(g, oldAa);
            }
        };
        midPanel.setOpaque(false);
        midPanel.setBackground(this.myToolBar.getBackground());
        midPanel.setBorder(NetBorderFactory.getPopupMenuBorder());
        midPanel.putClientProperty("OrangeTouch.invoker", this);
        popup.getContentPane().add(midPanel);
        midPanel.add(popupPanel);
        JComponent toolBar = this.myToolBar;
        boolean isWrappingEnabled = ClientPropertyUtil.booleanValue(toolBar, "OrangeTouch.toolbarWrappingEnabled");
        if (isWrappingEnabled) {
            midPanel.add((Component)changeLayoutButton, "South");
        }
        return popup;
    }

    public int calculateOverflowIndex(Container parent) {
        this.resetOverflow(parent);
        if (!this.allowSeveralRows()) {
            return Integer.MAX_VALUE;
        }
        Insets insets = parent.getInsets();
        int idx = 0;
        while (idx < parent.getComponentCount()) {
            Component comp = parent.getComponent(idx);
            if (comp.getX() + comp.getWidth() > parent.getWidth() - insets.right || comp.getX() == -100) {
                return idx;
            }
            ++idx;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected void paintComponent(Graphics g) {
        ColorUIResource iconColor = this.getModel().isRollover() || this.myPopupWindow != null && this.myPopupWindow.isVisible() ? NetTheme.getHoverColor() : OVERFLOW_ICON_COLOR;
        this.myOverflowIcon.setColor(iconColor);
        super.paintComponent(g);
        if (this.mySeparatorImage == null || this.mySeparatorImage.getHeight(null) != this.getHeight()) {
            this.mySeparatorImage = this.createSeparator();
        }
        g.drawImage(this.mySeparatorImage, 0, 0, null);
    }

    private Image createSeparator() {
        BufferedImage image = ImageUtils.createEmptyImage(this.getHeight(), 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(NetLookAndFeel.getWhite());
        g2d.drawLine(0, 0, image.getWidth(), 0);
        g2d.setColor(SEPARATOR_COLOR);
        g2d.drawLine(0, 1, image.getWidth(), 1);
        g2d.dispose();
        GradientAlphaFilter filter = new GradientAlphaFilter(image.getWidth() / 4, image.getWidth());
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(producer);
        return ImageUtils.createRotatedImage(img, false);
    }

    public void resetOverflow(Container parent) {
        Component[] overflowComponents = this.getOverflowComponents();
        int idx = 0;
        while (idx < overflowComponents.length) {
            parent.add(overflowComponents[idx]);
            ++idx;
        }
        this.hidePopup();
    }

    private boolean allowSeveralRows() {
        return Boolean.TRUE.equals(this.myChangeLayoutButton.getAction().getValue(ALLOW_SEVERAL_ROWS_ACTION_PROPERTY));
    }

    private class ChangeLayoutAction
    extends AbstractAction {
        public ChangeLayoutAction() {
            this.putValue("Name", WidgetResources.getString("ToolBar.AllowSeveralRows"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OverflowButton.this.myGrabber.hidePopupWindow();
            boolean allowSeveralRows = OverflowButton.this.allowSeveralRows();
            OverflowButton.this.myChangeLayoutButton.getAction().putValue(OverflowButton.ALLOW_SEVERAL_ROWS_ACTION_PROPERTY, !allowSeveralRows);
            if (allowSeveralRows) {
                OverflowButton.this.mySavedOriginalLayout = OverflowButton.this.myToolBar.getLayout();
                OverflowButton.this.myToolBar.setLayout(WrappingLayout.createSeparatorWrappingLayout());
                this.putValue("Name", WidgetResources.getString("ToolBar.AllowSingleRow"));
                Component[] comps = OverflowButton.this.getOverflowComponents();
                int idx = 0;
                while (idx < comps.length) {
                    OverflowButton.this.myToolBar.add(comps[idx]);
                    ++idx;
                }
            } else {
                OverflowButton.this.myToolBar.setLayout(OverflowButton.this.mySavedOriginalLayout);
                this.putValue("Name", WidgetResources.getString("ToolBar.AllowSeveralRows"));
            }
            OverflowButton.this.myToolBar.revalidate();
            OverflowButton.this.myToolBar.repaint();
        }
    }

    private static class ChangeLayoutButtonUI
    extends NetButtonUI {
        private static ChangeLayoutButtonUI theButtonUI = new ChangeLayoutButtonUI();

        private ChangeLayoutButtonUI() {
        }

        public static ComponentUI createUI(JComponent comp) {
            return theButtonUI;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton button = (AbstractButton)c;
            boolean rollover = button.getModel().isRollover();
            if (rollover) {
                g.setColor(UIManager.getColor("MenuItem.selectionBackground"));
                g.fillRect(1, 2, button.getWidth() - 3, button.getHeight() - 3);
            }
            super.paint(g, c);
        }

        @Override
        protected void paintButtonPressed(Graphics g, AbstractButton btn) {
        }
    }

    private class ShowOverflowPopupAction
    extends AbstractAction {
        public ShowOverflowPopupAction() {
            OverflowButton.this.myOverflowIcon.setColor(OVERFLOW_ICON_COLOR);
            this.putValue("SmallIcon", OverflowButton.this.myOverflowIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isWrapping = OverflowButton.this.myToolBar.getLayout() instanceof WrappingLayout;
            if (isWrapping) {
                OverflowButton.this.myChangeLayoutButton.setBorder(CHANGE_LAYOUT_BUTTON_BORDER_WRAPPING);
            }
            this.addOverflowComponentsToPopup();
            if (!OverflowButton.this.getModel().isSelected() && OverflowButton.this.myPopupWindow != null) {
                OverflowButton.this.myPopupWindow.setVisible(false);
                return;
            }
            if (OverflowButton.this.myPopupWindow != null) {
                OverflowButton.this.myPopupWindow.dispose();
            }
            Insets insets = OverflowButton.this.myPopupPanel.getInsets();
            Dimension prefSize = OverflowButton.this.myChangeLayoutButton.getPreferredSize();
            int popupWidth = prefSize.width + insets.left + insets.right;
            OverflowButton.this.myPopupPanel.putClientProperty("WrappingLayout.width", popupWidth);
            Window parentWindow = SwingUtilities.getWindowAncestor(OverflowButton.this);
            OverflowButton.this.myPopupPanel.setBackground(new Color(OverflowButton.this.myToolBar.getBackground().getRGB()));
            OverflowButton.this.myPopupWindow = OverflowButton.this.createOverflowPopupWindow(parentWindow, OverflowButton.this.myPopupPanel, OverflowButton.this.myChangeLayoutButton);
            OverflowButton.this.myPopupWindow.addComponentListener(OverflowButton.this);
            OverflowButton.this.myPopupWindow.pack();
            this.setPopupWindowLocation();
            OverflowButton.this.myGrabber = new WindowGrabber(OverflowButton.this.myPopupWindow);
            OverflowButton.this.myGrabber.grabWindow(parentWindow);
            OverflowButton.this.myPopupWindow.setVisible(true);
        }

        private void addOverflowComponentsToPopup() {
            JComponent toolbar = OverflowButton.this.myToolBar;
            int firstToOverflow = OverflowButton.this.calculateOverflowIndex(OverflowButton.this.myToolBar);
            int numberOfOverflowComponents = toolbar.getComponentCount() - firstToOverflow - 1;
            int idx = 0;
            while (idx <= numberOfOverflowComponents) {
                Component comp = toolbar.getComponent(firstToOverflow);
                OverflowButton.this.addToPopup(comp);
                ++idx;
            }
        }

        private void setPopupWindowLocation() {
            int ph;
            int x = OverflowButton.this.getLocationOnScreen().x - 2;
            int y = OverflowButton.this.getLocationOnScreen().y + OverflowButton.this.getSize().height;
            Rectangle scrBounds = OverflowButton.this.getGraphicsConfiguration().getBounds();
            int pw = ((OverflowButton)OverflowButton.this).myPopupPanel.getPreferredSize().width;
            if (x + pw > scrBounds.x + scrBounds.width) {
                x = scrBounds.x + scrBounds.width - pw - ((OverflowButton)OverflowButton.this).myPopupPanel.getPreferredSize().width;
            }
            if (y + (ph = ((OverflowButton)OverflowButton.this).myPopupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                y = scrBounds.y + scrBounds.height - ph;
            }
            OverflowButton.this.myPopupWindow.setLocation(x, y);
        }
    }
}

