/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.toolbar;

import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class WindowGrabber
implements AWTEventListener,
ComponentListener,
WindowListener,
ChangeListener {
    private JComponent myLastSubPopup = null;
    private Window myParentWindow;
    private Container myPopupWindow;

    public WindowGrabber(Container popupWindow) {
        this.myPopupWindow = popupWindow;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!this.myPopupWindow.isVisible()) {
            return;
        }
        Component src = (Component)event.getSource();
        switch (event.getID()) {
            case 501: {
                if (this.isInPopup(src)) {
                    return;
                }
                this.hidePopupWindow();
                break;
            }
            case 502: {
                boolean isToolButton;
                if (this.myLastSubPopup instanceof JPopupMenu && this.isInPopup(((JPopupMenu)this.myLastSubPopup).getInvoker()) && SwingUtilities.isDescendingFrom(src, this.myLastSubPopup)) {
                    this.hidePopupWindow();
                    break;
                }
                boolean bl = isToolButton = src instanceof JComponent && ClientPropertyUtil.booleanValue((JComponent)src, "toolButton");
                if (!isToolButton || !this.isInPopup(src) || ((MouseEvent)event).isPopupTrigger()) break;
                this.hidePopupWindow();
                break;
            }
            case 506: {
                if (this.isInPopup(src)) {
                    return;
                }
                this.hidePopupWindow();
                break;
            }
            case 507: {
                this.hidePopupWindow();
                break;
            }
            case 401: {
                KeyEvent keyEvent = (KeyEvent)event;
                if (this.myLastSubPopup == null && keyEvent.getKeyCode() == 27) {
                    this.hidePopupWindow();
                    break;
                }
                if (keyEvent.getKeyCode() != 10 || !this.isInPopup(src) || !(src instanceof JTextComponent) || ((ActionListener[])src.getListeners(ActionListener.class)).length <= 0) break;
                this.hidePopupWindow();
                break;
            }
        }
    }

    public void grabWindow(Window window) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit().addAWTEventListener(WindowGrabber.this, 131128L);
                return null;
            }
        });
        this.myParentWindow = window;
        if (this.myParentWindow != null) {
            if (this.myParentWindow instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)this.myParentWindow)).getRootPane().addComponentListener(this);
            }
            this.myParentWindow.addComponentListener(this);
            this.myParentWindow.addWindowListener(this);
            MenuSelectionManager.defaultManager().addChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JPopupMenu popupMenu;
        Object[] menuPath = MenuSelectionManager.defaultManager().getSelectedPath();
        this.myLastSubPopup = menuPath != null && menuPath.length > 0 ? ((popupMenu = this.getLastPopupMenu(menuPath)) != null && this.isInPopup(popupMenu.getInvoker()) ? popupMenu : null) : null;
    }

    public void ungrabWindow() {
        MenuSelectionManager.defaultManager().removeChangeListener(this);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(WindowGrabber.this);
                return null;
            }
        });
        if (this.myParentWindow != null) {
            if (this.myParentWindow instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)this.myParentWindow)).getRootPane().removeComponentListener(this);
            }
            this.myParentWindow.removeComponentListener(this);
            this.myParentWindow.removeWindowListener(this);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.hidePopupWindow();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.hidePopupWindow();
    }

    void hidePopupWindow() {
        this.ungrabWindow();
        this.myPopupWindow.setVisible(false);
    }

    private JPopupMenu getLastPopupMenu(Object[] items) {
        int idx = items.length - 1;
        while (idx >= 0) {
            if (items[idx] instanceof JPopupMenu) {
                return (JPopupMenu)items[idx];
            }
            --idx;
        }
        return null;
    }

    private boolean isInPopup(Component src) {
        Component c = src;
        while (c != null) {
            if (c == this.myPopupWindow) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }
}

