/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.toolbar;

import com.nokia.widgets.layout.LayoutUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolBar;

abstract class WrappingLayout
implements LayoutManager {
    public static final String CONTAINER_WIDTH = "WrappingLayout.width";

    public static LayoutManager createComponentWrappingLayout() {
        return new WrappingLayout(){

            @Override
            protected boolean isGroupSeparator(Component comp) {
                return true;
            }
        };
    }

    public static LayoutManager createSeparatorWrappingLayout() {
        return new WrappingLayout(){

            @Override
            protected boolean isGroupSeparator(Component comp) {
                return comp instanceof JToolBar.Separator;
            }
        };
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int groupX = insets.left;
        int groupY = insets.top;
        int maxX = parent.getWidth() - insets.right;
        List<Integer> rowHeights = this.calculateRowHeights(parent, parent.getWidth());
        int rowNumber = 0;
        List<SeparatorGroup> groups = this.calculateSeparatorGroups(parent);
        for (SeparatorGroup group : groups) {
            int rowHeight = rowHeights.get(rowNumber);
            if (groupX + group.myGroupWidth > maxX && group.myGroupLocation > 0 && rowNumber < rowHeights.size() - 1) {
                groupX = insets.left;
                groupY += rowHeight;
                rowHeight = rowHeights.get(++rowNumber);
            }
            this.layoutGroup(parent, groupX, groupY, group, rowHeight);
            groupX += group.myGroupWidth;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int rows;
        int width = ClientPropertyUtil.intValue((JComponent)parent, CONTAINER_WIDTH);
        if (width < 0) {
            width = 100;
        }
        if ((rows = this.calculateRowHeights(parent, width).size()) == 1) {
            width = LayoutUtils.getPreferredWidth(parent);
        }
        return new Dimension(width, this.calculateTotalHeight(parent, width));
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    protected List<Integer> calculateRowHeights(Container parent, int containerWidth) {
        int maxHeight = 0;
        Insets insets = parent.getInsets();
        int xPosition = insets.left;
        int maxX = containerWidth - insets.right;
        ArrayList<Integer> maxRowHeights = new ArrayList<Integer>();
        List<SeparatorGroup> groups = this.calculateSeparatorGroups(parent);
        Iterator<SeparatorGroup> iterator = groups.iterator();
        while (iterator.hasNext()) {
            SeparatorGroup group = iterator.next();
            if (xPosition + group.myGroupWidth <= maxX) {
                maxHeight = Math.max(group.myGroupHeight, maxHeight);
                xPosition += group.myGroupWidth;
            } else {
                if (maxHeight > 0) {
                    maxRowHeights.add(maxHeight);
                }
                xPosition = insets.left + group.myGroupWidth;
                maxHeight = group.myGroupHeight;
            }
            if (iterator.hasNext()) continue;
            maxRowHeights.add(maxHeight);
        }
        return maxRowHeights;
    }

    protected int calculateTotalHeight(Container parent, int width) {
        List<Integer> heights = this.calculateRowHeights(parent, width);
        Insets insets = parent.getInsets();
        int totalheight = insets.top + insets.bottom;
        Iterator<Integer> iterator = heights.iterator();
        while (iterator.hasNext()) {
            totalheight += iterator.next().intValue();
        }
        return totalheight;
    }

    protected abstract boolean isGroupSeparator(Component var1);

    private List<SeparatorGroup> calculateSeparatorGroups(Container parent) {
        ArrayList<SeparatorGroup> result = new ArrayList<SeparatorGroup>();
        int currentGroupWidth = 0;
        int currentGroupHeight = 0;
        int groupSize = 0;
        int startIndex = 0;
        Component[] comps = parent.getComponents();
        int idx = 0;
        while (idx < comps.length) {
            Component comp = comps[idx];
            if (comp.isVisible()) {
                Dimension prefSize = comp.getPreferredSize();
                if (this.isGroupSeparator(comp)) {
                    result.add(new SeparatorGroup(currentGroupWidth, currentGroupHeight, startIndex, groupSize));
                    currentGroupWidth = 0;
                    currentGroupHeight = 0;
                    groupSize = 0;
                    startIndex = idx;
                }
                currentGroupWidth += prefSize.width;
                currentGroupHeight = Math.max(currentGroupHeight, prefSize.height);
                ++groupSize;
                if (idx == comps.length - 1) {
                    result.add(new SeparatorGroup(currentGroupWidth, currentGroupHeight, startIndex, groupSize));
                }
            }
            ++idx;
        }
        return result;
    }

    private void layoutGroup(Container parent, int groupX, int yPosition, SeparatorGroup group, int rowHeight) {
        Component[] comps = parent.getComponents();
        int componentX = groupX;
        int idx = 0;
        while (idx < group.myGroupSize) {
            Component comp = comps[group.myGroupLocation + idx];
            if (comp.isVisible()) {
                Dimension prefSize = comp.getPreferredSize();
                comp.setSize(prefSize);
                int midY = yPosition + rowHeight / 2;
                comp.setLocation(componentX, midY - prefSize.height / 2);
                componentX += prefSize.width;
            }
            ++idx;
        }
    }

    protected static class SeparatorGroup {
        int myGroupHeight;
        int myGroupLocation;
        int myGroupSize;
        int myGroupWidth;

        protected SeparatorGroup(int groupWidth, int groupHeight, int startIndex, int size) {
            this.myGroupWidth = groupWidth;
            this.myGroupHeight = groupHeight;
            this.myGroupLocation = startIndex;
            this.myGroupSize = size;
        }

        public String toString() {
            return "SeparatorGroup: width=" + this.myGroupWidth + ", height=" + this.myGroupHeight + ", size=" + this.myGroupSize + ", startIndex=" + this.myGroupLocation;
        }
    }
}

