/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.util;

import com.nokia.laf.painters.ButtonGradientPainter;
import com.nokia.laf.painters.GradientBackgroundPainter;
import com.nokia.laf.painters.GradientOutlinePainter;
import com.nokia.laf.painters.GradientShapePainter;
import com.nokia.laf.painters.LinearGradientPainter;
import com.nokia.laf.painters.ProgressBarPainter;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GradientUtils {
    public static void drawDoubleGradient(JComponent comp, Graphics g, String key, int x, int y, int width, int height) {
        Color[] gradient = (Color[])UIManager.get(key);
        GradientUtils.drawDoubleGradient(comp, g, gradient, width, height, x, y);
    }

    public static void drawDoubleGradient(JComponent comp, Graphics g, String key) {
        Color[] gradient = (Color[])UIManager.get(key);
        GradientUtils.drawDoubleGradient(comp, g, gradient, comp.getWidth(), comp.getHeight(), 0, 0);
    }

    public static void drawDoubleGradient(JComponent comp, Graphics g, Color[] gradient, int width, int height, int x, int y) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        ButtonGradientPainter.INSTANCE.paint(comp, (Graphics2D)g, gradient, x, y, width, height, true);
    }

    public static void drawHorizontalDoubleGradient(JComponent comp, Graphics g, String key, int x, int y, int width, int height) {
        Color[] gradient = (Color[])UIManager.get(key);
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        ButtonGradientPainter.INSTANCE.paint(comp, (Graphics2D)g, gradient, x, y, width, height, false);
    }

    public static void drawHorizontalGradient(JComponent comp, Graphics g, String key, int x, int y, int width, int height) {
        Color[] gradient = (Color[])UIManager.get(key);
        GradientUtils.drawHorizontalGradient(comp, g, gradient, x, y, width, height);
    }

    public static void drawHorizontalGradient(JComponent comp, Graphics g, Color[] gradient, int x, int y, int width, int height) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        LinearGradientPainter.INSTANCE.paint(comp, (Graphics2D)g, gradient, x, y, width, height, false);
    }

    public static void drawHorizontalGradient(JComponent comp, Graphics g, String key, Shape shape) {
        Color[] gradient = (Color[])UIManager.get(key);
        GradientUtils.drawHorizontalGradient(comp, g, gradient, shape);
    }

    public static void drawHorizontalGradient(JComponent comp, Graphics g, Color[] gradient, Shape shape) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = shape.getBounds();
        if (rect.width > 10000 || rect.height > 10000) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(new GradientPaint(rect.x, rect.y, gradient[0], rect.x + rect.width, rect.y, gradient[1]));
            g2d.fill(shape);
            g2d.setPaint(oldPaint);
            NetUtils.setAntialiasing(g, oldAa);
            return;
        }
        GradientShapePainter.INSTANCE.paint(comp, g2d, gradient, shape, false);
    }

    public static void drawVerticalGradient(JComponent comp, Graphics g, Color[] gradient, Shape shape) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle rect = shape.getBounds();
        if (rect.width > 10000 || rect.height > 10000) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(new GradientPaint(rect.x, rect.y, gradient[0], rect.x, rect.y + rect.height, gradient[1]));
            g2d.fill(shape);
            g2d.setPaint(oldPaint);
            NetUtils.setAntialiasing(g, oldAa);
            return;
        }
        GradientShapePainter.INSTANCE.paint(comp, g2d, gradient, shape, true);
    }

    public static void drawVerticalGradient(JComponent comp, Graphics g, String key, int x, int y, int width, int height) {
        Color[] gradient = (Color[])UIManager.get(key);
        GradientUtils.drawVerticalGradient(comp, g, gradient, x, y, width, height);
    }

    public static void drawVerticalGradient(JComponent comp, Graphics g, String key, Shape shape) {
        Color[] gradient = (Color[])UIManager.get(key);
        GradientUtils.drawVerticalGradient(comp, g, gradient, shape);
    }

    public static void drawVerticalBackgroundGradient(Container comp, Graphics g) {
        if (comp == null) {
            return;
        }
        GradientUtils.drawVerticalBackgroundGradient(comp, g, SwingUtilities.getLocalBounds(comp));
    }

    public static void drawVerticalBackgroundGradient(Container comp, Graphics g, Shape shape) {
        GradientUtils.drawVerticalBackgroundGradient(comp, g, shape, 0);
    }

    public static void drawVerticalBackgroundGradient(Container comp, Graphics g, int depth) {
        GradientUtils.drawVerticalBackgroundGradient(comp, g, SwingUtilities.getLocalBounds(comp), depth);
    }

    public static void drawVerticalBackgroundGradient(Container comp, Graphics g, Shape shape, int depth) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        GradientBackgroundPainter.paintBackground(comp, g2d, shape, depth);
    }

    public static void drawVerticalGradient(JComponent comp, Graphics g, Color[] gradient, int x, int y, int width, int height) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        LinearGradientPainter.INSTANCE.paint(comp, (Graphics2D)g, gradient, x, y, width, height, true);
    }

    public static void drawVerticalGradientOutline(JComponent comp, Graphics g, String resourceKey, Shape outline) {
        Color[] colors = (Color[])UIManager.get(resourceKey);
        GradientUtils.drawVerticalGradientOutline(comp, g, colors, outline);
    }

    public static void drawVerticalGradientOutline(JComponent comp, Graphics g, Color[] gradient, Shape outline) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        GradientOutlinePainter.INSTANCE.paint(comp, (Graphics2D)g, gradient, outline, true);
    }

    public static void drawHorizontalGradientOutline(JComponent comp, Graphics g, String resourceKey, Shape outline) {
        Color[] colors = (Color[])UIManager.get(resourceKey);
        GradientUtils.drawHorizontalGradientOutline(comp, g, colors, outline);
    }

    public static void drawHorizontalGradientOutline(JComponent comp, Graphics g, Color[] gradient, Shape outline) {
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        GradientOutlinePainter.INSTANCE.paint(comp, (Graphics2D)g, gradient, outline, false);
    }

    public static void drawToggleButtonGradient(JComponent comp, Graphics g, int x, int y, int width, int height) {
        Color[] gradient = (Color[])UIManager.get("ToggleButton.largeSelectedGradient");
        GradientUtils.drawVerticalGradient(comp, g, gradient, x, y, width, height);
    }

    public static void drawProgressBarGradient(JComponent comp, Graphics g, String key, boolean vertical, boolean leftToRight, boolean determinate, int x, int y, int width, int height) {
        Color[] gradient = (Color[])UIManager.get(key);
        if (gradient == null || !(g instanceof Graphics2D)) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Object[] args = new Object[]{gradient, vertical, leftToRight, determinate};
        ProgressBarPainter.INSTANCE.paint(comp, (Graphics2D)g, x, y, width, height, args);
    }

    public static void drawDoubleGradientBackground(Graphics g, JComponent comp, Shape shape, Color[] colors) {
        Color topColor = colors[0];
        GradientUtils.drawVerticalGradient(comp, g, new Color[]{topColor, topColor}, shape);
        Area area = new Area(shape);
        int height = (int)shape.getBounds().getHeight();
        area.subtract(new Area(new Rectangle(0, 0, comp.getWidth(), height / 3)));
        GradientUtils.drawVerticalGradient(comp, g, new Color[]{topColor, colors[1]}, (Shape)area);
    }

    public static void drawDoubleGradientBackground(Graphics g, JComponent comp, Shape shape, String resourceKey) {
        GradientUtils.drawDoubleGradientBackground(g, comp, shape, (Color[])UIManager.get(resourceKey));
    }

    public static void drawLargeToggleButtonBackground(Graphics g, JComponent comp, Shape shape) {
        Color[] colors = (Color[])UIManager.get("ToggleButton.largeButtonGradient");
        GradientUtils.drawDoubleGradientBackground(g, comp, shape, colors);
    }
}

