/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.util;

import com.nokia.laf.NetComboBoxUI;
import com.nokia.laf.NetIconFactory;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.TablePanelBorder;
import com.nokia.laf.borders.TableShadowBorder;
import com.nokia.laf.combobox.NetComboBoxButton;
import com.nokia.laf.painters.GradientAlphaFilter;
import com.nokia.laf.text.TextComponentPopupMenu;
import com.nokia.laf.util.GradientUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.highlight.DefaultLabelHighlightPainter;
import com.nokia.widgets.labels.highlight.DefaultLabelHighlighter;
import com.nokia.widgets.labels.highlight.LabelHighlighter;
import com.nokia.widgets.table.PDisabledTableModel;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.NSNColors;
import com.nokia.widgets.util.SystemUtils;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class NetUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int LINE_SEPARATOR_LEN = LINE_SEPARATOR.length();
    protected static final Icon ASTERISK_ICON = new ImageIcon(NetUtils.class.getResource("/com/nokia/laf/icons/asterisk.png"));
    private static Robot theRobot;
    private static BufferedImage theDropShadowImage;
    private static Map<ImageEntry, Image> theCurvedShadowImages;

    static {
        theDropShadowImage = null;
        theCurvedShadowImages = new HashMap<ImageEntry, Image>();
        try {
            theRobot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    private NetUtils() {
    }

    public static boolean shouldIgnore(MouseEvent me, JComponent c) {
        return c == null || !c.isEnabled() || !SwingUtilities.isLeftMouseButton(me) || me.isConsumed();
    }

    public static int getLongestStringLength(Set<String> strings, FontMetrics fontMetrics) {
        int max = 0;
        for (String s : strings) {
            int stringLength = fontMetrics.stringWidth(s);
            int n = max = max > stringLength ? max : stringLength;
        }
        return max;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel model, int lead, int anchor) {
        int tempAnchor = anchor;
        if (tempAnchor == -1) {
            tempAnchor = lead;
        }
        if (lead == -1) {
            model.setAnchorSelectionIndex(-1);
            model.setLeadSelectionIndex(-1);
        } else {
            if (model.isSelectedIndex(lead)) {
                model.addSelectionInterval(lead, lead);
            } else {
                model.removeSelectionInterval(lead, lead);
            }
            model.setAnchorSelectionIndex(tempAnchor);
        }
    }

    public static Color getBlack(int alpha) {
        return NetUtils.getColor(NetLookAndFeel.getBlack(), alpha);
    }

    public static Color getColor(String key, int alpha) {
        return NetUtils.getColor(UIManager.getColor(key), alpha);
    }

    public static Color getColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static boolean isInDialog(JComponent comp) {
        if (Boolean.TRUE.equals(comp.getClientProperty("OrangeTouch.isInLightContainer"))) {
            return true;
        }
        Object property = comp.getClientProperty("OrangeTouch.rootPane");
        JRootPane rootPane = null;
        if (property instanceof JRootPane) {
            rootPane = (JRootPane)property;
        } else {
            rootPane = SwingUtilities.getRootPane(comp);
            comp.putClientProperty("OrangeTouch.rootPane", rootPane);
        }
        if (rootPane != null) {
            return rootPane.getParent() instanceof Dialog || rootPane.getParent() instanceof JWindow;
        }
        return false;
    }

    public static boolean isNegative(AbstractButton button) {
        Object property = button.getClientProperty("OrangeTouch.darkBackground");
        if (property != null) {
            return Boolean.TRUE.equals(property);
        }
        if (button.isFocusable() && button.isFocusPainted() && button.isFocusOwner() && button.isEnabled()) {
            return true;
        }
        return button instanceof JButton && ((JButton)button).isDefaultButton() && button.isEnabled();
    }

    public static Object antiAliasingOn(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return oldValue;
    }

    public static Object antiAliasingOff(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        return oldValue;
    }

    public static void setAntialiasing(Graphics g, Object value) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, value);
    }

    public static void setActiveCursor(Component comp) {
    }

    public static void setInactiveCursor(Component comp) {
    }

    public static void setCursor(JComponent comp) {
        if (comp == null) {
            return;
        }
        if (comp.isEnabled() && !ComponentUtils.isReadOnly(comp)) {
            NetUtils.setActiveCursor(comp);
        } else {
            NetUtils.setInactiveCursor(comp);
        }
    }

    public static void drawCurvedDropShadow(Graphics2D g, int x, int y, int width, boolean light) {
        g.translate(x, y);
        Image cached = NetUtils.getCachedImage(width, light);
        if (cached != null) {
            g.drawImage(cached, 0, 0, null);
            g.translate(-x, -y);
            return;
        }
        if (width <= 0) {
            return;
        }
        Object oldAa = NetUtils.antiAliasingOn(g);
        BufferedImage image = ImageUtils.createCompatibleTranslucentImage(width, 10);
        Graphics2D gImg = image.createGraphics();
        Composite oldComposite = gImg.getComposite();
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, image.getWidth(), image.getHeight());
        gImg.setComposite(oldComposite);
        NetUtils.antiAliasingOn(gImg);
        int midx = width / 2;
        Color[] colors = light ? (Color[])UIManager.get("Panel.lightCurvedShadow") : (Color[])UIManager.get("Panel.curvedShadow");
        int idx = 0;
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            gImg.setColor(color);
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, idx);
            path.quadTo(midx / 2 - 1, 0.0f, midx, 0.0f);
            path.quadTo(1.5f * (float)midx + 1.0f, 0.0f, width, idx++);
            gImg.draw(path);
            ++n2;
        }
        gImg.dispose();
        GradientAlphaFilter filter = new GradientAlphaFilter(width > 800 ? 40 : 20, width);
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(producer);
        img.flush();
        g.drawImage(img, 0, 0, null);
        NetUtils.addCachedImage(width, light, img);
        NetUtils.setAntialiasing(g, oldAa);
        g.translate(-x, -y);
    }

    private static Image getCachedImage(int width, boolean light) {
        return theCurvedShadowImages.get(new ImageEntry(width, light));
    }

    private static Image addCachedImage(int width, boolean light, Image image) {
        if (theCurvedShadowImages.size() > 1) {
            theCurvedShadowImages.remove(theCurvedShadowImages.keySet().iterator().next());
        }
        return theCurvedShadowImages.put(new ImageEntry(width, light), image);
    }

    public static void drawCurvedDropShadow(Graphics2D g, int x, int y, int width) {
        NetUtils.drawCurvedDropShadow(g, x, y, width, true);
    }

    public static Shape getRoundedRect(JComponent comp, int width, int height, int rounding) {
        GeneralPath result = new GeneralPath();
        result.moveTo(rounding, 0.0f);
        result.lineTo(width - rounding - 1, 0.0f);
        result.quadTo(width - 1, 0.0f, width - 1, rounding);
        result.lineTo(width - 1, height - rounding - 1);
        result.quadTo(width - 1, height - 1, width - rounding - 1, height - 1);
        result.lineTo(rounding, height - 1);
        result.quadTo(0.0f, height - 1, 0.0f, height - rounding - 1);
        result.lineTo(0.0f, rounding);
        result.quadTo(0.0f, 0.0f, rounding, 0.0f);
        return result;
    }

    public static RectangularShape getRoundedRect(JComponent comp, int x, int y, int width, int height, int rounding) {
        return new RoundRectangle2D.Double(x, y, width - 1, height - 1, rounding, rounding);
    }

    public static Shape getRoundedPath(JComponent comp, int x, int y, int width, int height, int rounding, int straightSegment, boolean isStraightEdgeOpen) {
        int tempRounding = rounding;
        int tempWidth = width;
        int tempHeight = height;
        tempRounding = tempRounding / 2 + 1;
        if (straightSegment == 5 || straightSegment == 1) {
            int oldWidth = tempWidth;
            tempWidth = tempHeight;
            tempHeight = oldWidth;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(tempWidth - 1 - tempRounding, 0.0f);
        path.quadTo(tempWidth - 1, 0.0f, tempWidth - 1, tempRounding);
        path.lineTo(tempWidth - 1, tempHeight - 1 - tempRounding);
        path.quadTo(tempWidth - 1, tempHeight - 1, tempWidth - 1 - tempRounding, tempHeight - 1);
        path.lineTo(0.0f, tempHeight - 1);
        if (!isStraightEdgeOpen) {
            path.closePath();
        }
        if (straightSegment == 5) {
            path.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
            path.transform(AffineTransform.getTranslateInstance(0.0, tempWidth - 1));
        } else if (straightSegment == 1) {
            path.transform(AffineTransform.getRotateInstance(1.5707963267948966));
            path.transform(AffineTransform.getTranslateInstance(tempHeight - 1, 0.0));
        } else if (straightSegment == 3) {
            path.transform(AffineTransform.getScaleInstance(-1.0, 1.0));
            path.transform(AffineTransform.getTranslateInstance(tempWidth - 1, 0.0));
        }
        path.transform(AffineTransform.getTranslateInstance(x, y));
        return path;
    }

    public static Shape getRoundedRectWithSharpCorner(JComponent comp, int x, int y, int width, int height, int rounding, int sharpCorner) {
        int tempRounding = rounding;
        int tempWidth = width;
        int tempHeight = height;
        tempRounding = tempRounding / 2 + 1;
        if (sharpCorner == 2 || sharpCorner == 6) {
            int oldWidth = tempWidth;
            tempWidth = tempHeight;
            tempHeight = oldWidth;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(tempWidth - 1 - tempRounding, 0.0f);
        path.quadTo(tempWidth - 1, 0.0f, tempWidth - 1, tempRounding);
        path.lineTo(tempWidth - 1, tempHeight - 1 - tempRounding);
        path.quadTo(tempWidth - 1, tempHeight - 1, tempWidth - 1 - tempRounding, tempHeight - 1);
        path.lineTo(tempRounding, tempHeight - 1);
        path.quadTo(0.0f, tempHeight - 1, 0.0f, tempHeight - 1 - tempRounding);
        path.closePath();
        if (sharpCorner == 6) {
            path.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
            path.transform(AffineTransform.getTranslateInstance(0.0, tempWidth - 1));
        } else if (sharpCorner == 2) {
            path.transform(AffineTransform.getRotateInstance(1.5707963267948966));
            path.transform(AffineTransform.getTranslateInstance(tempHeight - 1, 0.0));
        } else if (sharpCorner == 4) {
            path.transform(AffineTransform.getScaleInstance(-1.0, -1.0));
            path.transform(AffineTransform.getTranslateInstance(tempWidth - 1, tempHeight - 1));
        }
        path.transform(AffineTransform.getTranslateInstance(x, y));
        return path;
    }

    public static Shape getRoundedRect(JComponent comp, int x, int y, int width, int height, int rounding, int straightSegment) {
        return NetUtils.getRoundedPath(comp, x, y, width, height, rounding, straightSegment, false);
    }

    public static Shape getRoundedRect(JComponent comp, int x, int y, int width, int height, int rounding, int firstStraightEdge, int secondStraightSegment) {
        int tempRounding = rounding;
        tempRounding = tempRounding / 2 + 1;
        if (firstStraightEdge == secondStraightSegment) {
            return NetUtils.getRoundedRect(comp, x, y, width, height, tempRounding, firstStraightEdge);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(width - 1 - tempRounding, 0.0f);
        path.quadTo(width - 1, 0.0f, width - 1, tempRounding);
        path.lineTo(width - 1, height - 1);
        path.lineTo(0.0f, height - 1);
        path.closePath();
        if (firstStraightEdge == 1 || secondStraightSegment == 1) {
            path.transform(AffineTransform.getScaleInstance(1.0, -1.0));
            path.transform(AffineTransform.getTranslateInstance(0.0, height - 1));
        }
        if (firstStraightEdge == 3 || secondStraightSegment == 3) {
            path.transform(AffineTransform.getScaleInstance(-1.0, 1.0));
            path.transform(AffineTransform.getTranslateInstance(width - 1, 0.0));
        }
        path.transform(AffineTransform.getTranslateInstance(x, y));
        return path;
    }

    public static void drawRoundedRect(Graphics g, Color lineColor, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        g.setColor(lineColor);
        g.translate(x, y);
        g.drawLine(1, 0, width - 1, 0);
        g.drawLine(width, 1, width, height - 1);
        g.drawLine(0, 1, 0, height - 1);
        g.drawLine(1, height, width - 1, height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static void drawPressed3DBorder(Graphics g, Color background, int x, int y, int w, int h) {
        ColorUIResource borderColor = NetTheme.getComponentOutlineColor();
        NetUtils.drawRoundedRect(g, (Color)borderColor, background, x, y, w - 1, h - 1);
        ColorUIResource upperShadow = NetLookAndFeel.getControlDarkShadow();
        ColorUIResource lowerShadow = NetLookAndFeel.getWhite();
        NetUtils.draw3DShadowRect(g, upperShadow, lowerShadow, x + 1, y + 1, w - 3, h - 3);
    }

    public static void drawDefaultButtonBorder(Graphics g, Color background, int x, int y, int w, int h) {
        ColorUIResource upperShadow = NetTheme.COLOR_GRAY_9;
        ColorUIResource lowerShadow = NetLookAndFeel.getControlDarkShadow();
        NetUtils.drawRoundedRect(g, (Color)lowerShadow, background, x, y, w - 1, h - 1);
        NetUtils.draw3DShadowRect(g, upperShadow, lowerShadow, x + 1, y + 1, w - 3, h - 3);
    }

    public static void drawButtonBorder(Graphics g, Color background, int x, int y, int w, int h) {
        ColorUIResource borderColor = NetTheme.getComponentOutlineColor();
        NetUtils.drawRoundedRect(g, (Color)borderColor, x, y, w - 1, h - 4, 12);
    }

    public static void drawDisabledBorder(Graphics g, Color background, int x, int y, int w, int h) {
        NetUtils.drawRoundedRect(g, (Color)NetTheme.getDisabledComponentOutlineColor(), background, x, y, w - 1, h - 1);
    }

    public static void drawFilledRounded3DRect(Graphics g, Color background, Color fillColor, Color lineColor, Color upperShadow, Color lowerShadow, int x, int y, int w, int h) {
        g.setColor(fillColor);
        g.fillRect(x + 2, y + 2, w - 4, h - 4);
        NetUtils.drawRounded3DRect(g, background, lineColor, upperShadow, lowerShadow, x, y, w, h);
    }

    public static void drawRounded3DRect(Graphics g, Color background, Color lineColor, Color upperShadow, Color lowerShadow, int x, int y, int w, int h) {
        NetUtils.drawRoundedRect(g, lineColor, background, x, y, w, h);
        NetUtils.draw3DShadowRect(g, upperShadow, lowerShadow, x + 1, y + 1, w - 2, h - 2);
    }

    public static void drawRoundedRect(Graphics g, Color lineColor, Color background, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        g.setColor(background);
        g.fillRect(0, 0, 1, 1);
        g.fillRect(width, 0, 1, 1);
        g.fillRect(0, height, 1, 1);
        g.fillRect(width, height, 1, 1);
        g.setColor(lineColor);
        g.translate(x, y);
        g.drawRoundRect(0, 0, width, height, 4, 4);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static void fillRoundedRect(Graphics g, Color color, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(color);
        g.translate(x, y);
        g.fillRect(1, 0, width - 2, height);
        g.drawLine(0, 1, 0, height - 1);
        g.drawLine(width, 1, width, height - 1);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static void draw3DShadowRect(Graphics g, Color upperColor, Color lowerColor, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(upperColor);
        g.translate(x, y);
        g.drawLine(0, 0, width, 0);
        g.drawLine(0, 1, 0, height);
        g.setColor(lowerColor);
        g.drawLine(width, 1, width, height);
        g.drawLine(1, height, width, height);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static void draw2ColorRect(Graphics g, Color outerColor, Color innerColor, int x, int y, int width, int height) {
        g.translate(x, y);
        Color oldColor = g.getColor();
        g.setColor(outerColor);
        g.drawRect(0, 0, width - 1, height - 1);
        g.setColor(innerColor);
        g.drawRect(1, 1, width - 3, height - 3);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static void draw2ColorRect(Graphics g, Color outerColor, Color innerColor, int x, int y, int width, int height, int rounding) {
        g.translate(x, y);
        Color oldColor = g.getColor();
        g.setColor(outerColor);
        g.drawRect(0, 0, width - 1, height - 1);
        g.setColor(innerColor);
        g.drawRect(1, 1, width - 3, height - 3);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static ImageIcon loadIcon(String fileName) {
        if (fileName == null) {
            return null;
        }
        return new ImageIcon(NetIconFactory.class.getResource("icons/" + fileName));
    }

    public static Icon loadRotatedIcon(String name, boolean clockwise) {
        return new ImageIcon(ImageUtils.createRotatedImage((Image)ImageUtils.readImage(name), clockwise));
    }

    public static boolean hasVoidBorder(JComponent comp) {
        if (comp.getBorder() == null) {
            return true;
        }
        Insets insets = comp.getInsets();
        return insets.top == 0 && insets.bottom == 0 && insets.left == 0 && insets.right == 0;
    }

    public static boolean lookAndFeelCanReplace(Object resource) {
        return resource == null || resource instanceof UIResource;
    }

    public static void installDefaultPopupMenu(JTextComponent textComponent) {
        if (NetUtils.lookAndFeelCanReplace(textComponent.getComponentPopupMenu()) && UIManager.getBoolean("TextComponent.defaultPopupMenuInUse")) {
            textComponent.setComponentPopupMenu(new TextComponentPopupMenu(textComponent));
        }
    }

    public static void installFont(Component comp, String key) {
        if (NetUtils.lookAndFeelCanReplace(comp.getFont())) {
            comp.setFont(UIManager.getFont(key));
        }
    }

    public static void setVisualPadding(JComponent comp, Insets insets) {
        if (comp.getBorder() instanceof UIResource) {
            comp.putClientProperty("visualPadding", insets);
        } else {
            comp.putClientProperty("visualPadding", null);
        }
        comp.revalidate();
        comp.repaint();
    }

    public static boolean isCellDisabled(JTable table, int row, int column) {
        if (table != null && table.getModel() instanceof PDisabledTableModel) {
            PDisabledTableModel disabledTableModel = (PDisabledTableModel)((Object)table.getModel());
            return disabledTableModel.isCellDisabled(row, column);
        }
        return false;
    }

    public static void drawRollover(Graphics g, AbstractButton btn) {
        ButtonModel model = btn.getModel();
        if (model.isRollover() && !model.isPressed()) {
            int width = btn.getWidth();
            int height = btn.getHeight();
            if (model.isSelected()) {
                NetUtils.drawSelectedRollover(g, 1, 1, width - 2, height - 2);
            } else {
                NetUtils.drawRollover(g, 1, 1, width - 2, height - 2);
            }
        }
    }

    public static void drawRollover(Graphics g, int x, int y, int width, int height) {
        if (height > 11) {
            NetUtils.draw2ColorRect(g, UIManager.getColor("Button.rolloverColor"), UIManager.getColor("Button.rolloverColor2"), x, y, width, height);
        } else {
            NetUtils.drawThinRollover(g, x, y, width, height);
        }
    }

    public static void drawThinRollover(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(UIManager.getColor("Button.rolloverColor"));
        g.drawRect(x, y, width - 1, height - 1);
        g.setColor(oldColor);
    }

    public static void drawSelectedRollover(Graphics g, int x, int y, int width, int height) {
        NetUtils.draw3DShadowRect(g, NetLookAndFeel.getControlDarkShadow(), NetLookAndFeel.getWhite(), x, y, width - 1, height - 1);
        NetUtils.drawRollover(g, x + 1, y + 1, width - 2, height - 2);
    }

    public static void drawRollover(Graphics2D g, Shape outline) {
        Color oldColor = g.getColor();
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.setColor(NetTheme.getHoverColor());
        g.draw(outline);
        g.setColor(oldColor);
        NetUtils.setAntialiasing(g, oldAa);
    }

    public static void drawFocus(Graphics g, AbstractButton btn) {
        ButtonModel model = btn.getModel();
        if (btn.hasFocus() && btn.isFocusPainted()) {
            int width = btn.getWidth();
            int height = btn.getHeight();
            if (model.isSelected()) {
                NetUtils.drawSelectedFocus(g, 1, 1, width - 2, height - 2);
            } else {
                NetUtils.drawFocus(g, 1, 1, width - 2, height - 2);
            }
        }
    }

    public static void drawFocus(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(NetLookAndFeel.getFocusColor());
        g.drawRect(x, y, width, height);
        g.setColor(oldColor);
    }

    public static void drawDash(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(new Color(140, 140, 140));
        g.translate(x, y);
        int bottomOffset = height % 2 == 0 ? 1 : 0;
        int rightOffset = width % 2 == 0 ? 1 : 0;
        int vx = 0;
        while (vx < width) {
            g.fillRect(vx, 0, 1, 1);
            if (bottomOffset + vx < width) {
                g.fillRect(bottomOffset + vx, height - 1, 1, 1);
            }
            vx += 2;
        }
        int vy = 0;
        while (vy < height) {
            g.fillRect(0, vy, 1, 1);
            if (rightOffset + vy < height) {
                g.fillRect(width - 1, rightOffset + vy, 1, 1);
            }
            vy += 2;
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public static void drawFocus(Graphics2D g, Shape outline) {
        Color oldColor = g.getColor();
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.setColor(NetLookAndFeel.getFocusColor());
        g.draw(outline);
        NetUtils.setAntialiasing(g, oldAa);
        g.setColor(oldColor);
    }

    public static void drawDash(Graphics2D g, Shape outline) {
        NetUtils.drawDash(g, outline, 0.0f);
    }

    public static void drawDash(Graphics2D g, Shape outline, float dashPhase) {
        NetUtils.drawDash(g, outline, dashPhase, 1.0f);
    }

    public static void drawDash(Graphics2D g, Shape outline, float dashPhase, float width) {
        Color oldColor = g.getColor();
        g.setColor(NetTheme.COLOR_TABLE_TEXT);
        Stroke oldStroke = g.getStroke();
        BasicStroke stroke = new BasicStroke(width, 0, 1, 0.0f, new float[]{1.0f, 1.0f}, dashPhase);
        g.setStroke(stroke);
        g.draw(outline);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public static void drawSelectedFocus(Graphics g, int x, int y, int width, int height) {
        NetUtils.drawFocus(g, x, y, width, height);
    }

    public static void draw2ColorShape(Graphics2D g, Shape outline, Color outerColor, Color innerColor, boolean drawDash) {
        Shape oldClip = g.getClip();
        g.clip(outline);
        Color oldColor = g.getColor();
        g.setColor(innerColor);
        g.setStroke(new BasicStroke(3.0f));
        g.draw(outline);
        if (drawDash) {
            BasicStroke stroke = new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 2.0f);
            g.setColor(NetTheme.COLOR_TABLE_TEXT);
            g.setStroke(stroke);
            g.draw(outline);
        }
        g.setColor(outerColor);
        g.setClip(oldClip);
        g.setStroke(new BasicStroke(1.0f));
        g.draw(outline);
        g.setColor(oldColor);
    }

    public static void paintMandatoryStripe(Graphics g, JComponent comp, int x, int y, int width, int height, boolean drawBorder) {
        g.translate(x, y);
        Color oldColor = g.getColor();
        int offset = 0;
        if (drawBorder) {
            offset = 1;
            NetUtils.drawRoundedRect(g, NetTheme.getComponentOutlineColor(), 0, 0, width - 1, height - 1);
            g.setColor(NetTheme.getComponentOutlineColor());
            if (ComponentUtils.isLeftToRight(comp)) {
                g.drawLine(width - 1, 0, width - 1, 0);
                g.drawLine(width - 1, height - 1, width - 1, height - 1);
            } else {
                g.drawLine(0, 0, 0, 0);
                g.drawLine(0, height - 1, 0, height - 1);
            }
        }
        GradientUtils.drawHorizontalGradient(comp, g, "TextField.stripeGradient", offset, offset, width - 1 - offset, height - 1 - offset);
        ASTERISK_ICON.paintIcon(comp, g, (width - ASTERISK_ICON.getIconWidth()) / 2, (height - ASTERISK_ICON.getIconHeight()) / 2);
        g.setColor(oldColor);
        g.translate(-x, -y);
    }

    public static void paintMandatoryAsterisk(Graphics g, JComponent comp, int xOffset, int yOffset) {
        NetUtils.paintMandatoryAsterisk(g, comp, xOffset, yOffset, 12);
    }

    public static void paintMandatoryAsterisk(Graphics g, JComponent comp, int xOffset, int yOffset, int fontIncrement) {
        NetComboBoxButton button;
        if (!comp.isEnabled()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Font font = comp.getFont();
        font = font.deriveFont((float)(font.getSize() + fontIncrement));
        Font oldFont = g.getFont();
        g.setFont(font);
        Color oldColor = g.getColor();
        Object oldAa = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        NetLookAndFeel.toggleTextAntialiasing(g2d);
        int fontHeight = font.getSize();
        g.setColor(UIManager.getColor("TextField.mandatoryAsterisk"));
        if (comp instanceof NetComboBoxButton && (button = (NetComboBoxButton)comp).getComboBox().isFocusOwner()) {
            g.setColor(NetLookAndFeel.getWhite());
            g.drawString("*", comp.getWidth() - 21 + xOffset + 2, comp.getHeight() / 2 + fontHeight / 2 + yOffset + 1);
            g.setColor(UIManager.getColor("TextField.mandatoryAsterisk").brighter().brighter().brighter());
        }
        int offset = comp instanceof JTextComponent ? 1 : 0;
        g.drawString("*", comp.getWidth() - 21 + xOffset + 2, comp.getHeight() / 2 + fontHeight / 2 + yOffset + 1 + offset);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAa);
        g.setColor(oldColor);
        g.setFont(oldFont);
    }

    public static String[] breakupLines(String text) {
        int len = text.length();
        if (len == 0) {
            return new String[]{""};
        }
        ArrayList<String> data = new ArrayList<String>(10);
        int start = 0;
        int i = 0;
        while (i < len) {
            if (text.startsWith(LINE_SEPARATOR, i)) {
                data.add(text.substring(start, i));
                i = start = i + LINE_SEPARATOR_LEN;
                continue;
            }
            if (text.charAt(i) == '\n') {
                data.add(text.substring(start, i));
                i = start = i + 1;
                continue;
            }
            ++i;
        }
        if (start != len) {
            data.add(text.substring(start));
        }
        int numlines = data.size();
        String[] lines = new String[numlines];
        return data.toArray(lines);
    }

    public static String layoutCompoundLabel(JLabel label, FontMetrics fm, Rectangle viewR, Rectangle iconR, Rectangle textR, boolean clipIt) {
        Insets insets = label.getInsets();
        viewR.x = insets.left;
        viewR.y = insets.top;
        viewR.width = label.getWidth() - (insets.left + insets.right);
        viewR.height = label.getHeight() - (insets.top + insets.bottom);
        return NetUtils.layoutCompoundLabel(label, fm, label.getText(), label.getIcon(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), fm.getHeight(), clipIt);
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int textHeight, boolean clipIt) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null) {
            if (!c.getComponentOrientation().isLeftToRight()) {
                orientationIsLeftToRight = false;
            }
        } else {
            throw new NullPointerException("JComponent must not be null");
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
                break;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
                break;
            }
        }
        int orientation = ClientPropertyUtil.integerValue(c, "OrangeTouch.textClipOrientation");
        return NetUtils.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap, textHeight, clipIt, orientation);
    }

    public static String getClippedText(String text, FontMetrics fm, int availTextWidth) {
        return NetUtils.getClippedText(text, fm, availTextWidth, 4);
    }

    public static String getClippedText(String text, FontMetrics fm, int availTextWidth, int clipOrientation) {
        String clipString = "...";
        int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
        if (clipOrientation == 2) {
            int nChars = text.length() - 1;
            while (nChars >= 0) {
                if ((totalWidth += fm.charWidth(text.charAt(nChars))) > availTextWidth) {
                    return String.valueOf(clipString) + text.substring(nChars + 1);
                }
                --nChars;
            }
            return text;
        }
        int nChars = 0;
        while (nChars < text.length()) {
            if ((totalWidth += fm.charWidth(text.charAt(nChars))) > availTextWidth) {
                return String.valueOf(text.substring(0, nChars)) + clipString;
            }
            ++nChars;
        }
        return text;
    }

    public static boolean drawStringWithRange(Graphics g, String text, int x, int y, int underlinedCharIndex, int rangeStartIndex, int rangeEndIndex) {
        int index = -1;
        index = underlinedCharIndex;
        FontMetrics fm = g.getFontMetrics();
        String str = text.substring(0, rangeStartIndex);
        g.drawString(str, x, y);
        int xOffset = x + fm.stringWidth(str);
        Color oldColor = g.getColor();
        Color rangeColor = UIManager.getColor("Label.unitForeground");
        g.setColor(rangeColor);
        String rangeText = text.substring(rangeStartIndex, rangeEndIndex);
        g.drawString(rangeText, xOffset, y);
        xOffset += fm.stringWidth(rangeText);
        g.setColor(oldColor);
        if (rangeEndIndex < text.length()) {
            g.drawString(text.substring(rangeEndIndex), xOffset, y);
        }
        if (underlinedCharIndex < rangeStartIndex || underlinedCharIndex > rangeEndIndex) {
            g.setColor(oldColor);
        } else {
            g.setColor(rangeColor);
        }
        if (index != -1) {
            int underlineRectX = x + fm.stringWidth(text.substring(0, index));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(index));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
        return index != -1;
    }

    public static boolean drawString(Graphics g, String text, int underlinedChar, int x, int y, int underlinedCharIndex) {
        int index = -1;
        index = underlinedCharIndex;
        g.drawString(text, x, y);
        if (index != -1 && text.length() > index) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, index));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(index));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
        return index != -1;
    }

    public static boolean drawStringWithOffset(JComponent component, Graphics g, String s, int textX, int textY, int accChar, int accCharIndex) {
        g.setColor(component.getForeground());
        NetUtils.paintOffsetText(component, g, s, textX, textY, accChar, accCharIndex);
        return NetUtils.drawString(g, s, accChar, textX, textY, accCharIndex);
    }

    private static void paintOffsetText(JComponent component, Graphics g, String s, int textX, int textY, int accChar, int accCharIndex) {
        Color offsetForeground = (Color)component.getClientProperty("OrangeTouch.labelOffsetColor");
        if (offsetForeground == null) {
            return;
        }
        Object oldValue = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color oldColor = g.getColor();
        g.setColor(offsetForeground);
        if (offsetForeground.getRed() > 239) {
            NetUtils.drawString(g, s, accChar, textX, textY + 1, accCharIndex);
        } else {
            NetUtils.drawString(g, s, accChar, textX, textY - 1, accCharIndex);
        }
        g.setColor(oldColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValue);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int textHeight, boolean clipIt, int clipOrientation) {
        int gap;
        String tempText = text;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = tempText == null || "".equals(tempText);
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            tempText = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, tempText);
                textR.height = textHeight;
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty) {
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            if (clipIt && textR.width > availTextWidth) {
                if (v != null) {
                    textR.width = availTextWidth;
                } else {
                    tempText = NetUtils.getClippedText(tempText, fm, availTextWidth, clipOrientation);
                    textR.width = SwingUtilities.computeStringWidth(fm, tempText);
                }
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return tempText;
    }

    public static boolean isTableCellEditor(JComponent comp) {
        return comp != null && Boolean.TRUE.equals(comp.getClientProperty("JComboBox.isTableCellEditor")) && !Boolean.TRUE.equals(comp.getClientProperty("JComboBox.isFileChooserCombo"));
    }

    public static boolean isTableEditorTextField(Component comp) {
        Container parent = comp.getParent();
        if (parent instanceof JTable) {
            return true;
        }
        if (parent != null && parent.getParent() instanceof JTable) {
            return true;
        }
        return parent != null && parent.getParent() != null && parent.getParent().getParent() instanceof JTable;
    }

    public static boolean isTreeEditorTextField(Component comp) {
        Container parent = comp.getParent();
        if (parent instanceof JTree) {
            return true;
        }
        return parent != null && parent.getParent() != null && parent.getParent() instanceof JTree;
    }

    public static boolean isNotNullAndVisible(Component comp) {
        return comp != null && comp.isVisible() && comp.getWidth() > 0 && comp.getHeight() > 0;
    }

    public static Color getParentBackground(Component comp) {
        Container p = comp.getParent();
        while (p != null) {
            if (p.isOpaque()) {
                return p.getBackground();
            }
            p = p.getParent();
        }
        return NetTheme.COLOR_GRAY_15;
    }

    public static Color decodeColor(String color) {
        String tempColor = color;
        if (tempColor == null) {
            return null;
        }
        if (tempColor.startsWith("#")) {
            tempColor = tempColor.substring(1);
        }
        try {
            return new Color(Integer.parseInt(tempColor.substring(0, 2), 16), Integer.parseInt(tempColor.substring(2, 4), 16), Integer.parseInt(tempColor.substring(4, 6), 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String encodeColor(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Dimension getPreferredButtonSize(AbstractButton button, int textIconGap, boolean ignorePreferredSizeIfChildren) {
        boolean defaultAlignment;
        if (ignorePreferredSizeIfChildren && button.getComponentCount() > 0) {
            return null;
        }
        Icon icon = button.getIcon();
        String text = button.getText();
        Font font = button.getFont();
        FontMetrics fm = button.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(button, fm, text, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Insets insets = button.getInsets();
        Insets margin = button.getMargin();
        boolean bl = defaultAlignment = button.getVerticalAlignment() == 0 && button.getHorizontalAlignment() == 0 && button.getVerticalTextPosition() == 0 && button.getHorizontalTextPosition() == 11;
        if (icon != null && fm.getHeight() < 16 && text != null && text.length() > 0 && defaultAlignment && margin instanceof UIResource && !ClientPropertyUtil.booleanValue(button, "toolButton")) {
            iconR.height = fm.getHeight();
            iconR.y = textR.y;
        }
        Rectangle r = iconR.union(textR);
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    public static Dimension getPreferredButtonSize(AbstractButton button, int textIconGap) {
        Dimension result = NetUtils.getPreferredButtonSize(button, textIconGap, true);
        if (ComponentUtils.isRounded(button)) {
            int size = Math.max(result.width, result.height);
            return new Dimension(size, size);
        }
        return result;
    }

    public static void updateAutomaticTooltipVisibility(Graphics graphics, JComponent comp, String text, Icon icon, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, int textIconGap) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        if (Boolean.TRUE.equals(comp.getClientProperty("OceanTouch.tooltipSetByClient"))) {
            return;
        }
        if (text != null && !text.startsWith("<html>")) {
            String tooltipText = null;
            boolean singleRow = true;
            if (text != null && text.length() > 0) {
                String longestRow = text;
                if (text.indexOf("\n") > 0) {
                    singleRow = false;
                    longestRow = "";
                    String[] rows = text.split("\\n");
                    int idx = 0;
                    while (idx < rows.length) {
                        if (longestRow.length() < rows[idx].length()) {
                            longestRow = rows[idx];
                        }
                        ++idx;
                    }
                }
                Font font = comp.getFont();
                boolean textIsEmpty = text == null || text.length() == 0;
                int gap = textIsEmpty || icon == null ? 0 : textIconGap;
                int availableTextWidth = horizontalTextPosition == 0 ? viewRect.width : viewRect.width - (iconRect.width + gap);
                int textWidth = SwingUtilities.computeStringWidth(comp.getFontMetrics(font), longestRow);
                if (textWidth > availableTextWidth) {
                    tooltipText = text;
                }
            }
            if (singleRow && tooltipText != null && text.length() > 80) {
                StringBuilder builder = new StringBuilder("<html>");
                tooltipText = builder.append(NetUtils.forcedTextWrap(text, "<br>", 80)).toString();
            }
            comp.putClientProperty("OceanTouch.settingAutoTooltipText", true);
            comp.setToolTipText(tooltipText);
            comp.putClientProperty("OceanTouch.settingAutoTooltipText", false);
        }
    }

    public static String forcedTextWrap(String text, String lineSeparator, int rowLength) {
        int length = text.length();
        if (length < rowLength) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int idx = 0;
        while (idx < length) {
            if (idx % rowLength == 0 && idx > 0) {
                result.append(lineSeparator);
            }
            result.append(text.charAt(idx));
            ++idx;
        }
        return result.toString();
    }

    public static void resetRectangle(Rectangle rect) {
        rect.height = 0;
        rect.width = 0;
        rect.y = 0;
        rect.x = 0;
    }

    public static Rectangle calculateMidPosition(Rectangle rect, int width, int height, Rectangle result) {
        Rectangle tempResult = result;
        if (tempResult == null) {
            tempResult = new Rectangle();
        }
        tempResult.x = rect.x + (rect.width - width) / 2;
        tempResult.y = rect.y + (rect.height - height) / 2;
        tempResult.width = width;
        tempResult.height = height;
        return tempResult;
    }

    public static Rectangle calculateMidPosition(Rectangle rect, Icon icon, Rectangle result) {
        return NetUtils.calculateMidPosition(rect, icon.getIconWidth(), icon.getIconHeight(), result);
    }

    public static void installReadOnlyFocusInputMap(JTextComponent textComponent) {
        if (ComponentUtils.isReadOnly(textComponent)) {
            InputMap inputMap = (InputMap)UIManager.get("TextField.readOnlyFocusInputMap");
            SwingUtilities.replaceUIInputMap(textComponent, 0, inputMap);
        }
    }

    public static void drawRoundedRect(Graphics g, Color lineColor, int x, int y, int width, int height, int rounding) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        g.setColor(lineColor);
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, rounding + 1, rounding + 1);
        ((Graphics2D)g).draw(rect);
        g.setColor(oldColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static Shape getButtonOutline(JComponent comp) {
        return NetUtils.getButtonOutline(comp, 0, 0, comp.getWidth(), comp.getHeight());
    }

    public static Shape getButtonOutline(JComponent comp, int x, int y, int width, int height) {
        if (ComponentUtils.isRounded(comp)) {
            return new Ellipse2D.Double(x, y, width - 1, height - 1);
        }
        if (NetUtils.isMinimalistic(comp)) {
            int rounding = comp.getHeight() > 20 ? NetTheme.getNormalRounding() : NetTheme.getSmallRounding();
            return new RoundRectangle2D.Double(x, y, width - 1, height - 2, rounding, rounding);
        }
        return NetUtils.getOutline(comp, x + 2, y + 1, width - 5, height - 5);
    }

    public static boolean isMinimalistic(JComponent comp) {
        boolean isToolButton;
        Object property = comp.getClientProperty(ClientProperties.IS_MINIMALISTIC);
        if (property != null || !(comp instanceof AbstractButton) || comp.getClientProperty("JToggleButton.segmentPosition") != null) {
            return Boolean.TRUE.equals(property);
        }
        boolean bl = isToolButton = Boolean.TRUE.equals(comp.getClientProperty("toolButton")) || comp.getParent() instanceof JToolBar;
        if (isToolButton) {
            return false;
        }
        boolean result = comp.getParent() instanceof CellRendererPane || comp.getParent() != null && comp.getParent().getParent() instanceof CellRendererPane || comp.getWidth() < 20 || comp.getHeight() < 20 || comp.getWidth() + comp.getHeight() < 46;
        return result;
    }

    public static Shape getButtonOutlineForFill(JComponent comp) {
        return NetUtils.getButtonOutlineForFill(comp, 0, 0, comp.getWidth(), comp.getHeight());
    }

    public static Shape getButtonOutlineForFill(JComponent comp, int x, int y, int width, int height) {
        if (ComponentUtils.isRounded(comp)) {
            return new Ellipse2D.Double(x, y, width, height);
        }
        if (NetUtils.isMinimalistic(comp)) {
            return NetUtils.getOutline(comp, x, y, width, height - 1);
        }
        if (comp.getParent() instanceof JToolBar || ClientPropertyUtil.booleanValue(comp, "toolButton")) {
            return NetUtils.getOutline(comp, x + 2, y + 1, width - 4, height - 4);
        }
        return comp.getBorder() instanceof UIResource ? NetUtils.getFillRect(comp, x + 2, y + 2, width - 4, height - 6) : NetUtils.getFillRect(comp, x + 1, y + 1, width - 2, height - 2);
    }

    private static RectangularShape getFillRect(Component comp, int x, int y, int width, int height) {
        if (ComponentUtils.isSmall(comp)) {
            int rouding = comp.getHeight() > 25 ? 8 : 6;
            return new RoundRectangle2D.Double(x, y, width, height, rouding, rouding);
        }
        return new RoundRectangle2D.Double(x, y, width, height, 12.0, 12.0);
    }

    public static void drawButtonOutline(Graphics g, JComponent comp, Color ... lineColor) {
        NetUtils.drawButtonOutline(g, comp, 0, 0, comp.getWidth(), comp.getHeight(), lineColor);
    }

    public static void drawButtonOutline(Graphics g, JComponent comp, int x, int y, int width, int height, Color ... lineColor) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape rect = null;
        rect = ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStraightBottomEdge") ? NetUtils.getRoundedRect(comp, x + 2, y + 1, width - 3, height - 4, 14, 5) : (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStraightTopEdge") ? NetUtils.getRoundedRect(comp, x + 2, y + 1, width - 3, height - 4, 14, 1) : (ClientPropertyUtil.booleanValue(comp, "OceanTouch.searchButton") ? NetUtils.getRoundedRect(comp, x, y, width - 1, height - 2, height - 4, 7) : NetUtils.getButtonOutline(comp, x, y, width, height)));
        if (lineColor == null) {
            GradientUtils.drawVerticalGradientOutline(comp, g, "Button.outlineGradient", rect);
        } else if (lineColor.length == 1) {
            Color oldColor = g.getColor();
            g.setColor(lineColor[0]);
            ((Graphics2D)g).draw(rect);
            g.setColor(oldColor);
        } else if (lineColor.length == 2) {
            GradientUtils.drawVerticalGradientOutline(comp, g, lineColor, rect);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static RectangularShape getOutline(Component comp, int x, int y, int width, int height) {
        if (ComponentUtils.isSmall(comp)) {
            int rouding = comp.getHeight() > 20 ? NetTheme.getNormalRounding() : NetTheme.getSmallRounding();
            return new RoundRectangle2D.Double(x, y, width, height, rouding, rouding);
        }
        return new RoundRectangle2D.Double(x, y, width, height, 14.0, 14.0);
    }

    public static RectangularShape getOutline(JComponent comp) {
        return NetUtils.getOutline(comp, 0, 0, comp.getWidth() - 1, comp.getHeight() - 1);
    }

    public static RectangularShape getOutline(JComponent comp, int widthOffset, int heightOffset) {
        if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.searchField")) {
            return new RoundRectangle2D.Double(0.0, 0.0, comp.getWidth() - 1 + widthOffset, comp.getHeight() - 1 + heightOffset, comp.getHeight() - 1, comp.getHeight() - 1);
        }
        return NetUtils.getOutline(comp, 0, 0, comp.getWidth() - 1 + widthOffset, comp.getHeight() - 1 + heightOffset);
    }

    public static RectangularShape getOutlineForFill(JComponent comp) {
        if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.searchField")) {
            return new RoundRectangle2D.Double(1.0, 1.0, comp.getWidth() - 2, comp.getHeight() - 2, comp.getHeight() - 2, comp.getHeight() - 2);
        }
        if (ComponentUtils.isSmall(comp)) {
            return NetUtils.getOutline(comp, 1, 1, comp.getWidth() - 2, comp.getHeight() - 2);
        }
        return NetUtils.getOutline(comp, 1, 1, comp.getWidth() - 2, comp.getHeight() - 3);
    }

    public static void drawOutline(Graphics2D g, JComponent comp, Color lineColor) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        g.setColor(lineColor);
        RectangularShape rect = NetUtils.getOutline(comp);
        g.draw(rect);
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void drawOutline(Graphics2D g, JComponent c, Color lineColor, int x, int y, int w, int h) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        RectangularShape rect = NetUtils.getOutline(c);
        rect.setFrame(x, y, w - 1, h - 1);
        if (lineColor == null) {
            GradientUtils.drawVerticalGradientOutline(c, (Graphics)g, "Button.outlineGradient", (Shape)rect);
        } else {
            g.setColor(lineColor);
            g.draw(rect);
        }
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void drawRoundedRect(Graphics2D g, Color[] lineColors, int x, int y, int width, int height, int rounding) {
        Object oldHints = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        int idx = 0;
        while (idx < lineColors.length) {
            g.setColor(lineColors[idx]);
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x + idx, y + idx, width - 2 * idx, height - 2 * idx, rounding + 1 - idx, rounding + 1 - idx);
            g.draw(rect);
            ++idx;
        }
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints);
    }

    public static void drawRoundedRect(Graphics2D g, Color upperLineColor, Color lowerLineColor, int x, int y, int width, int height, int rounding) {
        NetUtils.drawRoundedRect(g, new Color[]{upperLineColor}, new Color[]{lowerLineColor}, x, y, width, height, rounding);
    }

    public static void drawRoundedRect(Graphics2D g, Color[] upperLineColors, Color[] lowerLineColors, int x, int y, int width, int height, int rounding) {
        if (upperLineColors == null || lowerLineColors == null || upperLineColors.length != lowerLineColors.length) {
            throw new IllegalArgumentException();
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        Shape oldClip = g.getClip();
        g.translate(x, y);
        float turningPoint = Math.min(width + 1, height + 1) / 2;
        GeneralPath clip = new GeneralPath();
        clip.moveTo(0.0f, 0.0f);
        clip.lineTo(width + 1, 0.0f);
        clip.lineTo((float)width - turningPoint + 1.0f, turningPoint);
        clip.lineTo(turningPoint, turningPoint);
        clip.lineTo(0.0f, height + 1);
        clip.closePath();
        g.clip(clip);
        NetUtils.drawRectangles(g, upperLineColors, width, height, rounding);
        g.setClip(oldClip);
        clip.reset();
        clip.moveTo(width + 1, 0.0f);
        clip.lineTo((float)(width + 1) - turningPoint, turningPoint);
        clip.lineTo(turningPoint, turningPoint);
        clip.lineTo(0.0f, height + 1);
        clip.lineTo(width + 1, height + 1);
        clip.closePath();
        g.clip(clip);
        NetUtils.drawRectangles(g, lowerLineColors, width, height, rounding);
        g.translate(-x, -y);
        g.setClip(oldClip);
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void drawMultiColorLine(Graphics2D g, Color[] lineColors, int x, int y, int length, boolean isVertical) {
        Color oldColor = g.getColor();
        int idx = 0;
        Color[] colorArray = lineColors;
        int n = lineColors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            g.setColor(color);
            if (isVertical) {
                g.drawLine(x + idx, y, x + idx, y + length);
            } else {
                g.drawLine(x, y + idx, x + length, y + idx);
            }
            ++idx;
            ++n2;
        }
        g.setColor(oldColor);
    }

    public static void drawDropShadow(Graphics2D g, String colors, Insets lineWidths, int x, int y, int width, int height, int rounding) {
        NetUtils.drawDropShadow(g, (Color[])UIManager.get(colors), lineWidths, x, y, width, height, rounding);
    }

    public static void drawDropShadow(Graphics2D g, Color[] lineColors, Insets lineWidths, int x, int y, int width, int height, int rounding) {
        Color color;
        Color color2;
        int tempRounding = rounding;
        tempRounding = tempRounding / 2 + 1;
        Object oldHints = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        g.translate(x, y);
        int verticalStraightSegmentLength = height - 2 * tempRounding - lineWidths.top - lineWidths.bottom - 1;
        Color[] leftColors = new Color[lineWidths.left];
        System.arraycopy(lineColors, 0, leftColors, 0, leftColors.length);
        NetUtils.drawMultiColorLine(g, leftColors, 0, lineWidths.top + tempRounding, verticalStraightSegmentLength, true);
        Color[] rightColors = new Color[lineWidths.right];
        System.arraycopy(lineColors, 0, rightColors, 0, rightColors.length);
        List<Color> rightList = Arrays.asList(rightColors);
        Collections.reverse(rightList);
        rightList.toArray(rightColors);
        NetUtils.drawMultiColorLine(g, rightColors, width - rightColors.length, tempRounding + lineWidths.top, verticalStraightSegmentLength, true);
        int horizontalStraightSegmentLength = width - 2 * tempRounding - lineWidths.left - lineWidths.right - 1;
        Color[] topColors = new Color[lineWidths.top];
        System.arraycopy(lineColors, 0, topColors, 0, topColors.length);
        NetUtils.drawMultiColorLine(g, topColors, lineWidths.left + tempRounding, 0, horizontalStraightSegmentLength, false);
        Color[] bottomColors = new Color[lineWidths.bottom];
        System.arraycopy(lineColors, 0, bottomColors, 0, bottomColors.length);
        List<Color> list = Arrays.asList(bottomColors);
        Collections.reverse(list);
        list.toArray(bottomColors);
        NetUtils.drawMultiColorLine(g, bottomColors, tempRounding + leftColors.length, height - bottomColors.length, horizontalStraightSegmentLength, false);
        int cornerWidth = Math.max(lineWidths.left, lineWidths.top);
        int arcCenterX = lineWidths.left + tempRounding;
        int arcCenterY = lineWidths.top + tempRounding;
        int idx = 0;
        while (idx < cornerWidth) {
            color2 = leftColors[idx];
            if (idx >= topColors.length) {
                g.setPaint(new GradientPaint(0.0f, topColors.length - 1, new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 0), 0.0f, topColors.length + tempRounding, color2));
                NetUtils.drawArc(g, arcCenterX, arcCenterY, arcCenterX - idx, tempRounding + 1, 180, -90);
            } else {
                g.setColor(color2);
                NetUtils.drawArc(g, arcCenterX, arcCenterY, arcCenterX - idx, arcCenterY - idx, 180, -90);
            }
            ++idx;
        }
        cornerWidth = Math.max(lineWidths.right, lineWidths.top);
        arcCenterX = width - lineWidths.right - tempRounding + 1;
        arcCenterY = lineWidths.top + tempRounding;
        idx = 0;
        while (idx < cornerWidth) {
            if (idx >= topColors.length) {
                color2 = rightColors[rightColors.length - 1 - idx];
                g.setPaint(new GradientPaint(0.0f, topColors.length - 1, new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 0), 0.0f, topColors.length + tempRounding, color2));
                NetUtils.drawArc(g, arcCenterX, arcCenterY, tempRounding + lineWidths.right - idx - 1, tempRounding + 1, 0, 90);
            } else {
                g.setColor(topColors[idx]);
                NetUtils.drawArc(g, arcCenterX, arcCenterY, tempRounding + lineWidths.right - idx - 1, tempRounding + lineWidths.top - idx, 0, 90);
            }
            ++idx;
        }
        cornerWidth = Math.max(lineWidths.left, lineWidths.bottom);
        arcCenterX = lineWidths.left + tempRounding;
        arcCenterY = height - lineWidths.bottom - tempRounding + 1;
        int imageWidth = tempRounding + lineWidths.left;
        int imageHeight = tempRounding + lineWidths.bottom;
        if (theDropShadowImage == null || theDropShadowImage.getHeight() < imageHeight || theDropShadowImage.getWidth() < imageWidth) {
            if (theDropShadowImage != null) {
                theDropShadowImage.flush();
            }
            theDropShadowImage = ImageUtils.createCompatibleTranslucentImage(imageWidth, imageHeight);
        }
        Graphics2D gImg = theDropShadowImage.createGraphics();
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, theDropShadowImage.getWidth(), theDropShadowImage.getHeight());
        gImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gImg.setComposite(AlphaComposite.Src);
        int idx2 = 0;
        while (idx2 < cornerWidth) {
            if (idx2 >= leftColors.length) {
                color = bottomColors[bottomColors.length - 1 - idx2];
                Color leftColor = leftColors[leftColors.length - 1];
                gImg.setPaint(new GradientPaint(0.0f, 0.0f, leftColor, 0.0f, tempRounding, color));
                NetUtils.drawArc(gImg, imageWidth, 1, tempRounding + 1, imageHeight - idx2, 180, 90);
            } else {
                gImg.setColor(leftColors[idx2]);
                NetUtils.drawArc(gImg, imageWidth, 1, arcCenterX - idx2, imageHeight - idx2, 180, 90);
            }
            ++idx2;
        }
        g.drawImage((Image)theDropShadowImage, 0, height - lineWidths.bottom - tempRounding, null);
        cornerWidth = Math.max(lineWidths.bottom, lineWidths.right);
        gImg.setComposite(AlphaComposite.Clear);
        gImg.fillRect(0, 0, theDropShadowImage.getWidth(), theDropShadowImage.getHeight());
        gImg.setComposite(AlphaComposite.Src);
        arcCenterX = width - lineWidths.right - tempRounding;
        arcCenterY = height - lineWidths.bottom - tempRounding + 1;
        idx2 = 0;
        while (idx2 < cornerWidth) {
            if (idx2 >= rightColors.length) {
                color = bottomColors[bottomColors.length - 1 - idx2];
                Color rightColor = rightColors[0];
                gImg.setPaint(new GradientPaint(0.0f, 0.0f, rightColor, 0.0f, tempRounding, color));
                NetUtils.drawArc(gImg, 0, 1, tempRounding + 1, imageHeight - idx2, 0, -90);
            } else {
                gImg.setColor(bottomColors[bottomColors.length - 1 - idx2]);
                NetUtils.drawArc(gImg, 0, 1, tempRounding + lineWidths.right - idx2, imageHeight - idx2, 0, -90);
            }
            ++idx2;
        }
        g.drawImage((Image)theDropShadowImage, width - tempRounding - lineWidths.right, height - lineWidths.bottom - tempRounding, null);
        g.setColor(oldColor);
        g.translate(-x, -y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints);
    }

    public static void drawArc(Graphics g, int centerX, int centerY, int radiusWidth, int radiusHeight, int startAngle, int arcAngle) {
        int x = centerX - radiusWidth;
        int y = centerY - radiusHeight;
        g.drawArc(x, y, 2 * radiusWidth - 1, 2 * radiusHeight - 2, startAngle, arcAngle);
    }

    public static void drawShadowRounding(Graphics2D g, Color[] lineColors, int x, int y, int width, int height) {
        g.translate(x, y);
        int cornerWidth = lineColors.length;
        BufferedImage image = ImageUtils.createCompatibleTranslucentImage(width, height);
        Graphics2D gImg = image.createGraphics();
        gImg.setComposite(AlphaComposite.getInstance(2));
        gImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int idx = 0;
        while (idx < cornerWidth) {
            Color leftColor = lineColors[idx];
            Color bottomColor = lineColors[lineColors.length - 1];
            gImg.setPaint(new GradientPaint(0.0f, 0.0f, leftColor, 0.0f, height, bottomColor));
            NetUtils.drawArc(gImg, width - 1, 0, width - idx, height, 180, 90);
            ++idx;
        }
        gImg.dispose();
        g.drawImage((Image)image, 0, 0, null);
        g.translate(-x, -y);
    }

    public static void drawRoundedRect(Graphics2D g, Color[] lineColors, Insets lineWidths, int x, int y, int width, int height, int rounding) {
        Object oldHints = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        Shape oldClip = g.getClip();
        g.translate(x, y);
        float turningPoint = Math.min(width + 1, height + 1) / 2;
        GeneralPath clip = new GeneralPath();
        if (lineWidths.top > 0) {
            clip.moveTo(0.0f, 0.0f);
            clip.lineTo(width + 1, 0.0f);
            clip.lineTo((float)width - turningPoint + 1.0f, turningPoint);
            clip.lineTo(turningPoint, turningPoint);
            clip.closePath();
            g.clip(clip);
            NetUtils.drawRectangles(g, lineColors, lineWidths.top, width, height, rounding);
            g.setClip(oldClip);
        }
        if (lineWidths.left > 0) {
            clip.reset();
            clip.moveTo(0.0f, 0.0f);
            clip.lineTo(turningPoint, turningPoint);
            clip.lineTo(0.0f, height + 1);
            clip.closePath();
            g.clip(clip);
            NetUtils.drawRectangles(g, lineColors, lineWidths.left, width, height, rounding);
            g.setClip(oldClip);
        }
        if (lineWidths.right > 0) {
            clip.reset();
            clip.moveTo(width + 1, 0.0f);
            clip.lineTo((float)(width + 1) - turningPoint, turningPoint);
            clip.lineTo(width + 1, height + 1);
            clip.closePath();
            g.clip(clip);
            NetUtils.drawRectangles(g, lineColors, lineWidths.right, width, height, rounding);
            g.setClip(oldClip);
        }
        if (lineWidths.bottom > 0) {
            clip.reset();
            clip.moveTo(width + 1, height + 1);
            clip.lineTo((float)(width + 1) - turningPoint, turningPoint);
            clip.lineTo(turningPoint, turningPoint);
            clip.lineTo(0.0f, height + 1);
            clip.closePath();
            g.clip(clip);
            NetUtils.drawRectangles(g, lineColors, lineWidths.bottom, width, height, rounding);
        }
        clip.moveTo(0.0f, 0.0f);
        clip.lineTo(width + 1, 0.0f);
        clip.lineTo((float)width - turningPoint + 1.0f, turningPoint);
        clip.lineTo(turningPoint, turningPoint);
        clip.closePath();
        g.clip(clip);
        NetUtils.drawRectangles(g, lineColors, lineWidths.top, width, height, rounding);
        g.setClip(oldClip);
        clip.reset();
        clip.moveTo(0.0f, 0.0f);
        clip.lineTo(turningPoint, turningPoint);
        clip.lineTo(0.0f, height + 1);
        clip.closePath();
        g.clip(clip);
        NetUtils.drawRectangles(g, lineColors, lineWidths.left, width, height, rounding);
        g.setClip(oldClip);
        clip.reset();
        clip.moveTo(width + 1, 0.0f);
        clip.lineTo((float)(width + 1) - turningPoint, turningPoint);
        clip.lineTo(width + 1, height + 1);
        clip.closePath();
        g.clip(clip);
        NetUtils.drawRectangles(g, lineColors, lineWidths.right, width, height, rounding);
        g.setClip(oldClip);
        clip.reset();
        clip.moveTo(width + 1, height + 1);
        clip.lineTo((float)(width + 1) - turningPoint, turningPoint);
        clip.lineTo(turningPoint, turningPoint);
        clip.lineTo(0.0f, height + 1);
        clip.closePath();
        g.clip(clip);
        NetUtils.drawRectangles(g, lineColors, lineWidths.bottom, width, height, rounding);
        g.translate(-x, -y);
        g.setClip(oldClip);
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints);
    }

    public static void drawRoundRectWithFilledCap(JComponent component, Graphics g, int x, int y, int width, int height, Color background, Color outline, int straightSegment) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldAa = NetUtils.antiAliasingOn(g);
        Shape outlineShape = NetUtils.getRoundedRect(component, x, y, width, height, 10, straightSegment);
        Shape clip = g.getClip();
        g2d.clip(outlineShape);
        if (1 == straightSegment) {
            g.clipRect(x, y + height - 5, width, 4);
        }
        g.setColor(background);
        g2d.fill(outlineShape);
        g.setClip(clip);
        g.setColor(outline);
        g2d.draw(outlineShape);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private static void drawRectangles(Graphics2D g, Color[] lineColors, int numberOfColors, int width, int height, int rounding) {
        int offset = 0;
        int idx = 0;
        while (idx < numberOfColors) {
            g.setColor(lineColors[idx]);
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float(idx + offset, idx + offset, width - 2 * (idx + offset), height - 2 * (idx + offset), rounding - (idx + offset), rounding - (idx + offset));
            g.draw(rect);
            ++idx;
        }
    }

    private static void drawRectangles(Graphics2D g, Color[] lineColors, int width, int height, int rounding) {
        NetUtils.drawRectangles(g, lineColors, lineColors.length, width, height, rounding);
    }

    public static void paintText(Graphics g, String text, int underlinedIndex, int x, int y, Color textColor, Color shadowColor, int offset) {
        Object oldAa = NetUtils.antiAliasingOff(g);
        NetLookAndFeel.toggleTextAntialiasing(g);
        Color oldColor = g.getColor();
        if (shadowColor != null) {
            g.setColor(shadowColor);
            g.translate(0, offset);
            NetUtils.antiAliasingOn(g);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
            NetUtils.antiAliasingOff(g);
            g.translate(0, -offset);
        }
        g.setColor(textColor);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, underlinedIndex, x, y);
        g.setColor(oldColor);
        NetUtils.setAntialiasing(g, oldAa);
    }

    public static void paintPrompt(Graphics g, JTextComponent comp) {
        Object prompt = comp.getClientProperty("OrangeTouch.prompt");
        if (prompt != null) {
            boolean isfocused;
            Component defaultComp = comp.getFocusCycleRootAncestor().getFocusTraversalPolicy().getDefaultComponent(comp);
            boolean bl = isfocused = comp.isFocusOwner() && comp == defaultComp;
            if (!ComponentUtils.isReadOnly(comp) && (!comp.isFocusOwner() || isfocused) && comp.isEditable() && comp.isEnabled() && comp.getText().length() == 0) {
                g.setColor(UIManager.getColor("TextField.promptColor"));
                int offset = comp.getHeight() < 20 ? 1 : 2;
                int y = comp.getHeight() / 2 + comp.getFont().getSize() / 2 - offset;
                if (ClientPropertyUtil.intValue(comp, "OceanTouch.promptAlignment") == 1) {
                    y = comp.getFont().getSize() + 2;
                }
                g.drawString(prompt.toString(), comp.getInsets().left + 3, y);
            }
        }
    }

    public static boolean paintLabel(Graphics g, JTextComponent comp) {
        Object label = comp.getClientProperty("OrangeTouch.label");
        if (label != null && !ComponentUtils.isReadOnly(comp) && !comp.isFocusOwner() && comp.isEditable() && comp.isEnabled() && comp.getText().length() == 0) {
            g.setColor(UIManager.getColor("TextField.labelColor"));
            g.setFont(g.getFont());
            g.drawString(label.toString(), comp.getInsets().left + 3, comp.getHeight() / 2 + comp.getFont().getSize() / 2 - 2);
            return true;
        }
        return false;
    }

    public static void paintLabelOrPrompt(Graphics g, JTextComponent comp) {
        if (!NetUtils.paintLabel(g, comp)) {
            NetUtils.paintPrompt(g, comp);
        }
    }

    public static boolean isFocused(JComboBox comboBox) {
        if (comboBox.isEditable()) {
            return comboBox.isFocusOwner() || comboBox.getEditor().getEditorComponent().isFocusOwner();
        }
        return comboBox.isFocusOwner();
    }

    public static void setMarginAndFont(AbstractButton button, String propertyPrefix) {
        String fontKey;
        Font font;
        Object sizeVariant = button.getClientProperty("JComponent.sizeVariant");
        sizeVariant = "small";
        if (NetUtils.lookAndFeelCanReplace(button.getMargin())) {
            if (button.getIcon() != null && (button.getText() == null || "".equals(button.getText()))) {
                button.setMargin(ComponentUtils.isSmall(button) && !ComponentUtils.isRounded(button) ? UIManager.getInsets(String.valueOf(propertyPrefix) + "smallIconOnlyMargin") : UIManager.getInsets(String.valueOf(propertyPrefix) + "iconOnlyMargin"));
            } else {
                String marginKey;
                Insets margin;
                if ("normal".equals(sizeVariant) || sizeVariant == null) {
                    sizeVariant = "";
                }
                String iconKey = "";
                if (button.getIcon() != null) {
                    iconKey = "icon";
                }
                if ((margin = UIManager.getInsets(marginKey = String.valueOf(propertyPrefix) + iconKey + sizeVariant + "margin")) != null) {
                    if (NetUtils.isIconAfterText(button)) {
                        int leftMargin = margin.left;
                        margin.left = margin.right;
                        margin.right = leftMargin;
                    }
                    button.setMargin(margin);
                }
            }
        }
        if (ComponentUtils.isRounded(button) && NetUtils.lookAndFeelCanReplace(button.getMargin())) {
            button.setMargin(new InsetsUIResource(3, 3, 3, 3));
        }
        if (NetUtils.lookAndFeelCanReplace(button.getFont()) && (font = UIManager.getFont(fontKey = String.valueOf(propertyPrefix) + sizeVariant + "font")) != null) {
            button.setFont(font);
        }
    }

    private static boolean isIconAfterText(AbstractButton button) {
        return button.getIcon() != null && button.getHorizontalTextPosition() == 10 && !ComponentUtils.isLeftToRight(button) && button.getHorizontalTextPosition() == 2;
    }

    public static void paintTableCellBackground(Graphics g, JComponent c) {
        Object value = c.getClientProperty("Table.isEditable");
        if (!c.isOpaque() && value != null) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (Boolean.TRUE.equals(value) && c.isEnabled()) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            RectangularShape roundRect = NetUtils.getRoundedRect(c, 2, 2, c.getWidth() - 3, c.getHeight() - 3, 5);
            Color oldColor = g.getColor();
            ColorUIResource color = (Color)c.getClientProperty("Table.tableCellBackground") == null ? NetLookAndFeel.getWhite() : (Color)c.getClientProperty("Table.tableCellBackground");
            g.setColor(color);
            ((Graphics2D)g).fill(roundRect);
            NetUtils.setAntialiasing(g, oldAa);
            g.setColor(oldColor);
        }
    }

    public static Color brighter(Color color, double factor) {
        float[] hsbval = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbval[2] = (float)Math.min((double)hsbval[2] / factor, 1.0);
        return new Color(Color.HSBtoRGB(hsbval[0], hsbval[1], hsbval[2]));
    }

    public static Color darker(Color color, double factor) {
        float[] hsbval = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbval[2] = (float)Math.max((double)hsbval[2] * factor, 0.0);
        return new Color(Color.HSBtoRGB(hsbval[0], hsbval[1], hsbval[2]));
    }

    public static void setTransparent(Window window) {
        try {
            Class<?> awtUtilities = Class.forName("com.sun.awt.AWTUtilities");
            Class<?> translucency = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Method method = awtUtilities.getMethod("isTranslucencySupported", translucency);
            Field field = translucency.getField("TRANSLUCENT");
            boolean isTranslucencySupported = (Boolean)method.invoke(null, field.get(null));
            if (isTranslucencySupported) {
                Method setWindowOpaque = awtUtilities.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                setWindowOpaque.invoke(null, window, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void paintEmptyText(Graphics g, Component comp, String emptyText) {
        if (emptyText == null) {
            return;
        }
        Color oldColor = g.getColor();
        FontMetrics fm = g.getFontMetrics();
        if (comp instanceof JTable && comp.isOpaque() && comp.getParent() != null) {
            g.setColor(comp.getParent().getBackground());
            g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        }
        NetLookAndFeel.toggleTextAntialiasing(g);
        g.setColor(UIManager.getColor("Table.emptyText"));
        g.drawString(emptyText, 10, fm.getMaxAscent());
        g.setColor(oldColor);
    }

    public static GeneralPath createCurvedOutline(Graphics g, JComponent comp, int outlineWidth, int outlineHeight) {
        GeneralPath path = new GeneralPath();
        Insets insets = comp.getInsets();
        float menuHeight = comp.getHeight() - insets.bottom - outlineHeight;
        path.moveTo(0.0f, menuHeight);
        path.lineTo(outlineWidth, menuHeight);
        int curvedAreaWidth = 68;
        int curvedAreaHeight = 22;
        path.quadTo(outlineWidth + curvedAreaWidth / 2 - 12, menuHeight, outlineWidth + curvedAreaWidth / 2 - 2, 3.0f + menuHeight + (float)(curvedAreaHeight / 2));
        path.quadTo(outlineWidth + curvedAreaWidth / 2 + 12, 3.0f + menuHeight + (float)curvedAreaHeight + 14.0f, outlineWidth + curvedAreaWidth, comp.getHeight() - insets.bottom);
        path.lineTo(0.0f, comp.getHeight() - insets.bottom);
        path.closePath();
        return path;
    }

    public static void paintDropShadow(Graphics graphics, JComponent comp, int x, int y, int w, int h, int rounding) {
        int tempH = h;
        int tempY = y;
        if (ClientPropertyUtil.booleanValue(comp, "OceanTouch.searchButton")) {
            return;
        }
        Color[] colors = null;
        Insets lineWidths = new Insets(1, 2, 3, 2);
        if (comp instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)comp;
            colors = btn.getModel().isRollover() ? (Color[])UIManager.get("Button.hoverShadow") : (Color[])UIManager.get("Button.shadow");
        } else if (comp instanceof JComboBox) {
            JComboBox combo = (JComboBox)comp;
            ComboBoxUI ui = combo.getUI();
            if (ui instanceof NetComboBoxUI) {
                NetComboBoxUI netUI = (NetComboBoxUI)ui;
                colors = netUI.getArrowButton().getModel().isRollover() ? (Color[])UIManager.get("Editor.hoverShadow") : (Color[])UIManager.get("Editor.shadow");
                lineWidths = new Insets(1, 1, 2, 1);
            }
        } else {
            colors = (Color[])UIManager.get("Editor.shadow");
            lineWidths = new Insets(1, 1, 2, 1);
        }
        if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStraightBottomEdge")) {
            tempH += 1000;
        } else if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStraightTopEdge")) {
            tempH += 1000;
            tempY -= 1000;
        }
        NetUtils.drawDropShadow((Graphics2D)graphics, colors, lineWidths, x, tempY, w, tempH, rounding);
    }

    public static void paintDropShadow(Graphics graphics, JComponent comp, int x, int y, int w, int h) {
        NetUtils.paintDropShadow(graphics, comp, x, y, w, h, NetTheme.getComponentOutlineRounding(comp));
    }

    public static void paintEmphasis(Graphics2D g, JComponent jComponent, int width) {
        NetUtils.paintEmphasis(g, jComponent, 0, 0, width, 12);
    }

    public static void paintEmphasis(Graphics2D g, JComponent jComponent, int x, int y, int width, int rounding) {
        int topOutlineY = y;
        int topOutlineHeight = 6;
        Shape topOutline = NetUtils.getRoundedPath(jComponent, x, topOutlineY, width - 1, topOutlineHeight, rounding, 5, true);
        g.setColor(NetTheme.getEmphasisColor());
        g.draw(topOutline);
        topOutline = NetUtils.getRoundedPath(jComponent, x, ++topOutlineY, width - 1, topOutlineHeight, rounding, 5, true);
        g.setColor(NetLookAndFeel.getWhite());
        g.draw(topOutline);
        g.setColor(NetUtils.getColor(NetTheme.getEmphasisColor(), 160));
        g.draw(topOutline);
        g.setColor(NetLookAndFeel.getWhite());
        topOutline = NetUtils.getRoundedPath(jComponent, x, ++topOutlineY, width - 1, topOutlineHeight, rounding, 5, true);
        g.draw(topOutline);
    }

    public static boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static Insets getVisualPadding(JComponent comp) {
        if (!(comp.getBorder() instanceof UIResource)) {
            return null;
        }
        if (comp instanceof AbstractButton) {
            return new Insets(1, 2, 3, 2);
        }
        if (comp instanceof JComboBox || comp instanceof JSpinner) {
            return new Insets(1, 0, 2, 1);
        }
        if (comp instanceof JTextComponent) {
            return new Insets(0, 0, 1, 0);
        }
        if (comp instanceof JScrollPane && comp.getBorder() instanceof TableShadowBorder) {
            return new Insets(2, 2, 2, 2);
        }
        if (comp instanceof JPanel && comp.getBorder() instanceof TablePanelBorder) {
            return new Insets(2, 2, 2, 2);
        }
        return null;
    }

    public static Insets add(Insets insets1, Insets insets2) {
        return new Insets(insets1.top + insets2.top, insets1.left + insets2.left, insets1.bottom + insets2.bottom, insets1.right + insets2.right);
    }

    public static void merge(Insets insets, Insets insetsToAdd) {
        insets.top = Math.max(insets.top, insetsToAdd.top);
        insets.left = Math.max(insets.left, insetsToAdd.left);
        insets.bottom = Math.max(insets.bottom, insetsToAdd.bottom);
        insets.right = Math.max(insets.right, insetsToAdd.right);
    }

    public static Robot getRobot() {
        return theRobot;
    }

    public static void paintScreenCapture(Graphics g, Rectangle screenArea) {
        if (theRobot != null) {
            BufferedImage image = theRobot.createScreenCapture(screenArea);
            g.drawImage(image, 0, 0, null);
        }
    }

    public static boolean isWarningOrErrorBox(JRootPane root) {
        return root.getWindowDecorationStyle() == 8 || root.getWindowDecorationStyle() == 4;
    }

    public static boolean isMessageBox(JRootPane root) {
        return root.getWindowDecorationStyle() == 8 || root.getWindowDecorationStyle() == 4 || root.getWindowDecorationStyle() == 3 || root.getWindowDecorationStyle() == 7;
    }

    public static void highlight(JLabel label, String text) {
        String tempText = text;
        String lowerCaseText = label.getText().toLowerCase();
        lowerCaseText = lowerCaseText.replaceAll(LINE_SEPARATOR, "").replaceAll("\n", "");
        if (tempText == null || lowerCaseText.indexOf(tempText.toLowerCase()) < 0) {
            NetUtils.clearHighlights(label);
            return;
        }
        tempText = tempText.toLowerCase();
        tempText = Pattern.quote(tempText);
        Pattern p = Pattern.compile(tempText);
        Matcher m = p.matcher(lowerCaseText);
        while (m.find()) {
            NetUtils.addHighlight(label, m.start(), m.end(), NSNColors.getGreen());
        }
    }

    public static void clearHighlights(JLabel label) {
        LabelHighlighter highlighter = (LabelHighlighter)label.getClientProperty("OrangeTouch.highlighter");
        if (highlighter != null) {
            highlighter.removeAllHighlights();
        }
    }

    public static void addHighlight(JLabel label, int start, int end, Color color) {
        int length;
        int tempStart = start;
        int tempEnd = end;
        LabelHighlighter highlighter = (LabelHighlighter)label.getClientProperty("OrangeTouch.highlighter");
        if (highlighter == null) {
            highlighter = new DefaultLabelHighlighter();
            label.putClientProperty("OrangeTouch.highlighter", highlighter);
        }
        if (tempStart < 0) {
            tempStart = 0;
        }
        if (tempStart > (length = label.getText().length())) {
            tempStart = length;
        }
        if (tempEnd > length) {
            tempEnd = length;
        }
        if (tempEnd < tempStart) {
            tempStart = -1;
            tempEnd = -1;
        }
        highlighter.addHighlight(tempStart, tempEnd, new DefaultLabelHighlightPainter(color));
    }

    public static void paintTextComponentBackground(Graphics g, JTextComponent comp) {
        Object oldAa = NetUtils.antiAliasingOn(g);
        Color oldColor = g.getColor();
        RectangularShape outlineForFill = NetUtils.getOutlineForFill(comp);
        NetUtils.setFrameForComponentOutLine(comp, outlineForFill);
        if (!comp.isEnabled() || ComponentUtils.isReadOnly(comp)) {
            GradientUtils.drawVerticalBackgroundGradient(comp, g);
            if (NetUtils.isInDialog(comp)) {
                g.setColor(UIManager.getColor("TextComponent.disabledFill"));
                ((Graphics2D)g).fill(outlineForFill);
            }
        } else if (comp.isEditable()) {
            if (comp.getParent() instanceof JTable) {
                JTable table = (JTable)comp.getParent();
                g.setColor(table.getSelectionBackground());
                int rounding = NetTheme.getComponentOutlineRounding(comp);
                outlineForFill = new RoundRectangle2D.Double(2.0, 2.0, comp.getWidth() - 4, comp.getHeight() - 4, rounding, rounding);
                g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
            }
            g.setColor(comp.getBackground());
            ((Graphics2D)g).fill(outlineForFill);
        }
        g.setColor(oldColor);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private static void setFrameForComponentOutLine(JTextComponent comp, RectangularShape outlineForFill) {
        double outLinewidth = outlineForFill.getWidth();
        double outLineHeight = outlineForFill.getHeight();
        if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.openRightEdge")) {
            outLinewidth += 1000.0;
        } else if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.openBottomEdge")) {
            outLineHeight += 1000.0;
        } else if (ClientPropertyUtil.booleanValue(comp, "Multi-language")) {
            outLinewidth += -34.0;
        }
        outlineForFill.setFrame(outlineForFill.getX(), outlineForFill.getY(), outLinewidth, outLineHeight);
    }

    public static void paintHoverEffect(Graphics g, Component comp, int x, int y, int width, int height) {
        NetUtils.paintHoverEffect(g, comp, x, y, width, height, null);
    }

    public static void paintHoverEffect(Graphics g, Component component, int x, int y, int width, int height, Rectangle textRect) {
        if (SystemUtils.isOrangeTouch()) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            g.setColor(NetTheme.getSelectionColor());
            g.drawRoundRect(x, y, width, height, 8, 8);
            NetUtils.setAntialiasing(g, oldAa);
        } else {
            g.setColor(NetTheme.getHoverColor());
            if (textRect == null) {
                int xOffset = 5;
                g.drawLine(x + 5, y + height - 1, x + component.getPreferredSize().width - 5 - 1, y + height - 1);
            } else {
                g.drawLine(textRect.x, textRect.y + textRect.height, textRect.x + textRect.width, textRect.y + textRect.height);
            }
        }
    }

    public static Color getTableOutlineColor(JComponent component) {
        if (NetUtils.isInDialog(component)) {
            return UIManager.getColor("Table.dialogOutlineColor");
        }
        if (component.getParent() instanceof JPanel) {
            return UIManager.getColor("Table.panelOutlineColor");
        }
        return UIManager.getColor("TableHeader.outlineColor");
    }

    public static void paintTableBackgroundFilter(Graphics g, JTable table, Shape shapeToFill) {
        if (!ComponentUtils.isStandalone(table) || !table.isEnabled()) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(NetUtils.getColor(Color.WHITE, 100));
        ((Graphics2D)g).fill(shapeToFill);
        g.setColor(oldColor);
    }

    public static void drawTableShadow(Component c, Graphics g, int x, int y, int width, int height, Insets shadowSize, int rounding) {
        Color[] colors = (Color[])(NetUtils.isInDialog((JComponent)c) ? UIManager.get("Table.dialogShadow") : UIManager.get("Table.shadow"));
        NetUtils.drawDropShadow((Graphics2D)g, colors, shadowSize, x, y, width, height, rounding);
    }

    public static void fillShapeInPopup(JComponent c, Graphics2D g2d, Shape shape) {
        if (ClientPropertyUtil.booleanValue(c, "OrangeTouch.isLightbox")) {
            GradientUtils.drawVerticalBackgroundGradient((Container)c, (Graphics)g2d, shape);
            return;
        }
        Color oldColor = g2d.getColor();
        g2d.setColor(c.getBackground());
        g2d.fill(shape);
        g2d.setColor(oldColor);
    }

    private static class ImageEntry {
        boolean myLight;
        int myWidth;

        public ImageEntry(int width, boolean light) {
            this.myLight = light;
            this.myWidth = width;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myLight ? 1231 : 1237);
            result = 31 * result + this.myWidth;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageEntry other = (ImageEntry)obj;
            if (this.myLight != other.myLight) {
                return false;
            }
            return this.myWidth == other.myWidth;
        }
    }
}

