/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.util;

import com.nokia.widgets.text.PTextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class TextFieldHandler {
    private PTextField myComponent;
    private JList myList;
    private JPopupMenu myPopup;
    protected MouseAdapter myDropdownMouseAdapter;
    protected FocusAdapter myDropdownFocusAdapter;
    protected KeyAdapter myDropdownKeyAdapter;

    public TextFieldHandler(PTextField component, JList list, JPopupMenu popup) {
        this.myComponent = component;
        this.myList = list;
        this.myPopup = popup;
    }

    public void installListeners() {
        if (this.myComponent != null && this.myList != null && this.myPopup != null) {
            this.myDropdownMouseAdapter = this.createDropdownMouseAdapter();
            this.myList.addMouseMotionListener(this.myDropdownMouseAdapter);
            this.myList.addMouseListener(this.myDropdownMouseAdapter);
            this.myComponent.addFocusListener(this.createFocusAdapter());
            this.myComponent.addKeyListener(this.createKeyAdapter());
        }
    }

    public void uninstallListeners() {
        this.myList.removeMouseMotionListener(this.myDropdownMouseAdapter);
        this.myList.removeMouseListener(this.myDropdownMouseAdapter);
        this.myComponent.removeFocusListener(this.myDropdownFocusAdapter);
        this.myComponent.removeKeyListener(this.myDropdownKeyAdapter);
    }

    private MouseAdapter createDropdownMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = TextFieldHandler.this.myList.locationToIndex(e.getPoint());
                if (index >= 0 && TextFieldHandler.this.myList.getSelectedIndex() != index) {
                    TextFieldHandler.this.myList.setSelectedIndex(index);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    TextFieldHandler.this.setTextWithoutNotification((String)TextFieldHandler.this.myList.getSelectedValue());
                    TextFieldHandler.this.myPopup.setVisible(false);
                }
            }
        };
    }

    protected void setTextWithoutNotification(String selectedValue) {
    }

    private FocusAdapter createFocusAdapter() {
        this.myDropdownFocusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TextFieldHandler.this.myPopup.setVisible(false);
            }
        };
        return this.myDropdownFocusAdapter;
    }

    protected KeyAdapter createKeyAdapter() {
        this.myDropdownKeyAdapter = new DropdownKeyAdapter();
        return this.myDropdownKeyAdapter;
    }

    protected class DropdownKeyAdapter
    extends KeyAdapter {
        protected DropdownKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (TextFieldHandler.this.myPopup.isShowing()) {
                switch (e.getKeyCode()) {
                    case 38: {
                        this.changeListSelectedIndex(-1);
                        e.consume();
                        break;
                    }
                    case 33: {
                        this.changeListSelectedIndex(-TextFieldHandler.this.myList.getVisibleRowCount());
                        e.consume();
                        break;
                    }
                    case 40: {
                        this.changeListSelectedIndex(1);
                        e.consume();
                        break;
                    }
                    case 34: {
                        this.changeListSelectedIndex(TextFieldHandler.this.myList.getVisibleRowCount());
                        e.consume();
                        break;
                    }
                    case 27: {
                        TextFieldHandler.this.myPopup.setVisible(false);
                        e.consume();
                        TextFieldHandler.this.setTextWithoutNotification(this.getUserText());
                        break;
                    }
                    case 10: 
                    case 37: 
                    case 39: {
                        TextFieldHandler.this.myPopup.setVisible(false);
                        e.consume();
                    }
                }
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 38 || e.getKeyCode() == 33 || e.getKeyCode() == 34) {
                e.consume();
                this.setUserText(TextFieldHandler.this.myComponent.getText());
                this.showDropdownList();
            }
        }

        private void changeListSelectedIndex(int delta) {
            int size = TextFieldHandler.this.myList.getModel().getSize();
            int index = TextFieldHandler.this.myList.getSelectedIndex();
            int newIndex = 0;
            newIndex = index < 0 ? (delta > 0 ? 0 : size - 1) : index + delta;
            if (newIndex >= size || newIndex < 0) {
                int n = newIndex = newIndex < 0 ? 0 : size - 1;
                if (index == newIndex) {
                    newIndex = -1;
                }
            }
            if (newIndex < 0) {
                TextFieldHandler.this.myList.getSelectionModel().clearSelection();
                TextFieldHandler.this.myList.ensureIndexIsVisible(0);
                TextFieldHandler.this.setTextWithoutNotification(this.getUserText());
            } else {
                TextFieldHandler.this.myList.setSelectedIndex(newIndex);
                TextFieldHandler.this.myList.ensureIndexIsVisible(newIndex);
                TextFieldHandler.this.setTextWithoutNotification((String)TextFieldHandler.this.myList.getSelectedValue());
            }
        }

        protected String getUserText() {
            return null;
        }

        protected void setUserText(String text) {
        }

        protected void showDropdownList() {
        }
    }
}

