/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf.util;

import com.nokia.laf.util.NetUtils;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class VisualPaddingHandler
implements PropertyChangeListener {
    private static final VisualPaddingHandler theInstance = new VisualPaddingHandler();

    public static VisualPaddingHandler getInstance() {
        return theInstance;
    }

    public void installTo(Component comp) {
        this.setVisualPadding((JComponent)comp);
        comp.addPropertyChangeListener("border", this);
    }

    public void uninstallFrom(Component comp) {
        comp.removePropertyChangeListener("border", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JComponent) {
            JComponent comp = (JComponent)evt.getSource();
            this.setVisualPadding(comp);
        }
    }

    private void setVisualPadding(JComponent comp) {
        Insets visualPadding = NetUtils.getVisualPadding(comp);
        comp.putClientProperty("visualPadding", visualPadding);
    }
}

