/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.NetTheme;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.UIManager;

public class ColorBox
extends JCheckBox
implements ActionListener {
    private static JColorChooser myColorChooser = null;
    private BoxIcon myDefaultIcon = new BoxIcon();

    public ColorBox() {
        this(Color.white, null);
    }

    public ColorBox(Color color) {
        this(color, null);
    }

    public ColorBox(Color color, String text) {
        super(text);
        this.myDefaultIcon.setColor(color);
        this.setIcon(this.myDefaultIcon);
        super.addActionListener(this);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.removeActionListener(this);
        super.addActionListener(l);
        super.addActionListener(this);
    }

    public void setColor(Color color) {
        this.myDefaultIcon.setColor(color);
        this.repaint();
    }

    public Color getColor() {
        return this.myDefaultIcon.getColor();
    }

    public void setIconHeight(int height) {
        this.myDefaultIcon.setIconHeight(height);
        this.repaint();
    }

    public void setIconWidth(int width) {
        this.myDefaultIcon.setIconWidth(width);
        this.repaint();
    }

    public int getIconHeight() {
        return this.myDefaultIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.myDefaultIcon.getIconWidth();
    }

    public JColorChooser getChooserPane() {
        if (myColorChooser == null) {
            myColorChooser = new JColorChooser(this.getColor());
        }
        return myColorChooser;
    }

    public static void setChooserPane(JColorChooser chooser) {
        if (chooser != null) {
            myColorChooser = chooser;
        }
    }

    private void openColorChooser() {
        String title = WidgetResources.getString("ColorChooser.Title_text");
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = myColorChooser.getColor();
                ColorBox.this.setColor(c);
            }
        };
        JDialog dialog = JColorChooser.createDialog(this, title, true, this.getChooserPane(), ok, null);
        dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            this.openColorChooser();
        }
    }

    protected class BoxIcon
    implements Icon {
        private int myWidth = 12;
        private int myHeight = 12;
        private Color myColor;

        protected BoxIcon() {
        }

        public Color getColor() {
            return this.myColor;
        }

        public void setColor(Color color) {
            this.myColor = color;
        }

        public void setIconHeight(int height) {
            this.myHeight = height;
        }

        public void setIconWidth(int width) {
            this.myWidth = width;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(this.myColor);
            g.fillRect(x + 1, y + 1, this.myWidth - 1, this.myHeight - 1);
            if (ColorBox.this.model.isEnabled()) {
                g.setColor(NetTheme.getComponentOutlineColor());
            } else {
                g.setColor(NetTheme.getDisabledComponentOutlineColor());
            }
            g.drawRoundRect(x, y, this.myWidth, this.myHeight, 2, 2);
            if (ColorBox.this.model.isRollover()) {
                Color innerColor = UIManager.getColor("Button.rolloverColor");
                g.setColor(innerColor);
                g.drawRect(x + 1, y + 1, this.myWidth - 2, this.myHeight - 2);
            }
            g.setColor(savedColor);
        }
    }
}

