/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.infotip.InfoTip;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PMatrixLayout;
import com.nokia.widgets.slidingpanel.SlidingPanel;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FlyInMessage
extends SlidingPanel {
    public static final int WARNING_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int ERROR_MESSAGE = 2;
    protected String myTitle;
    protected JComponent myMsg;
    protected Icon myIcon;
    protected InfoTip myInfoTip;
    private boolean myShowCloseButton;
    private ActionListener myCloseListener;

    public FlyInMessage(String title, String message, int messageType) {
        this.init(title, PLabel.createSystemText(message), this.loadIcon(messageType));
    }

    public FlyInMessage(String title, String message, Icon icon) {
        this.init(title, PLabel.createSystemText(message), icon);
    }

    public FlyInMessage(String title, JComponent message, int messageType) {
        this.init(title, message, this.loadIcon(messageType));
    }

    public FlyInMessage(String title, JComponent message, Icon icon) {
        this.init(title, message, icon);
    }

    public void setInfotipText(String infoText) {
        if (this.myInfoTip == null) {
            this.myInfoTip = new InfoTip((Component)this, "");
        }
        this.myInfoTip.setTipContent(infoText);
    }

    public void setInfotip(InfoTip tip) {
        if (this.myInfoTip != null) {
            this.myInfoTip.disposeTip();
        }
        this.myInfoTip = tip;
    }

    public void setCloseVisible(boolean visible, ActionListener closeListener) {
        this.myShowCloseButton = visible;
        this.myCloseListener = closeListener;
        this.reBuildUI();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
        this.reBuildUI();
    }

    public String getMessageText() {
        if (this.myMsg instanceof PLabel) {
            return ((PLabel)this.myMsg).getText();
        }
        return null;
    }

    public JComponent getMessageComponent() {
        return this.myMsg;
    }

    public void setMessageText(String text) {
        this.myMsg = PLabel.createSystemText(text);
        this.reBuildUI();
    }

    public void setMessageComponent(JComponent comp) {
        this.myMsg = comp;
        this.reBuildUI();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
        this.reBuildUI();
    }

    public void showMessage() {
        this.showPanel();
    }

    public void hideMessage() {
        this.hidePanel();
    }

    public boolean isMessageVisible() {
        return this.isPanelVisible();
    }

    protected void init(String title, JComponent message, Icon icon) {
        this.myTitle = title;
        this.myMsg = message;
        this.myIcon = icon;
        this.reBuildUI();
    }

    protected Icon loadIcon(int messageType) {
        if (messageType == 0) {
            return WidgetResources.getImageIcon("Warning.Icon");
        }
        if (messageType == 2) {
            return WidgetResources.getImageIcon("Error.Icon");
        }
        return WidgetResources.getImageIcon("Info.Icon");
    }

    protected void reBuildUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new PMatrixLayout(2, 6, 6, 6, 6));
        main.setBackground(new Color(255, 245, 201));
        main.add(new PLabel(this.myIcon));
        main.add(PLabel.createTitle(this.myTitle));
        main.add(new PLabel());
        main.add(this.myMsg);
        this.add((Component)main, "Center");
        if (this.myShowCloseButton) {
            JButton myXButton = new JButton(new CloseIcon());
            myXButton.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
            myXButton.setDefaultCapable(false);
            myXButton.setFocusable(false);
            myXButton.setMargin(new Insets(0, 0, 0, 0));
            myXButton.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 1));
            myXButton.setAlignmentY(0.0f);
            myXButton.setFocusPainted(false);
            myXButton.setContentAreaFilled(false);
            myXButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlyInMessage.this.hideMessage();
                }
            });
            if (this.myCloseListener != null) {
                myXButton.addActionListener(this.myCloseListener);
            }
            JPanel button = new JPanel();
            button.add(myXButton);
            button.setBackground(new Color(255, 245, 201));
            this.add((Component)button, "East");
        }
        this.revalidate();
        this.repaint();
    }
}

