/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.ColorBox;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.text.IntegerDocument;
import com.nokia.widgets.text.NumberRangeValidator;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.TextFieldFactory;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class FontChooser
extends JDialog {
    private static final int COLORBOXWIDTH = 60;
    private static final int DEFAULTFONTSIZE = 12;
    private boolean predictableTextInputInProcess = false;
    private boolean isOKclicked;
    private PTextField myFamilyField;
    private JList myFamilyList;
    private PTextField mySizeField;
    private JList mySizeList;
    private IntegerDocument mySizeFieldDocument;
    private NumberRangeValidator mySizeFieldRangeValidator;
    private JButton myOkButton;
    private JButton myCancelButton;
    private PLabel myTextColorLabel;
    private ColorBox myTextColorBox;
    private Color myDefaultColor;
    private JTextArea myPreviewArea;
    private String previewText = String.valueOf(WidgetResources.getString("FontChooser.PreviewLine1_text")) + System.getProperty("line.separator") + WidgetResources.getString("FontChooser.PreviewLine2_text") + System.getProperty("line.separator") + WidgetResources.getString("FontChooser.PreviewLine3_text");
    private JCheckBox myIsBold = null;
    private JCheckBox myIsItalic = null;
    private int myMaxFontSize = 100;
    private int myMinFontSize = 8;
    private boolean isFontListPopulatingInProcess = true;
    private Thread myFontListThread;
    private Font myDefaultFont;

    public FontChooser() {
        this((Window)null, (Font)null, (Color)null);
    }

    public FontChooser(Window parent) {
        this(parent, (Font)null, (Color)null);
    }

    public FontChooser(Window parent, Font font) {
        this(parent, font, null);
    }

    public FontChooser(Window parent, Font font, Color color) {
        super(parent);
        Font tempFont = font;
        this.setModal(true);
        this.setTitle(WidgetResources.getString("FontChooser.Title_text"));
        this.getContentPane().setLayout(new BorderLayout());
        if (tempFont == null && parent != null) {
            tempFont = parent.getFont();
        }
        if (tempFont == null) {
            tempFont = new Font("Dialog", 0, 12);
        }
        this.myDefaultFont = tempFont;
        this.myDefaultColor = color == null ? NetLookAndFeel.getControlInfo() : color;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(22, 22, 20, 22));
        JPanel selectionPanel = this.getSelectionPanel();
        content.add((Component)selectionPanel, "North");
        JPanel previewPanel = this.buildPreviewPanel();
        content.add((Component)previewPanel, "Center");
        this.getContentPane().add((Component)content, "Center");
        JPanel buttonPanel = this.buildButtonPanel();
        this.getContentPane().add("South", buttonPanel);
        previewPanel.registerKeyboardAction(new ClosingListener(), KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        Dimension dim = this.getSize();
        if (dim.width > 600 || dim.height > 600) {
            if (dim.width > 600) {
                dim.width = 600;
            }
            if (dim.height > 600) {
                dim.height = 600;
            }
            this.setSize(dim);
        }
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(parent));
    }

    public FontChooser(Frame parent, Font font, Color color) {
        super(parent, true);
        Font tempFont = font;
        this.setTitle(WidgetResources.getString("FontChooser.Title_text"));
        this.getContentPane().setLayout(new BorderLayout());
        if (tempFont == null && parent != null) {
            tempFont = parent.getFont();
        }
        if (tempFont == null) {
            tempFont = new Font("Dialog", 0, 12);
        }
        this.myDefaultFont = tempFont;
        this.myDefaultColor = color == null ? Color.black : color;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(20, 26, 20, 26));
        JPanel selectionPanel = this.getSelectionPanel();
        content.add((Component)selectionPanel, "North");
        JPanel previewPanel = this.buildPreviewPanel();
        content.add((Component)previewPanel, "Center");
        this.getContentPane().add((Component)content, "Center");
        JPanel buttonPanel = this.buildButtonPanel();
        this.getContentPane().add("South", buttonPanel);
        previewPanel.registerKeyboardAction(new ClosingListener(), KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        Dimension dim = this.getSize();
        if (dim.width > 600 || dim.height > 600) {
            if (dim.width > 600) {
                dim.width = 600;
            }
            if (dim.height > 600) {
                dim.height = 600;
            }
            this.setSize(dim);
        }
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(parent));
    }

    private JPanel getSelectionPanel() {
        JPanel listPanel = new JPanel(new GridBagLayout());
        this.myFamilyField = new PTextField();
        this.myFamilyField.addFocusListener(new MyFocusListener());
        this.myFamilyField.setValidateOnFocusLost(true);
        this.myFamilyField.addDocumentListener(new MyFontDocumentListener());
        this.myFamilyList = new JList<Object>(new Object[]{WidgetResources.getString("FontChooser.Populating_text")});
        this.myFamilyList.setVisibleRowCount(8);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 6, 12);
        PLabel fontLabel = PLabel.createTitle(WidgetResources.getString("FontChooser.Font_text"));
        listPanel.add((Component)fontLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 6, 12);
        listPanel.add((Component)this.myFamilyField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 12, 12);
        JScrollPane fontScroller = new JScrollPane(this.myFamilyList, 22, 31);
        listPanel.add((Component)fontScroller, constraints);
        if (!this.isFontListPopulatingInProcess) {
            this.myFamilyList.setSelectedValue(this.myDefaultFont.getFamily(), true);
            this.myFamilyField.setText(this.myDefaultFont.getFamily());
        }
        this.mySizeField = TextFieldFactory.createIntegerTextField(this.myMinFontSize, this.myMaxFontSize);
        this.mySizeFieldDocument = new IntegerDocument(this.myMinFontSize, this.myMaxFontSize);
        this.mySizeField.setDocument(this.mySizeFieldDocument);
        this.mySizeFieldRangeValidator = new NumberRangeValidator(this.myMinFontSize, this.myMaxFontSize);
        this.mySizeField.addValidationListener(this.mySizeFieldRangeValidator);
        this.mySizeField.setValidateOnFocusLost(true);
        this.mySizeField.addDocumentListener(new MySizeDocumentListener());
        this.mySizeList = new JList();
        this.mySizeList.setPrototypeCellValue("199");
        this.mySizeList.setVisibleRowCount(8);
        this.populateFontSizeList();
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 6, 12);
        PLabel sizeLabel = PLabel.createTitle(WidgetResources.getString("FontChooser.Size_text"));
        listPanel.add((Component)sizeLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 0, 6, 12);
        listPanel.add((Component)this.mySizeField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 12, 12);
        JScrollPane sizeScroller = new JScrollPane(this.mySizeList);
        sizeScroller.setHorizontalScrollBarPolicy(31);
        sizeScroller.setVerticalScrollBarPolicy(22);
        listPanel.add((Component)sizeScroller, constraints);
        this.mySizeList.setSelectedValue(String.valueOf(this.myDefaultFont.getSize()), true);
        this.mySizeField.setText(String.valueOf(this.myDefaultFont.getSize()));
        ListHandler listHandler = new ListHandler();
        this.myFamilyList.addListSelectionListener(listHandler);
        this.mySizeList.addListSelectionListener(listHandler);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 6, 0);
        PLabel titleLabel = PLabel.createTitle(WidgetResources.getString("FontChooser.Style_text"));
        listPanel.add((Component)titleLabel, constraints);
        JPanel stylesPanel = new JPanel(new PVerticalLayout(0, 0, 0, 0));
        this.myIsBold = new JCheckBox(WidgetResources.getString("FontChooser.Bold_text"));
        this.myIsBold.setMnemonic(WidgetResources.getMnemonic("FontChooser.Bold_Mnemonic"));
        this.myIsBold.addActionListener(new CheckActionHandler());
        if (this.myDefaultFont.isBold()) {
            this.myIsBold.setSelected(true);
        }
        stylesPanel.add(this.myIsBold);
        this.myIsItalic = new JCheckBox(WidgetResources.getString("FontChooser.Italic_text"));
        this.myIsItalic.setMnemonic(WidgetResources.getMnemonic("FontChooser.Italic_Mnemonic"));
        this.myIsItalic.addActionListener(new CheckActionHandler());
        if (this.myDefaultFont.isItalic()) {
            this.myIsItalic.setSelected(true);
        }
        stylesPanel.add(this.myIsItalic);
        this.myTextColorLabel = PLabel.createSystemText(WidgetResources.getString("FontChooser.Color_text"));
        this.myTextColorBox = new ColorBox(this.myDefaultColor);
        this.myTextColorBox.setIconWidth(60);
        this.myTextColorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.myPreviewArea.setForeground(FontChooser.this.myTextColorBox.getColor());
                FontChooser.this.myPreviewArea.repaint();
            }
        });
        stylesPanel.add(Box.createVerticalStrut(6));
        stylesPanel.add(this.myTextColorLabel);
        stylesPanel.add(this.myTextColorBox);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 0;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.insets = new Insets(0, 0, 12, 0);
        listPanel.add((Component)stylesPanel, constraints);
        return listPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new PButtonRowLayout());
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setBorder(PBorderFactory.getButtonBarBorder());
        this.myOkButton = new JButton(WidgetResources.getString("OkAction_Text"));
        this.myOkButton.addActionListener(new ActionHandler());
        this.myOkButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.myOkButton);
        buttonPanel.add(this.myOkButton);
        this.myCancelButton = new JButton(WidgetResources.getString("CancelAction_Text"));
        this.myCancelButton.setMnemonic(WidgetResources.getMnemonic("CancelAction_Mnemonic"));
        this.myCancelButton.addActionListener(new ActionHandler());
        buttonPanel.add(this.myCancelButton);
        return buttonPanel;
    }

    private JPanel buildPreviewPanel() {
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BorderLayout(6, 6));
        this.myPreviewArea = new JTextArea(this.previewText);
        this.myPreviewArea.setForeground(this.myDefaultColor);
        this.myPreviewArea.setOpaque(true);
        if (this.myDefaultFont.getSize() < 30) {
            this.myPreviewArea.setRows(4);
        }
        this.myPreviewArea.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        this.myPreviewArea.setBackground(Color.white);
        JScrollPane pane = new JScrollPane(this.myPreviewArea);
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(20);
        JPanel previewTextPanel = new JPanel(new BorderLayout());
        previewTextPanel.add(pane);
        PLabel previewTitle = PLabel.createTitle(WidgetResources.getString("FontChooser.Preview_text"));
        previewPanel.add((Component)previewTitle, "North");
        this.updatePreview();
        previewPanel.add("Center", previewTextPanel);
        return previewPanel;
    }

    @Override
    public void setVisible(boolean b) {
        this.myFontListThread = new MyFontListFillerThread();
        this.myFontListThread.start();
        super.setVisible(b);
    }

    public void setPreviewText(String text) {
        this.myPreviewArea.setText(text);
    }

    public void setFontColorSelectionVisible(boolean aFlag) {
        this.myTextColorLabel.setVisible(aFlag);
        this.myTextColorBox.setVisible(aFlag);
    }

    protected void populateFontSizeList() {
        final Vector<String> fontSizes = new Vector<String>();
        int adder = 1;
        int i = this.myMinFontSize;
        while (i <= this.myMaxFontSize) {
            fontSizes.add(Integer.toString(i));
            if (i == 10) {
                adder = 2;
            } else if (i == 20) {
                adder = 4;
            } else if (i == 48) {
                adder = 6;
            } else if (i == 72) {
                adder = 8;
            } else if (i == 96) {
                adder = 12;
            }
            i += adder;
        }
        AbstractListModel model = new AbstractListModel(){

            @Override
            public int getSize() {
                return fontSizes.size();
            }

            @Override
            public Object getElementAt(int i) {
                return fontSizes.elementAt(i);
            }
        };
        this.mySizeList.setModel(model);
    }

    public void setMaxFontSize(int maxValue) {
        if (maxValue > this.myMinFontSize && maxValue > 0) {
            this.myMaxFontSize = maxValue;
            this.mySizeFieldRangeValidator.setMaxValue(maxValue);
            this.mySizeFieldDocument.setMaxValue(maxValue);
            this.populateFontSizeList();
        }
    }

    public void setMinFontSize(int minValue) {
        if (minValue < this.myMaxFontSize && minValue > 0) {
            this.myMinFontSize = minValue;
            this.mySizeFieldRangeValidator.setMinValue(this.myMinFontSize);
            this.mySizeFieldDocument.setMinValue(this.myMinFontSize);
            this.populateFontSizeList();
        }
    }

    public void ok() {
        this.isOKclicked = true;
        if (this.myFontListThread != null && this.myFontListThread.isAlive()) {
            this.myFontListThread.stop();
        }
        this.dispose();
    }

    public void cancel() {
        if (this.myFontListThread != null && this.myFontListThread.isAlive()) {
            this.myFontListThread.stop();
        }
        this.dispose();
    }

    public void setSelectedFont(Font font) {
        this.myDefaultFont = font;
    }

    public Font getSelectedFont() {
        int size;
        if (!this.isOKclicked) {
            return null;
        }
        try {
            size = Integer.parseInt(this.mySizeField.getText());
        }
        catch (Exception e) {
            size = 12;
        }
        int style = 0;
        if (this.myIsBold.isSelected()) {
            ++style;
        }
        if (this.myIsItalic.isSelected()) {
            style += 2;
        }
        return new Font((String)this.myFamilyList.getSelectedValue(), style, size);
    }

    public Color getSelectedFontColor() {
        if (!this.isOKclicked) {
            return null;
        }
        return this.myTextColorBox.getColor();
    }

    public void setSelectedFontColor(Color color) {
        this.myTextColorBox.setColor(color);
        this.myPreviewArea.setForeground(color);
    }

    protected void updatePreview() {
        int size;
        String family = (String)this.myFamilyList.getSelectedValue();
        try {
            size = Integer.parseInt(this.mySizeField.getText());
        }
        catch (Exception e) {
            size = 12;
        }
        int style = 0;
        if (this.myIsBold.isSelected()) {
            ++style;
        }
        if (this.myIsItalic.isSelected()) {
            style += 2;
        }
        Font font = new Font(family, style, size);
        this.myPreviewArea.setFont(font);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == FontChooser.this.myOkButton) {
                FontChooser.this.ok();
            } else if (evt.getSource() == FontChooser.this.myCancelButton) {
                FontChooser.this.cancel();
            }
        }
    }

    private class CheckActionHandler
    implements ActionListener {
        private CheckActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FontChooser.this.updatePreview();
        }
    }

    private class ClosingListener
    implements ActionListener {
        private ClosingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FontChooser.this.cancel();
        }
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            String size;
            Object source = evt.getSource();
            if (source == FontChooser.this.myFamilyList) {
                String family = (String)FontChooser.this.myFamilyList.getSelectedValue();
                if (family != null && !FontChooser.this.predictableTextInputInProcess) {
                    FontChooser.this.myFamilyField.setText(family);
                } else {
                    FontChooser.this.predictableTextInputInProcess = false;
                }
            } else if (source == FontChooser.this.mySizeList && (size = (String)FontChooser.this.mySizeList.getSelectedValue()) != null) {
                FontChooser.this.mySizeField.setText(size);
            }
            FontChooser.this.updatePreview();
        }
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            if (FontChooser.this.myFamilyList != null && FontChooser.this.myFamilyField != null && FontChooser.this.myFamilyList.getSelectedValue() != null) {
                FontChooser.this.myFamilyField.setText(FontChooser.this.myFamilyList.getSelectedValue().toString());
            }
        }
    }

    private class MyFontDocumentListener
    implements DocumentListener {
        private MyFontDocumentListener() {
        }

        @Override
        public void changedUpdate(final DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String str = e.getDocument().getText(0, e.getDocument().getLength());
                        str = str.toLowerCase();
                        ListModel model = FontChooser.this.myFamilyList.getModel();
                        int i = model.getSize();
                        int counter = 0;
                        while (i > counter) {
                            String s = (String)model.getElementAt(counter);
                            if ((s = s.toLowerCase()).startsWith(str)) {
                                FontChooser.this.predictableTextInputInProcess = true;
                                FontChooser.this.myFamilyList.setSelectedIndex(counter);
                                FontChooser.this.myFamilyList.ensureIndexIsVisible(counter);
                                FontChooser.this.updatePreview();
                                break;
                            }
                            ++counter;
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }

    private class MyFontListFillerThread
    extends Thread {
        private Vector<String> nameVector;

        private MyFontListFillerThread() {
            FontChooser.this.isFontListPopulatingInProcess = true;
        }

        @Override
        public void run() {
            try {
                Class<?> geClass = Class.forName("java.awt.GraphicsEnvironment");
                Method geMethod = geClass.getMethod("getLocalGraphicsEnvironment", null);
                Object geInstance = geMethod.invoke(null, null);
                Method namesMethod = geClass.getMethod("getAvailableFontFamilyNames", null);
                String[] nameArray = (String[])namesMethod.invoke(geInstance, null);
                this.nameVector = new Vector(nameArray.length);
                int i = 0;
                while (i < nameArray.length) {
                    this.nameVector.addElement(nameArray[i]);
                    Thread.yield();
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyFontListFillerThread.this.done();
                }
            });
        }

        protected void done() {
            FontChooser.this.myFamilyList.setListData(this.nameVector);
            FontChooser.this.myOkButton.setEnabled(true);
            FontChooser.this.myFamilyField.setText(FontChooser.this.myDefaultFont.getFamily());
            FontChooser.this.mySizeField.setText(String.valueOf(FontChooser.this.myDefaultFont.getSize()));
            FontChooser.this.isFontListPopulatingInProcess = false;
        }
    }

    private class MySizeDocumentListener
    implements DocumentListener {
        private MySizeDocumentListener() {
        }

        @Override
        public void changedUpdate(final DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String str = e.getDocument().getText(0, e.getDocument().getLength());
                        FontChooser.this.mySizeList.setSelectedValue(str, true);
                        FontChooser.this.updatePreview();
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }
}

