/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.util.GradientUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.TableRowFilter;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class Footer
extends PPanel
implements PropertyChangeListener {
    private JLabel myFilterLabel = new JLabel(CommonIcons.getFilterIcon());
    private PLabel myResultsCount = PLabel.createValueText();
    private PLabel myTotalCount = PLabel.createValueText();
    JLabel myResultsLabel = new JLabel(WidgetResources.getString("Footer.results"));
    JLabel myTotalLabel = new JLabel(WidgetResources.getString("Footer.total"));
    JTable myTable = null;
    private TableModelListener myTableModelHandler;

    public Footer(JTable table) {
        this();
        this.myTable = table;
        this.myFilterLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        this.myResultsCount.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.append(this.myFilterLabel, this.myResultsLabel, this.myResultsCount, this.myTotalLabel, this.myTotalCount);
        this.updateFooterTexts(table.getModel());
        this.myTableModelHandler = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Footer.this.updateFooterTexts((TableModel)e.getSource());
            }
        };
        this.myTable.addPropertyChangeListener(this);
        table.getModel().addTableModelListener(this.myTableModelHandler);
    }

    public Footer() {
        this.setLayout(new PHorizontalLayout(2, 2, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 8, 1, 4));
    }

    @Override
    protected void paintComponent(Graphics g) {
        GradientUtils.drawVerticalGradient((JComponent)this, g, "Footer.gradient", 0, 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(UIManager.getColor("Footer.topOutline"));
        g.drawLine(0, 0, this.getWidth(), 0);
    }

    private void updateFooterTexts(TableModel model) {
        if (model instanceof PSortableTableModel) {
            PSortableTableModel sortModel = (PSortableTableModel)model;
            this.myTotalCount.setText(String.valueOf(sortModel.getWrappedModel().getRowCount()));
            TableRowFilter rowFilter = sortModel.getRowFilter();
            if (rowFilter != null) {
                this.myResultsCount.setText(String.valueOf(sortModel.getRowCount()));
            }
            this.myFilterLabel.setVisible(rowFilter != null);
            boolean filterActive = rowFilter != null && rowFilter.isActive();
            this.myResultsLabel.setVisible(filterActive);
            this.myResultsCount.setVisible(filterActive);
            this.myFilterLabel.setEnabled(filterActive);
        } else {
            this.myTotalCount.setText(String.valueOf(model.getRowCount()));
            this.myResultsLabel.setVisible(false);
            this.myResultsCount.setVisible(false);
            this.myFilterLabel.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            TableModel newModel = (TableModel)evt.getNewValue();
            TableModel oldModel = (TableModel)evt.getOldValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(this.myTableModelHandler);
            }
            if (newModel != null) {
                newModel.addTableModelListener(this.myTableModelHandler);
                this.updateFooterTexts(newModel);
            }
        }
    }
}

