/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.widgets.icons.PEmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.AbstractBorder;

public class IconBorder
extends AbstractBorder {
    private transient Icon myIcon = PEmptyIcon.ICON_16;
    private int myIconPadding = 0;
    private Insets myMargin = new Insets(0, 0, 0, 0);
    private int myIconHorizontalAlignment = 2;
    private int myIconVerticalAlignment = 0;

    public IconBorder() {
    }

    public IconBorder(int top, int bottom, int left, int right) {
        this.myMargin.top = top;
        this.myMargin.bottom = bottom;
        this.myMargin.left = left;
        this.myMargin.right = right;
    }

    public IconBorder(int top, int bottom, int left, int right, int padding) {
        this(top, bottom, left, right);
        this.myIconPadding = padding;
    }

    public IconBorder(Icon icon) {
        this.myIcon = icon;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void setMargin(Insets margin) {
        this.myMargin = margin;
    }

    public Insets getMargin() {
        return new Insets(this.myMargin.top, this.myMargin.left, this.myMargin.bottom, this.myMargin.right);
    }

    public void setIconVerticalAlignment(int iconVerticalAlignment) {
        this.myIconVerticalAlignment = iconVerticalAlignment;
    }

    public void setIconHorizontalAlignment(int iconHorizontalAlignment) {
        this.myIconHorizontalAlignment = iconHorizontalAlignment;
    }

    public void setIconPadding(int iconPadding) {
        this.myIconPadding = iconPadding;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.top = 0;
        int iconWidth = this.myIcon.getIconWidth();
        int iconHeight = this.myIcon.getIconHeight();
        switch (this.myIconHorizontalAlignment) {
            case 2: {
                insets.left = iconWidth + this.myIconPadding;
                break;
            }
            case 4: {
                insets.right = iconWidth + this.myIconPadding;
                break;
            }
        }
        switch (this.myIconVerticalAlignment) {
            case 3: {
                insets.bottom = iconHeight + this.myIconPadding;
                break;
            }
            case 1: {
                insets.top = iconHeight + this.myIconPadding;
                break;
            }
        }
        insets.top += this.myMargin.top;
        insets.bottom += this.myMargin.bottom;
        insets.left += this.myMargin.left;
        insets.right += this.myMargin.right;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int iconX = 0;
        int iconY = 0;
        switch (this.myIconHorizontalAlignment) {
            case 2: {
                iconX = x + this.myMargin.left;
                break;
            }
            case 4: {
                iconX = x + width - this.myIcon.getIconWidth() - this.myMargin.right;
                break;
            }
            case 0: {
                iconX = x + (width - this.myIcon.getIconWidth()) / 2;
                break;
            }
        }
        switch (this.myIconVerticalAlignment) {
            case 3: {
                iconY = y + height - this.myIcon.getIconHeight() - this.myMargin.bottom;
                break;
            }
            case 1: {
                iconY = y + this.myMargin.top;
                break;
            }
            case 0: {
                iconY = y + (height - this.myIcon.getIconHeight()) / 2;
                break;
            }
        }
        this.myIcon.paintIcon(c, g, iconX, iconY);
    }
}

