/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.toolbar.OverflowButton;
import com.nokia.widgets.layout.DelegateLayoutManager;
import com.nokia.widgets.layout.DelegateLayoutManager2;
import com.nokia.widgets.layout.LayoutManagerAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class OverflowToolBar
extends JComponent
implements Accessible {
    private JComponent myToolBar;
    protected OverflowButton myOverflowButton;
    private int myPreviousWidth = -1;

    public OverflowToolBar(JComponent toolBar) {
        this.myToolBar = toolBar;
        this.myToolBar.putClientProperty("OrangeTouch.toolbarOverflowEnabled", Boolean.TRUE);
        this.myToolBar.setLayout(this.createToolBarLayout(this.myToolBar));
        this.myOverflowButton = new OverflowButton(this.myToolBar);
        this.setLayout(new OverflowToolBarLayout());
        this.add(this.myToolBar);
        this.add(this.myOverflowButton);
    }

    protected LayoutManager createToolBarLayout(JComponent toolBar) {
        LayoutManager originalLayout = this.myToolBar.getLayout();
        if (originalLayout instanceof LayoutManager2) {
            return new ToolBarLayoutDelegate2((LayoutManager2)originalLayout);
        }
        return new ToolBarLayoutDelegate(originalLayout);
    }

    public JToolBar getToolBar() {
        return this.myToolBar instanceof JToolBar ? (JToolBar)this.myToolBar : null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleOverflowToolBar();
        }
        return this.accessibleContext;
    }

    private void setComponentVisibility(Container toolBar, boolean setButtonVisibility) {
        Insets toolBarInsets = toolBar.getInsets();
        int visibleWidth = toolBar.getWidth() - toolBarInsets.right;
        Component[] comps = toolBar.getComponents();
        boolean hasOverflow = false;
        int idx = comps.length - 1;
        while (idx >= 0) {
            Component comp = comps[idx];
            if (comp.isVisible() && comp.getX() + comp.getWidth() > visibleWidth) {
                hasOverflow = true;
                if (comp.getX() < visibleWidth) {
                    comp.setBounds(-100, -100, 0, 0);
                }
            }
            --idx;
        }
        if (setButtonVisibility) {
            this.myOverflowButton.setVisible(hasOverflow);
        }
    }

    protected class AccessibleOverflowToolBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleOverflowToolBar() {
            super(OverflowToolBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }
    }

    private class OverflowToolBarLayout
    extends LayoutManagerAdapter {
        private OverflowToolBarLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension buttonPrefSize = OverflowToolBar.this.myOverflowButton.getPreferredSize();
            int width = parent.getWidth() - insets.left - insets.right;
            int height = parent.getHeight();
            OverflowToolBar.this.myOverflowButton.setSize((int)buttonPrefSize.getWidth(), height);
            OverflowToolBar.this.myOverflowButton.setLocation(parent.getWidth() - insets.right - OverflowToolBar.this.myOverflowButton.getWidth(), parent.getHeight() - insets.bottom - OverflowToolBar.this.myOverflowButton.getHeight());
            OverflowToolBar.this.myToolBar.setLocation(insets.left, insets.top);
            OverflowToolBar.this.myToolBar.setSize(width - OverflowToolBar.this.myOverflowButton.getWidth(), ((OverflowToolBar)OverflowToolBar.this).myToolBar.getPreferredSize().height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension result = new Dimension();
            Insets insets = parent.getInsets();
            result.height = Math.max(((OverflowToolBar)OverflowToolBar.this).myToolBar.getPreferredSize().height, OverflowToolBar.this.myOverflowButton.getPreferredSize().height);
            result.height += insets.top + insets.bottom;
            result.width = ((OverflowToolBar)OverflowToolBar.this).myToolBar.getPreferredSize().width + OverflowToolBar.this.myOverflowButton.getPreferredSize().width;
            result.width += insets.left + insets.right;
            return result;
        }
    }

    protected class ToolBarLayoutDelegate
    extends DelegateLayoutManager {
        public ToolBarLayoutDelegate(LayoutManager layout) {
            super(layout);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            super.removeLayoutComponent(comp);
            OverflowToolBar.this.myOverflowButton.hidePopup();
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean widthChanged;
            boolean bl = widthChanged = OverflowToolBar.this.myPreviousWidth != OverflowToolBar.this.getWidth();
            if (widthChanged) {
                OverflowToolBar.this.myOverflowButton.resetOverflow(parent);
            }
            super.layoutContainer(parent);
            OverflowToolBar.this.setComponentVisibility(parent, widthChanged);
            OverflowToolBar.this.myPreviousWidth = OverflowToolBar.this.getWidth();
        }
    }

    protected class ToolBarLayoutDelegate2
    extends DelegateLayoutManager2 {
        public ToolBarLayoutDelegate2(LayoutManager2 layout) {
            super(layout);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            super.removeLayoutComponent(comp);
            OverflowToolBar.this.myOverflowButton.hidePopup();
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean widthChanged;
            boolean bl = widthChanged = OverflowToolBar.this.myPreviousWidth != OverflowToolBar.this.getWidth();
            if (widthChanged) {
                OverflowToolBar.this.myOverflowButton.resetOverflow(parent);
            }
            super.layoutContainer(parent);
            OverflowToolBar.this.setComponentVisibility(parent, widthChanged);
            OverflowToolBar.this.myPreviousWidth = OverflowToolBar.this.getWidth();
        }
    }
}

