/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class PBorderFactory {
    private static Map theBasicNetBorders = new HashMap();
    private static Border theButtonBarBorder;
    private static Border theFocusBorder;
    private static Border theDashedUnderlineBorder;

    private PBorderFactory() {
    }

    public static Border getBlueBorder() {
        return PBorderFactory.getBasicNetBorder(NetTheme.getComponentOutlineColor());
    }

    public static Border getFocusBorder() {
        if (theFocusBorder == null) {
            theFocusBorder = new FocusBorder();
        }
        return theFocusBorder;
    }

    public static Border getBasicNetBorder(Color color) {
        if (!theBasicNetBorders.containsKey(color)) {
            theBasicNetBorders.put(color, new BasicNetBorder(color));
        }
        return (Border)theBasicNetBorders.get(color);
    }

    public static Border getButtonBarBorder() {
        if (theButtonBarBorder == null) {
            theButtonBarBorder = new ButtonBarBorder();
        }
        return theButtonBarBorder;
    }

    public static Border getDashedUnderlineBorder() {
        if (theDashedUnderlineBorder == null) {
            theDashedUnderlineBorder = new DashedUnderlineBorder();
        }
        return theDashedUnderlineBorder;
    }

    public static Border getTitledBorder(String title) {
        return PBorderFactory.getTitledBorder(title, false);
    }

    public static Border getTitledBorder(String title, boolean useGroupIndentation) {
        return new CompoundBorder(new TitledBorder(null, title, 4, 3), new EmptyBorder(1, useGroupIndentation ? 15 : 3, 0, 2));
    }

    private static class BasicNetBorder
    extends EmptyBorder {
        private Color myColor;

        public BasicNetBorder(Color color) {
            super(1, 1, 1, 1);
            this.myColor = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean enabled = c.isEnabled();
            Color color = enabled ? this.myColor : UIManager.getColor("secondaryShadow");
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color oldColor = g.getColor();
            g.setColor(color);
            RectangularShape rect = NetUtils.getOutline((JComponent)c);
            rect.setFrame(x, y, width - 1, height - 1);
            ((Graphics2D)g).draw(rect);
            g.setColor(oldColor);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private static class ButtonBarBorder
    extends EmptyBorder {
        public ButtonBarBorder() {
            super(new Insets(3, 0, 0, 0));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int offset = 18;
            g.translate(x, y);
            Color oldColor = g.getColor();
            g.setColor(UIManager.getColor("Panel.borderFullShadow"));
            g.drawLine(offset, 0, width - 1 - offset, 0);
            g.setColor(UIManager.getColor("Panel.borderShadow"));
            g.drawLine(offset, 1, width - 1 - offset, 1);
            g.setColor(new Color(240, 240, 240));
            g.drawLine(offset, 2, width - 1 - offset, 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private static class DashedUnderlineBorder
    extends EmptyBorder {
        public DashedUnderlineBorder() {
            super(1, 1, 1, 1);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            NetUtils.drawDash(g, x, y + height, width, 0);
        }
    }

    private static class FocusBorder
    extends EmptyBorder {
        public FocusBorder() {
            super(1, 1, 1, 1);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(NetLookAndFeel.getCurrentTheme().getFocusColor());
            g.drawRect(x, y, width - 1, height - 1);
        }
    }
}

