/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class PButtonPane
extends PPanel {
    public PButtonPane() {
        this(null, null, null);
    }

    public PButtonPane(AbstractButton[] leftButtons, AbstractButton[] centerButtons, AbstractButton[] rightButtons) {
        RowAlignLayout layout = new RowAlignLayout();
        this.setLayout(layout);
        if (ComponentUtils.isSmall(this)) {
            layout.setVMargin(11);
        }
        this.initButtonArea(leftButtons, "West");
        this.initButtonArea(centerButtons, "Center");
        this.initButtonArea(rightButtons, "East");
        this.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        this.setVisibleUpperEdge(true);
        this.setVisibleLeadingEdge(false);
        this.setVisibleTrailingEdge(false);
        this.setVisibleLowerEdge(false);
    }

    private void initButtonArea(AbstractButton[] buttons, String orientation) {
        if (buttons == null || buttons.length < 1) {
            return;
        }
        int i = 0;
        while (i < buttons.length) {
            this.add((Component)buttons[i], orientation);
            ++i;
        }
    }

    public AbstractButton getButtonAt(int index) {
        int j = 0;
        int i = 0;
        while (i < this.getComponents().length) {
            Component c = this.getComponent(i);
            if (c instanceof AbstractButton) {
                if (j == index) {
                    return (AbstractButton)c;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public AbstractButton getButtonByText(String text) {
        return this.getButtonByProperty("getText", text);
    }

    public AbstractButton getButtonByCommand(String command) {
        return this.getButtonByProperty("getActionCommand", command);
    }

    public AbstractButton getButtonByIcon(Icon icon) {
        return this.getButtonByProperty("getIcon", icon);
    }

    private AbstractButton getButtonByProperty(String getMethod, Object criteria) {
        int i = 0;
        while (i < this.getComponents().length) {
            try {
                AbstractButton button;
                Method getter;
                Object value;
                if (this.getComponents()[i] instanceof AbstractButton && criteria.equals(value = (getter = (button = (AbstractButton)this.getComponents()[i]).getClass().getMethod(getMethod, null)).invoke((Object)button, null))) {
                    return button;
                }
            }
            catch (Exception e) {
                return null;
            }
            ++i;
        }
        return null;
    }
}

