/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.NetComboBoxUI;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class PComboBox
extends JComboBox
implements PropertyChangeListener {
    protected static final String PROPERTY_EDITOR = "editor";
    protected static final String PROPERTY_EMPTY_ITEM = "emptyItem";
    protected UpdateHandler myUpdateHandler = new UpdateHandler();
    private Object myEmptyItem = "";

    public PComboBox(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.init();
    }

    public PComboBox(ComboBoxModel model) {
        super(model);
        this.init();
    }

    public PComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public PComboBox(Vector<?> items) {
        super(items);
        this.init();
    }

    public PComboBox() {
        this.init();
    }

    public PComboBox(ComboBoxModel model, Object emptyItem) {
        super(model);
        this.myEmptyItem = emptyItem;
        this.init();
    }

    public PComboBox(Object[] items, Object emptyItem) {
        super(items);
        this.myEmptyItem = emptyItem;
        this.init();
    }

    public PComboBox(Vector<?> items, Object emptyItem) {
        super(items);
        this.myEmptyItem = emptyItem;
        this.init();
    }

    public PComboBox(Object emptyItem) {
        this.myEmptyItem = emptyItem;
        this.init();
    }

    public void setSearchFieldVisibleInPopup() {
        if (!((NetComboBoxUI)this.getUI()).getComboPopup().isSearchSupported()) {
            ((NetComboBoxUI)this.getUI()).getComboPopup().setSearchField();
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    protected void init() {
        this.addItemListener(this.myUpdateHandler);
        this.addEditListener(this.getEditor());
        this.addPropertyChangeListener("mandatoryEntry", this);
        this.addPropertyChangeListener("model", this);
        this.addPropertyChangeListener(PROPERTY_EDITOR, this);
        this.addPropertyChangeListener(PROPERTY_EMPTY_ITEM, this);
        this.addPropertyChangeListener("BlueTouch.unmodifiedValue", this);
        this.addPropertyChangeListener("requiredButMissing", this);
    }

    public Component getEditorComponent() {
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor != null) {
            return comboBoxEditor.getEditorComponent();
        }
        return null;
    }

    public void setMandatoryEntry(boolean mandatory) {
        this.putClientProperty("mandatoryEntry", mandatory);
    }

    public boolean isMandatoryEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("mandatoryEntry"));
    }

    public boolean isRequiredButMissing() {
        return Boolean.TRUE.equals(this.getClientProperty("requiredButMissing"));
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.putClientProperty("BlueTouch.unmodifiedValue", unmodifiedValue);
    }

    public Object getUnmodifiedValue() {
        return this.getClientProperty("BlueTouch.unmodifiedValue");
    }

    public boolean isModified() {
        return Boolean.TRUE.equals(this.getClientProperty("BlueTouch.isModified"));
    }

    public void setValueComparator(Comparator<?> comparator) {
        this.putClientProperty(ClientProperties.VALUE_COMPARATOR, comparator);
    }

    public int getHorizontalAlignment() {
        return ClientPropertyUtil.integerValue(this, "Combobox.horizontalAlignment");
    }

    public void setHorizontalAlignment(int alignment) {
        this.putClientProperty("Combobox.horizontalAlignment", this.checkHorizontalKey(alignment));
    }

    protected int checkHorizontalKey(int key) {
        if (key == 2 || key == 0 || key == 4 || key == 10 || key == 11) {
            return key;
        }
        throw new IllegalArgumentException("PComboBox.horizontalAlignment");
    }

    public void setPopupWidth(int width) {
        this.putClientProperty("BlueTouch.ComboBox.popupWidth", width);
    }

    public int getPopupWidth() {
        return ClientPropertyUtil.integerValue(this, "BlueTouch.ComboBox.popupWidth");
    }

    public void setPackPopupWidth(boolean packPopupWidth) {
        this.putClientProperty("OrangeTouch.ComboBox.packPopupWidth", packPopupWidth ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent editorAsJComponent;
        String propertyName = evt.getPropertyName();
        JComponent jComponent = editorAsJComponent = this.getEditorComponent() instanceof JComponent ? (JComponent)this.getEditorComponent() : null;
        if (PROPERTY_EDITOR.equals(propertyName)) {
            ComboBoxEditor newEditor = (ComboBoxEditor)evt.getNewValue();
            ComboBoxEditor oldEditor = (ComboBoxEditor)evt.getOldValue();
            this.removeEditListener(oldEditor);
            this.addEditListener(newEditor);
            if (editorAsJComponent != null) {
                editorAsJComponent.putClientProperty("mandatoryEntry", this.isMandatoryEntry());
                editorAsJComponent.putClientProperty("BlueTouch.unmodifiedValue", this.getClientProperty("BlueTouch.unmodifiedValue"));
            }
        } else if ("mandatoryEntry".equals(propertyName)) {
            Object newValue = evt.getNewValue();
            this.putClientProperty("requiredButMissing", Boolean.TRUE.equals(newValue) && this.isMissing());
            if (editorAsJComponent != null) {
                editorAsJComponent.putClientProperty("mandatoryEntry", evt.getNewValue());
            }
        } else if ("BlueTouch.unmodifiedValue".equals(propertyName)) {
            if (editorAsJComponent != null) {
                editorAsJComponent.putClientProperty("BlueTouch.unmodifiedValue", evt.getNewValue());
            }
        } else if (PROPERTY_EMPTY_ITEM.equals(propertyName)) {
            this.updateIsRequiredAndMissingProperty();
        } else if ("model".equals(propertyName)) {
            this.updateIsRequiredAndMissingProperty();
        }
    }

    private void addEditListener(ComboBoxEditor newEditor) {
        if (newEditor == null) {
            return;
        }
        Component editorComponent = newEditor.getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().addDocumentListener(this.myUpdateHandler);
        }
        newEditor.addActionListener(this.myUpdateHandler);
    }

    private void removeEditListener(ComboBoxEditor oldEditor) {
        if (oldEditor == null) {
            return;
        }
        Component editorComponent = oldEditor.getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().removeDocumentListener(this.myUpdateHandler);
        }
        oldEditor.removeActionListener(this.myUpdateHandler);
    }

    public void setEmptyItem(Object emptyItem) {
        Object oldValue = this.myEmptyItem;
        this.myEmptyItem = emptyItem;
        this.firePropertyChange(PROPERTY_EMPTY_ITEM, oldValue, this.myEmptyItem);
    }

    public Object getEmptyItem() {
        return this.myEmptyItem;
    }

    public void setSizeVariant(String sizeVariant) {
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
    }

    public String getSizeVariant() {
        if (!ClientPropertyUtil.hasProperty(this, "JComponent.sizeVariant")) {
            return "normal";
        }
        return this.getClientProperty("JComponent.sizeVariant").toString();
    }

    protected boolean isMissing() {
        if (this.isEditable()) {
            return this.myEmptyItem.equals(this.getEditor().getItem());
        }
        boolean emptyItemSelected = false;
        if (this.myEmptyItem != null) {
            emptyItemSelected = this.myEmptyItem.equals(this.getSelectedItem());
        }
        return emptyItemSelected || this.getSelectedIndex() == -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object newItem = this.getEditor().getItem();
        this.setPopupVisible(false);
        this.getModel().setSelectedItem(newItem);
        String oldCommand = this.getActionCommand();
        this.setActionCommand("comboBoxEdited");
        this.fireActionEvent();
        this.setActionCommand(oldCommand);
    }

    public void updateIsRequiredAndMissingProperty() {
        this.putClientProperty("requiredButMissing", this.isMandatoryEntry() && this.isMissing());
    }

    public String getSegmentPosition() {
        return (String)this.getClientProperty("JToggleButton.segmentPosition");
    }

    public void setSegmentPosition(String segmentPosition) {
        this.putClientProperty("JToggleButton.segmentPosition", segmentPosition);
    }

    private class UpdateHandler
    implements ItemListener,
    ActionListener,
    DocumentListener {
        private UpdateHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int stateChange = itemEvent.getStateChange();
            if (stateChange == 1 || PComboBox.this.getSelectedItem() == null && stateChange == 2) {
                PComboBox.this.updateIsRequiredAndMissingProperty();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PComboBox.this.updateIsRequiredAndMissingProperty();
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            PComboBox.this.updateIsRequiredAndMissingProperty();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }
    }
}

