/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.OverflowToolBar;
import com.nokia.widgets.ProductBannerDescription;
import com.nokia.widgets.util.SystemUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PMenuBar
extends JMenuBar {
    public static final Color[] BACKGROUND_GRADIENT = new Color[]{new Color(242, 242, 242), NetLookAndFeel.getWhite()};
    private static final Color INNER_OUTLINE = UIManager.getColor("ProductBanner.innerOutline");
    private static final Color OUTER_OUTLINE = UIManager.getColor("ProductBanner.outerOutline");
    private static final Color[] LIGHT_GRADIENT = (Color[])UIManager.get("ProductBanner.lightGradient");
    private static final Color[] DARK_GRADIENT = (Color[])UIManager.get("ProductBanner.darkGradient");
    private static final Color[] SHADOW = new Color[]{new Color(100, 100, 100, 48), new Color(100, 100, 100, 24), new Color(100, 100, 100, 12), new Color(100, 100, 100, 5)};
    private JLabel myLogoLabel = new JLabel();
    private JToolBar myToolBar;
    private boolean myToolBarOverflowEnabled = false;
    private static final int OVERFLOW_BUTTON_WIDTH = 24;
    private String myApplicationName = null;
    private Component myOptionalBannerComponent;
    private ProductBannerLayout myLayout = new ProductBannerLayout();

    public PMenuBar(Icon logoIcon, JToolBar toolBar) {
        this.setLayout(this.myLayout);
        this.setBackground(Color.WHITE);
        this.add(this.myLogoLabel);
        this.setLogoIcon(logoIcon);
        this.myLogoLabel.setOpaque(false);
        this.myToolBar = toolBar;
        this.add(toolBar);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PMenuBar.this.revalidate();
            }
        });
    }

    public PMenuBar(JToolBar toolBar) {
        this(PMenuBar.getNokiaLogo(), toolBar);
    }

    public PMenuBar() {
        this(PMenuBar.getNokiaLogo(), new JToolBar());
        this.setToolBarOverflowEnabled(true);
    }

    public void setApplicationName(String name) {
        this.myApplicationName = name;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        PMenuBar.paintBannerElements(g, this, this.myToolBar, this.myLogoLabel, this.myApplicationName);
    }

    public static void paintBannerElements(Graphics gr, JComponent menuBar, JToolBar toolBar, JComponent logoLabel, String applicationName) {
        int darkWaveMaxWidth;
        int toolbarWidth;
        int toolbarAreaWidth;
        int appNameEndLocation;
        int darkWaveWidth;
        boolean isToolbarPrefSizeSet;
        boolean isToolbarEmpty = toolBar == null || toolBar.getComponentCount() == 0;
        boolean bl = isToolbarPrefSizeSet = toolBar != null && toolBar.isPreferredSizeSet();
        if (isToolbarEmpty && !isToolbarPrefSizeSet) {
            return;
        }
        Object oldAa = NetUtils.antiAliasingOn(gr);
        int width = menuBar.getWidth();
        int height = menuBar.getHeight();
        GradientUtils.drawVerticalGradient(menuBar, gr, BACKGROUND_GRADIENT, 0, 0, width, height - toolBar.getHeight() - 9);
        int toolBarHeightWithOffset = toolBar.getHeight() + 3;
        int logoLabelWidth = logoLabel.getWidth();
        int darkWaveWidthOffset = 90;
        if (SystemUtils.isOrangeTouch()) {
            darkWaveWidthOffset = 210;
            GeneralPath outline = NetUtils.createCurvedOutline(gr, menuBar, width - 90 - logoLabelWidth, toolBarHeightWithOffset);
            GradientUtils.drawVerticalGradient(menuBar, gr, LIGHT_GRADIENT, (Shape)outline);
            PMenuBar.paintOuterShadow((Graphics2D)gr, outline);
        }
        if ((darkWaveWidth = Math.max(appNameEndLocation = (toolbarAreaWidth = Math.max(toolbarWidth = PMenuBar.getToolBarWidth(menuBar, toolBar), width / 3 + 30)) + 56 + PMenuBar.getAppNameWidth(gr, applicationName) + 12, width - darkWaveWidthOffset - logoLabelWidth)) > (darkWaveMaxWidth = width - logoLabelWidth - 59)) {
            darkWaveWidth = darkWaveMaxWidth;
        }
        GeneralPath darkWaveOutline = NetUtils.createCurvedOutline(gr, menuBar, darkWaveWidth, toolBarHeightWithOffset);
        GradientUtils.drawVerticalGradient(menuBar, gr, DARK_GRADIENT, (Shape)darkWaveOutline);
        boolean superCondensed = PMenuBar.paintApplicationName(gr, menuBar, toolBar, logoLabelWidth, toolbarAreaWidth, darkWaveOutline, applicationName);
        Shape toolBarOutline = PMenuBar.createToolBarBackgroundOutline(gr, menuBar, toolBar, toolBarHeightWithOffset, toolbarAreaWidth, darkWaveWidth, superCondensed);
        PMenuBar.paintToolBarBackground(gr, toolBar, toolBarOutline);
        PMenuBar.paintShadowAroundToolBar(gr, height, toolBarOutline);
        NetUtils.setAntialiasing(gr, oldAa);
    }

    private static void paintOuterShadow(Graphics2D gr, Shape outline) {
        gr.setColor(OUTER_OUTLINE);
        gr.draw(outline);
        gr.translate(-1, 1);
        gr.setColor(INNER_OUTLINE);
        gr.draw(outline);
        gr.translate(1, -1);
    }

    private static Shape paintToolBarBackground(Graphics gr, JToolBar toolBar, Shape outline) {
        gr.setColor(toolBar.getBackground());
        ((Graphics2D)gr).fill(outline);
        return outline;
    }

    private static Shape createToolBarBackgroundOutline(Graphics gr, JComponent menuBar, JToolBar toolBar, int toolBarHeightWithOffset, int toolbarAreaWidth, int darkWaveWidth, boolean superCondensed) {
        int toolbarBakgroundLocation = Math.min(menuBar.getWidth() / 3, darkWaveWidth);
        toolbarBakgroundLocation = Math.max(toolbarBakgroundLocation, toolbarAreaWidth) - 20;
        if (superCondensed) {
            toolbarBakgroundLocation = PMenuBar.getToolBarWidth(menuBar, toolBar) - 33;
        }
        return NetUtils.createCurvedOutline(gr, menuBar, toolbarBakgroundLocation, toolBarHeightWithOffset);
    }

    private static void paintShadowAroundToolBar(Graphics gr, int height, Shape outline) {
        Shape oldClip = gr.getClip();
        gr.clipRect(0, 0, (int)outline.getBounds().getWidth(), height);
        gr.setColor(SHADOW[0]);
        gr.translate(-1, 0);
        ((Graphics2D)gr).draw(outline);
        gr.setColor(SHADOW[1]);
        gr.translate(-1, 1);
        ((Graphics2D)gr).draw(outline);
        gr.setColor(SHADOW[2]);
        gr.translate(-1, 1);
        ((Graphics2D)gr).draw(outline);
        gr.setColor(SHADOW[3]);
        gr.translate(-1, 1);
        ((Graphics2D)gr).draw(outline);
        gr.translate(4, -3);
        gr.setClip(oldClip);
    }

    private static boolean paintApplicationName(Graphics g, JComponent comp, JToolBar toolBar, int logoLabelWidth, int toolbarAreaWidth, Shape clipShape, String applicationName) {
        if (applicationName != null) {
            boolean superCondensed;
            g.setFont(g.getFont().deriveFont(16.0f));
            g.setColor(NetLookAndFeel.getBlack());
            int nameLocation = toolbarAreaWidth + 48;
            boolean bl = superCondensed = nameLocation + PMenuBar.getAppNameWidth(g, applicationName) > comp.getWidth() - logoLabelWidth - 22;
            if (superCondensed) {
                nameLocation = Math.min(nameLocation, PMenuBar.getToolBarWidth(comp, toolBar) + 21);
            }
            int yOffset = superCondensed ? 3 : 0;
            String clipped = NetUtils.getClippedText(applicationName, g.getFontMetrics(), comp.getWidth() - nameLocation);
            g.drawString(clipped, nameLocation, comp.getHeight() - 10 + yOffset);
            g.setColor(NetLookAndFeel.getWhite());
            Shape oldClip = g.getClip();
            g.setClip(clipShape);
            g.drawString(clipped, nameLocation, comp.getHeight() - 11 + yOffset);
            g.setClip(oldClip);
            return superCondensed;
        }
        return false;
    }

    private static int getToolBarWidth(JComponent menuBar, JToolBar toolBar) {
        if (menuBar.getClientProperty("OceanTouch.productBannerDescription") != null) {
            return toolBar.getPreferredSize().width;
        }
        return toolBar.getParent() instanceof OverflowToolBar ? toolBar.getParent().getWidth() : toolBar.getWidth();
    }

    private static int getAppNameWidth(Graphics g, String applicationName) {
        return SwingUtilities.computeStringWidth(g.getFontMetrics(g.getFont()), applicationName);
    }

    public void setToolBarOverflowEnabled(boolean enabled) {
        if (enabled != this.myToolBarOverflowEnabled) {
            this.myToolBarOverflowEnabled = enabled;
            if (this.myToolBarOverflowEnabled) {
                this.remove(this.myToolBar);
                this.add(new OverflowToolBar(this.myToolBar));
            } else if (this.myToolBar.getParent() != this) {
                this.remove(this.myToolBar.getParent());
                this.add(this.myToolBar);
            }
            this.myLayout.setToolBarOverflowEnabled(enabled);
            this.revalidate();
            this.repaint();
        }
    }

    public void setToolBarWrappingEnabled(boolean enabled) {
        this.myToolBar.putClientProperty("OrangeTouch.toolbarWrappingEnabled", enabled);
    }

    public JLabel getLogoLabel() {
        return this.myLogoLabel;
    }

    public JToolBar getToolBar() {
        return this.myToolBar;
    }

    public void setToolBar(JToolBar toolBar) {
        if (this.myToolBar == toolBar) {
            return;
        }
        JToolBar oldToolBar = this.myToolBar;
        this.myToolBar = toolBar;
        if (this.myToolBarOverflowEnabled) {
            this.remove(oldToolBar.getParent());
            this.add(new OverflowToolBar(toolBar));
        } else {
            this.remove(oldToolBar);
            this.add(toolBar);
        }
        this.revalidate();
        this.repaint();
    }

    public void setOptionalBannerComponent(Component comp) {
        if (this.myOptionalBannerComponent == comp) {
            return;
        }
        Component oldComponent = this.myOptionalBannerComponent;
        if (oldComponent != null) {
            this.remove(oldComponent);
        }
        if (comp == null) {
            this.remove(this.myOptionalBannerComponent);
        } else {
            this.add(comp);
        }
        this.myOptionalBannerComponent = comp;
        this.myLayout.setOptionalBannerComponent(this.myOptionalBannerComponent);
        this.revalidate();
        this.repaint();
    }

    public Component getOptionalBannnerComponent() {
        return this.myOptionalBannerComponent;
    }

    @Override
    public int getMenuCount() {
        return super.getMenuCount() - 2;
    }

    @Override
    public JMenu getMenu(int index) {
        return super.getMenu(index + 2);
    }

    public void setApplicationIcon(Icon icon) {
    }

    protected static Icon getNokiaLogo() {
        return WidgetResources.getImageIcon("CompanyLogoProductBanner_Icon");
    }

    public void setLogoIcon(Icon logoIcon) {
        this.myLogoLabel.setIcon(logoIcon);
        this.myLogoLabel.setDisabledIcon(logoIcon);
    }

    public Icon getLogoIcon() {
        return this.myLogoLabel.getIcon();
    }

    public static class ProductBannerLayout
    implements LayoutManager {
        private final int TOP_OFFSET = UIManager.getInt("ProductBanner.topOffset");
        private final int LOGO_TRAILING_OFFSET = UIManager.getInt("ProductBanner.trailingOffset");
        private static final int OPTIONAL_BANNER_COMPONENT_TRAILING_OFFSET = 18;
        public static final int MENU_OFFSET = 1;
        public static final int TOOLBAR_OFFSET = 4;
        private boolean myToolBarOverflowEnabled = false;
        private Component myOptionalBannerComponent = null;

        public void setToolBarOverflowEnabled(boolean toolBarOverflowEnabled) {
            this.myToolBarOverflowEnabled = toolBarOverflowEnabled;
        }

        public void setOptionalBannerComponent(Component optionalBannerComponent) {
            this.myOptionalBannerComponent = optionalBannerComponent;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            JMenuBar menuBar = (JMenuBar)target;
            int numComponents = target.getComponentCount();
            Insets insets = target.getInsets();
            int leadingOffset = 0;
            int trailingOffset = this.LOGO_TRAILING_OFFSET;
            JToolBar toolBar = this.getToolBar(menuBar);
            int totalMenuWidth = 0;
            int maxMenuHeight = 0;
            JRootPane rootPane = SwingUtilities.getRootPane(target);
            int menuBarWidth = 0;
            if (rootPane != null) {
                Insets rootPaneInsets = rootPane.getInsets();
                menuBarWidth = rootPane.getWidth() - rootPaneInsets.left - rootPaneInsets.right;
            }
            int appIconWidth = 0;
            JLabel logoLabel = this.getLogoLabel(menuBar);
            int startMenuX = insets.left + appIconWidth + 1;
            int maxMenuX = menuBarWidth - insets.right - trailingOffset - logoLabel.getPreferredSize().width - 6;
            int maxWidthForMenus = maxMenuX - startMenuX;
            int rowCount = 1;
            int rowWidth = 0;
            int preferredWidth = insets.left + insets.right + leadingOffset;
            int i = 0;
            while (i < numComponents) {
                Component comp = target.getComponent(i);
                Dimension compPrefSize = comp.getPreferredSize();
                if (comp instanceof JMenu && comp.isVisible()) {
                    totalMenuWidth += compPrefSize.width;
                    if (rowWidth + compPrefSize.width > maxWidthForMenus) {
                        rowWidth = compPrefSize.width;
                        ++rowCount;
                    } else {
                        rowWidth += compPrefSize.width;
                    }
                    maxMenuHeight = Math.max(maxMenuHeight, compPrefSize.height);
                }
                ++i;
            }
            rowCount = Math.min(menuBar.getMenuCount(), rowCount);
            maxMenuHeight = rowCount * maxMenuHeight;
            int toolBarWidth = this.getToolBarWidth(target, logoLabel.getPreferredSize().width);
            preferredWidth = toolBarWidth > (totalMenuWidth += trailingOffset) ? (preferredWidth += toolBarWidth) : (preferredWidth += totalMenuWidth);
            int heightAddition = toolBar != null && toolBar.getComponentCount() > 0 ? 5 : 2;
            int preferredHeight = insets.top + insets.bottom + heightAddition;
            int toolBarHeight = 0;
            if (toolBar != null) {
                int offset = this.myToolBarOverflowEnabled ? 24 : 0;
                toolBar.putClientProperty("WrappingLayout.width", toolBarWidth - offset);
                toolBar.invalidate();
                toolBarHeight = toolBar.getPreferredSize().height;
            }
            return new Dimension(preferredWidth, preferredHeight += maxMenuHeight + toolBarHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public void layoutContainer(Container target) {
            int minMenuX;
            JMenuBar menuBar = (JMenuBar)target;
            int numComponents = target.getComponentCount();
            Insets insets = target.getInsets();
            Dimension size = target.getSize();
            boolean leftToRight = target.getComponentOrientation().isLeftToRight();
            JLabel logoLabel = this.getLogoLabel(menuBar);
            int trailingOffset = this.LOGO_TRAILING_OFFSET;
            int normalMenuX = minMenuX = insets.left + 1;
            int maxMenuX = size.width - insets.right - trailingOffset - logoLabel.getPreferredSize().width - 6;
            if (!leftToRight) {
                normalMenuX = minMenuX = size.width - insets.right;
                maxMenuX = insets.left + trailingOffset;
            }
            Dimension compPrefSize = logoLabel.getPreferredSize();
            this.layoutLogoLabel(target, leftToRight, logoLabel);
            int menuY = insets.top;
            int maxMenuHeightInRow = 0;
            int i = 0;
            while (i < numComponents) {
                Component comp = target.getComponent(i);
                compPrefSize = comp.getPreferredSize();
                if (comp instanceof JMenu && comp.isVisible()) {
                    if (leftToRight) {
                        if (normalMenuX + compPrefSize.width <= maxMenuX || normalMenuX == minMenuX) {
                            maxMenuHeightInRow = Math.max(compPrefSize.height, maxMenuHeightInRow);
                            comp.setLocation(normalMenuX, menuY);
                            normalMenuX += compPrefSize.width;
                            comp.setSize(compPrefSize);
                        } else {
                            maxMenuHeightInRow = compPrefSize.height;
                            normalMenuX = minMenuX;
                            comp.setLocation(normalMenuX, menuY += maxMenuHeightInRow);
                            normalMenuX += compPrefSize.width;
                            comp.setSize(compPrefSize);
                        }
                    } else if (normalMenuX - compPrefSize.width >= maxMenuX) {
                        maxMenuHeightInRow = Math.max(compPrefSize.height, maxMenuHeightInRow);
                        comp.setLocation(normalMenuX -= compPrefSize.width, insets.top);
                        comp.setSize(compPrefSize);
                    } else {
                        maxMenuHeightInRow = compPrefSize.height;
                        normalMenuX = minMenuX;
                        comp.setLocation(normalMenuX, menuY += maxMenuHeightInRow);
                        normalMenuX -= compPrefSize.width;
                        comp.setSize(compPrefSize);
                    }
                } else if (comp instanceof JToolBar || comp instanceof OverflowToolBar) {
                    if (leftToRight) {
                        comp.setLocation(insets.left + 4, size.height - insets.bottom - compPrefSize.height);
                    } else {
                        comp.setLocation(insets.left, size.height - insets.bottom - compPrefSize.height);
                    }
                    int toolBarWidth = this.getToolBarWidth(target, logoLabel.getPreferredSize().width);
                    comp.setSize(compPrefSize.width <= toolBarWidth ? compPrefSize.width : toolBarWidth, compPrefSize.height);
                } else if (comp == this.myOptionalBannerComponent) {
                    comp.setLocation(size.width - insets.right - compPrefSize.width - insets.right - 18 - this.LOGO_TRAILING_OFFSET - logoLabel.getWidth(), insets.top + this.TOP_OFFSET);
                    comp.setSize(compPrefSize.width, compPrefSize.height);
                }
                ++i;
            }
        }

        private void layoutLogoLabel(Container target, boolean leftToRight, JLabel logoLabel) {
            Insets insets = target.getInsets();
            Dimension size = target.getSize();
            Dimension compPrefSize = logoLabel.getPreferredSize();
            if (leftToRight) {
                int yLocation = insets.top + this.TOP_OFFSET;
                if (yLocation + logoLabel.getPreferredSize().height > target.getHeight()) {
                    yLocation = target.getHeight() / 2 - logoLabel.getPreferredSize().height / 2;
                }
                logoLabel.setLocation(size.width - insets.right - compPrefSize.width - this.LOGO_TRAILING_OFFSET, yLocation);
            } else {
                logoLabel.setLocation(insets.left + this.LOGO_TRAILING_OFFSET, insets.top + this.TOP_OFFSET);
            }
            logoLabel.setSize(compPrefSize);
        }

        protected JToolBar getToolBar(JMenuBar menuBar) {
            if (menuBar instanceof PMenuBar) {
                return ((PMenuBar)menuBar).getToolBar();
            }
            ProductBannerDescription description = (ProductBannerDescription)menuBar.getClientProperty("OceanTouch.productBannerDescription");
            return description.getToolBar();
        }

        protected JLabel getLogoLabel(JMenuBar menuBar) {
            if (menuBar instanceof PMenuBar) {
                return ((PMenuBar)menuBar).getLogoLabel();
            }
            ProductBannerDescription description = (ProductBannerDescription)menuBar.getClientProperty("OceanTouch.productBannerDescription");
            return description.getLogoLabel();
        }

        private int getToolBarWidth(Container target, int logoLabelWidth) {
            Insets insets = target.getInsets();
            int targetWidth = target.getWidth() - insets.left - insets.right;
            return targetWidth - logoLabelWidth - 4 - this.LOGO_TRAILING_OFFSET - 12;
        }
    }
}

