/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.borders.HeaderBorder;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PPanel
extends JPanel {
    private static String ERROR_MESSAGE = "Given value is not allowed";

    public PPanel() {
        this(true);
    }

    public PPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public PPanel(LayoutManager layout) {
        this(layout, true);
    }

    public PPanel(Border border) {
        this();
        this.setBorder(border);
    }

    public PPanel(boolean isDoubleBuffered) {
        this(new FlowLayout(), isDoubleBuffered);
    }

    public static PPanel createHeaderPanel(String headerText) {
        HeaderBorder border = new HeaderBorder(headerText);
        if (headerText != null && headerText.length() > 0) {
            border.setPaintSeparator(true);
        }
        PPanel panel = new PPanel(border);
        panel.setOpaque(false);
        return panel;
    }

    public static PPanel createHeaderPanel(String headerText, boolean paintHeader) {
        HeaderBorder border = new HeaderBorder(headerText, false, paintHeader);
        if (headerText != null && headerText.length() > 0) {
            border.setPaintSeparator(true);
        }
        PPanel panel = new PPanel(border);
        panel.setOpaque(false);
        return panel;
    }

    public static PPanel createEmphasizedHeaderPanel(String headerText) {
        return PPanel.createEmphasizedHeaderPanel(headerText, true);
    }

    public static PPanel createEmphasizedHeaderPanel(String headerText, boolean paintSeparator) {
        HeaderBorder border = new HeaderBorder(headerText, true);
        border.setPaintSeparator(paintSeparator);
        PPanel panel = new PPanel(border);
        panel.setOpaque(false);
        return panel;
    }

    public void setFloatingPane(boolean floatingPane) {
        this.putClientProperty("OrangeTouch.floatingPane", floatingPane);
    }

    public PPanel append(Component ... comp) {
        int i = 0;
        while (i < comp.length) {
            this.add(comp[i]);
            ++i;
        }
        return this;
    }

    public PPanel append(Component comp, Object constraints) {
        this.add(comp, constraints);
        return this;
    }

    public int indexOfChild(Component child) {
        Component[] children = this.getComponents();
        int idx = 0;
        while (idx < children.length) {
            if (children[idx] == child) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void setCurvedSheet(boolean curvedSheet) {
        this.putClientProperty("OrangeTouch.curvedSheet", curvedSheet);
    }

    public void setPaintSheetOutline(boolean paintSheetOutline) {
        this.putClientProperty("OrangeTouch.paintSheetOutline", paintSheetOutline);
    }

    public boolean isVisibleUpperEdge() {
        return Boolean.TRUE.equals(this.getClientProperty("visibleUpperEdge"));
    }

    public void setVisibleUpperEdge(boolean visibleUpperEdge) {
        this.putClientProperty("visibleUpperEdge", visibleUpperEdge);
    }

    public boolean isVisibleLowerEdge() {
        return Boolean.TRUE.equals(this.getClientProperty("visibleLowerEdge"));
    }

    public void setVisibleLowerEdge(boolean visibleLowerEdge) {
        this.putClientProperty("visibleLowerEdge", visibleLowerEdge);
    }

    public boolean isVisibleLeadingEdge() {
        return Boolean.TRUE.equals(this.getClientProperty("visibleLeadingEdge"));
    }

    public void setVisibleLeadingEdge(boolean visibleLeadingEdge) {
        this.putClientProperty("visibleLeadingEdge", visibleLeadingEdge);
    }

    public boolean isVisibleTrailingEdge() {
        return Boolean.TRUE.equals(this.getClientProperty("visibleTrailingEdge"));
    }

    public void setVisibleTrailingEdge(boolean visibleTrailingEdge) {
        this.putClientProperty("visibleTrailingEdge", visibleTrailingEdge);
    }

    public void setPanelType(Integer type) {
        this.checkType(type, ERROR_MESSAGE);
        this.putClientProperty("panelType", type);
        this.putClientProperty("foregroundArea", type.intValue() == ClientProperties.PANEL_USER_FOREGROUND.intValue());
    }

    public void setHeaderFont(Font font) {
        this.putClientProperty(ClientProperties.PANEL_HEADER_FONT, font);
    }

    public Integer getPanelType() {
        return ClientPropertyUtil.integerValue(this, "panelType");
    }

    protected int checkType(int type, String message) {
        if (type == ClientProperties.PANEL_USER_FOREGROUND || type == ClientProperties.PANEL_USER_BACKGROUND || type == ClientProperties.PANEL_BUTTONAREA_BACKGROUND) {
            return type;
        }
        throw new IllegalArgumentException(message);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.getBorder() instanceof HeaderBorder) {
            int headerPreferredWidth = ((HeaderBorder)this.getBorder()).getPreferredWidth(this);
            result.width = Math.max(headerPreferredWidth, result.width);
        }
        return result;
    }
}

