/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ResizeCorner
extends JLabel {
    private Window myParentWindow;
    private boolean myParentIsResizable = true;
    private Point myStartingPoint;
    private Point myEndPoint;
    private WindowStateListener myWindowStateListener;

    public ResizeCorner() {
        this.init();
    }

    public ResizeCorner(Window parent) {
        this.init();
        this.setParent(parent);
    }

    private void init() {
        this.setIcon(new GripCornerIcon());
        this.setCursor(Cursor.getPredefinedCursor(6));
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public void setParent(Window parent) {
        if (this.myWindowStateListener != null && this.myParentWindow != null) {
            this.myParentWindow.removeWindowStateListener(this.myWindowStateListener);
        }
        this.myParentWindow = parent;
        if (this.myParentWindow != null) {
            this.myWindowStateListener = new MyWindowStateListener();
            this.myParentWindow.addWindowStateListener(this.myWindowStateListener);
            this.testIfParentResizable();
        } else {
            this.doParentNonResizable();
        }
    }

    private void testIfParentResizable() {
        if (this.myParentWindow instanceof Frame && ((Frame)this.myParentWindow).isResizable()) {
            int state = ((Frame)this.myParentWindow).getExtendedState();
            if (state == 0) {
                this.doParentResizable();
            } else {
                this.doParentNonResizable();
            }
        } else if (this.myParentWindow instanceof Dialog && ((Dialog)this.myParentWindow).isResizable()) {
            this.doParentResizable();
        } else {
            this.doParentNonResizable();
        }
    }

    private void doParentNonResizable() {
        this.myParentIsResizable = false;
        this.setCursor(null);
    }

    private void doParentResizable() {
        this.myParentIsResizable = true;
        this.setCursor(Cursor.getPredefinedCursor(6));
    }

    private class GripCornerIcon
    implements Icon {
        private final Color myColor = new Color(173, 173, 173);

        private GripCornerIcon() {
        }

        @Override
        public int getIconHeight() {
            return 14;
        }

        @Override
        public int getIconWidth() {
            return 14;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!ResizeCorner.this.myParentIsResizable) {
                return;
            }
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            Color savedColor = g.getColor();
            g.setColor(Color.WHITE);
            g.drawRect(width - 2, height - 2, 1, 1);
            g.drawRect(width - 6, height - 2, 1, 1);
            g.drawRect(width - 10, height - 2, 1, 1);
            g.drawRect(width - 2, height - 6, 1, 1);
            g.drawRect(width - 6, height - 6, 1, 1);
            g.drawRect(width - 2, height - 10, 1, 1);
            g.setColor(this.myColor);
            g.drawRect(width - 3, height - 3, 1, 1);
            g.drawRect(width - 7, height - 3, 1, 1);
            g.drawRect(width - 11, height - 3, 1, 1);
            g.drawRect(width - 3, height - 7, 1, 1);
            g.drawRect(width - 7, height - 7, 1, 1);
            g.drawRect(width - 3, height - 11, 1, 1);
            g.setColor(savedColor);
        }
    }

    protected class MyMouseListener
    extends MouseAdapter {
        protected MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = ((Component)e.getSource()).getLocationOnScreen().x + e.getX();
            int y = ((Component)e.getSource()).getLocationOnScreen().y + e.getY();
            ResizeCorner.this.myStartingPoint = new Point(x, y);
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ResizeCorner.this.myParentWindow != null && ResizeCorner.this.myParentIsResizable) {
                ResizeCorner.this.myEndPoint = new Point(((ResizeCorner)ResizeCorner.this).myStartingPoint.x + e.getX(), ((ResizeCorner)ResizeCorner.this).myStartingPoint.y + e.getY());
                Dimension s = ResizeCorner.this.myParentWindow.getSize();
                s.height -= ((ResizeCorner)ResizeCorner.this).myStartingPoint.y - ((ResizeCorner)ResizeCorner.this).myEndPoint.y;
                s.width -= ((ResizeCorner)ResizeCorner.this).myStartingPoint.x - ((ResizeCorner)ResizeCorner.this).myEndPoint.x;
                ResizeCorner.this.myParentWindow.setSize(s);
                ResizeCorner.this.myStartingPoint = ResizeCorner.this.myEndPoint;
            }
        }
    }

    public class MyWindowStateListener
    implements WindowStateListener {
        @Override
        public void windowStateChanged(WindowEvent e) {
            int state = e.getNewState();
            if (state == 0) {
                ResizeCorner.this.doParentResizable();
            } else {
                ResizeCorner.this.doParentNonResizable();
            }
        }
    }
}

