/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.buttons.MenuButton;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.layout.PVerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ScrollablePopupMenu
extends JPopupMenu
implements PopupMenuListener,
ChangeListener {
    private static final int NORMAL_SCROLL_DELAY = 80;
    private static final int FAST_SCROLL_DELAY = 30;
    private static final int SCROLL_STEP = 10;
    private JButton myScrollDownButton;
    private JButton myScrollUpButton;
    private JViewport myViewport = new MenuElementViewport();
    private JPanel myMenuPanel = new MenuElementPanel();
    private Timer myScrollTimer;
    private Component myRolloveredScrollButton;
    private boolean myAlignWithInvoker = false;
    private int myMaximumRowCount = 12;
    private boolean myAboveCombo = false;

    public ScrollablePopupMenu() {
        this.setLayout(new BorderLayout());
        this.myViewport.setView(this.myMenuPanel);
        this.myMenuPanel.setBackground(NetTheme.getMidGrayOutline());
        this.myMenuPanel.setLayout(new PVerticalLayout(3, 0, 0, 0));
        this.myScrollDownButton = new ScrollButton(1);
        this.myScrollUpButton = new ScrollButton(-1);
        this.add((Component)this.myScrollUpButton, "North");
        this.add((Component)this.myScrollDownButton, "South");
        this.addMenuContainer();
        this.addPopupMenuListener(this);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("DOWN"), "down");
        this.getActionMap().put("down", new SelectItemAction(true));
        this.getInputMap(2).put(KeyStroke.getKeyStroke("UP"), "up");
        this.getActionMap().put("up", new SelectItemAction(false));
        this.myScrollTimer = new Timer(80, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point viewPosition = ScrollablePopupMenu.this.myViewport.getViewPosition();
                int direction = ScrollablePopupMenu.this.myRolloveredScrollButton == ScrollablePopupMenu.this.myScrollDownButton ? 1 : -1;
                viewPosition.y += direction * 10;
                if (direction < 0) {
                    if (viewPosition.y > -10) {
                        ScrollablePopupMenu.this.myViewport.setViewPosition(viewPosition);
                    }
                } else {
                    ScrollablePopupMenu.this.myViewport.setViewPosition(viewPosition);
                }
                ScrollablePopupMenu.this.setScrollButtonsVisibility();
                ScrollablePopupMenu.this.repaint();
            }
        });
        this.myScrollTimer.setRepeats(true);
    }

    protected void addMenuContainer() {
        if (this.myAlignWithInvoker) {
            JScrollPane scroll = new JScrollPane();
            scroll.setOpaque(false);
            scroll.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.getBackground()));
            scroll.setViewportBorder(BorderFactory.createEmptyBorder());
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.getVerticalScrollBar().setOpaque(false);
            ((JComponent)scroll.getVerticalScrollBar().getComponent(0)).setOpaque(false);
            scroll.setViewport(this.myViewport);
            this.add((Component)scroll, "Center");
        } else {
            this.add((Component)this.myViewport, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    public void setAlignWithInvoker(boolean alignWithInvoker) {
        this.myAlignWithInvoker = alignWithInvoker;
        this.addMenuContainer();
    }

    public boolean isAlignWithInvoker() {
        return this.myAlignWithInvoker;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        boolean addingItself;
        boolean bl = this.myAlignWithInvoker ? comp == this.myViewport.getParent() : (addingItself = comp == this.myViewport);
        if (!addingItself && comp != this.myScrollDownButton && comp != this.myScrollUpButton) {
            this.myMenuPanel.add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (this.myMenuPanel.getComponentCount() == 0) {
            return;
        }
        if (this.getInvoker() != null) {
            this.setPopupAboveCombo();
        }
        super.show(invoker, x, y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        MenuSelectionManager selectionManager = MenuSelectionManager.defaultManager();
        if (visible) {
            selectionManager.addChangeListener(this);
            if (this.getInvoker() instanceof JMenu) {
                MenuElement[] path = selectionManager.getSelectedPath();
                int originalLength = path.length;
                path = Arrays.copyOf(path, originalLength + 2);
                path[originalLength] = (MenuElement)((Object)this.myViewport);
                path[originalLength + 1] = (MenuElement)((Object)this.myMenuPanel);
                selectionManager.setSelectedPath(path);
                this.setScrollButtonsVisibility();
            } else {
                MenuElement[] menuElements = new MenuElement[]{this, (MenuElement)((Object)this.myViewport), (MenuElement)((Object)this.myMenuPanel)};
                selectionManager.setSelectedPath(menuElements);
            }
        } else {
            selectionManager.removeChangeListener(this);
        }
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int menuPanelWidth = this.myMenuPanel.getPreferredSize().width;
        int invokerWidth = this.getInvoker().getPreferredSize().width;
        int screenHeight = this.getScreenHeight();
        int visibleHeight = this.getMaxPopupVisibleHeight(screenHeight);
        int height = this.myViewport.getPreferredSize().height;
        if (dimension != null) {
            int width = dimension.width - 7;
            super.setPreferredSize(dimension);
            if (this.myAlignWithInvoker && menuPanelWidth < invokerWidth) {
                if (this.getInvoker() instanceof JMenu) {
                    if (this.myViewport.getPreferredSize().height > visibleHeight) {
                        width = dimension.width - 25;
                    }
                } else {
                    width = this.myViewport.getPreferredSize().height > visibleHeight ? invokerWidth - 22 : invokerWidth - 6;
                }
            }
            this.myMenuPanel.setPreferredSize(new Dimension(width, height));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.configurePopupmenu();
    }

    public void configurePopupmenu() {
        Dimension popupPreferredSize = this.getPreferredSize();
        Insets insets = this.getInsets();
        popupPreferredSize.height -= insets.top + insets.bottom;
        int screenHeight = this.getScreenHeight();
        int visibleHeight = this.getMaxPopupVisibleHeight(screenHeight);
        if (popupPreferredSize.height > visibleHeight) {
            int popupHeight = this.getPopupHeightForRowCount(this.getMaximumRowCount());
            int popupWidth = (int)popupPreferredSize.getWidth();
            popupPreferredSize.width += insets.left + insets.right;
            if (this.myAlignWithInvoker) {
                this.setPreferredSize(new Dimension(popupWidth, popupHeight));
                if (this.getInvoker() instanceof MenuButton) {
                    Point newLocation = this.getMyLocationOnScreen(popupHeight);
                    this.setLocation(newLocation);
                }
            } else {
                this.setPreferredSize(new Dimension(popupWidth, screenHeight - 22));
            }
            this.setScrollButtonsVisibility();
        } else {
            popupPreferredSize.height += insets.top + insets.bottom;
            this.setPreferredSize(popupPreferredSize);
            this.myScrollDownButton.setVisible(false);
            this.myScrollUpButton.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    private Point getMyLocationOnScreen(int popupHeight) {
        Point invokerLocationOnScreen = this.getInvoker().getLocationOnScreen();
        Point popupLocation = this.isAboveCombo() ? new Point(invokerLocationOnScreen.x - 1, invokerLocationOnScreen.y - popupHeight + 6) : new Point(invokerLocationOnScreen.x - 1, invokerLocationOnScreen.y + this.getInvoker().getHeight() - 4);
        return popupLocation;
    }

    private int getScreenHeight() {
        GraphicsConfiguration graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        int screenHeight = screenBounds.height - (screenInsets.top + screenInsets.bottom);
        return screenHeight;
    }

    private int getMaxPopupVisibleHeight(int screenHeight) {
        int maxVisibleHeight = this.getInvoker() instanceof MenuButton ? screenHeight - this.getInvoker().getLocationOnScreen().y - this.getInvoker().getHeight() : screenHeight;
        return maxVisibleHeight;
    }

    private int getPopupHeightForRowCount(int maximumRowCount) {
        int height = 0;
        int visibleRowCount = Math.min(maximumRowCount, this.myMenuPanel.getComponentCount());
        Insets insets = this.getInsets();
        int index = 0;
        while (index < visibleRowCount) {
            height += this.myMenuPanel.getComponent((int)index).getPreferredSize().height;
            ++index;
        }
        return height + insets.top + insets.bottom;
    }

    private void setScrollButtonsVisibility() {
        if (this.myAlignWithInvoker) {
            this.myScrollDownButton.setVisible(false);
            this.myScrollUpButton.setVisible(false);
            return;
        }
        Point viewPosition = this.myViewport.getViewPosition();
        if ((double)viewPosition.y + this.myViewport.getExtentSize().getHeight() >= (double)this.myViewport.getViewSize().height) {
            this.myScrollDownButton.setVisible(false);
        } else {
            this.myScrollDownButton.setVisible(true);
        }
        this.myScrollUpButton.setVisible(viewPosition.y > 0);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public int getMaximumRowCount() {
        return this.myMaximumRowCount;
    }

    public void setMaximumRowCount(int maximumRowCount) {
        this.myMaximumRowCount = maximumRowCount;
    }

    public boolean isAboveCombo() {
        return this.myAboveCombo;
    }

    public void setPopupAboveCombo() {
        if (this.myAlignWithInvoker) {
            int screenHeight;
            int popupHeight = this.getPopupHeightForRowCount(this.getMaximumRowCount());
            this.myAboveCombo = popupHeight > this.getMaxPopupVisibleHeight(screenHeight = this.getScreenHeight());
            this.putClientProperty("OrangeTouch.popupAboveCombo", this.isAboveCombo());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MenuElement lastElement;
        if (this.myMenuPanel.getComponentCount() == 0) {
            return;
        }
        MenuElement[] selection = MenuSelectionManager.defaultManager().getSelectedPath();
        if (selection != null && selection.length > 3 && this.isDeepestPopup() && (lastElement = selection[selection.length - 1]) != this.myMenuPanel) {
            this.myMenuPanel.scrollRectToVisible(((Component)((Object)lastElement)).getBounds());
        }
    }

    private boolean isDeepestPopup() {
        MenuElement[] selection = MenuSelectionManager.defaultManager().getSelectedPath();
        int idx = selection.length - 1;
        while (idx >= 0) {
            if (selection[idx] instanceof ScrollablePopupMenu) {
                return selection[idx] == this;
            }
            --idx;
        }
        return false;
    }

    private class MenuElementPanel
    extends JPanel
    implements MenuElement,
    Scrollable {
        private MenuElementPanel() {
        }

        @Override
        public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public MenuElement[] getSubElements() {
            ArrayList<MenuElement> tmp = new ArrayList<MenuElement>();
            int idx = 0;
            while (idx < this.getComponentCount()) {
                Component component = this.getComponent(idx);
                if (component instanceof MenuElement) {
                    tmp.add((MenuElement)((Object)component));
                }
                ++idx;
            }
            return tmp.toArray(new MenuElement[tmp.size()]);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 26;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (int)visibleRect.getHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class MenuElementViewport
    extends JViewport
    implements MenuElement {
        private MenuElementViewport() {
        }

        @Override
        public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public MenuElement[] getSubElements() {
            return new MenuElement[]{(MenuElement)((Object)this.getView())};
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private class ScrollButton
    extends PToolButton
    implements MouseListener {
        public ScrollButton(int direction) {
            if (direction == -1) {
                this.setIcon(new PArrowIcon(8, 4, (Color)NetLookAndFeel.getFocusColor(), 1));
                this.setRolloverIcon(new PArrowIcon(8, 4, (Color)NetTheme.getHoverColor(), 1));
            } else {
                this.setIcon(new PArrowIcon(8, 4, (Color)NetLookAndFeel.getFocusColor(), 5));
                this.setRolloverIcon(new PArrowIcon(8, 4, (Color)NetTheme.getHoverColor(), 5));
            }
            this.setFocusable(false);
            this.setPreferredSize(new Dimension(40, 18));
            this.setDefaultCapable(false);
            this.setVisible(false);
            this.addMouseListener(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(UIManager.getColor("MenuItem.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ScrollablePopupMenu.this.myScrollTimer.setDelay(30);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ScrollablePopupMenu.this.myScrollTimer.setDelay(80);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ScrollablePopupMenu.this.myRolloveredScrollButton = e.getComponent();
            ScrollablePopupMenu.this.myScrollTimer.restart();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ScrollablePopupMenu.this.myScrollTimer.stop();
            ScrollablePopupMenu.this.myRolloveredScrollButton = null;
        }
    }

    private class SelectItemAction
    extends AbstractAction {
        private boolean myForward = true;

        public SelectItemAction(boolean forward) {
            this.myForward = forward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            MenuElement[] selection = MenuSelectionManager.defaultManager().getSelectedPath();
            int originalLength = selection.length;
            MenuElement[] newSelection = Arrays.copyOf(selection, originalLength + 1);
            newSelection[newSelection.length - 1] = (MenuElement)((Object)ScrollablePopupMenu.this.myMenuPanel.getComponent(this.myForward ? 0 : ScrollablePopupMenu.this.myMenuPanel.getComponentCount() - 1));
            MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
        }

        @Override
        public boolean isEnabled() {
            MenuElement[] selection = MenuSelectionManager.defaultManager().getSelectedPath();
            return selection != null && selection.length == 3 && selection[2] == ScrollablePopupMenu.this.myMenuPanel && ScrollablePopupMenu.this.myMenuPanel.getComponentCount() > 0 && ScrollablePopupMenu.this.myMenuPanel.getComponent(this.myForward ? 0 : ScrollablePopupMenu.this.myMenuPanel.getComponentCount() - 1) instanceof MenuElement;
        }
    }
}

