/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets;

import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class TitlePanel
extends PPanel {
    private JLabel myTitle;
    private JLabel myLogolabel;
    private JButton myCloseButton;

    public TitlePanel(String title) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 6));
        this.myTitle = PLabel.createHeader(title);
        this.myTitle.setBorder(BorderFactory.createEmptyBorder(22, 0, 4, 12));
        this.myLogolabel = new JLabel(WidgetResources.getImageIcon("CompanyLogoProductBanner_Icon"));
        this.myLogolabel.setBorder(BorderFactory.createEmptyBorder(6, 64, 2, 12));
        CloseIcon icon = new CloseIcon();
        icon.setStrokeWidth(2);
        this.myCloseButton = new JButton(icon);
        this.myCloseButton.setFocusable(false);
        this.myCloseButton.putClientProperty("OrangeTouch.roundedOutline", true);
        this.myCloseButton.setPreferredSize(new Dimension(22, 22));
        ExtendedGridBagConstraints gc = new ExtendedGridBagConstraints();
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.setAnchor(13);
        gc.nextRow();
        gc.weighty = 1.0;
        gc.setAnchor(17);
        this.add((Component)this.myTitle, gc);
        gc.nextColumn();
        gc.setAnchor(13);
        this.add((Component)this.myLogolabel, gc);
        gc.nextColumn();
        gc.anchor = 11;
        gc.weightx = 0.0;
        this.add((Component)this.myCloseButton, gc);
    }

    public JButton getCloseButton() {
        return this.myCloseButton;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        GradientUtils.drawVerticalGradient((JComponent)this, g, new Color[]{new Color(230, 230, 230), new Color(255, 255, 255)}, 0, 0, this.getWidth(), 24);
        Object oldAa = NetUtils.antiAliasingOn(g);
        GeneralPath curve = NetUtils.createCurvedOutline(g, this, Math.max(this.myTitle.getWidth(), this.getWidth() / 2 - 10), this.getHeight() - 24);
        g.setColor(UIManager.getColor("ToolBar.background"));
        ((Graphics2D)g).fill(curve);
        NetUtils.setAntialiasing(g, oldAa);
    }
}

