/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.about;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.about.AboutBoxController;
import com.nokia.widgets.about.AboutBoxModel;
import com.nokia.widgets.about.AboutView;
import com.nokia.widgets.about.TextViewerDialog;
import com.nokia.widgets.about.View;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.util.SystemUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutBoxView
extends JDialog
implements AWTEventListener,
View {
    protected AboutBoxModel myModel;
    protected AboutBoxController myController;
    protected JFrame myParentFrame;
    protected Font myBigFont;
    protected Font myMediumFont;
    protected Font mySmallFont;
    private AboutView myView;
    private JButton myAboutCloseButton;

    public AboutBoxView(JFrame parentFrame, AboutBoxController controller) {
        super(parentFrame);
        this.myParentFrame = parentFrame;
        this.myController = controller;
        this.myModel = this.myController.getModel();
        this.myView = new AboutView(controller, this);
        this.getRootPane().putClientProperty("OrangeTouch.isLightbox", true);
        this.buildUI();
        this.getToolkit().addAWTEventListener(this, 8L);
        this.addWindowListener(new WindowListener());
    }

    @Override
    public void setController(AboutBoxController controller) {
        this.myController = controller;
    }

    protected void buildUI() {
        PPanel mainPanel = new PPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        mainPanel.add((Component)this.myView, gbc);
        RowAlignLayout aboutBoxLayout = new RowAlignLayout();
        aboutBoxLayout.setComponentScaled(false);
        aboutBoxLayout.setGap(5);
        PPanel buttonPanel = new PPanel(aboutBoxLayout);
        buttonPanel.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        if (this.myModel.hasProperty("AboutBox_ApplicationName")) {
            String applicationName = (String)this.myModel.getProperty("AboutBox_ApplicationName");
            this.setTitle(applicationName);
        }
        if (Boolean.TRUE.equals(this.myModel.getProperty("AboutBox_Show_System_Info"))) {
            buttonPanel.add((Component)this.makeSystemInfoButton(), "West");
        }
        if (this.myModel.getProperty("AboutBox_Show_License_Agreement") != null) {
            buttonPanel.add((Component)this.makelicenseAgreementButton((String)this.myModel.getProperty("AboutBox_Show_License_Agreement")), "West");
        }
        if (this.myModel.hasProperty("AboutBox_Readme")) {
            buttonPanel.add((Component)this.makeReadmeButton(), "West");
        }
        if (Boolean.TRUE.equals(this.myModel.getProperty("AboutBox_CopyRightBottomAligned"))) {
            buttonPanel.add((Component)this.myView.generateCopyrightPanel(), "West");
        }
        this.myAboutCloseButton = this.makeCloseButton();
        buttonPanel.add((Component)this.myAboutCloseButton, "East");
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 15;
        gbc.fill = 2;
        mainPanel.add((Component)buttonPanel, gbc);
        this.getContentPane().add(mainPanel);
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.myView.scaleBackgroundImage();
        this.myView.setFocusable(false);
        this.pack();
        this.setPlace();
    }

    protected JButton makeReadmeButton() {
        JButton readmeButton = new JButton();
        readmeButton.setText(WidgetResources.getString("AboutBox.Readme_Text"));
        readmeButton.setMnemonic(WidgetResources.getMnemonic("AboutBox.Readme_Mnemonic"));
        try {
            final URL absolutePath = (URL)this.myModel.getProperty("AboutBox_Readme");
            boolean isReadmeFileExist = false;
            if (absolutePath != null) {
                File readmeFile = new File(absolutePath.toURI());
                isReadmeFileExist = readmeFile.exists();
            }
            readmeButton.setEnabled(isReadmeFileExist);
            if (!isReadmeFileExist) {
                readmeButton.setToolTipText(WidgetResources.getString("AboutBox.Readme_Button_TooltipText"));
            } else {
                readmeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionevent) {
                        new ReadmeDialog((JDialog)AboutBoxView.this, absolutePath);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return readmeButton;
    }

    protected JButton makeCloseButton() {
        PButton closeButton = new PButton();
        closeButton.setDefaultButton(true);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AboutBoxView.this.myController.closeRequest();
            }
        });
        closeButton.setText(WidgetResources.getString("CloseAction_Text"));
        return closeButton;
    }

    protected JButton makeSystemInfoButton() {
        JButton sysInfoButton = new JButton();
        sysInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                AboutBoxView.this.myController.sysInfoRequest();
            }
        });
        sysInfoButton.setText(WidgetResources.getString("AboutBox.SystemInfo_Text"));
        sysInfoButton.setMnemonic(WidgetResources.getMnemonic("AboutBox.SystemInfo_Mnemonic"));
        return sysInfoButton;
    }

    protected JButton makelicenseAgreementButton(final String licenseAgreement) {
        JButton license = new JButton();
        license.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                new LicenseDialog(AboutBoxView.this, licenseAgreement);
            }
        });
        license.setText(WidgetResources.getString("AboutBox.LicenseAgreement_Text"));
        license.setMnemonic(WidgetResources.getMnemonic("AboutBox.LicenseAgreement_Mnemonic"));
        return license;
    }

    protected void setPlace() {
        if (this.myParentFrame != null) {
            Rectangle parentBounds = this.myParentFrame.getBounds();
            Dimension size = this.getSize();
            int x = (parentBounds.width - size.width) / 2 + parentBounds.x;
            int y = (parentBounds.height - size.height) / 2 + parentBounds.y;
            this.setLocation(x, y);
        }
    }

    protected void removeListeners() {
        this.getToolkit().removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent keyEvent = (KeyEvent)event;
        if (!this.isFocused()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    this.myController.closeRequest();
                    break;
                }
            }
        }
    }

    protected static class LicenseDialog
    extends TextViewerDialog {
        private String myLicenseText;

        public LicenseDialog(JDialog parentDialog, String licenseText) {
            super(parentDialog, WidgetResources.getString("AboutBox.LicenseAgreement_Text"));
            this.myLicenseText = licenseText;
            this.buildUI();
        }

        @Override
        protected Component initContents() {
            JTextArea textArea = new JTextArea(this.myLicenseText);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEditable(false);
            return textArea;
        }
    }

    protected static class ReadmeDialog
    extends TextViewerDialog {
        private URL myReadmeLink;

        public ReadmeDialog(JDialog parentDialog, URL readmeLink) {
            super(parentDialog, WidgetResources.getString("AboutBox.Readme_Text"));
            this.myReadmeLink = readmeLink;
            this.buildUI();
        }

        @Override
        protected Component initContents() {
            final JEditorPane editorPane = new JEditorPane();
            try {
                editorPane.setPage(this.myReadmeLink);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
            editorPane.setEditable(false);
            HyperlinkListener l = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                        if (!this.isExternalURL(e.getURL())) {
                            try {
                                editorPane.setPage(e.getURL());
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            SystemUtils.openInBrowser(e.getURL());
                        }
                    }
                }

                private boolean isExternalURL(URL urlLink) {
                    return (urlLink.toString().contains("http://") || urlLink.toString().contains("https://")) && !urlLink.toString().contains(String.valueOf(ReadmeDialog.this.myReadmeLink.toString()) + "#");
                }
            };
            editorPane.addHyperlinkListener(l);
            return editorPane;
        }
    }

    protected class WindowListener
    extends WindowAdapter {
        protected WindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            AboutBoxView.this.removeListeners();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AboutBoxView.this.removeListeners();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            AboutBoxView.this.myAboutCloseButton.requestFocusInWindow();
        }
    }
}

