/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.about;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.about.AboutBoxController;
import com.nokia.widgets.about.AboutBoxModel;
import com.nokia.widgets.about.AboutBoxView;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PMatrixLayout;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class AboutView
extends PPanel {
    protected AboutBoxModel myModel;
    private boolean myAboutBoxOpened = false;
    private JLabel myBackgroundLabel;
    private final Color VERSION_LABEL_COLOR = NetUtils.decodeColor("#474747");

    public AboutView(AboutBoxController controller) {
        this.myModel = controller.getModel();
        this.buildUI();
    }

    public AboutView(AboutBoxController controller, Component comp) {
        this.myModel = controller.getModel();
        this.myAboutBoxOpened = comp instanceof AboutBoxView;
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.add((Component)this.buildDataPanel(), gbc);
        this.setFocusable(true);
    }

    protected PPanel buildDataPanel() {
        PLabel versionLabel;
        PPanel dataPanel = new PPanel(new GridBagLayout());
        dataPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        int leftInsets = this.myAboutBoxOpened ? 15 : 25;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(11, 56, 0, 26);
        if (this.myModel.hasProperty("AboutBox_ApplicationName") && !this.myAboutBoxOpened) {
            gbc.insets = new Insets(10, leftInsets, 0, 26);
            ++gbc.gridy;
            Object name = this.myModel.getProperty("AboutBox_ApplicationName");
            versionLabel = PLabel.createHeader(name.toString());
            versionLabel.setFont(versionLabel.getFont().deriveFont(20.0f));
            dataPanel.add((Component)versionLabel, gbc);
        }
        if (this.myModel.hasProperty("AboutBox_Version")) {
            gbc.insets = new Insets(3, leftInsets, 0, 26);
            ++gbc.gridy;
            StringBuffer version = new StringBuffer();
            version.append(this.getVersionText());
            if (this.myModel.hasProperty("AboutBox_BuildNumber") && this.myModel.getProperty("AboutBox_BuildNumber") != null && !"".equals(this.myModel.getProperty("AboutBox_BuildNumber"))) {
                version.append(" (");
                version.append((String)this.myModel.getProperty("AboutBox_BuildNumber"));
                version.append(")");
            }
            versionLabel = PLabel.createSubHeader(version.toString());
            versionLabel.setForeground(this.VERSION_LABEL_COLOR);
            dataPanel.add((Component)versionLabel, gbc);
        }
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(12, 0, 12, 25);
        this.myBackgroundLabel = new JLabel(WidgetResources.getImageIcon("Company-Logo-Icon")){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                String brandText = UIManager.getString("AboutBox.brandText");
                if (brandText == null) {
                    return;
                }
                NetLookAndFeel.toggleTextAntialiasing(g);
                g.setColor(new Color(79, 81, 84));
                g.setFont(g.getFont().deriveFont(11.0f));
                int textX = 245;
                g.drawString(brandText, 245, AboutView.this.myBackgroundLabel.getHeight() / 2 + 31);
                int tmLocation = 245 + SwingUtilities.computeStringWidth(g.getFontMetrics(), brandText);
                g.setFont(g.getFont().deriveFont(5.0f));
                g.drawString("TM", tmLocation, AboutView.this.myBackgroundLabel.getHeight() / 2 + 25);
            }
        };
        this.myBackgroundLabel.setBorder(BorderFactory.createEmptyBorder(26, 200, 12, 8));
        dataPanel.add((Component)this.myBackgroundLabel, gbc);
        gbc.fill = 1;
        gbc.anchor = 17;
        if (this.myAboutBoxOpened && this.myModel.hasProperty("AboutBox_Plugins") && !((List)this.myModel.getProperty("AboutBox_Plugins")).isEmpty()) {
            gbc.insets = new Insets(0, 25, 0, 0);
            ++gbc.gridy;
            PLabel systemSummary = PLabel.createSubHeader(this.getSystemSummaryText());
            dataPanel.add((Component)systemSummary, gbc);
            gbc.insets = new Insets(0, 0, 0, 0);
            ++gbc.gridy;
            dataPanel.add(this.buildApplicationPanel(), gbc);
        }
        if (this.myModel.hasProperty("AboutBox_CopyrightText") && !Boolean.TRUE.equals(this.myModel.getProperty("AboutBox_CopyRightBottomAligned"))) {
            gbc.fill = 0;
            gbc.insets = new Insets(10, leftInsets, this.myAboutBoxOpened ? 0 : 30, 0);
            ++gbc.gridy;
            PPanel copyrightPanel = this.generateCopyrightPanel();
            dataPanel.add((Component)copyrightPanel, gbc);
        }
        return dataPanel;
    }

    public PPanel generateCopyrightPanel() {
        PLabel symbol = new PLabel(String.valueOf(WidgetResources.getString("AboutBox.Copyright_Symbol")) + " ");
        symbol.setFont(NetLookAndFeel.getUserTextFont().deriveFont(0, 14 + NetLookAndFeel.getFontSizeIncrement()));
        String text = this.myModel.getProperty("AboutBox_CopyrightYear") + " " + this.myModel.getProperty("AboutBox_CopyrightCompany") + " " + this.myModel.getProperty("AboutBox_CopyrightText") + " ";
        PLabel copyYearAndCompany = new PLabel(text);
        copyYearAndCompany.setFont(NetLookAndFeel.getUserTextFont().deriveFont(0, 12 + NetLookAndFeel.getFontSizeIncrement()));
        copyYearAndCompany.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        PMatrixLayout layout = new PMatrixLayout(2, 0, 4, 0, 0);
        layout.setMatrixHorizontalAlignment(0);
        layout.setMatrixVerticalAlignment(2);
        PPanel copyrightPanel = new PPanel(layout);
        copyrightPanel.setOpaque(false);
        copyrightPanel.add(symbol);
        copyrightPanel.add(copyYearAndCompany);
        String additionalCopyrights = (String)this.myModel.getProperty("AboutBox_AdditionalCopyrights");
        if (additionalCopyrights != null) {
            JLabel label = new JLabel(additionalCopyrights);
            label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() - 1.0f));
            copyrightPanel.add(Box.createHorizontalBox());
            copyrightPanel.add(label);
        }
        return copyrightPanel;
    }

    private String getVersionText() {
        if (this.myModel.hasProperty("AboutBox_VersionLabel")) {
            Object[] arguments = new Object[]{this.myModel.getProperty("AboutBox_Version"), this.myModel.getProperty("AboutBox_VersionLabel")};
            return MessageFormat.format(WidgetResources.getString("AboutBox.CustomVersion_Text"), arguments);
        }
        Object[] arguments = new Object[]{this.myModel.getProperty("AboutBox_Version")};
        return MessageFormat.format(WidgetResources.getString("AboutBox.Version_Text"), arguments);
    }

    private String getSystemSummaryText() {
        if (this.myModel.hasProperty("AboutBox_SystemSummaryLabel")) {
            return (String)this.myModel.getProperty("AboutBox_SystemSummaryLabel");
        }
        return WidgetResources.getString("AboutBox.System_Summary");
    }

    public void scaleBackgroundImage() {
        ImageIcon backgroundIcon = (ImageIcon)this.myBackgroundLabel.getIcon();
        Image newImage = backgroundIcon.getImage();
        Image img = backgroundIcon.getImage();
        double scaleFactor = 0.77;
        newImage = img.getScaledInstance((int)(scaleFactor * (double)img.getWidth(null)), (int)(scaleFactor * (double)img.getHeight(null)), 4);
        this.myBackgroundLabel.setIcon(new ImageIcon(newImage));
    }

    protected Component buildApplicationPanel() {
        PPanel applicationDetailsArea = new PPanel(new GridBagLayout());
        applicationDetailsArea.setOpaque(true);
        GridBagConstraints detailsGbc = new GridBagConstraints();
        detailsGbc.gridx = 0;
        detailsGbc.gridy = 0;
        detailsGbc.gridwidth = 2;
        detailsGbc.anchor = 10;
        detailsGbc.weightx = 1.0;
        detailsGbc.fill = 2;
        detailsGbc.insets = new Insets(7, 26, 0, 28);
        applicationDetailsArea.add((Component)this.createBorderPanel(), detailsGbc);
        List pluginList = (List)this.myModel.getProperty("AboutBox_Plugins");
        int pluginListSize = pluginList.size();
        int i = 0;
        while (i < pluginListSize) {
            Map pluginDesc = (Map)pluginList.get(i);
            ++detailsGbc.gridy;
            detailsGbc.gridwidth = 1;
            detailsGbc.anchor = 18;
            detailsGbc.insets = new Insets(-4, 25, 0, 0);
            applicationDetailsArea.add((Component)PLabel.createText((String)pluginDesc.get("AboutBox_ApplicationName")), detailsGbc);
            detailsGbc.gridx = 1;
            detailsGbc.gridwidth = 0;
            detailsGbc.anchor = 12;
            detailsGbc.insets = new Insets(-4, 0, 0, 28);
            PLabel versionLabel = PLabel.createText((String)pluginDesc.get("AboutBox_Version"));
            versionLabel.setHorizontalAlignment(4);
            applicationDetailsArea.add((Component)versionLabel, detailsGbc);
            ++detailsGbc.gridy;
            detailsGbc.gridx = 0;
            detailsGbc.insets = new Insets(6, 26, 0, 28);
            applicationDetailsArea.add((Component)this.createBorderPanel(), detailsGbc);
            ++i;
        }
        return applicationDetailsArea;
    }

    private PPanel createBorderPanel() {
        PPanel borderPanel = new PPanel();
        borderPanel.setVisibleLowerEdge(true);
        borderPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new ColorUIResource(NetUtils.decodeColor("#D9D9D9"))));
        return borderPanel;
    }
}

