/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.about;

import com.nokia.widgets.PButtonPane;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class TextViewerDialog
extends JDialog {
    private final int[] DEFAULT_BOUNDS = new int[]{600, 450};
    private JButton myCloseButton;
    private String myDialogTitle;

    public TextViewerDialog(JDialog parentDialog, String dialogTitle) {
        super(parentDialog);
        this.myDialogTitle = dialogTitle;
    }

    protected void buildUI() {
        this.setTitle(this.myDialogTitle);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.initContents());
        scroll.getViewport().setPreferredSize(new Dimension(this.DEFAULT_BOUNDS[0], this.DEFAULT_BOUNDS[1]));
        scroll.getViewport().setBackground(Color.WHITE);
        JPanel midPanel = new JPanel(new BorderLayout());
        midPanel.setBorder(BorderFactory.createEmptyBorder(26, 26, 6, 26));
        midPanel.add(scroll);
        contentPane.add((Component)midPanel, "Center");
        PButtonPane buttonPanel = new PButtonPane();
        contentPane.add((Component)buttonPanel, "South");
        buttonPanel.add(this.createCloseButton());
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setMinimumSize(this.getPreferredSize());
        this.myCloseButton.requestFocusInWindow();
        this.setVisible(true);
    }

    protected abstract Component initContents();

    private JButton createCloseButton() {
        this.myCloseButton = new JButton();
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                TextViewerDialog.this.dispose();
            }
        });
        this.myCloseButton.setText(WidgetResources.getString("CloseAction_Text"));
        this.getRootPane().setDefaultButton(this.myCloseButton);
        return this.myCloseButton;
    }
}

