/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.approvalbar;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.slidingpanel.SlidingPanel;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class ApprovalBar
extends SlidingPanel {
    protected PButton myApproveButton;
    protected PButton myCancelButton;
    protected ActionListener myActionListener;
    protected PButton myDefaultButton;

    public ApprovalBar(ActionListener actionListener) {
        this.setLayout(new BorderLayout());
        this.myActionListener = actionListener;
        String applyText = WidgetResources.getString("ApproveAction");
        int applyMnemonic = WidgetResources.getMnemonic("ApproveAction_Mnemonic");
        String cancelText = WidgetResources.getString("CancelAction");
        int cancelMnemonic = WidgetResources.getMnemonic("CancelAction_Mnemonic");
        this.buildUI(applyText, applyMnemonic, cancelText, cancelMnemonic);
    }

    public ApprovalBar(ActionListener actionListener, String applyText, int applyMnemonic, String cancelText) {
        this.setLayout(new BorderLayout());
        this.myActionListener = actionListener;
        this.buildUI(applyText, applyMnemonic, cancelText, 27);
    }

    public ApprovalBar(ActionListener actionListener, String applyText, int applyMnemonic, String cancelText, int cancelMnemonic) {
        this.setLayout(new BorderLayout());
        this.myActionListener = actionListener;
        this.buildUI(applyText, applyMnemonic, cancelText, cancelMnemonic);
    }

    protected void buildUI(String applyText, int applyMnemonic, String cancelText, int cancelMnemonic) {
        RowAlignLayout layout = new RowAlignLayout();
        layout.setHMargin(12);
        layout.setVMargin(12);
        this.setLayout(layout);
        this.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        this.setVisibleUpperEdge(true);
        this.setOpaque(true);
        this.myDefaultButton = this.myApproveButton = new PButton();
        this.myApproveButton.setText(applyText);
        this.myApproveButton.setMnemonic(applyMnemonic);
        this.myApproveButton.addActionListener(this.myActionListener);
        this.add((Component)this.myApproveButton, "Center");
        this.myCancelButton = new PButton();
        this.myCancelButton.setText(cancelText);
        if (cancelMnemonic != 27) {
            this.myCancelButton.setMnemonic(cancelMnemonic);
        } else {
            this.myCancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(cancelMnemonic, 0), "escaped");
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ApprovalBar.this.myCancelButton.doClick();
                }
            };
            this.myCancelButton.getActionMap().put("escaped", cancelAction);
        }
        this.myCancelButton.addActionListener(this.myActionListener);
        this.add((Component)this.myCancelButton, "Center");
    }

    public PButton getApplyButton() {
        return this.myApproveButton;
    }

    public PButton getCancelButton() {
        return this.myCancelButton;
    }

    public void setDefaultButton(PButton button) {
        this.myDefaultButton = button;
    }

    public void showBar() {
        this.myApproveButton.setEnabled(true);
        this.myCancelButton.setEnabled(true);
        super.showPanel();
        JRootPane root = this.getRootPane();
        if (root != null) {
            root.setDefaultButton(this.myDefaultButton);
        }
    }

    public void hideBar() {
        this.myApproveButton.setEnabled(false);
        this.myCancelButton.setEnabled(false);
        super.hidePanel();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.myState == 2 && this.myApproveButton.isEnabled()) {
            this.myApproveButton.setEnabled(false);
            this.myCancelButton.setEnabled(false);
        }
        super.actionPerformed(event);
    }

    public boolean isBarVisible() {
        return super.isPanelVisible();
    }
}

