/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.balloon;

import com.nokia.widgets.balloon.BalloonBorder;
import com.nokia.widgets.balloon.BalloonListener;
import com.nokia.widgets.balloon.BalloonMouseAdapter;
import com.nokia.widgets.balloon.BalloonUI;
import com.nokia.widgets.hyperlink.Hyperlink;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.util.SystemUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Balloon
extends JInternalFrame {
    private static final String uiClassID = "NetBalloonWidgetUI";
    public static final int DEFAULT_ARROW = 0;
    public static final int RIGHT_DOWN_ARROW = 1;
    public static final int LEFT_UP_ARROW = 2;
    public static final int RIGHT_UP_ARROW = 3;
    public static final int INFO_BALLOON = 0;
    public static final int WARNING_BALLOON = 1;
    public static final int ERROR_BALLOON = 2;
    private static final int ARROW_HEIGHT_OFFSET = 11;
    static final AlphaComposite ZEROALPHA = AlphaComposite.getInstance(3, 1.0f);
    static final int X_INSETS = 7;
    static final int Y_INSETS = 4;
    static final int REDUCED_SIZE_INSET = 7;
    private static final int ARROW_Y_INSETS = 11;
    private static final int SMALL_OFFSET = 10;
    private static final int NORMAL_OFFSET = 20;
    private static final int LARGE_OFFSET = 40;
    private static final int X_GAP = 15;
    private int myArrowOffset = 0;
    private int myComponentXOffset = 0;
    private int myComponentYOffset = 0;
    private int myComponentX = 0;
    private int myComponentY = 0;
    private List<BalloonListener> myListeners;
    Insets myInsets;
    private String myBalloonTitle = "";
    private int myTableRow = 0;
    private int myListIndex = 0;
    private int myTableColumn = 0;
    boolean mySizeReduced = false;
    boolean myAttached = true;
    private JComponent myComponent;
    private Container myParentFrame;
    private String myBalloonMessage = "";
    private int myBalloonType;
    private Timer myAutoCloseTimer;
    private Timer myAlphaTimer = null;
    float myAlpha = 0.0f;
    private int myArrowDirection = 0;
    private boolean myScrollHostVisible = false;
    private Hyperlink myLink = null;
    private ComponentListener myListener = null;
    private AncestorListener myBalloonUpdater = new AncestorListener(){

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            Balloon.this.attachBalloon();
        }
    };

    static {
        UIManager.put(uiClassID, BalloonUI.class.getName());
    }

    public Balloon(JComponent host, String message) {
        this(host, Balloon.searchAcceptableParent(host), message, null);
    }

    public Balloon(JComponent host, Container parent, String message) {
        this(host, parent, message, null);
    }

    public Balloon(JComponent host, Container parent, String message, String title, int balloonType, int arrowDirection) {
        this.init(host, parent, message, title, balloonType, arrowDirection);
    }

    public Balloon(JComponent host, Container parent, String message, String title, int balloonType) {
        this(host, parent, message, title, balloonType, 0);
    }

    public Balloon(JTable host, int tableRow, int tableColumn, Container parent, String message, String title, int balloonType) {
        this.myTableRow = tableRow;
        this.myTableColumn = tableColumn;
        this.init(host, parent, message, title, balloonType, 0);
    }

    public Balloon(JComponent host, Container parent, String message, String title) {
        this(host, parent, message, title, 0, 0);
    }

    public Balloon(JTable host, int tableRow, int tableColumn, Container parent, String message, String title, int balloonType, int arrowDirection) {
        this.myTableRow = tableRow;
        this.myTableColumn = tableColumn;
        this.init(host, parent, message, title, balloonType, arrowDirection);
    }

    public Balloon(JList host, int index, Container parent, String message, String title, int balloonType, int arrowDirection) {
        this.myListIndex = index;
        this.init(host, parent, message, title, balloonType, arrowDirection);
    }

    private void init(JComponent host, Container initParent, String message, String titleText, int balloonType, int arrowDirection) {
        Container parent = initParent;
        if (parent != null && !this.isComponentValid(parent) && (parent = Balloon.searchAcceptableParent(parent)) == null) {
            throw new IllegalArgumentException("Parent must be instance of JWindow, JDialog, JFrame or JInternalFrame");
        }
        this.myListeners = new LinkedList<BalloonListener>();
        this.myParentFrame = parent;
        this.myBalloonMessage = message;
        this.myBalloonTitle = titleText;
        if (host == null) {
            throw new IllegalArgumentException("Host cannot be null");
        }
        this.setComponent(host);
        if (balloonType != 2 && balloonType != 0 && balloonType != 1) {
            throw new IllegalArgumentException("Type must be one of ERROR_BALLOON, INFO_BALLOON, WARNING_BALLOON");
        }
        this.myBalloonType = balloonType;
        if (arrowDirection != 0 && arrowDirection != 2 && arrowDirection != 1 && arrowDirection != 3) {
            throw new IllegalArgumentException("Arrow direction must be one of DEFAULT_ARROW, LEFT_UP_ARROW, RIGHT_DOWN_ARROW, RIGHT_UP_ARROW");
        }
        this.myArrowDirection = arrowDirection;
        BalloonMouseAdapter adapter = new BalloonMouseAdapter(this);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        this.setClosable(true);
        this.buildUI();
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Balloon.this.UICloseRequest();
            }
        });
        this.createBalloon();
        this.addPropertyChangeListener("closable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() == Balloon.this) {
                    Balloon.this.updateUI();
                    Balloon.this.revalidate();
                    Balloon.this.repaint();
                }
            }
        });
    }

    private boolean isComponentValid(Container parent) {
        return parent instanceof JWindow || parent instanceof JFrame || parent instanceof JDialog || parent instanceof JInternalFrame;
    }

    @Override
    public Component getMostRecentFocusOwner() {
        return null;
    }

    @Override
    public void restoreSubcomponentFocus() {
    }

    @Override
    public Component getFocusOwner() {
        return null;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    private static Container searchAcceptableParent(Component component) {
        Container acceptedParent = SwingUtilities.getAncestorOfClass(JInternalFrame.class, component);
        if (acceptedParent == null) {
            acceptedParent = SwingUtilities.getWindowAncestor(component);
        }
        return acceptedParent;
    }

    private void setComponent(JComponent component) {
        if (this.myComponent != null) {
            this.myComponent.removeAncestorListener(this.myBalloonUpdater);
        }
        this.myComponent = component;
        this.myComponent.addAncestorListener(this.myBalloonUpdater);
    }

    private void buildUI() {
        this.setUI(new BalloonUI(this));
        this.setVisible(false);
        this.setClosable(true);
        this.setOpaque(false);
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        MyLabel messageLabel = new MyLabel(this);
        messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        messageLabel.setText(this.myBalloonMessage);
        Dimension size = this.getBalloonDimension(messageLabel);
        this.setContentPane(new MyPanel(this));
        this.getContentPane().setLayout(new GridBagLayout());
        if (this.myBalloonTitle != null && this.myBalloonTitle.length() > 0) {
            this.setSize(size);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 15, 12, 0);
            gbc.weightx = 1.0;
            gbc.anchor = 23;
            this.getContentPane().add((Component)messageLabel, gbc);
        } else {
            this.setSize(new Dimension(size.width, size.height - messageLabel.getPreferredSize().height));
        }
    }

    private void createHyperlink(Action action) {
        if (action != null && this.myLink == null) {
            this.myLink = new MyHyperlink(this);
            this.setSize(new Dimension(this.getSize().width, this.getSize().height + this.myLink.getPreferredSize().height + 24));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.anchor = 23;
            this.getContentPane().add((Component)this.myLink, gbc);
        }
    }

    public void setUI(BalloonUI newUI) {
        super.setUI(newUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((BalloonUI)UIManager.getUI(this));
    }

    public int getBalloonType() {
        return this.myBalloonType;
    }

    public String getBalloonTitle() {
        return this.myBalloonTitle;
    }

    public void setAction(Action newAction) {
        if (newAction != null) {
            this.createHyperlink(newAction);
            this.myLink.setAction(newAction);
        }
    }

    public Action getAction() {
        if (this.myLink != null) {
            return this.myLink.getAction();
        }
        return null;
    }

    public void setLocationOffset(Point p) {
        this.myComponentXOffset = p.x;
        this.myComponentYOffset = p.y;
    }

    public void setLocationOffset(int x, int y) {
        this.myComponentXOffset = x;
        this.myComponentYOffset = y;
    }

    public Point getLocationOffset() {
        return new Point(this.myComponentXOffset, this.myComponentYOffset);
    }

    public void UICloseRequest() {
        if (!this.isClosable()) {
            return;
        }
        LinkedList<BalloonListener> copy = new LinkedList<BalloonListener>(this.myListeners);
        for (BalloonListener listener : copy) {
            listener.userClosedBalloon();
        }
        this.close();
    }

    public void close() {
        this.doDefaultCloseAction();
        if (this.myParentFrame instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)this.myParentFrame);
            JLayeredPane layeredPane = container.getLayeredPane();
            layeredPane.remove(this);
        }
        if (this.myListeners != null) {
            this.myListeners.clear();
        }
        this.myComponent.removeAncestorListener(this.myBalloonUpdater);
    }

    public void setCloseTimeoutOnDrag(boolean aFlag) {
        if (aFlag) {
            if (this.myListener == null) {
                this.myListener = new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        if (Balloon.this.myAutoCloseTimer != null && Balloon.this.myAutoCloseTimer.isRunning()) {
                            Balloon.this.myAutoCloseTimer.restart();
                        }
                    }
                };
            }
            this.addComponentListener(this.myListener);
        } else {
            this.removeComponentListener(this.myListener);
        }
    }

    public void showBalloon() {
        this.showBalloon(false);
    }

    public void showBalloon(boolean scrollHostVisible) {
        if (this.myAlphaTimer != null && this.myAlphaTimer.isRunning()) {
            return;
        }
        this.myScrollHostVisible = scrollHostVisible;
        if (!this.createBalloon()) {
            return;
        }
        if (this.myParentFrame instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)this.myParentFrame);
            JLayeredPane layeredPane = container.getLayeredPane();
            layeredPane.add(this);
        }
        this.toFront();
        this.myAlpha = 0.0f;
        if (this.getBorder() instanceof BalloonBorder) {
            ((BalloonBorder)this.getBorder()).setAlpha(0.0f);
        }
        this.myAlphaTimer = new Timer(0, new MyTimer());
        this.myAlphaTimer.setDelay(0);
        this.myAlphaTimer.start();
        this.setVisible(true);
    }

    public void showBalloon(int timeToShow) {
        this.showBalloon(timeToShow, false);
    }

    public void showBalloon(int timeToShow, boolean scrollHostVisible) {
        this.showBalloon(scrollHostVisible);
        if (this.myAutoCloseTimer == null) {
            this.myAutoCloseTimer = new Timer(timeToShow, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Balloon.this.close();
                }
            });
            this.myAutoCloseTimer.setRepeats(false);
        } else {
            this.myAutoCloseTimer.stop();
            this.myAutoCloseTimer.setDelay(timeToShow);
        }
        this.myAutoCloseTimer.start();
    }

    public void stopAutoCloseTimer() {
        if (this.myAutoCloseTimer != null) {
            this.myAutoCloseTimer.stop();
        }
    }

    public void addBalloonWidgetListener(BalloonListener observer) {
        this.myListeners.add(observer);
    }

    public void removeBalloonWidgetListener(BalloonListener observer) {
        this.myListeners.remove(observer);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite composite = AlphaComposite.getInstance(3, this.myAlpha);
        g2d.setComposite(composite);
        super.paintComponent(g);
        g2d.setComposite(ZEROALPHA);
    }

    public int getArrowDirection() {
        return this.myArrowDirection;
    }

    public String getBalloonMessage() {
        return this.myBalloonMessage;
    }

    public void attachBalloon() {
        this.myAttached = true;
        if (this.mySizeReduced) {
            this.mySizeReduced = false;
            int width = this.getSize().width;
            int height = this.getSize().height;
            height = height + this.myInsets.top + this.myInsets.bottom - 4 - 7;
            this.setSize(width, height);
        }
        this.createBalloon();
    }

    public JComponent getHost() {
        return this.myComponent;
    }

    public void relocateBalloon(JComponent component) {
        this.setComponent(component);
        this.attachBalloon();
    }

    public void relocateBalloon(JTable table, int row, int column) {
        this.setComponent(table);
        this.myTableColumn = column;
        this.myTableRow = row;
        this.attachBalloon();
    }

    public int getTableRow() {
        return this.myTableRow;
    }

    public int getTableColumn() {
        return this.myTableColumn;
    }

    private boolean createBalloon() {
        if (this.myAttached) {
            if (this.myParentFrame == null && this.myComponent != null) {
                this.myParentFrame = SwingUtilities.getWindowAncestor(this.myComponent);
            }
            if (this.myParentFrame == null || !this.myParentFrame.isShowing()) {
                return false;
            }
            int heightAdjustment = 0;
            int maxComponentX = this.myParentFrame.getWidth();
            int xLocationOnScreen = 0;
            int yLocationOnScreen = 0;
            if (this.myComponent instanceof JTable && this.myComponent.isShowing()) {
                JTable table = (JTable)this.myComponent;
                if (this.myScrollHostVisible && this.myTableRow >= 0) {
                    Container c = table.getParent();
                    if (c != null) {
                        c = c.getParent();
                    }
                    if (c != null && c instanceof JScrollPane) {
                        ((JScrollPane)c).scrollRectToVisible(this.myComponent.getBounds());
                    }
                    this.scrollToVisible(table, this.getTableRect(table));
                }
                Point tablePoint = table.getLocationOnScreen();
                Rectangle cellRect = this.getTableRect(table);
                xLocationOnScreen = cellRect.x + tablePoint.x;
                yLocationOnScreen = cellRect.y + tablePoint.y;
                if (this.myTableRow < 0 && table.getTableHeader() != null) {
                    yLocationOnScreen -= table.getTableHeader().getHeight();
                }
            } else if (this.myComponent instanceof JList && this.myComponent.isShowing()) {
                JList list = (JList)this.myComponent;
                if (this.myScrollHostVisible && this.myListIndex >= 0) {
                    Container c = list.getParent();
                    if (c != null) {
                        c = c.getParent();
                    }
                    if (c != null && c instanceof JScrollPane) {
                        ((JScrollPane)c).scrollRectToVisible(list.getCellBounds(this.myListIndex, this.myListIndex));
                    }
                    this.scrollToVisible(list, list.getCellBounds(this.myListIndex, this.myListIndex));
                }
                xLocationOnScreen = this.myComponent.getLocationOnScreen().x + list.getCellBounds((int)this.myListIndex, (int)this.myListIndex).x;
                yLocationOnScreen = this.myComponent.getLocationOnScreen().y + list.getCellBounds((int)this.myListIndex, (int)this.myListIndex).y;
            } else if (this.myComponent.isShowing()) {
                if (this.myScrollHostVisible) {
                    this.scrollToVisible(this.myComponent.getParent(), this.myComponent.getBounds());
                }
                xLocationOnScreen = this.myComponent.getLocationOnScreen().x;
                yLocationOnScreen = this.myComponent.getLocationOnScreen().y;
                if (!(this.myComponent instanceof JPanel)) {
                    heightAdjustment = this.myArrowDirection == 3 || this.myArrowDirection == 2 ? this.myComponent.getHeight() / 2 : 0;
                }
            } else {
                xLocationOnScreen = this.myComponentX > 0 ? this.myComponentX : Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2;
                yLocationOnScreen = this.myComponentY > 0 ? this.myComponentY : Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2;
            }
            this.setParametersForBalloon(maxComponentX, xLocationOnScreen, yLocationOnScreen);
            this.setLocation(this.myComponentX, this.myComponentY + heightAdjustment);
            BalloonBorder b = new BalloonBorder(this, this.myInsets, this.myAttached, this.myArrowDirection, this.myArrowOffset);
            b.setAlpha(1.0f);
            this.setBorder(b);
        }
        return true;
    }

    private Point getLocationOfParentInScreen() {
        if (this.myParentFrame instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.myParentFrame)).getLayeredPane().getLocationOnScreen();
        }
        return this.myParentFrame.getLocationOnScreen();
    }

    private Rectangle getTableRect(JTable table) {
        if (this.myTableRow < 0 && table.getTableHeader() != null) {
            return table.getTableHeader().getHeaderRect(this.myTableColumn);
        }
        return table.getCellRect(this.myTableRow, this.myTableColumn, true);
    }

    private void scrollToVisible(Container initContainer, Rectangle rectangle) {
        Container container = initContainer;
        while (container != null) {
            if (container instanceof JViewport) {
                ((JViewport)container).scrollRectToVisible(rectangle);
                container = null;
                continue;
            }
            rectangle.translate(container.getX(), container.getY());
            container = container.getParent();
        }
    }

    private Dimension getBalloonDimension(JLabel messageLabel) {
        int x = Math.max(messageLabel.getPreferredSize().width + 14 + 15 + 14, this.getPreferredSize().width + 14);
        int y = messageLabel.getPreferredSize().height + this.getPreferredSize().height + 11 + 18;
        return new Dimension(x, y);
    }

    private void setParametersForBalloon(int maxComponentX, int xLocationOnScreen, int yLocationOnScreen) {
        if (this.myArrowDirection == 0) {
            this.setParametersForDefaultArrowBalloon(maxComponentX, xLocationOnScreen, yLocationOnScreen);
        } else if (this.myArrowDirection == 1) {
            this.setParametersForRightDownArrowBalloon(maxComponentX, xLocationOnScreen, yLocationOnScreen);
        } else if (this.myArrowDirection == 3) {
            this.setParametersForRightUpBalloon(maxComponentX, xLocationOnScreen, yLocationOnScreen);
        }
        if (this.myArrowDirection == 2) {
            this.setParametersForLeftUpArrowBalloon(maxComponentX, xLocationOnScreen, yLocationOnScreen);
        }
        this.myComponentX -= this.myInsets.left;
        if (this.myComponentXOffset == 0 && (this.myArrowDirection == 0 || this.myArrowDirection == 2) && this.myParentFrame instanceof RootPaneContainer) {
            int componenLeftEdge;
            int componentRightEdge;
            int arrowPointerOffset;
            RootPaneContainer container = (RootPaneContainer)((Object)this.myParentFrame);
            JLayeredPane layeredPane = container.getLayeredPane();
            if (layeredPane != null && layeredPane.isShowing() && this.myComponent.isShowing() && this.myComponentX + (arrowPointerOffset = 27 + this.myArrowOffset + 11) > (componentRightEdge = (componenLeftEdge = this.myComponent.getLocationOnScreen().x - layeredPane.getLocationOnScreen().x) + this.myComponent.getWidth())) {
                this.myComponentX = componentRightEdge - arrowPointerOffset - this.myComponent.getWidth() / 2;
            }
        } else {
            this.myComponentX += this.myComponentXOffset;
        }
        this.myComponentY += this.myComponentYOffset;
        if (this.myComponentX < 0) {
            this.myComponentX = 0;
        }
        if (this.myComponentY < 0) {
            this.myComponentY = 0;
        }
    }

    private void setParametersForRightUpBalloon(int maxComponentX, int xLocationOnScreen, int yLocationOnScreen) {
        int preferredXSize = this.getSize().width;
        Point parentLocationInsScreen = this.getLocationOfParentInScreen();
        this.myComponentX = xLocationOnScreen - parentLocationInsScreen.x - preferredXSize + 20 + 40;
        this.myComponentY = yLocationOnScreen - parentLocationInsScreen.y + 10 + 2;
        this.myInsets = new Insets(11, 7, 7, 7);
        this.myArrowOffset = preferredXSize;
        if (this.myComponentX < 10) {
            this.myArrowOffset = xLocationOnScreen - this.myParentFrame.getLocationOnScreen().x + 20;
            if (this.myArrowOffset < 42) {
                this.myArrowOffset = 42;
            }
            this.myComponentX = 10;
        } else if (this.myComponentX + preferredXSize > maxComponentX) {
            this.myArrowOffset = this.myComponentX - maxComponentX + preferredXSize - 10;
            this.myComponentX = maxComponentX - preferredXSize - 20;
        }
    }

    private void setParametersForLeftUpArrowBalloon(int maxComponentX, int xLocationOnScreen, int yLocationOnScreen) {
        int preferredXSize = this.getSize().width;
        Point parentLocationInsScreen = this.getLocationOfParentInScreen();
        this.myComponentX = xLocationOnScreen - parentLocationInsScreen.x;
        this.myComponentY = yLocationOnScreen - parentLocationInsScreen.y + 10 + 3;
        this.myInsets = new Insets(11, 7, 7, 7);
        if (this.myComponentX < 0) {
            this.myArrowOffset = 10 - this.myComponentX;
            this.myComponentX = 10;
        } else if (this.myComponentX + preferredXSize > maxComponentX) {
            this.myArrowOffset = this.myComponentX - maxComponentX + preferredXSize;
            this.myComponentX = maxComponentX - preferredXSize;
        }
    }

    private void setParametersForRightDownArrowBalloon(int maxComponentX, int xLocationOnScreen, int yLocationOnScreen) {
        int preferredXSize = this.getSize().width;
        int preferredYSize = this.getSize().height;
        Point parentLocationInsScreen = this.getLocationOfParentInScreen();
        this.myComponentX = xLocationOnScreen - parentLocationInsScreen.x - preferredXSize + 20 + 40;
        this.myComponentY = yLocationOnScreen - parentLocationInsScreen.y - preferredYSize + 3;
        this.myInsets = new Insets(4, 7, 11, 7);
        this.myArrowOffset = preferredXSize;
        if (this.myComponentX < 10) {
            this.myArrowOffset = xLocationOnScreen - this.myParentFrame.getLocationOnScreen().x + 20;
            if (this.myArrowOffset < 42) {
                this.myArrowOffset = 42;
            }
            this.myComponentX = 10;
        } else if (this.myComponentX + preferredXSize > maxComponentX) {
            this.myArrowOffset = maxComponentX - this.myComponentX;
            this.myComponentX = maxComponentX - preferredXSize - 10;
        }
    }

    private void setParametersForDefaultArrowBalloon(int maxComponentX, int xLocationOnScreen, int yLocationOnScreen) {
        int preferredXSize = this.getSize().width;
        int preferredYSize = this.getSize().height;
        Point parentLocationInsScreen = this.getLocationOfParentInScreen();
        this.myComponentX = xLocationOnScreen - parentLocationInsScreen.x;
        this.myComponentY = yLocationOnScreen - parentLocationInsScreen.y - preferredYSize + 3;
        this.myInsets = new Insets(4, 7, 11, 7);
        if (this.myComponentY < 0) {
            this.myArrowDirection = 2;
        }
        if (this.myComponentX < 0) {
            this.myArrowOffset = 10 - this.myComponentX;
            this.myComponentX = 10;
        } else if (this.myComponentX + preferredXSize > maxComponentX) {
            this.myArrowOffset = -(maxComponentX - this.myComponentX - preferredXSize);
            this.myComponentX = maxComponentX - preferredXSize - 10;
        }
    }

    private static final class MyHyperlink
    extends Hyperlink {
        private Balloon myBalloon;

        private MyHyperlink(Balloon balloon) {
            this.myBalloon = balloon;
            this.setNegative(true);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 15, 12, 4));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite composite = AlphaComposite.getInstance(3, this.myBalloon.myAlpha);
            g2d.setComposite(composite);
            super.paintComponent(g);
            g2d.setComposite(ZEROALPHA);
        }
    }

    private static final class MyLabel
    extends PLabel {
        private Balloon myBalloon;

        private MyLabel(Balloon balloon) {
            this.myBalloon = balloon;
            this.setOpaque(false);
            this.setForeground(Color.WHITE);
            this.setFont(UIManager.getFont("BalloonInternalFrame.font"));
            this.setAutoTooltipEnabled(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite composite = AlphaComposite.getInstance(3, this.myBalloon.myAlpha);
            g2d.setComposite(composite);
            super.paintComponent(g);
            g2d.setComposite(ZEROALPHA);
        }
    }

    private static final class MyPanel
    extends JPanel {
        private Balloon balloon;

        private MyPanel(Balloon b) {
            this.balloon = b;
            this.setFocusable(false);
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite composite = AlphaComposite.getInstance(3, this.balloon.myAlpha);
            g2d.setComposite(composite);
            super.paintComponent(g);
            g2d.setComposite(ZEROALPHA);
        }
    }

    private class MyTimer
    implements ActionListener {
        private MyTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Balloon.this.myAlpha = SystemUtils.isEqual(Balloon.this.myAlpha, 0.0) ? 0.1f : (Balloon.this.myAlpha += 0.2f);
            if (Balloon.this.myAlpha > 1.0f) {
                Balloon.this.myAlpha = 1.0f;
                Balloon.this.myAlphaTimer.stop();
            }
            if (Balloon.this.getBorder() instanceof BalloonBorder) {
                ((BalloonBorder)Balloon.this.getBorder()).setAlpha(Balloon.this.myAlpha);
            }
            Balloon.this.repaint();
        }
    }
}

