/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.balloon;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.balloon.Balloon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

class BalloonBorder
extends AbstractBorder {
    private float myAlpha = 0.0f;
    protected static final int ARROW_HEIGHT = 11;
    protected static final int ARROW_HALF_WIDTH = 11;
    protected Insets myInsets = new Insets(4, 7, 11, 7);
    private boolean myAttached = true;
    private int myHeight;
    private int myArrowDirection = 0;
    protected static final int ARROW_START = 27;
    private int myArrowOffset = 0;

    protected BalloonBorder(boolean attached, int width, int height, int arrowDirection) {
        this.myAttached = attached;
        if (!attached) {
            this.myInsets = new Insets(4, 7, 7, 7);
        }
        this.myHeight = height;
        this.myArrowDirection = arrowDirection;
    }

    protected BalloonBorder(Balloon widget, Insets insets, boolean attached, int arrowDirection, int arrowOffset) {
        this(insets);
        this.myAttached = attached;
        this.myInsets = insets;
        this.myHeight = widget.getSize().height;
        this.myArrowDirection = arrowDirection;
        this.myArrowOffset = arrowOffset - 1;
    }

    protected BalloonBorder(Insets insets) {
        this.myInsets = insets;
    }

    public void setAlpha(float alpha) {
        this.myAlpha = alpha;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.myInsets;
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        newInsets.top = this.myInsets.top;
        newInsets.left = this.myInsets.left;
        newInsets.bottom = this.myInsets.bottom;
        newInsets.right = this.myInsets.right;
        return newInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        this.paintGradientDropShadow(c, g2d, x, y, width, height);
        if (this.myAttached) {
            this.paintBalloonArrow(g2d, this.myInsets);
        }
        g2d.setComposite(Balloon.ZEROALPHA);
    }

    public void paintGradientDropShadow(Component c, Graphics2D g2d, int x, int y, int w, int h) {
        int yTemp = y;
        int hTemp = h;
        Color[] shadow = (Color[])UIManager.get("Balloon.dropShadow");
        Insets shadowSize = new Insets(4, 7, 7, 7);
        if (this.myAttached) {
            if (this.myArrowDirection == 2 || this.myArrowDirection == 3) {
                yTemp += 11 - shadowSize.top;
                hTemp -= 11 - shadowSize.top;
            } else {
                hTemp -= 11 - shadowSize.bottom;
            }
        }
        NetUtils.drawDropShadow(g2d, shadow, shadowSize, x, yTemp, w, hTemp, 14);
    }

    private void paintBalloonArrow(Graphics2D g2d, Insets insets) {
        this.assignFillColor(g2d);
        Object oldAa = NetUtils.antiAliasingOn(g2d);
        if (this.myArrowDirection == 0) {
            this.paintLeftDownArrow(g2d, insets);
        } else if (this.myArrowDirection == 1) {
            this.paintRightDownArrow(g2d, insets);
        } else if (this.myArrowDirection == 2) {
            this.paintLeftUpArrow(g2d, insets);
        } else if (this.myArrowDirection == 3) {
            this.paintRightUpArrow(g2d);
        }
        NetUtils.setAntialiasing(g2d, oldAa);
    }

    private void paintLeftDownArrow(Graphics2D g2d, Insets insets) {
        GeneralPath path = new GeneralPath();
        path.moveTo(27 + this.myArrowOffset + 1 + 11, this.myHeight - insets.bottom + 11);
        path.lineTo(27 + this.myArrowOffset + 1, this.myHeight - insets.bottom);
        path.lineTo(27 + this.myArrowOffset + 22 + 1, this.myHeight - insets.bottom);
        g2d.fill(path);
    }

    private void paintLeftUpArrow(Graphics2D g2d, Insets insets) {
        GeneralPath path = new GeneralPath();
        path.moveTo(27 + this.myArrowOffset + 1 + 11, insets.top - 11);
        path.lineTo(27 + this.myArrowOffset + 1, insets.top);
        path.lineTo(27 + this.myArrowOffset + 22 + 1, insets.top);
        g2d.fill(path);
    }

    private void paintRightUpArrow(Graphics2D g2d) {
        GeneralPath path = new GeneralPath();
        path.moveTo(this.myArrowOffset - 27 - 11, this.myInsets.top - 11);
        path.lineTo(this.myArrowOffset - 27 - 22, this.myInsets.top);
        path.lineTo(this.myArrowOffset - 27, this.myInsets.top);
        g2d.fill(path);
    }

    private void paintRightDownArrow(Graphics2D g2d, Insets insets) {
        GeneralPath path = new GeneralPath();
        path.moveTo(this.myArrowOffset - 27 + 1, this.myHeight - insets.bottom);
        path.lineTo(this.myArrowOffset - 27 + 1 - 11, this.myHeight - insets.bottom + 11);
        path.lineTo(this.myArrowOffset - 27 - 22 + 2, this.myHeight - insets.bottom);
        g2d.fill(path);
    }

    private void assignFillColor(Graphics2D g2d) {
        Color[] balloonBackground = (Color[])UIManager.get("Balloon.backgroundGradient");
        Color background = this.myArrowDirection == 2 || this.myArrowDirection == 3 ? balloonBackground[0] : balloonBackground[1];
        g2d.setColor(background);
        AlphaComposite composite = AlphaComposite.getInstance(3, this.myAlpha);
        g2d.setComposite(composite);
    }
}

