/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.balloon;

import com.nokia.widgets.balloon.Balloon;
import com.nokia.widgets.balloon.BalloonBorder;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

class BalloonMouseAdapter
extends MouseInputAdapter {
    protected Balloon myBalloon;
    protected int myX;
    protected int myY;
    protected boolean myLocationChangedMouseDragging = false;
    protected static final int ARROW_HEIGHT = 11;
    private Container myBalloonParent;

    protected BalloonMouseAdapter(Balloon balloon) {
        this.myBalloon = balloon;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int y;
        int x;
        int arrowDirection = this.myBalloon.getArrowDirection();
        if ((arrowDirection == 2 || arrowDirection == 3) && !this.myBalloon.mySizeReduced || this.myLocationChangedMouseDragging) {
            x = e.getX() - this.myX + this.myBalloon.getX() + 7;
            y = e.getY() - this.myY + this.myBalloon.getY() + 11;
            this.myLocationChangedMouseDragging = true;
        } else {
            x = e.getX() - this.myX + this.myBalloon.getX();
            y = e.getY() - this.myY + this.myBalloon.getY();
        }
        this.myBalloonParent = this.myBalloon.getParent();
        this.myBalloon.setLocation(this.inBoundX(x), this.inBoundY(y));
        int width = this.myBalloon.getWidth();
        int height = this.myBalloon.getHeight();
        if (!this.myBalloon.mySizeReduced) {
            height = height - this.myBalloon.myInsets.top - this.myBalloon.myInsets.bottom + 4 + 7;
            this.myBalloon.setSize(width, height);
            this.myBalloon.mySizeReduced = true;
        }
        if (this.myBalloon.myAttached) {
            this.myBalloon.myAttached = false;
            BalloonBorder border = new BalloonBorder(this.myBalloon.myAttached, width, height, arrowDirection);
            border.setAlpha(1.0f);
            this.myBalloon.setBorder(border);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.myBalloon.toFront();
        this.myX = e.getX();
        this.myY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.myLocationChangedMouseDragging = false;
    }

    private int inBoundX(int x) {
        int pointX = x;
        if (x + this.myBalloon.getWidth() > this.myBalloonParent.getWidth()) {
            pointX = this.myBalloonParent.getWidth() - this.myBalloon.getWidth();
        }
        if (pointX < 0) {
            pointX = 0;
        }
        return pointX;
    }

    private int inBoundY(int y) {
        int pointY = y;
        if (y + this.myBalloon.getHeight() > this.myBalloonParent.getHeight()) {
            pointY = this.myBalloonParent.getHeight() - this.myBalloon.getHeight();
        }
        if (y < 0) {
            pointY = 0;
        }
        return pointY;
    }
}

