/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.balloon;

import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.balloon.Balloon;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.labels.PLabel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RectangularShape;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BalloonUI
extends BasicInternalFrameUI {
    private String myTitle = null;
    private Balloon myBalloon;

    public BalloonUI(Balloon widget) {
        super(widget);
        this.myBalloon = widget;
        this.myTitle = widget.getBalloonTitle();
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        return this.createTitleBar();
    }

    public static ComponentUI createUI(JComponent comp) {
        return new BalloonUI((Balloon)comp);
    }

    public String getPropertyPrefix() {
        return "BalloonInternalframe.";
    }

    public void close() {
        this.myBalloon.UICloseRequest();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        RectangularShape internals = NetUtils.getOutline(c);
        internals.setFrame(insets.left, insets.top, internals.getWidth() - (double)(insets.left + insets.right) + 1.0, internals.getHeight() - (double)(insets.top + insets.bottom) + 1.0);
        GradientUtils.drawVerticalGradient(c, g, "Balloon.backgroundGradient", (Shape)internals);
        this.paint(g, c);
    }

    private JPanel createTitleBar() {
        this.uninstallListeners();
        MyPanel titlePanel = new MyPanel();
        titlePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 10, 8, 10);
        c.anchor = 23;
        MyLabel titleLabel = new MyLabel(null);
        titleLabel.setHorizontalAlignment(10);
        if (this.myTitle != null && this.myTitle.length() > 0) {
            Font f = UIManager.getFont("BalloonInternalFrame.titleFont");
            titleLabel.setFont(f);
            titleLabel.setForeground(Color.WHITE);
            titleLabel.setText(this.myTitle);
        } else {
            titleLabel.setText(this.myBalloon.getBalloonMessage());
        }
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(12, 15, 0, 4);
        c.anchor = 23;
        titlePanel.add((Component)titleLabel, c);
        CloseIcon closeIcon = new CloseIcon();
        closeIcon.setSize(16);
        closeIcon.setPaintRoundBackground(true);
        closeIcon.setMargin(5);
        closeIcon.setStrokeWidth(2);
        if (this.myBalloon.isClosable()) {
            CloseButton closeButton = new CloseButton((Icon)closeIcon);
            closeButton.setRolloverIcon(closeIcon);
            c.gridx = 3;
            c.gridy = 0;
            c.insets = new Insets(14, 2, 0, 10);
            c.anchor = 24;
            titlePanel.add((Component)closeButton, c);
        }
        return titlePanel;
    }

    private final class CloseButton
    extends JButton {
        private Dimension myDimension;

        CloseButton(Icon icon) {
            super(icon);
            this.setOpaque(false);
            this.myDimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BalloonUI.this.close();
                }
            });
            this.setContentAreaFilled(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myDimension;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.myDimension;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.myDimension;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite composite = AlphaComposite.getInstance(3, ((BalloonUI)BalloonUI.this).myBalloon.myAlpha);
            g2d.setComposite(composite);
            super.paintComponent(g);
            g2d.setComposite(Balloon.ZEROALPHA);
        }
    }

    private final class MyLabel
    extends PLabel {
        private MyLabel(Icon icon) {
            super(icon);
            this.setAutoTooltipEnabled(false);
            this.setForeground(Color.WHITE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite composite = AlphaComposite.getInstance(3, ((BalloonUI)BalloonUI.this).myBalloon.myAlpha);
            g2d.setComposite(composite);
            super.paintComponent(g);
            g2d.setComposite(Balloon.ZEROALPHA);
        }
    }

    private final class MyPanel
    extends JPanel {
        private MyPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            this.setOpaque(false);
            AlphaComposite composite = AlphaComposite.getInstance(3, ((BalloonUI)BalloonUI.this).myBalloon.myAlpha);
            g2d.setComposite(composite);
            super.paintComponent(g);
            g2d.setComposite(Balloon.ZEROALPHA);
        }
    }
}

