/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.buttons;

import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.PArrowIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class DropDownToolButton
extends PToolButton
implements MouseListener {
    private JPopupMenu popupMenu = null;
    private static Icon ARROW_ICON = null;
    private static Icon DISABLED_ARROW_ICON = null;
    private static Color disabledColor = UIManager.getColor("Button.disabledText");
    private boolean isActionAllowed = true;
    private int DROP_DOWN_AREA_WIDTH = 16;
    private int ARROW_SIZE = 4;

    public DropDownToolButton() {
        this(null, null);
    }

    public DropDownToolButton(String text) {
        this(text, null);
    }

    public DropDownToolButton(Action action) {
        super(action);
        this.init();
    }

    public DropDownToolButton(Icon icon) {
        this(null, icon);
    }

    public DropDownToolButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    protected void init() {
        this.setModel(new MyModel());
        this.addMouseListener(this);
        ARROW_ICON = new PArrowIcon(this.DROP_DOWN_AREA_WIDTH, this.DROP_DOWN_AREA_WIDTH, this.ARROW_SIZE, Color.DARK_GRAY, 5);
        DISABLED_ARROW_ICON = new PArrowIcon(this.DROP_DOWN_AREA_WIDTH, this.DROP_DOWN_AREA_WIDTH, 4, disabledColor, 5);
        this.setMargin(new Insets(1, 1, 1, this.DROP_DOWN_AREA_WIDTH));
        this.setIconTextGap(2);
    }

    @Override
    public Component add(Component component) {
        if (component != null && component instanceof JPopupMenu) {
            this.popupMenu = (JPopupMenu)component;
            this.popupMenu.setInvoker(this);
        } else {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.popupMenu.setInvoker(this);
            }
            this.popupMenu.add(component);
        }
        return component;
    }

    public void addSeparator() {
        if (this.popupMenu != null) {
            this.popupMenu.addSeparator();
        }
    }

    public void openPopupMenu() {
        if (this.popupMenu != null && this.isEnabled()) {
            Point topLeftCorner = this.getLocationOnScreen();
            this.popupMenu.setLocation(topLeftCorner.x, topLeftCorner.y + this.getHeight() - 1);
            this.popupMenu.setVisible(true);
        }
    }

    public void closePopupMenu() {
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (ARROW_ICON != null) {
            int x = this.getWidth() - this.DROP_DOWN_AREA_WIDTH;
            if (this.isEnabled()) {
                ARROW_ICON.paintIcon(null, g, x - 1, (this.getHeight() - 2 - this.DROP_DOWN_AREA_WIDTH) / 2);
            } else {
                DISABLED_ARROW_ICON.paintIcon(null, g, x - 1, (this.getHeight() - 2 - this.DROP_DOWN_AREA_WIDTH) / 2);
            }
            if (this.model.isRollover() && !this.model.isPressed() || this.model.isArmed() && this.isEnabled()) {
                g.setColor(Color.GRAY);
                g.drawLine(x, 4, x, this.getHeight() - 5);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.isActionAllowed = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getPoint().x > this.getWidth() || e.getPoint().x < 0 || e.getPoint().y > this.getHeight() || e.getPoint().y < 0) {
            return;
        }
        if (e.getPoint().x > this.getWidth() - this.DROP_DOWN_AREA_WIDTH) {
            this.openPopupMenu();
        } else {
            this.isActionAllowed = true;
            this.model.setPressed(true);
            this.model.setArmed(true);
            this.model.setPressed(false);
            this.model.setArmed(false);
        }
    }

    private class MyModel
    extends DefaultButtonModel {
        private MyModel() {
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (DropDownToolButton.this.isActionAllowed) {
                super.fireActionPerformed(e);
            }
        }
    }
}

