/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.buttons;

import com.nokia.laf.NetButtonUI;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.buttons.PulldownPopupMenuBorder;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.layout.DelegateLayoutManager2;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class MenuButton
extends PToolButton
implements PopupMenuListener {
    private static final String CLOSE_POPUP_BINDING = "closePopup";
    private static final int DROP_DOWN_AREA_WIDTH = 24;
    private static final Insets DEFAULT_MARGIN = new Insets(6, 18, 8, 30);
    private static final Insets DEFAULT_MARGIN_SPLITBUTTON = new Insets(6, 18, 8, 42);
    private static final Insets DEFAULT_SMALL_MARGIN = new Insets(4, 10, 4, 22);
    private static final Insets DEFAULT_SMALL_MARGIN_SPLITBUTTON = new Insets(4, 10, 4, 34);
    private static final Insets DEFAULT_TOOLBAR_MARGIN = new Insets(0, 4, 0, 15);
    protected JPopupMenu myPopupMenu;
    private static PArrowIcon ARROW_ICON = new PArrowIcon(4, 5, Color.decode("#6E6E6E"));
    private static PArrowIcon HOVER_ARROW_ICON = new PArrowIcon(4, 5, NetTheme.getHoverColor());
    private static PArrowIcon DISABLED_ARROW_ICON = new PArrowIcon(4, 5, UIManager.getColor("Button.disabledText"));
    private static PArrowIcon WHITE_ARROW_ICON = new PArrowIcon(4, 5, NetLookAndFeel.getWhite());
    private static String IS_PULL_DOWN = "OrangeTouch.isPulldown";
    private static String POPUP_ABOVE_COMBO = "OrangeTouch.popupAboveCombo";
    public boolean myIsSplitButton = false;
    private int myMouseXLocation = -1;
    private ChangeListener myMenuChangeListener;
    private boolean myArrowIconVisible = true;

    public MenuButton() {
        this.initMenuButton();
    }

    public MenuButton(String text) {
        super(text);
        this.initMenuButton();
    }

    public MenuButton(String text, Icon icon) {
        super(text, icon);
        this.initMenuButton();
    }

    public MenuButton(Icon icon) {
        super(icon);
        this.initMenuButton();
    }

    protected void initMenuButton() {
        this.setUI(MenuButtonUI.createUI(this));
        this.myPopupMenu = new JPopupMenu();
        this.configurePopupMenu();
        JComboBox comboBox = new JComboBox();
        this.putClientProperty("doNotCancelPopup", comboBox.getClientProperty("doNotCancelPopup"));
        this.setMargin(DEFAULT_MARGIN);
        this.setToolButton(false);
        this.setHorizontalTextPosition(10);
        MouseHandler mouseHandler = new MouseHandler();
        this.removeAllListeners();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("DOWN"), "openPopup");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("SPACE"), "openPopup");
        this.getActionMap().put("openPopup", new OpenPopupAction());
        this.myMenuChangeListener = new MenuButtonPopupChangeListener();
    }

    public void setArrowIconVisible(boolean visible) {
        boolean oldValue = this.myArrowIconVisible;
        this.myArrowIconVisible = visible;
        if (this.myArrowIconVisible != oldValue) {
            this.setMargin();
        }
    }

    public boolean isArrowIconVisible() {
        return this.myArrowIconVisible;
    }

    private void removeAllListeners() {
        MouseListener[] mouseListenerArray = (MouseListener[])this.getListeners(MouseListener.class);
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener event = mouseListenerArray[n2];
            if (event instanceof MouseHandler) {
                this.removeMouseListener(event);
            }
            ++n2;
        }
    }

    protected void configurePopupMenu() {
        LayoutManager layout = this.myPopupMenu.getLayout();
        if (layout instanceof LayoutManager2) {
            this.myPopupMenu.setLayout(new MenuButtonPopupLayout((LayoutManager2)layout));
        }
        this.myPopupMenu.setBorder(new PulldownPopupMenuBorder());
        this.myPopupMenu.putClientProperty(IS_PULL_DOWN, true);
        this.myPopupMenu.putClientProperty(POPUP_ABOVE_COMBO, false);
        this.myPopupMenu.setInvoker(this);
        this.myPopupMenu.addPopupMenuListener(this);
    }

    @Override
    public void updateUI() {
        this.setUI(MenuButtonUI.createUI(this));
    }

    @Override
    public void setSizeVariant(String sizeVariant) {
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
        this.setMargin();
    }

    private void setMargin() {
        if (!this.myArrowIconVisible) {
            this.setMargin(new Insets(3, 3, 3, 3));
        } else if (ComponentUtils.isSmall(this)) {
            this.setMargin(this.myIsSplitButton ? DEFAULT_SMALL_MARGIN_SPLITBUTTON : DEFAULT_SMALL_MARGIN);
        } else {
            this.setMargin(this.myIsSplitButton ? DEFAULT_MARGIN_SPLITBUTTON : DEFAULT_MARGIN);
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!DEFAULT_MARGIN.equals(this.getMargin()) && !DEFAULT_TOOLBAR_MARGIN.equals(this.getMargin())) {
            return;
        }
        if (this.getParent() instanceof JToolBar) {
            this.setMargin(DEFAULT_TOOLBAR_MARGIN);
        } else {
            this.setMargin(ComponentUtils.isSmall(this) ? DEFAULT_SMALL_MARGIN : DEFAULT_MARGIN);
        }
    }

    public JMenuItem add(JMenuItem menuItem) {
        return this.myPopupMenu.add(menuItem);
    }

    public void addSeparator() {
        this.myPopupMenu.addSeparator();
    }

    @Override
    public Component add(Component component) {
        this.myPopupMenu.add(component);
        return component;
    }

    public JPopupMenu add(JPopupMenu component) {
        LayoutManager layout;
        if (this.myPopupMenu != null) {
            this.myPopupMenu.removePopupMenuListener(this);
        }
        this.myPopupMenu = component;
        this.myPopupMenu.putClientProperty(IS_PULL_DOWN, true);
        if (this.myPopupMenu.getBorder() instanceof UIResource) {
            this.myPopupMenu.setBorder(new PulldownPopupMenuBorder());
        }
        if ((layout = component.getLayout()) instanceof LayoutManager2 && layout instanceof UIResource) {
            this.myPopupMenu.setLayout(new MenuButtonPopupLayout((LayoutManager2)layout));
        }
        this.myPopupMenu.setInvoker(this);
        this.myPopupMenu.addPopupMenuListener(this);
        return component;
    }

    public void setSplitButton(boolean splitButton) {
        boolean oldValue = this.myIsSplitButton;
        this.myIsSplitButton = splitButton;
        if (this.myIsSplitButton) {
            this.setMargin(DEFAULT_SMALL_MARGIN_SPLITBUTTON);
        } else {
            this.setMargin(DEFAULT_SMALL_MARGIN);
        }
        if (oldValue != splitButton) {
            this.revalidate();
            this.repaint();
        }
        this.firePropertyChange("splitButton", oldValue, this.myIsSplitButton);
    }

    public boolean isSplitButton() {
        return this.myIsSplitButton;
    }

    public void setPopupMenuVisible(boolean visible) {
        JRootPane rootPane;
        boolean isVisible = this.isPopupMenuVisible();
        if (visible == isVisible) {
            return;
        }
        this.getPopupMenu().putClientProperty("OceanTouch.isPulldown", true);
        if (this.isEnabled() && !ComponentUtils.isReadOnly(this) || !visible) {
            if (visible && this.isShowing()) {
                Point p = this.getPopupMenuLocation();
                this.getPopupMenu().putClientProperty("OceanTouch.popupHeight", this.getPopupMenu().getPreferredSize().height);
                this.getPopupMenu().show(this, p.x, p.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
        MenuSelectionManager.defaultManager().removeChangeListener(this.myMenuChangeListener);
        if (visible && (rootPane = this.getPopupMenu().getRootPane()) != null) {
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("SPACE"), CLOSE_POPUP_BINDING);
            rootPane.getActionMap().put(CLOSE_POPUP_BINDING, new ClosePopupAction());
            MenuSelectionManager.defaultManager().addChangeListener(this.myMenuChangeListener);
        }
    }

    public boolean isPopupMenuVisible() {
        return this.myPopupMenu.isVisible();
    }

    public JPopupMenu getPopupMenu() {
        return this.myPopupMenu;
    }

    public void openPopupMenu() {
        this.setPopupMenuVisible(true);
    }

    public void closePopupMenu() {
        this.setPopupMenuVisible(false);
    }

    @Override
    public void doClick() {
        int oldXLocation = this.myMouseXLocation;
        this.myMouseXLocation = -1;
        super.doClick();
        this.myMouseXLocation = oldXLocation;
    }

    private boolean isMouseOnSplitButtonPopupArea() {
        return this.isSplitButton() && this.myMouseXLocation > 0 && this.myMouseXLocation > this.getWidth() - 24;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myArrowIconVisible) {
            this.paintArrowIcon(g);
        }
        if (this.isSplitButton()) {
            this.paintSplitter(g);
        }
    }

    private void paintArrowIcon(Graphics g) {
        PArrowIcon icon = this.getArrowIcon();
        icon.setArrowSize(ComponentUtils.isSmall(this) ? 4 : 5);
        if (icon == ARROW_ICON) {
            WHITE_ARROW_ICON.setArrowSize(ComponentUtils.isSmall(this) ? 4 : 5);
            WHITE_ARROW_ICON.paintIcon(this, g, this.getWidth() - ARROW_ICON.getIconWidth() - 12, this.getHeight() / 2 - ARROW_ICON.getIconHeight() / 2);
        }
        icon.paintIcon(this, g, this.getWidth() - ARROW_ICON.getIconWidth() - 12, this.getHeight() / 2 - ARROW_ICON.getIconHeight() / 2 - 1);
    }

    protected PArrowIcon getArrowIcon() {
        PArrowIcon icon = ARROW_ICON;
        if (this.isEnabled()) {
            if (this.isFocusOwner()) {
                icon = WHITE_ARROW_ICON;
            } else if (this.isSplitButton()) {
                if (this.isMouseOnSplitButtonPopupArea()) {
                    icon = HOVER_ARROW_ICON;
                }
            } else if (this.model.isRollover()) {
                icon = HOVER_ARROW_ICON;
            }
        } else {
            icon = DISABLED_ARROW_ICON;
        }
        return icon;
    }

    private void paintSplitter(Graphics g) {
        if (!this.isToolButton() || this.model.isRollover() && !this.model.isPressed() || this.model.isArmed() && this.isEnabled()) {
            int offset = this.getModel().isPressed() && this.model.isArmed() ? 0 : 0;
            int x = this.getWidth() - 24;
            if (this.getParent() instanceof JToolBar) {
                ++x;
            }
            if (this.model.isRollover() && !this.model.isPressed()) {
                g.setColor(NetTheme.getHoverColor());
            } else {
                g.setColor(NetTheme.getComponentOutlineColor());
            }
            g.drawLine(x + offset, 1 + offset, x + offset, this.getHeight() - 5 + offset);
        }
    }

    protected Point getPopupMenuLocation() {
        PulldownPopupMenuBorder border;
        int x = -1;
        int y = 0;
        JPopupMenu popupMenu = this.getPopupMenu();
        Dimension size = this.getSize();
        Dimension popupSize = popupMenu.getSize();
        if (popupSize.width == 0) {
            popupSize = popupMenu.getPreferredSize();
        }
        if (popupMenu.getBorder() instanceof PulldownPopupMenuBorder && (border = (PulldownPopupMenuBorder)popupMenu.getBorder()).isRightAligned()) {
            x -= popupSize.width - this.getWidth() - 2;
        }
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        int idx = 0;
        while (idx < gd.length) {
            GraphicsConfiguration dgc;
            if (gd[idx].getType() == 0 && (dgc = gd[idx].getDefaultConfiguration()).getBounds().contains(position)) {
                gc = dgc;
                break;
            }
            ++idx;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            position.x -= Math.abs(screenInsets.left);
            position.y -= Math.abs(screenInsets.top);
        }
        if (ComponentUtils.isLeftToRight(this)) {
            if (position.x + x + popupSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - size.width < 2 * (position.x - screenBounds.x)) {
                x = size.width - popupSize.width - 1;
            }
        } else {
            x = size.width - popupSize.width;
            if (position.x + x < screenBounds.x && screenBounds.width - size.width > 2 * (position.x - screenBounds.x)) {
                x = 0;
            }
        }
        if (position.y + (y = size.height - 4) + popupSize.height >= screenBounds.height && screenBounds.height - size.height < 2 * (position.y - screenBounds.y)) {
            y = -popupSize.height + 1;
        }
        return new Point(x, y);
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        this.myMouseXLocation = -1;
        super.processKeyEvent(event);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        this.myMouseXLocation = event.getX();
        super.processMouseEvent(event);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.putClientProperty("OrangeTouch.isStraightBottomEdge", true);
        this.repaint();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.putClientProperty("OrangeTouch.isStraightBottomEdge", false);
        this.putClientProperty("OrangeTouch.isStraightTopEdge", false);
        this.repaint();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.putClientProperty("OrangeTouch.isStraightBottomEdge", false);
        this.putClientProperty("OrangeTouch.isStraightTopEdge", false);
        this.repaint();
    }

    protected class ClosePopupAction
    extends AbstractAction {
        protected ClosePopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuButton.this.closePopupMenu();
        }
    }

    protected class MenuButtonPopupChangeListener
    implements ChangeListener {
        protected MenuButtonPopupChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            MenuSelectionManager msm = (MenuSelectionManager)evt.getSource();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length == 0 || !path[0].getComponent().equals(MenuButton.this.getPopupMenu())) {
                return;
            }
            JRootPane rootPane = MenuButton.this.myPopupMenu.getRootPane();
            if (rootPane != null) {
                rootPane.getInputMap().remove(KeyStroke.getKeyStroke("SPACE"));
                rootPane.getActionMap().remove(MenuButton.CLOSE_POPUP_BINDING);
            }
        }
    }

    private static class MenuButtonPopupLayout
    extends DelegateLayoutManager2 {
        public MenuButtonPopupLayout(LayoutManager2 layout) {
            super(layout);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension result = super.preferredLayoutSize(parent);
            Component invoker = ((JPopupMenu)parent).getInvoker();
            result.width = Math.max(result.width, invoker.getWidth() + 3);
            return result;
        }
    }

    private static class MenuButtonUI
    extends NetButtonUI {
        static MenuButtonUI theButtonUI = new MenuButtonUI();

        private MenuButtonUI() {
        }

        public static ComponentUI createUI(JComponent comp) {
            return theButtonUI;
        }

        @Override
        protected boolean isPressed(AbstractButton button) {
            return super.isPressed(button) || ((MenuButton)button).getPopupMenu().isVisible();
        }
    }

    protected class MouseHandler
    extends MouseInputAdapter {
        boolean isMouseDragged = false;

        protected MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.isMouseDragged = true;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!(MenuButton.this.isSplitButton() && !MenuButton.this.isMouseOnSplitButtonPopupArea() || this.isMouseDragged)) {
                MenuButton.this.setPopupMenuVisible(!MenuButton.this.isPopupMenuVisible());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((!MenuButton.this.isSplitButton() || MenuButton.this.isMouseOnSplitButtonPopupArea()) && this.isMouseDragged) {
                MenuButton.this.setPopupMenuVisible(!MenuButton.this.isPopupMenuVisible());
            }
            this.isMouseDragged = false;
            if (!SwingUtilities.getLocalBounds(e.getComponent()).contains(e.getPoint())) {
                MenuButton.this.setPopupMenuVisible(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MenuButton.this.myMouseXLocation = -1;
            MenuButton.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MenuButton.this.myMouseXLocation = e.getX();
            MenuButton.this.repaint();
        }
    }

    protected class OpenPopupAction
    extends AbstractAction {
        protected OpenPopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuButton.this.openPopupMenu();
        }
    }
}

