/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.buttons;

import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class PulldownPopupMenuBorder
extends AbstractBorder {
    private int myHorizontalAlignment = 2;

    public PulldownPopupMenuBorder() {
        this(2);
    }

    public boolean isRightAligned() {
        return this.myHorizontalAlignment == 4;
    }

    public PulldownPopupMenuBorder(int horizontalAlignment) {
        this.myHorizontalAlignment = horizontalAlignment;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets newInsets) {
        super.getBorderInsets(comp, newInsets);
        newInsets.top = 4;
        newInsets.left = 4;
        newInsets.bottom = 10;
        newInsets.right = 4;
        this.adjustInsets(newInsets, (JComponent)comp);
        return newInsets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        JPopupMenu popupMenu = (JPopupMenu)c;
        Object oldAa = NetUtils.antiAliasingOn(g);
        int rounding = NetTheme.getComponentOutlineRounding(popupMenu);
        boolean isPopupAboveCombo = ClientPropertyUtil.booleanValue(popupMenu, "OrangeTouch.popupAboveCombo");
        Insets shadowInsets = isPopupAboveCombo ? new Insets(4, 4, 0, 4) : new Insets(0, 4, 4, 4);
        this.paintShadow(g2d, x, y, width, height, rounding, shadowInsets, isPopupAboveCombo);
        this.fillTopCap(g2d, popupMenu, x, y, width, height, rounding, shadowInsets, isPopupAboveCombo);
        this.fillBottomCap(g2d, popupMenu, x, y, width, height, rounding, shadowInsets, isPopupAboveCombo);
        this.paintOutline(g2d, x, y, width, height, popupMenu, rounding, shadowInsets, isPopupAboveCombo);
        NetUtils.setAntialiasing(g, oldAa);
    }

    private void fillTopCap(Graphics2D g, JPopupMenu popupMenu, int x, int y, int width, int height, int rounding, Insets shadowInsets, boolean isPopupAboveCombo) {
        Area topShape = new Area(this.getPopupOutline(popupMenu, x, y, width, height, rounding, shadowInsets, isPopupAboveCombo));
        topShape.intersect(new Area(new Rectangle2D.Double(x, y, width, 10.0)));
        NetUtils.fillShapeInPopup(popupMenu, g, topShape);
    }

    private void fillBottomCap(Graphics2D g, JPopupMenu popupMenu, int x, int y, int width, int height, int rounding, Insets shadowInsets, boolean isPopupAboveCombo) {
        Area bottomShape = new Area(this.getPopupOutline(popupMenu, x, y, width, height, rounding, shadowInsets, isPopupAboveCombo));
        bottomShape.intersect(new Area(new Rectangle2D.Double(x, y + height - shadowInsets.bottom - 6, width, 8.0)));
        NetUtils.fillShapeInPopup(popupMenu, g, bottomShape);
    }

    private void paintShadow(Graphics2D g2d, int x, int y, int width, int height, int rounding, Insets shadowInsets, boolean isPopupAboveCombo) {
        Color[] colors = (Color[])UIManager.get("PopupMenu.shadow");
        if (isPopupAboveCombo) {
            BufferedImage image = ImageUtils.createCompatibleTranslucentImage(width, height);
            Graphics2D imageGraphics = image.createGraphics();
            NetUtils.drawDropShadow(imageGraphics, colors, new Insets(0, 4, 4, 4), x, y, width, height, rounding);
            imageGraphics.dispose();
            g2d.drawImage((Image)ImageUtils.createFlippedImage(image), x, y, null);
        } else {
            NetUtils.drawDropShadow(g2d, colors, shadowInsets, x, y, width, height, rounding);
        }
    }

    private void paintOutline(Graphics2D g2d, int x, int y, int width, int height, JPopupMenu popupMenu, int rounding, Insets shadowInsets, boolean isPopupAboveCombo) {
        g2d.setColor(NetTheme.getComponentOutlineColor());
        Shape shape = this.getPopupOutline(popupMenu, x, y, width, height, rounding, shadowInsets, isPopupAboveCombo);
        g2d.draw(shape);
    }

    private Shape getPopupOutline(JPopupMenu popupMenu, int x, int y, int width, int height, int rounding, Insets shadowInsets, boolean isPopupAboveCombo) {
        boolean isPopupWiderThanInvoker = popupMenu.getWidth() > popupMenu.getInvoker().getWidth() + rounding;
        int innerX = x + shadowInsets.left;
        int innerWidth = width - (shadowInsets.left + shadowInsets.right);
        int innerHeight = height - (shadowInsets.bottom + shadowInsets.top);
        if (isPopupWiderThanInvoker) {
            int sharpCorner;
            int n = sharpCorner = isPopupAboveCombo ? 6 : 8;
            if (this.myHorizontalAlignment == 4) {
                sharpCorner = isPopupAboveCombo ? 4 : 2;
            }
            return NetUtils.getRoundedRectWithSharpCorner(popupMenu, innerX - 1, y + shadowInsets.top, innerWidth + 2, innerHeight, rounding, sharpCorner);
        }
        return NetUtils.getRoundedRect(popupMenu, innerX - 1, y + shadowInsets.top, innerWidth + 2, innerHeight, rounding, isPopupAboveCombo ? 5 : 1);
    }

    private void adjustInsets(Insets newInsets, JComponent jComp) {
        boolean isPopupAboveCombo = ClientPropertyUtil.booleanValue(jComp, "OrangeTouch.popupAboveCombo");
        if (isPopupAboveCombo) {
            int oldTop = newInsets.top;
            newInsets.top = newInsets.bottom;
            newInsets.bottom = oldTop;
        }
    }
}

