/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart;

import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.AxisComputedProperties;
import com.nokia.widgets.chart.AxisPropertiesCalculator;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.DefaultAxisPropertiesCalculator;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.util.SystemUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.DateFormatter;
import javax.swing.text.NumberFormatter;

public final class AxisFactory {
    private static final int DEFAULT_VALUE_LABEL_INTERVAL = 1;
    private static final int DEFAULT_VALUE_LABEL_COUNT = 11;
    public static final double EXTRA_PERCENTAGE = 10.0;
    private static final int DEFAULT_MAX_VALUE_LABLES = 20;
    private static final int MAX_FRACTION_DIGITS_FOR_SMALL_NUMBERS = 5;
    private static NumberFormat DEFAULT_SCIENTIFIC_NOTATION_FORMAT;
    private static final Set<Integer> PREFERRED_AXIS_DIVISORS;
    private static final AxisPropertiesCalculator myAxisPropertiesCalculator;
    private static boolean myIsNewAxisComputationUsed;

    static {
        PREFERRED_AXIS_DIVISORS = new HashSet<Integer>(Arrays.asList(1, 2, 5));
        myAxisPropertiesCalculator = new DefaultAxisPropertiesCalculator(PREFERRED_AXIS_DIVISORS, 11);
        myIsNewAxisComputationUsed = false;
    }

    private AxisFactory() {
    }

    public static Axis createAxis(int type, String label, List<?> data) {
        AxisModel axis = AxisFactory.initializeAxisModel(type, label);
        axis.setValues((List)data);
        axis.setValueLineCount(data.size());
        return axis;
    }

    public static Axis createDoubleAxis(int type, String label, List data) {
        if (!AxisFactory.checkIsValidDoubleData(data)) {
            throw new IllegalArgumentException("The data has to contain only Double or Float objects.");
        }
        AxisModel axis = AxisFactory.initializeAxisModel(type, label);
        Collections.sort(data);
        double max = Double.parseDouble(data.get(data.size() - 1).toString());
        if (SystemUtils.isEqual(max, ChartConstants.VALUE_NOT_SHOWN)) {
            data.remove(data.size() - 1);
        }
        if (myIsNewAxisComputationUsed) {
            AxisFactory.setAxisComputedProperties(axis, data);
        } else {
            AxisFactory.setAxisMaxValues(axis, data);
        }
        AxisFactory.setDoubleNumberFormatter(axis);
        return axis;
    }

    public static Axis createLongAxis(int type, String label, List data) {
        AxisModel axis = AxisFactory.initializeAxisModel(type, label);
        Collections.sort(data);
        if (type == 0 || type == 1) {
            if (myIsNewAxisComputationUsed) {
                AxisFactory.setAxisComputedProperties(axis, data);
            } else {
                AxisFactory.setAxisMaxValues(axis, data);
            }
        } else {
            axis.setValues(data);
        }
        return axis;
    }

    private static void setAxisComputedProperties(AxisModel axis, List data) {
        AxisComputedProperties properties = myAxisPropertiesCalculator.computeProperties(data);
        axis.setMaxValue(properties.getMaxValue());
        axis.setMinValue(properties.getMinValue());
        axis.setValueLineCount(properties.getGridLinesCount());
    }

    private static AxisModel initializeAxisModel(int type, String label) {
        AxisModel axis = new AxisModel();
        axis.setType(type);
        axis.setLabel(label);
        axis.setValueLabelInterval(1);
        return axis;
    }

    public static Axis createDateAxis(int type, String label, List<?> data) {
        Axis axis = AxisFactory.createAxis(type, label, data);
        axis.setDataFormatter(new DateFormatter());
        return axis;
    }

    private static void setAxisMaxValues(AxisModel axis, List<?> data) {
        if (data.size() == 0) {
            axis.setMaxValue(0.1);
            axis.setMinValue(0.0);
            axis.setValueLineCount(2);
            return;
        }
        if (Double.parseDouble(data.get(0).toString()) >= 0.0) {
            axis.setMaxValue(AxisFactory.calculateAxisMaxValue(axis, true, new BigDecimal(data.get(data.size() - 1).toString()).abs()).doubleValue());
            axis.setMinValue(0.0);
        } else if (Double.parseDouble(data.get(data.size() - 1).toString()) <= 0.0) {
            axis.setMaxValue(0.0);
            axis.setMinValue(-AxisFactory.calculateAxisMaxValue(axis, true, new BigDecimal(data.get(0).toString()).abs()).doubleValue());
        } else {
            BigDecimal max = AxisFactory.calculateAxisMaxValue(axis, false, new BigDecimal(data.get(data.size() - 1).toString()).abs());
            BigDecimal min = AxisFactory.calculateAxisMaxValue(axis, false, new BigDecimal(data.get(0).toString()).abs());
            AxisFactory.scaleMaxValues(axis, min, max);
            return;
        }
        if (axis.getValueLineCount() == 0) {
            axis.setValueLineCount(11);
        }
    }

    private static void scaleMaxValues(AxisModel axis, BigDecimal minD, BigDecimal maxD) {
        int scaleMin;
        BigDecimal min = minD;
        BigDecimal max = maxD;
        int scaleMax = AxisFactory.getScale(max);
        if (scaleMax < (scaleMin = AxisFactory.getScale(min))) {
            max = max.scaleByPowerOfTen(-scaleMin).setScale(0, RoundingMode.UP).scaleByPowerOfTen(scaleMin);
        } else {
            min = min.scaleByPowerOfTen(-scaleMax).setScale(0, RoundingMode.UP).scaleByPowerOfTen(scaleMax);
        }
        BigDecimal sum = min.add(max);
        BigDecimal lineCount = sum.scaleByPowerOfTen(scaleMax > scaleMin ? -scaleMax : -scaleMin);
        int i = 1;
        BigDecimal maxValueLines = new BigDecimal(20);
        while (lineCount.compareTo(maxValueLines) == 1) {
            max = max.scaleByPowerOfTen(-i).setScale(0, RoundingMode.UP).scaleByPowerOfTen(i);
            min = min.scaleByPowerOfTen(-i).setScale(0, RoundingMode.UP).scaleByPowerOfTen(i);
            sum = min.add(max);
            lineCount = sum.scaleByPowerOfTen(-i).setScale(0, RoundingMode.UP);
            ++i;
        }
        axis.setMaxValue(max.doubleValue());
        axis.setMinValue(-min.doubleValue());
        axis.setValueLineCount(lineCount.add(BigDecimal.ONE).intValue());
    }

    public static void setDoubleNumberFormatter(AxisModel axis) {
        NumberFormat format = null;
        double maxValue = Math.max((Double)axis.getMaxValue(), Math.abs((Double)axis.getMinValue()));
        if (maxValue > 1.0 || Double.isNaN(maxValue)) {
            format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(1);
            if (maxValue < 20.0) {
                format.setMinimumFractionDigits(1);
            }
        } else {
            double mantissa = AxisFactory.getMantissa(maxValue);
            int power = AxisFactory.getPowerOfTen(maxValue);
            if (Math.abs(power) < 5) {
                StringBuffer s = new StringBuffer();
                s.append("0.0");
                int ix = 0;
                while (ix < Math.abs(power)) {
                    s.append("0");
                    ++ix;
                }
                if (mantissa * 10.0 < 20.0) {
                    s.append("0");
                }
                if (axis.getValueLineCount() > 20) {
                    s.append("0");
                }
                format = new DecimalFormat(s.toString());
            } else {
                format = DEFAULT_SCIENTIFIC_NOTATION_FORMAT;
            }
        }
        axis.setDataFormatter(new NumberFormatter(format));
    }

    public static void setActivateNewAxisComputation(boolean isActivated) {
        myIsNewAxisComputationUsed = isActivated;
    }

    private static boolean checkIsValidDoubleData(List<?> data) {
        int i = 0;
        while (i < data.size()) {
            if (!(data.get(i) instanceof Double) && !(data.get(i) instanceof Float)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static double getMantissa(double value) {
        if (new Double(value).isNaN()) {
            throw new IllegalArgumentException("Can't get mantissa for value 'Double.NaN'");
        }
        AxisFactory.initScientificFormatterIfNeeded();
        String strValue = DEFAULT_SCIENTIFIC_NOTATION_FORMAT.format(value);
        int eIndex = strValue.indexOf("E");
        return Double.valueOf(strValue.substring(0, eIndex));
    }

    private static int getPowerOfTen(double value) {
        if (new Double(value).isNaN()) {
            throw new IllegalArgumentException("Can't get mantissa for value 'Double.NaN'");
        }
        AxisFactory.initScientificFormatterIfNeeded();
        String strValue = DEFAULT_SCIENTIFIC_NOTATION_FORMAT.format(value);
        int eIndex = strValue.indexOf("E");
        return Integer.valueOf(strValue.substring(eIndex + 1));
    }

    private static void initScientificFormatterIfNeeded() {
        if (DEFAULT_SCIENTIFIC_NOTATION_FORMAT == null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            DEFAULT_SCIENTIFIC_NOTATION_FORMAT = new DecimalFormat("0.0#E0", symbols);
        }
    }

    public static BigDecimal calculateAxisMaxValue(Axis axis, boolean incrementInSmallSteps, BigDecimal maxValue) {
        return maxValue.compareTo(BigDecimal.ONE) <= 0 ? AxisFactory.findMaxForSmallValue(axis, incrementInSmallSteps, maxValue) : AxisFactory.findMaxForBigValue(axis, incrementInSmallSteps, maxValue);
    }

    private static BigDecimal findMaxForBigValue(Axis axis, boolean incrementInSmallSteps, BigDecimal maxValue) {
        BigDecimal smallIncrement;
        if (incrementInSmallSteps && (smallIncrement = AxisFactory.scaleBigValueToFindDivisor(axis, maxValue)) != null) {
            return smallIncrement;
        }
        BigDecimal scaled = maxValue;
        int scale = AxisFactory.getScale(scaled);
        scale = scale < 0 ? 0 : scale;
        scaled = scaled.movePointLeft(scale);
        int roundPrecision = maxValue.compareTo(new BigDecimal(10)) < 0 || !maxValue.toString().startsWith("1") ? 1 : 2;
        scaled = scaled.add(new BigDecimal(1));
        scaled = scaled.round(new MathContext(roundPrecision, RoundingMode.DOWN));
        return scaled.movePointRight(scale);
    }

    private static BigDecimal findMaxForSmallValue(Axis axis, boolean incrementInSmallSteps, BigDecimal value) {
        BigDecimal smallIncrement;
        if (incrementInSmallSteps && (smallIncrement = AxisFactory.scaleSmallValueToFindDivisor(axis, value)) != null) {
            return smallIncrement;
        }
        BigDecimal scaled = value;
        scaled = scaled.round(new MathContext(4));
        int decimals = AxisFactory.getZeroDecimalCount(scaled);
        scaled = scaled.movePointRight(decimals - 1);
        int roundPrecision = (scaled = scaled.add(BigDecimal.valueOf(1.01))).compareTo(new BigDecimal(10)) < 0 || !scaled.toPlainString().startsWith("1") ? 1 : 2;
        if (!(scaled = scaled.round(new MathContext(roundPrecision, RoundingMode.DOWN))).equals(value.round(new MathContext(1, RoundingMode.HALF_UP)))) {
            scaled = scaled.movePointLeft(decimals - 1);
        }
        return scaled;
    }

    private static BigDecimal scaleBigValueToFindDivisor(Axis axis, BigDecimal maxValue) {
        BigDecimal scaled = maxValue;
        int scale = AxisFactory.getScale(scaled);
        scaled = scaled.movePointLeft(scale - 1);
        scaled = scaled.round(new MathContext(2, RoundingMode.HALF_UP));
        return AxisFactory.increaseMaxInLoopToFindDivisor(axis, maxValue, scaled, scale);
    }

    private static BigDecimal scaleSmallValueToFindDivisor(Axis axis, BigDecimal value) {
        BigDecimal scaled = value;
        scaled = scaled.round(new MathContext(4));
        int decimals = AxisFactory.getZeroDecimalCount(scaled);
        scaled = scaled.movePointRight(decimals);
        BigDecimal max = AxisFactory.increaseMaxInLoopToFindDivisor(axis, value, scaled = scaled.round(new MathContext(2, RoundingMode.HALF_UP)), 1);
        return max != null ? max.movePointLeft(decimals) : null;
    }

    private static BigDecimal increaseMaxInLoopToFindDivisor(Axis axis, BigDecimal maxValue, BigDecimal scaled, int scale) {
        BigDecimal tempValue = scaled;
        int add = 0;
        while (add < 9) {
            int i = 10;
            while (i > 0) {
                if (tempValue.doubleValue() % (double)i == 0.0 && tempValue.doubleValue() / (double)i <= 11.0 && tempValue.doubleValue() >= maxValue.movePointLeft(scale - 1).doubleValue()) {
                    int tics = (int)tempValue.doubleValue() / i == 1 ? 10 : (int)tempValue.doubleValue() / i;
                    axis.setValueLineCount(tics + 1);
                    tempValue = tempValue.movePointRight(scale - 1);
                    return tempValue;
                }
                --i;
            }
            tempValue = tempValue.add(BigDecimal.ONE);
            ++add;
        }
        return null;
    }

    private static int getScale(BigDecimal scalableValue) {
        if (scalableValue.compareTo(new BigDecimal(10)) < 0) {
            return 0;
        }
        String value = new Long(scalableValue.longValue()).toString();
        return value.startsWith("1") ? value.length() - 2 : value.length() - 1;
    }

    private static int getZeroDecimalCount(BigDecimal scaled) {
        String value = scaled.toPlainString();
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) != '0' && value.charAt(i) != '.') {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

