/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.AxisFactory;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphRenderer;
import com.nokia.widgets.chart.data.XYDataSet;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.chart.impl.ChartView;
import com.nokia.widgets.chart.impl.GraphValueRange;
import com.nokia.widgets.chart.renderers.CascadedAreaGraphRenderer;
import com.nokia.widgets.chart.renderers.CascadedColumnGraphRenderer;
import com.nokia.widgets.chart.renderers.ClusteredColumnGraphRenderer;
import com.nokia.widgets.chart.renderers.ColumnGraphRenderer;
import com.nokia.widgets.chart.renderers.ContourGraphRenderer;
import com.nokia.widgets.chart.renderers.LineGraphRenderer;
import com.nokia.widgets.chart.renderers.PieChartRenderer;
import com.nokia.widgets.chart.renderers.StackedAreaGraphRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import java.util.Random;

public class ChartFactory {
    public static Chart createXYLineChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, new LineGraphRenderer(), showLegend, dynamicUpdates);
        view.setProperty("GraphType", "LineGraph");
        return view;
    }

    public static Chart createXYColumnChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, new ColumnGraphRenderer(), showLegend, dynamicUpdates);
        view.setProperty("spaceonaxisend", true);
        view.setProperty("GraphType", "ColumnGraph");
        return view;
    }

    public static Chart createXYStackedAreaChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, new StackedAreaGraphRenderer(), showLegend, dynamicUpdates);
        view.setProperty("GraphType", "StackedAreaGraph");
        return view;
    }

    public static Chart createXYClusteredColumnChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, new ClusteredColumnGraphRenderer(), showLegend, dynamicUpdates);
        view.setProperty("spaceonaxisend", true);
        view.setProperty("GraphType", "ClusteredColumnGraph");
        return view;
    }

    public static Chart createContourChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates) {
        return ChartFactory.doCreateContourChart(chartTitle, xLabel, yLabel, dataSet, showLegend, dynamicUpdates, new ContourGraphRenderer());
    }

    public static Chart createContourChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates, List<GraphValueRange> valueRanges) {
        ContourGraphRenderer renderer = new ContourGraphRenderer();
        renderer.setValueRanges(valueRanges);
        return ChartFactory.doCreateContourChart(chartTitle, xLabel, yLabel, dataSet, showLegend, dynamicUpdates, renderer);
    }

    private static Chart doCreateContourChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates, ContourGraphRenderer renderer) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, renderer, showLegend, dynamicUpdates);
        view.setProperty("spaceonaxisend", true);
        view.setProperty("GraphType", "ContourChart");
        return view;
    }

    public static Chart createChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, GraphRenderer renderer, boolean showLegend, boolean dynamicUpdates) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, renderer, showLegend, dynamicUpdates);
        if (renderer instanceof CascadedAreaGraphRenderer) {
            view.setProperty("GraphType", "CascadedAreaGraph");
        } else if (renderer instanceof CascadedColumnGraphRenderer) {
            view.setProperty("GraphType", "CascadedColumnGraph");
        } else {
            view.setProperty("GraphType", "OtherGraphType");
        }
        return view;
    }

    public static Chart createPieChart(Object chartTitle, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates, String pieSize) {
        Chart view = ChartFactory.createDefaultView(chartTitle, null, null, dataSet, new PieChartRenderer(), showLegend, dynamicUpdates);
        view.setProperty("GraphType", "PieChart");
        view.setProperty("PieSize", pieSize);
        view.setProperty("showlegend", showLegend);
        if (showLegend) {
            int rowCount = "LargePie".equals(pieSize) ? ChartConstants.DEFAULT_LARGE_PIE_CHART_LEGEND_BOX_ROW_COUNT : ChartConstants.DEFAULT_SMALL_PIE_CHART_LEGEND_BOX_ROW_COUNT;
            int columnCount = dataSet.getSeriesCount() / rowCount;
            columnCount = dataSet.getSeriesCount() % rowCount == 0 ? columnCount : columnCount + 1;
            Font labelFont = "LargePie".equals(pieSize) ? ChartConstants.DEFAULT_CHART_AXIS_VALUE_LABEL_FONT : ChartConstants.DEFAULT_CHART_AXIS_VALUE_LABEL_FONT.deriveFont(12.0f);
            view.setProperty("axisvaluefont", labelFont);
            view.setProperty("Location", "East");
            view.setProperty("legendboxshowcheckbox", false);
            view.setProperty("legendboxcolumncount", columnCount);
            view.setProperty("legendboxshowborder", false);
        }
        return view;
    }

    private static Chart createDefaultView(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, GraphRenderer renderer, boolean showLegend, boolean dynamicUpdates) {
        Axis horizontalAxis = null;
        Axis leftVerticalAxis = null;
        XYSeries firstSeries = dataSet.getAllSeries().get(0);
        XYPair firstPair = firstSeries.getXYPairs().get(0);
        horizontalAxis = firstPair.isXFloatingPointNumber() ? AxisFactory.createDoubleAxis(2, xLabel, dataSet.getXValues()) : (firstPair.isXIntegerNumber() ? AxisFactory.createLongAxis(2, xLabel, dataSet.getXValues()) : AxisFactory.createAxis(2, xLabel, dataSet.getDefaultXAxisValues()));
        leftVerticalAxis = firstPair.isYFloatingPointNumber() ? AxisFactory.createDoubleAxis(0, yLabel, dataSet.getYValues()) : (firstPair.isYIntegerNumber() ? AxisFactory.createLongAxis(0, yLabel, dataSet.getYValues()) : AxisFactory.createAxis(0, yLabel, dataSet.getDefaultYAxisValues()));
        Random r = new Random(3L);
        ChartView view = new ChartView(chartTitle, (AxisModel)horizontalAxis, (AxisModel)leftVerticalAxis, null);
        ((AxisModel)leftVerticalAxis).addAxisModelListener(view);
        ((AxisModel)horizontalAxis).addAxisModelListener(view);
        int i = 0;
        while (i < dataSet.getAllSeries().size()) {
            XYSeries series = dataSet.getAllSeries().get(i);
            if (series.getColor() == null) {
                if (i < ChartConstants.DEFAULT_CHART_COLORS.length) {
                    series.setColor(ChartConstants.DEFAULT_CHART_COLORS[i][0], ChartConstants.DEFAULT_CHART_COLORS[i][1]);
                } else {
                    Color color = new Color(r.nextInt(200), r.nextInt(200), r.nextInt(255));
                    series.setColor(color, NetUtils.darker(color, 0.85));
                }
            }
            ++i;
        }
        if (renderer != null) {
            view.setDataSet(dataSet, true, renderer, dynamicUpdates);
        } else {
            view.setDataSet(dataSet, true, dynamicUpdates);
        }
        view.setProperty("showlegend", showLegend);
        view.setProperty("AllowAccessoryMouseFunctions", ChartConstants.DEFAULT_CHART_ALLOW_ACCESSORY_MOUSE_FUNCTIONS);
        return view;
    }

    public static Chart createCompositeChart(Object chartTitle, String xLabel, String yLabel, XYDataSet dataSet, boolean showLegend, boolean dynamicUpdates) {
        Chart view = ChartFactory.createDefaultView(chartTitle, xLabel, yLabel, dataSet, null, showLegend, dynamicUpdates);
        view.setProperty("GraphType", "CompositeGraph");
        return view;
    }

    public static Chart createXYLineSparkline(XYSeries series) {
        Chart sparkline = ChartFactory.createXYLineChart(null, null, null, new XYDataSet(series), false, false);
        ChartFactory.setSparklineProperties(sparkline);
        return sparkline;
    }

    public static Chart createXYColumnSparkline(XYSeries series) {
        Chart sparkline = ChartFactory.createXYColumnChart(null, null, null, new XYDataSet(series), false, false);
        ChartFactory.setSparklineProperties(sparkline);
        return sparkline;
    }

    public static Chart createXYColumnSparkline(XYDataSet dataSet) {
        Chart sparkline = ChartFactory.createXYColumnChart(null, null, null, dataSet, false, false);
        ChartFactory.setSparklineProperties(sparkline);
        return sparkline;
    }

    public static Chart createXYStackedAreaSparkline(XYSeries series) {
        Chart sparkline = ChartFactory.createXYStackedAreaChart(null, null, null, new XYDataSet(series), false, false);
        ChartFactory.setSparklineProperties(sparkline);
        return sparkline;
    }

    private static void setSparklineProperties(Chart sparkline) {
        sparkline.setProperty("sparkline", true);
        sparkline.setProperty("showleftyaxis", false);
        sparkline.setProperty("showrightyaxis", false);
        sparkline.setProperty("showxaxis", false);
        sparkline.setProperty("hidexaxis", true);
        sparkline.setProperty("hideyaxis", true);
        sparkline.setProperty("gridvisibility", 3);
        sparkline.setProperty("showValueMarkers", false);
        sparkline.setProperty("chartMargin", new Insets(0, 0, 0, 0));
        sparkline.setProperty("bordercolor", null);
        sparkline.setProperty("linewidth", Float.valueOf(1.0f));
        sparkline.setProperty("ShowHighlightLegend", false);
        sparkline.setProperty("graphtooltip", false);
        sparkline.setProperty("bordercolor", Color.WHITE);
        sparkline.getView().setPreferredSize(new Dimension(70, 30));
        sparkline.setProperty("chartbackgroundcolor", null);
        sparkline.getView().setOpaque(false);
    }
}

