/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart;

import com.nokia.widgets.PButtonPane;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;

public class ChartPropertiesDialog
extends JDialog {
    private PTextField myXAxisLabelField;
    private PTextField myYAxisLabelField;
    private PComboBox myXValueOrientation;
    private PComboBox myYValueOrientation;
    private JCheckBox myShowHighLightedArea;
    private PButton myHighLightedAreaColor;
    private PTextField myHighLightedAreaToolTip;
    private PSpinner myTickMarkLenght;
    private JCheckBox myShowLegendArea;
    private PComboBox myLegendAreaLocation;
    private PSpinner myLegendAreaColumns;
    private PComboBox myFirstLegendAreaItemAlign;
    private PButton myGridColor;
    private PComboBox myPaintGrid;
    private PButton myBackGroundColors;
    private JCheckBox myGradientPaint;
    private JCheckBox myShowToolTips;
    private PSpinner myValueMarkerSize;
    private PSpinner myLineWidth;
    private PButton myAxisColor;
    private Chart myChart;
    private Map<String, Object> myChartPropertiesMap;

    public ChartPropertiesDialog(Chart c, Frame parent) {
        super(parent, WidgetResources.getString("ChartPropertiesDialog.DialogTitleText"), false);
        this.init(c);
    }

    public ChartPropertiesDialog(Chart c, JDialog d) {
        super(d, WidgetResources.getString("ChartPropertiesDialog.DialogTitleText"), false);
        this.init(c);
    }

    private void init(Chart c) {
        this.myChartPropertiesMap = new HashMap<String, Object>();
        this.myChart = c;
        this.buildUI();
    }

    private void restrictControllers() {
        this.myHighLightedAreaColor.setEnabled(this.myShowHighLightedArea.isSelected());
        this.myHighLightedAreaToolTip.setEnabled(this.myShowHighLightedArea.isSelected());
        this.myLegendAreaLocation.setEnabled(this.myShowLegendArea.isSelected());
        this.myLegendAreaColumns.setEnabled(this.myShowLegendArea.isSelected());
        this.myFirstLegendAreaItemAlign.setEnabled(this.myShowLegendArea.isSelected());
        this.myGridColor.setEnabled(!this.myPaintGrid.getSelectedItem().equals(WidgetResources.getString("ChartPropertiesDialog.SelectionNone")));
    }

    private void buildUI() {
        this.myXAxisLabelField = new PTextField();
        this.myYAxisLabelField = new PTextField();
        this.myXValueOrientation = new PComboBox();
        this.myYValueOrientation = new PComboBox();
        this.myShowHighLightedArea = new JCheckBox();
        this.myHighLightedAreaColor = new PButton("Choose..");
        this.myHighLightedAreaToolTip = new PTextField();
        this.myTickMarkLenght = new PSpinner();
        this.myShowLegendArea = new JCheckBox();
        this.myLegendAreaLocation = new PComboBox();
        this.myLegendAreaColumns = new PSpinner();
        this.myFirstLegendAreaItemAlign = new PComboBox();
        this.myGridColor = new PButton("Choose..");
        this.myPaintGrid = new PComboBox();
        this.myBackGroundColors = new PButton("Choose..");
        this.myGradientPaint = new JCheckBox();
        this.myShowToolTips = new JCheckBox();
        this.myValueMarkerSize = new PSpinner();
        this.myLineWidth = new PSpinner();
        this.myAxisColor = new PButton("Choose..");
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.useHeaderInsets();
        panel.add((Component)PLabel.createTitle(WidgetResources.getString("ChartPropertiesDialog.CommonSettingsTitle")), gbc);
        gbc.nextRowSameColumn();
        gbc.useNormalInsets();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.XAxisLabelTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myXAxisLabelField, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.YAxisLabelTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myYAxisLabelField, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.XValueLabelOrientationTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myXValueOrientation, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.YValueLabelOrientationTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myYValueOrientation, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.ShowHighLightedAreaTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myShowHighLightedArea, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.HighlightedAreaColorTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myHighLightedAreaColor, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.HighlightedAreaTooltipTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myHighLightedAreaToolTip, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.AxisTicMarkLengthTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myTickMarkLenght, gbc);
        gbc.nextRow();
        gbc.useHeaderInsets();
        panel.add((Component)PLabel.createTitle(WidgetResources.getString("ChartPropertiesDialog.LegendAreaSettingsTitle")), gbc);
        gbc.useNormalInsets();
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.ShowLegendAreaTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myShowLegendArea, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.LegendAreaColumnsTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myLegendAreaColumns, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.LegendBoxLocationTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myLegendAreaLocation, gbc);
        gbc.nextRow();
        panel.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.FirstLegendItemAlignTitle")), gbc);
        gbc.nextColumn();
        panel.add((Component)this.myFirstLegendAreaItemAlign, gbc);
        gbc = new ExtendedGridBagConstraints();
        gbc.fillHorizontal();
        JPanel panel2 = new JPanel(new GridBagLayout());
        gbc.useHeaderInsets();
        panel2.add((Component)PLabel.createTitle(WidgetResources.getString("ChartPropertiesDialog.GraphSettingsTitle")), gbc);
        gbc.nextRow();
        gbc.useNormalInsets();
        panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.PaintGridLinesTitle")), gbc);
        gbc.nextColumn();
        panel2.add((Component)this.myPaintGrid, gbc);
        gbc.nextRow();
        panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.GridColorTitle")), gbc);
        gbc.nextColumn();
        panel2.add((Component)this.myGridColor, gbc);
        gbc.nextRow();
        panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.AxisColorTitle")), gbc);
        gbc.nextColumn();
        panel2.add((Component)this.myAxisColor, gbc);
        gbc.nextRow();
        panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.ChartBackgroundColorTitle")), gbc);
        gbc.nextColumn();
        panel2.add((Component)this.myBackGroundColors, gbc);
        gbc.nextRow();
        gbc.useHeaderInsets();
        panel2.add((Component)PLabel.createTitle(WidgetResources.getString("ChartPropertiesDialog.GraphTypeSpecificSettingsTitle")), gbc);
        gbc.nextRow();
        gbc.useNormalInsets();
        Object type = this.myChart.getProperty("GraphType");
        if (type.equals("LineGraph")) {
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.ShowTooltipsTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myShowToolTips, gbc);
            gbc.nextRow();
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.ValueMarkerSizetitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myValueMarkerSize, gbc);
            gbc.gridx = gbc.gridx - 1;
            gbc.gridy = gbc.gridy + 1;
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.LineWidthTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myLineWidth, gbc);
            gbc.nextRow();
        } else if (type.equals("ColumnGraph")) {
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.GradientPaintTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myGradientPaint, gbc);
            gbc.nextRow();
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.ShowToolTipsTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myShowToolTips, gbc);
            gbc.nextRow();
        } else if (type.equals("StackedAreaGraph")) {
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.GradientPaintTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myGradientPaint, gbc);
            gbc.nextRow();
        } else if (type.equals("ClusteredColumnGraph")) {
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.GradientPaintTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myGradientPaint, gbc);
            gbc.nextColumn();
        } else if (type.equals("CascadedAreaGraph")) {
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.GradientPaintTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myGradientPaint, gbc);
            gbc.nextRow();
        } else if (type.equals("CascadedColumnGraph")) {
            panel2.add((Component)PLabel.createSystemText(WidgetResources.getString("ChartPropertiesDialog.GradientPaintTitle")), gbc);
            gbc.nextColumn();
            panel2.add((Component)this.myGradientPaint, gbc);
            gbc.nextRow();
        } else {
            panel2.add((Component)PLabel.createLabel("-"), gbc);
        }
        ExtendedGridBagConstraints gbc2 = new ExtendedGridBagConstraints();
        gbc2.anchor = 11;
        gbc2.useSpecificInsets(new Insets(6, 6, 6, 6));
        this.getContentPane().add((Component)panel, gbc2);
        gbc2.nextColumn();
        this.getContentPane().add((Component)panel2, gbc2);
        gbc2.useSpecificInsets(new Insets(0, 0, 0, 0));
        JButton okButton = new JButton(WidgetResources.getString("ChartPropertiesDialog.ApplyButtonText"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPropertiesDialog.this.commitModifications();
            }
        });
        JButton cancelButton = new JButton(WidgetResources.getString("ChartPropertiesDialog.CloseButtonText"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPropertiesDialog.this.dispose();
            }
        });
        AbstractButton[] b = new AbstractButton[]{okButton, cancelButton};
        PButtonPane pane = new PButtonPane(null, null, b);
        gbc2.nextRow();
        gbc2.setColumnWidth(2);
        gbc2.fill = 2;
        this.getContentPane().add((Component)pane, gbc2);
        this.prepareComponents();
        this.loadInitialValues();
        this.myPaintGrid.addActionListener(new NotifyingActionListener());
        this.myShowLegendArea.addActionListener(new NotifyingActionListener());
        this.myShowHighLightedArea.addActionListener(new NotifyingActionListener());
        this.myBackGroundColors.addActionListener(new CustomActionListener("chartbackgroundcolor"));
        this.myAxisColor.addActionListener(new CustomActionListener("axiscolor"));
        this.myGridColor.addActionListener(new CustomActionListener("gridcolor"));
        this.myHighLightedAreaColor.addActionListener(new CustomActionListener("ChartHighLightColor"));
        this.restrictControllers();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void commitModifications() {
        this.myChart.setProperty("ChartHighLightColor", this.myChartPropertiesMap.get("ChartHighLightColor"));
        this.myChart.setProperty("HighLightToolTipKey", this.myHighLightedAreaToolTip.getText());
        this.myChart.setProperty("legendboxcolumncount", (Integer)this.myLegendAreaColumns.getValue());
        this.myChart.setProperty("axiscolor", this.myChartPropertiesMap.get("axiscolor"));
        Double tempDouble = new Double(this.myTickMarkLenght.getValue().toString());
        this.myChart.setProperty("valuelinelengthkey", tempDouble);
        this.myChart.setProperty("gridcolor", this.myChartPropertiesMap.get("gridcolor"));
        this.myChart.setProperty("chartbackgroundcolor", this.myChartPropertiesMap.get("chartbackgroundcolor"));
        this.myChart.getAxis(2).setLabel(this.myXAxisLabelField.getText());
        this.myChart.getAxis(0).setLabel(this.myYAxisLabelField.getText());
        this.myChart.setProperty("showlegend", this.myShowLegendArea.isSelected());
        this.myChart.setProperty("ShowHighLight", this.myShowHighLightedArea.isSelected());
        Object loc = this.myLegendAreaLocation.getSelectedItem();
        String val = loc.equals("North") ? "North" : (loc.equals("South") ? "South" : (loc.equals("East") ? "East" : "West"));
        this.myChart.setProperty("Location", val);
        this.myChart.setProperty("firstseriesontopleftcorner", this.myFirstLegendAreaItemAlign.getSelectedIndex() == 0);
        loc = this.myPaintGrid.getSelectedItem();
        int i = loc.equals(WidgetResources.getString("ChartPropertiesDialog.SelectionHorizontal")) ? 1 : (loc.equals(WidgetResources.getString("ChartPropertiesDialog.SelectionVertical")) ? 2 : (loc.equals(WidgetResources.getString("ChartPropertiesDialog.SelectionNone")) ? 3 : 0));
        this.myChart.setProperty("gridvisibility", i);
        this.myChart.setProperty("gradientpaint", this.myGradientPaint.isSelected());
        this.myChart.setProperty("graphtooltip", this.myShowToolTips.isSelected());
        this.myChart.setProperty("valuemarker", new Double(this.myValueMarkerSize.getValue().toString()));
        this.myChart.setProperty("linewidth", new Float(this.myLineWidth.getValue().toString()));
        if (this.myXValueOrientation.getSelectedItem().toString().compareTo(WidgetResources.getString("ChartPropertiesDialog.SelectionHorizontal")) == 0) {
            this.myChart.getAxis(2).setValueLabelOrientation(0);
        } else if (this.myXValueOrientation.getSelectedItem().toString().compareTo(WidgetResources.getString("ChartPropertiesDialog.SelectionVertical")) == 0) {
            this.myChart.getAxis(2).setValueLabelOrientation(90);
        } else {
            this.myChart.getAxis(2).setValueLabelOrientation(45);
        }
        if (this.myYValueOrientation.getSelectedItem().toString().compareTo(WidgetResources.getString("ChartPropertiesDialog.SelectionHorizontal")) == 0) {
            this.myChart.getAxis(0).setValueLabelOrientation(0);
        } else if (this.myYValueOrientation.getSelectedItem().toString().compareTo(WidgetResources.getString("ChartPropertiesDialog.SelectionVertical")) == 0) {
            this.myChart.getAxis(0).setValueLabelOrientation(90);
        } else {
            this.myChart.getAxis(0).setValueLabelOrientation(45);
        }
        this.myChart.getView().revalidate();
        this.myChart.getView().repaint();
    }

    private void prepareComponents() {
        this.myXValueOrientation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionHorizontal"));
        this.myXValueOrientation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionVertical"));
        this.myXValueOrientation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionRotated"));
        this.myYValueOrientation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionHorizontal"));
        this.myYValueOrientation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionVertical"));
        this.myYValueOrientation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionRotated"));
        this.myLegendAreaLocation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionSouth"));
        this.myLegendAreaLocation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionNorth"));
        this.myLegendAreaLocation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionEast"));
        this.myLegendAreaLocation.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionWest"));
        this.myFirstLegendAreaItemAlign.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionTopLeftCorner"));
        this.myFirstLegendAreaItemAlign.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionBottomRightCorner"));
        this.myPaintGrid.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionBoth"));
        this.myPaintGrid.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionHorizontal"));
        this.myPaintGrid.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionVertical"));
        this.myPaintGrid.addItem(WidgetResources.getString("ChartPropertiesDialog.SelectionNone"));
        this.myTickMarkLenght.setModel(new SpinnerNumberModel(3, 0, 20, 1));
        this.myLegendAreaColumns.setModel(new SpinnerNumberModel(2, 1, 5, 1));
        this.myValueMarkerSize.setModel(new SpinnerNumberModel(3, 0, 20, 1));
        this.myLineWidth.setModel(new SpinnerNumberModel(1, 1, 10, 1));
    }

    private void loadInitialValues() {
        Color c = (Color)this.myChart.getProperty("chartbackgroundcolor");
        if (c == null) {
            c = Color.WHITE;
        }
        this.myChartPropertiesMap.put("chartbackgroundcolor", c);
        c = (Color)this.myChart.getProperty("axiscolor");
        this.myChartPropertiesMap.put("axiscolor", c);
        c = (Color)this.myChart.getProperty("ChartHighLightColor");
        this.myChartPropertiesMap.put("ChartHighLightColor", c);
        this.myXAxisLabelField.setText(this.myChart.getAxis(2).getLabel());
        this.myYAxisLabelField.setText(this.myChart.getAxis(0).getLabel());
        Boolean bb = (Boolean)this.myChart.getProperty("ShowHighLight");
        this.myShowHighLightedArea.setSelected(bb);
        String ss = (String)this.myChart.getProperty("HighLightToolTipKey");
        this.myHighLightedAreaToolTip.setText(ss);
        Double dd = (Double)this.myChart.getProperty("valuelinelengthkey");
        this.myTickMarkLenght.setValue(dd);
        bb = (Boolean)this.myChart.getProperty("showlegend");
        this.myShowLegendArea.setSelected(bb);
        Integer i = (Integer)this.myChart.getProperty("legendboxcolumncount");
        if (i == null) {
            i = ChartConstants.DEFAULT_CHART_LEGEND_BOX_COLUMN_COUNT;
        }
        this.myLegendAreaColumns.setValue(i);
        bb = (Boolean)this.myChart.getProperty("firstseriesontopleftcorner");
        if (bb.booleanValue()) {
            this.myFirstLegendAreaItemAlign.setSelectedIndex(0);
        } else {
            this.myFirstLegendAreaItemAlign.setSelectedIndex(1);
        }
        c = (Color)this.myChart.getProperty("gridcolor");
        this.myChartPropertiesMap.put("gridcolor", c);
        i = (Integer)this.myChart.getProperty("gridvisibility");
        switch (i) {
            case 0: {
                this.myPaintGrid.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.myPaintGrid.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.myPaintGrid.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.myPaintGrid.setSelectedIndex(3);
                break;
            }
            default: {
                this.myPaintGrid.setSelectedIndex(0);
            }
        }
        int orientation = this.myChart.getAxis(2).getValueLabelOrientation();
        if (orientation == 0) {
            this.myXValueOrientation.setSelectedIndex(0);
        } else if (orientation == 90) {
            this.myXValueOrientation.setSelectedIndex(1);
        } else {
            this.myXValueOrientation.setSelectedIndex(2);
        }
        orientation = this.myChart.getAxis(0).getValueLabelOrientation();
        if (orientation == 0) {
            this.myYValueOrientation.setSelectedIndex(0);
        } else if (orientation == 90) {
            this.myYValueOrientation.setSelectedIndex(1);
        } else {
            this.myYValueOrientation.setSelectedIndex(2);
        }
        String location = (String)this.myChart.getProperty("Location");
        this.myLegendAreaLocation.setSelectedItem(location);
        String type = (String)this.myChart.getProperty("GraphType");
        if (type.compareTo("CascadedAreaGraph") == 0) {
            this.myGradientPaint.setSelected((Boolean)this.myChart.getProperty("gradientpaint"));
        } else if (type.compareTo("CascadedColumnGraph") == 0) {
            this.myGradientPaint.setSelected((Boolean)this.myChart.getProperty("gradientpaint"));
        } else if (type.compareTo("ClusteredColumnGraph") == 0) {
            this.myGradientPaint.setSelected((Boolean)this.myChart.getProperty("gradientpaint"));
        } else if (type.compareTo("ColumnGraph") == 0) {
            if (this.myChart.getProperty("gradientpaint") != null) {
                this.myGradientPaint.setSelected((Boolean)this.myChart.getProperty("gradientpaint"));
            }
            this.myShowToolTips.setSelected((Boolean)this.myChart.getProperty("graphtooltip"));
        } else if (type.compareTo("LineGraph") == 0) {
            this.myShowToolTips.setSelected((Boolean)this.myChart.getProperty("graphtooltip"));
            this.myLineWidth.setValue(this.myChart.getProperty("linewidth"));
            this.myValueMarkerSize.setValue(this.myChart.getProperty("valuemarker"));
        } else if (type.compareTo("StackedAreaGraph") == 0 && this.myChart.getProperty("gradientpaint") != null) {
            this.myGradientPaint.setSelected((Boolean)this.myChart.getProperty("gradientpaint"));
        }
    }

    class CustomActionListener
    implements ActionListener {
        private String key;

        public CustomActionListener(String propertyKey) {
            this.key = propertyKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JColorChooser chooser = new JColorChooser((Color)ChartPropertiesDialog.this.myChartPropertiesMap.get(this.key));
            JDialog d = JColorChooser.createDialog(ChartPropertiesDialog.this.myChart.getView(), WidgetResources.getString("ChartPropertiesDialog.ColorChooserTitle"), true, chooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChartPropertiesDialog.this.myChartPropertiesMap.put(CustomActionListener.this.key, chooser.getColor());
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                }
            });
            d.setVisible(true);
            ChartPropertiesDialog.this.restrictControllers();
        }
    }

    class NotifyingActionListener
    implements ActionListener {
        NotifyingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChartPropertiesDialog.this.restrictControllers();
        }
    }
}

