/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart;

import com.nokia.widgets.chart.AxisComputedProperties;
import com.nokia.widgets.chart.AxisPropertiesCalculator;
import com.nokia.widgets.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultAxisPropertiesCalculator
implements AxisPropertiesCalculator {
    private static final int INTERVAL_MULTIPLIER = 10;
    private final List<Integer> myPreferredDivisors;
    private final int myPreferredGridLinesCount;
    private final int OFFSET_EXPONENT = 1;
    private final int OFFSET_GRID_SIZE = 1;
    private static final double DELTA = Double.MIN_VALUE;

    public DefaultAxisPropertiesCalculator(Set<Integer> preferredDivisors, int preferredGridLinesCount) {
        if (preferredDivisors == null || preferredDivisors.isEmpty() || this.hasInvalidDivisor(preferredDivisors)) {
            throw new IllegalArgumentException();
        }
        this.myPreferredDivisors = this.sortCollection(preferredDivisors);
        this.myPreferredGridLinesCount = preferredGridLinesCount;
    }

    @Override
    public AxisComputedProperties computeProperties(List series) {
        if (series == null) {
            throw new IllegalArgumentException();
        }
        if (!series.isEmpty()) {
            return this.getComputedProperties(series);
        }
        return new AxisComputedProperties();
    }

    private AxisComputedProperties getComputedProperties(List series) {
        double interval = this.computeInterval(series);
        double maxValue = this.computeMaxValue(series, interval);
        double minValue = this.computeMinValue(series, interval);
        int gridLinesCount = this.computeGridLinesCount(series, interval);
        return new AxisComputedProperties(maxValue, minValue, interval, gridLinesCount);
    }

    private double computeInterval(List series) {
        if (this.hasZeroAsMinimumAndMaximum(series)) {
            return 0.0;
        }
        double linearDifferenceMean = MathUtils.getLinearDifferenceMean(series);
        if (MathUtils.getDistance(linearDifferenceMean, 0.0) <= Double.MIN_VALUE) {
            return this.computeAssumedInterval(series, this.computeAssumedIntervals(this.getLastElement(series)));
        }
        return this.computeRationalInterval(series, linearDifferenceMean);
    }

    private boolean hasZeroAsMinimumAndMaximum(List series) {
        double maximumValue = this.getLastElement(series);
        double minimumValue = this.getDouble(series.get(0));
        return MathUtils.getDistance(maximumValue, 0.0) - 0.0 <= Double.MIN_VALUE && MathUtils.getDistance(minimumValue, 0.0) - 0.0 <= Double.MIN_VALUE;
    }

    private double computeAssumedInterval(List series, List<Double> assumedIntervals) {
        double assumedInterval = Double.MAX_VALUE;
        int previousGridLinesCount = 0;
        for (double interval : assumedIntervals) {
            int currentGridLinesCount = this.computeGridLinesCount(series, interval);
            if (!this.isNewGridLinesCountPreferred(currentGridLinesCount, previousGridLinesCount)) continue;
            previousGridLinesCount = currentGridLinesCount;
            assumedInterval = interval;
        }
        if (previousGridLinesCount == 0) {
            return this.computeAssumedInterval(series, this.incrementIntervals(assumedIntervals, 10));
        }
        return assumedInterval;
    }

    private List<Double> computeAssumedIntervals(double data) {
        int exponent = MathUtils.getNormalizedSignificandExponent(data);
        Number[] preferredDivisorsArr = this.myPreferredDivisors.toArray(new Number[0]);
        List<Double> assumedIntervals = MathUtils.raiseByPowerOfTen(exponent, preferredDivisorsArr);
        assumedIntervals.addAll(MathUtils.raiseByPowerOfTen(exponent - 1, preferredDivisorsArr));
        assumedIntervals.addAll(MathUtils.raiseByPowerOfTen(exponent + 1, preferredDivisorsArr));
        Collections.sort(assumedIntervals);
        return assumedIntervals;
    }

    private double computeRationalInterval(List series, double linearDifferenceMean) {
        List<Double> preferredIntervals = this.computeRationalIntervals(linearDifferenceMean);
        return this.selectMostRationalInterval(linearDifferenceMean, preferredIntervals, series);
    }

    private List<Double> computeRationalIntervals(double linearDifferenceMean) {
        int exponent = MathUtils.getNormalizedSignificandExponent(linearDifferenceMean);
        List<Double> rationalIntervals = MathUtils.raiseByPowerOfTen(exponent, this.myPreferredDivisors.toArray(new Number[this.myPreferredDivisors.size()]));
        Collections.sort(rationalIntervals);
        return rationalIntervals;
    }

    private double selectMostRationalInterval(double linearDifferenceMean, List<Double> rationalIntervals, List series) {
        double previousInterval = Double.MAX_VALUE;
        int previousGridLinesCount = 0;
        for (double interval : rationalIntervals) {
            double currentDistance = MathUtils.getDistance(interval, linearDifferenceMean);
            double previousDistance = MathUtils.getDistance(previousInterval, linearDifferenceMean);
            int currentGridLinesCount = this.computeGridLinesCount(series, interval);
            if (!(currentDistance < previousDistance) || !this.isNewGridLinesCountPreferred(currentGridLinesCount, previousGridLinesCount)) continue;
            previousInterval = interval;
            previousGridLinesCount = currentGridLinesCount;
        }
        if (previousGridLinesCount == 0) {
            return this.selectMostRationalInterval(linearDifferenceMean, this.incrementIntervals(rationalIntervals, 10), series);
        }
        return previousInterval;
    }

    private boolean isNewGridLinesCountPreferred(int newGridLinesCount, int previousGridLinesCount) {
        return newGridLinesCount > previousGridLinesCount && newGridLinesCount <= this.myPreferredGridLinesCount;
    }

    private List<Double> incrementIntervals(List<Double> intervals, int multiples) {
        ArrayList<Double> incrementedIntervals = new ArrayList<Double>();
        for (double interval : intervals) {
            incrementedIntervals.add(interval * (double)multiples);
        }
        return incrementedIntervals;
    }

    private double computeMaxValue(List series, double interval) {
        double maxData = this.getLastElement(series);
        return this.computeMaxValue(interval, maxData);
    }

    private double computeMaxValue(double interval, double maxData) {
        if (maxData > 0.0) {
            return this.computeGreaterThanZeroMaxData(interval, maxData);
        }
        return 0.0;
    }

    private double computeGreaterThanZeroMaxData(double interval, double maxData) {
        double computedMax = Math.ceil(maxData / interval) * interval;
        if (MathUtils.getDistance(computedMax, maxData) <= Double.MIN_VALUE) {
            computedMax += interval;
        }
        return computedMax;
    }

    private double computeMinValue(List series, double interval) {
        double minData = this.getDouble(series.get(0));
        return this.computeMinValue(interval, minData);
    }

    private double computeMinValue(double interval, double minData) {
        if (minData < 0.0) {
            return this.computeLessThanZeroMinValue(interval, minData);
        }
        return 0.0;
    }

    private double computeLessThanZeroMinValue(double interval, double minData) {
        double computedMin = -1.0 * Math.ceil(Math.abs(minData / interval)) * interval;
        if (MathUtils.getDistance(computedMin, minData) <= Double.MIN_VALUE) {
            computedMin -= interval;
        }
        return computedMin;
    }

    private int computeGridLinesCount(List series, double interval) {
        double maxValue = this.computeMaxValue(series, interval);
        double minValue = this.computeMinValue(series, interval);
        float gridLinesCount = Math.round(MathUtils.getDistance(maxValue, minValue) / interval) + 1L;
        return Math.round(gridLinesCount);
    }

    private List<Integer> sortCollection(Set<Integer> collection) {
        ArrayList<Integer> sortedCollections = new ArrayList<Integer>(collection);
        Collections.sort(sortedCollections);
        return sortedCollections;
    }

    private boolean hasInvalidDivisor(Set<Integer> preferredDivisors) {
        for (int divisor : preferredDivisors) {
            if (divisor > 0) continue;
            return true;
        }
        return false;
    }

    private double getLastElement(List series) {
        int size = series.size();
        return this.getDouble(series.get(size - 1));
    }

    private double getDouble(Object number) {
        return ((Number)number).doubleValue();
    }
}

